// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/TwitchVoyagerTwirp/twirp.proto

/*
Package TwitchVoyagerTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/TwitchVoyagerTwirp/twirp.proto
*/
package TwitchVoyagerTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =======================
// TwitchVoyager Interface
// =======================

type TwitchVoyager interface {
	ListUserExpiredSubscriptions(context.Context, *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error)

	GetUserSubscriptions(context.Context, *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error)

	GetUserSubscriptionsWithPaymentsData(context.Context, *GetUserSubscriptionsWithPaymentsDataRequest) (*GetUserSubscriptionsWithPaymentsDataResponse, error)

	GetUserProductSubscriptions(context.Context, *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error)

	GetUserProductSubscriptionsWithPaymentsData(context.Context, *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error)

	GetUserChannelSubscription(context.Context, *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error)

	GetUserChannelSubscriptionWithPaymentsData(context.Context, *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error)

	GetChannelSubscriptions(context.Context, *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error)

	GetChannelSubscriptionsAfterTime(context.Context, *GetChannelSubscriptionsAfterTimeRequest) (*GetChannelSubscriptionsAfterTimeResponse, error)

	GetPendingSubscriptionInfo(context.Context, *GetPendingSubscriptionInfoRequest) (*GetPendingSubscriptionInfoResponse, error)

	GetSubscriberCount(context.Context, *GetSubscriberCountRequest) (*GetSubscriberCountResponse, error)

	GrantAdminSubscription(context.Context, *GrantAdminSubscriptionRequest) (*GrantAdminSubscriptionResponse, error)

	OnboardChannel(context.Context, *OnboardChannelRequest) (*OnboardChannelResponse, error)

	OffboardChannel(context.Context, *OffboardChannelRequest) (*OffboardChannelResponse, error)
}

// =============================
// TwitchVoyager Protobuf Client
// =============================

type twitchVoyagerProtobufClient struct {
	client HTTPClient
	urls   [14]string
	opts   twirp.ClientOptions
}

// NewTwitchVoyagerProtobufClient creates a Protobuf client that implements the TwitchVoyager interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewTwitchVoyagerProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVoyager {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVoyagerPathPrefix
	urls := [14]string{
		prefix + "ListUserExpiredSubscriptions",
		prefix + "GetUserSubscriptions",
		prefix + "GetUserSubscriptionsWithPaymentsData",
		prefix + "GetUserProductSubscriptions",
		prefix + "GetUserProductSubscriptionsWithPaymentsData",
		prefix + "GetUserChannelSubscription",
		prefix + "GetUserChannelSubscriptionWithPaymentsData",
		prefix + "GetChannelSubscriptions",
		prefix + "GetChannelSubscriptionsAfterTime",
		prefix + "GetPendingSubscriptionInfo",
		prefix + "GetSubscriberCount",
		prefix + "GrantAdminSubscription",
		prefix + "OnboardChannel",
		prefix + "OffboardChannel",
	}

	return &twitchVoyagerProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVoyagerProtobufClient) ListUserExpiredSubscriptions(ctx context.Context, in *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "ListUserExpiredSubscriptions")
	out := new(ListUserExpiredSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptions")
	out := new(GetUserSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserSubscriptionsWithPaymentsDataRequest) (*GetUserSubscriptionsWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptionsWithPaymentsData")
	out := new(GetUserSubscriptionsWithPaymentsDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptions")
	out := new(GetUserProductSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserProductSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	out := new(GetUserProductSubscriptionsWithPaymentsDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscription")
	out := new(GetUserChannelSubscriptionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptions")
	out := new(GetChannelSubscriptionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetChannelSubscriptionsAfterTime(ctx context.Context, in *GetChannelSubscriptionsAfterTimeRequest) (*GetChannelSubscriptionsAfterTimeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptionsAfterTime")
	out := new(GetChannelSubscriptionsAfterTimeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetPendingSubscriptionInfo(ctx context.Context, in *GetPendingSubscriptionInfoRequest) (*GetPendingSubscriptionInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetPendingSubscriptionInfo")
	out := new(GetPendingSubscriptionInfoResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GetSubscriberCount(ctx context.Context, in *GetSubscriberCountRequest) (*GetSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriberCount")
	out := new(GetSubscriberCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) GrantAdminSubscription(ctx context.Context, in *GrantAdminSubscriptionRequest) (*GrantAdminSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GrantAdminSubscription")
	out := new(GrantAdminSubscriptionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) OnboardChannel(ctx context.Context, in *OnboardChannelRequest) (*OnboardChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardChannel")
	out := new(OnboardChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerProtobufClient) OffboardChannel(ctx context.Context, in *OffboardChannelRequest) (*OffboardChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "OffboardChannel")
	out := new(OffboardChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================
// TwitchVoyager JSON Client
// =========================

type twitchVoyagerJSONClient struct {
	client HTTPClient
	urls   [14]string
	opts   twirp.ClientOptions
}

// NewTwitchVoyagerJSONClient creates a JSON client that implements the TwitchVoyager interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewTwitchVoyagerJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) TwitchVoyager {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + TwitchVoyagerPathPrefix
	urls := [14]string{
		prefix + "ListUserExpiredSubscriptions",
		prefix + "GetUserSubscriptions",
		prefix + "GetUserSubscriptionsWithPaymentsData",
		prefix + "GetUserProductSubscriptions",
		prefix + "GetUserProductSubscriptionsWithPaymentsData",
		prefix + "GetUserChannelSubscription",
		prefix + "GetUserChannelSubscriptionWithPaymentsData",
		prefix + "GetChannelSubscriptions",
		prefix + "GetChannelSubscriptionsAfterTime",
		prefix + "GetPendingSubscriptionInfo",
		prefix + "GetSubscriberCount",
		prefix + "GrantAdminSubscription",
		prefix + "OnboardChannel",
		prefix + "OffboardChannel",
	}

	return &twitchVoyagerJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *twitchVoyagerJSONClient) ListUserExpiredSubscriptions(ctx context.Context, in *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "ListUserExpiredSubscriptions")
	out := new(ListUserExpiredSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptions")
	out := new(GetUserSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserSubscriptionsWithPaymentsDataRequest) (*GetUserSubscriptionsWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptionsWithPaymentsData")
	out := new(GetUserSubscriptionsWithPaymentsDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptions")
	out := new(GetUserProductSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserProductSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	out := new(GetUserProductSubscriptionsWithPaymentsDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscription")
	out := new(GetUserChannelSubscriptionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptions")
	out := new(GetChannelSubscriptionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetChannelSubscriptionsAfterTime(ctx context.Context, in *GetChannelSubscriptionsAfterTimeRequest) (*GetChannelSubscriptionsAfterTimeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptionsAfterTime")
	out := new(GetChannelSubscriptionsAfterTimeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetPendingSubscriptionInfo(ctx context.Context, in *GetPendingSubscriptionInfoRequest) (*GetPendingSubscriptionInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetPendingSubscriptionInfo")
	out := new(GetPendingSubscriptionInfoResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GetSubscriberCount(ctx context.Context, in *GetSubscriberCountRequest) (*GetSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriberCount")
	out := new(GetSubscriberCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) GrantAdminSubscription(ctx context.Context, in *GrantAdminSubscriptionRequest) (*GrantAdminSubscriptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "GrantAdminSubscription")
	out := new(GrantAdminSubscriptionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) OnboardChannel(ctx context.Context, in *OnboardChannelRequest) (*OnboardChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "OnboardChannel")
	out := new(OnboardChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *twitchVoyagerJSONClient) OffboardChannel(ctx context.Context, in *OffboardChannelRequest) (*OffboardChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithMethodName(ctx, "OffboardChannel")
	out := new(OffboardChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================
// TwitchVoyager Server Handler
// ============================

type twitchVoyagerServer struct {
	TwitchVoyager
	hooks *twirp.ServerHooks
}

func NewTwitchVoyagerServer(svc TwitchVoyager, hooks *twirp.ServerHooks) TwirpServer {
	return &twitchVoyagerServer{
		TwitchVoyager: svc,
		hooks:         hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *twitchVoyagerServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// TwitchVoyagerPathPrefix is used for all URL paths on a twirp TwitchVoyager server.
// Requests are always: POST TwitchVoyagerPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const TwitchVoyagerPathPrefix = "/twirp/twitch.voyager.TwitchVoyager/"

func (s *twitchVoyagerServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "TwitchVoyager")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.TwitchVoyager/ListUserExpiredSubscriptions":
		s.serveListUserExpiredSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserSubscriptions":
		s.serveGetUserSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserSubscriptionsWithPaymentsData":
		s.serveGetUserSubscriptionsWithPaymentsData(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserProductSubscriptions":
		s.serveGetUserProductSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserProductSubscriptionsWithPaymentsData":
		s.serveGetUserProductSubscriptionsWithPaymentsData(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserChannelSubscription":
		s.serveGetUserChannelSubscription(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetUserChannelSubscriptionWithPaymentsData":
		s.serveGetUserChannelSubscriptionWithPaymentsData(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetChannelSubscriptions":
		s.serveGetChannelSubscriptions(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetChannelSubscriptionsAfterTime":
		s.serveGetChannelSubscriptionsAfterTime(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetPendingSubscriptionInfo":
		s.serveGetPendingSubscriptionInfo(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GetSubscriberCount":
		s.serveGetSubscriberCount(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/GrantAdminSubscription":
		s.serveGrantAdminSubscription(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/OnboardChannel":
		s.serveOnboardChannel(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.TwitchVoyager/OffboardChannel":
		s.serveOffboardChannel(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *twitchVoyagerServer) serveListUserExpiredSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListUserExpiredSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserExpiredSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveListUserExpiredSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUserExpiredSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListUserExpiredSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListUserExpiredSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.ListUserExpiredSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserExpiredSubscriptionsResponse and nil error while calling ListUserExpiredSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveListUserExpiredSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListUserExpiredSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListUserExpiredSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListUserExpiredSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.ListUserExpiredSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserExpiredSubscriptionsResponse and nil error while calling ListUserExpiredSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserSubscriptionsWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSubscriptionsWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptionsWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserSubscriptionsWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserSubscriptionsWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserSubscriptionsWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserSubscriptionsWithPaymentsDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserProductSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserProductSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserProductSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserProductSubscriptionsWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserProductSubscriptionsWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserProductSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserProductSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserProductSubscriptionsWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserProductSubscriptionsWithPaymentsDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserProductSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserProductSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserChannelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserChannelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserChannelSubscriptionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelSubscriptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsAfterTime(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSubscriptionsAfterTimeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSubscriptionsAfterTimeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsAfterTimeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptionsAfterTime")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelSubscriptionsAfterTimeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsAfterTimeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetChannelSubscriptionsAfterTime(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsAfterTimeResponse and nil error while calling GetChannelSubscriptionsAfterTime. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetChannelSubscriptionsAfterTimeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSubscriptionsAfterTime")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelSubscriptionsAfterTimeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsAfterTimeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetChannelSubscriptionsAfterTime(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsAfterTimeResponse and nil error while calling GetChannelSubscriptionsAfterTime. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetPendingSubscriptionInfo(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPendingSubscriptionInfoJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPendingSubscriptionInfoProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetPendingSubscriptionInfoJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPendingSubscriptionInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPendingSubscriptionInfoRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPendingSubscriptionInfoResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetPendingSubscriptionInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingSubscriptionInfoResponse and nil error while calling GetPendingSubscriptionInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetPendingSubscriptionInfoProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPendingSubscriptionInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPendingSubscriptionInfoRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPendingSubscriptionInfoResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetPendingSubscriptionInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingSubscriptionInfoResponse and nil error while calling GetPendingSubscriptionInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGetSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriberCountResponse and nil error while calling GetSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGetSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetSubscriberCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GetSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriberCountResponse and nil error while calling GetSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGrantAdminSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGrantAdminSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGrantAdminSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveGrantAdminSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GrantAdminSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GrantAdminSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GrantAdminSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GrantAdminSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GrantAdminSubscriptionResponse and nil error while calling GrantAdminSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveGrantAdminSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GrantAdminSubscription")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GrantAdminSubscriptionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GrantAdminSubscriptionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.GrantAdminSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GrantAdminSubscriptionResponse and nil error while calling GrantAdminSubscription. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveOnboardChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOnboardChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOnboardChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveOnboardChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OnboardChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OnboardChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.OnboardChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardChannelResponse and nil error while calling OnboardChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveOnboardChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OnboardChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(OnboardChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OnboardChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.OnboardChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OnboardChannelResponse and nil error while calling OnboardChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveOffboardChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOffboardChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOffboardChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *twitchVoyagerServer) serveOffboardChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OffboardChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OffboardChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OffboardChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.OffboardChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OffboardChannelResponse and nil error while calling OffboardChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) serveOffboardChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OffboardChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(OffboardChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OffboardChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.TwitchVoyager.OffboardChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OffboardChannelResponse and nil error while calling OffboardChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *twitchVoyagerServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *twitchVoyagerServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *twitchVoyagerServer) PathPrefix() string {
	return TwitchVoyagerPathPrefix
}

// ===========================
// ChannelOnboarding Interface
// ===========================

type ChannelOnboarding interface {
	SetupEmotes(context.Context, *Onboarding) (*Onboarding, error)

	SetupBenefits(context.Context, *Onboarding) (*Onboarding, error)

	SetupProducts(context.Context, *Onboarding) (*Onboarding, error)

	SetupRevenueConfigs(context.Context, *Onboarding) (*Onboarding, error)

	EntitleStreamer(context.Context, *Onboarding) (*Onboarding, error)
}

// =================================
// ChannelOnboarding Protobuf Client
// =================================

type channelOnboardingProtobufClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewChannelOnboardingProtobufClient creates a Protobuf client that implements the ChannelOnboarding interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewChannelOnboardingProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) ChannelOnboarding {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + ChannelOnboardingPathPrefix
	urls := [5]string{
		prefix + "SetupEmotes",
		prefix + "SetupBenefits",
		prefix + "SetupProducts",
		prefix + "SetupRevenueConfigs",
		prefix + "EntitleStreamer",
	}

	return &channelOnboardingProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *channelOnboardingProtobufClient) SetupEmotes(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupEmotes")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingProtobufClient) SetupBenefits(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupBenefits")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingProtobufClient) SetupProducts(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupProducts")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingProtobufClient) SetupRevenueConfigs(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupRevenueConfigs")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingProtobufClient) EntitleStreamer(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "EntitleStreamer")
	out := new(Onboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =============================
// ChannelOnboarding JSON Client
// =============================

type channelOnboardingJSONClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewChannelOnboardingJSONClient creates a JSON client that implements the ChannelOnboarding interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewChannelOnboardingJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) ChannelOnboarding {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + ChannelOnboardingPathPrefix
	urls := [5]string{
		prefix + "SetupEmotes",
		prefix + "SetupBenefits",
		prefix + "SetupProducts",
		prefix + "SetupRevenueConfigs",
		prefix + "EntitleStreamer",
	}

	return &channelOnboardingJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *channelOnboardingJSONClient) SetupEmotes(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupEmotes")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingJSONClient) SetupBenefits(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupBenefits")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingJSONClient) SetupProducts(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupProducts")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingJSONClient) SetupRevenueConfigs(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "SetupRevenueConfigs")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOnboardingJSONClient) EntitleStreamer(ctx context.Context, in *Onboarding) (*Onboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithMethodName(ctx, "EntitleStreamer")
	out := new(Onboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ================================
// ChannelOnboarding Server Handler
// ================================

type channelOnboardingServer struct {
	ChannelOnboarding
	hooks *twirp.ServerHooks
}

func NewChannelOnboardingServer(svc ChannelOnboarding, hooks *twirp.ServerHooks) TwirpServer {
	return &channelOnboardingServer{
		ChannelOnboarding: svc,
		hooks:             hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *channelOnboardingServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ChannelOnboardingPathPrefix is used for all URL paths on a twirp ChannelOnboarding server.
// Requests are always: POST ChannelOnboardingPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ChannelOnboardingPathPrefix = "/twirp/twitch.voyager.ChannelOnboarding/"

func (s *channelOnboardingServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOnboarding")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.ChannelOnboarding/SetupEmotes":
		s.serveSetupEmotes(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOnboarding/SetupBenefits":
		s.serveSetupBenefits(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOnboarding/SetupProducts":
		s.serveSetupProducts(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOnboarding/SetupRevenueConfigs":
		s.serveSetupRevenueConfigs(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOnboarding/EntitleStreamer":
		s.serveEntitleStreamer(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *channelOnboardingServer) serveSetupEmotes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetupEmotesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetupEmotesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveSetupEmotesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupEmotesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupBenefits(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetupBenefitsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetupBenefitsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveSetupBenefitsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupBenefitsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetupProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetupProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveSetupProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupRevenueConfigs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetupRevenueConfigsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetupRevenueConfigsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveSetupRevenueConfigsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupRevenueConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupRevenueConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupRevenueConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveSetupRevenueConfigsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetupRevenueConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.SetupRevenueConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling SetupRevenueConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveEntitleStreamer(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEntitleStreamerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEntitleStreamerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOnboardingServer) serveEntitleStreamerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EntitleStreamer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Onboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.EntitleStreamer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling EntitleStreamer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) serveEntitleStreamerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EntitleStreamer")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Onboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Onboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOnboarding.EntitleStreamer(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Onboarding and nil error while calling EntitleStreamer. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOnboardingServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *channelOnboardingServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *channelOnboardingServer) PathPrefix() string {
	return ChannelOnboardingPathPrefix
}

// =====================
// Fulfillment Interface
// =====================

type Fulfillment interface {
	FulfillEmotes(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	FulfillTenure(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	FulfillChatNotification(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	PublishFulfillmentSuccess(context.Context, *FulfillmentStep) (*FulfillmentStep, error)

	FulfillPubsub(context.Context, *FulfillmentStep) (*FulfillmentStep, error)
}

// ===========================
// Fulfillment Protobuf Client
// ===========================

type fulfillmentProtobufClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewFulfillmentProtobufClient creates a Protobuf client that implements the Fulfillment interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewFulfillmentProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Fulfillment {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + FulfillmentPathPrefix
	urls := [5]string{
		prefix + "FulfillEmotes",
		prefix + "FulfillTenure",
		prefix + "FulfillChatNotification",
		prefix + "PublishFulfillmentSuccess",
		prefix + "FulfillPubsub",
	}

	return &fulfillmentProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *fulfillmentProtobufClient) FulfillEmotes(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillEmotes")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) FulfillTenure(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillTenure")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) FulfillChatNotification(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillChatNotification")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) PublishFulfillmentSuccess(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "PublishFulfillmentSuccess")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentProtobufClient) FulfillPubsub(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillPubsub")
	out := new(FulfillmentStep)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// Fulfillment JSON Client
// =======================

type fulfillmentJSONClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewFulfillmentJSONClient creates a JSON client that implements the Fulfillment interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewFulfillmentJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Fulfillment {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + FulfillmentPathPrefix
	urls := [5]string{
		prefix + "FulfillEmotes",
		prefix + "FulfillTenure",
		prefix + "FulfillChatNotification",
		prefix + "PublishFulfillmentSuccess",
		prefix + "FulfillPubsub",
	}

	return &fulfillmentJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *fulfillmentJSONClient) FulfillEmotes(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillEmotes")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) FulfillTenure(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillTenure")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) FulfillChatNotification(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillChatNotification")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) PublishFulfillmentSuccess(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "PublishFulfillmentSuccess")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *fulfillmentJSONClient) FulfillPubsub(ctx context.Context, in *FulfillmentStep) (*FulfillmentStep, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithMethodName(ctx, "FulfillPubsub")
	out := new(FulfillmentStep)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================
// Fulfillment Server Handler
// ==========================

type fulfillmentServer struct {
	Fulfillment
	hooks *twirp.ServerHooks
}

func NewFulfillmentServer(svc Fulfillment, hooks *twirp.ServerHooks) TwirpServer {
	return &fulfillmentServer{
		Fulfillment: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *fulfillmentServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// FulfillmentPathPrefix is used for all URL paths on a twirp Fulfillment server.
// Requests are always: POST FulfillmentPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const FulfillmentPathPrefix = "/twirp/twitch.voyager.Fulfillment/"

func (s *fulfillmentServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "Fulfillment")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.Fulfillment/FulfillEmotes":
		s.serveFulfillEmotes(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/FulfillTenure":
		s.serveFulfillTenure(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/FulfillChatNotification":
		s.serveFulfillChatNotification(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/PublishFulfillmentSuccess":
		s.servePublishFulfillmentSuccess(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.Fulfillment/FulfillPubsub":
		s.serveFulfillPubsub(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *fulfillmentServer) serveFulfillEmotes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFulfillEmotesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillEmotesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) serveFulfillEmotesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillEmotesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillEmotes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillEmotes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillEmotes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillTenure(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFulfillTenureJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillTenureProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) serveFulfillTenureJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillTenure")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillTenure(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillTenure. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillTenureProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillTenure")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillTenure(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillTenure. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFulfillChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) serveFulfillChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillChatNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillChatNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillChatNotification")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillChatNotification. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) servePublishFulfillmentSuccess(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePublishFulfillmentSuccessJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePublishFulfillmentSuccessProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) servePublishFulfillmentSuccessJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishFulfillmentSuccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.PublishFulfillmentSuccess(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling PublishFulfillmentSuccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) servePublishFulfillmentSuccessProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PublishFulfillmentSuccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.PublishFulfillmentSuccess(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling PublishFulfillmentSuccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillPubsub(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFulfillPubsubJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillPubsubProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *fulfillmentServer) serveFulfillPubsubJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillPubsub")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FulfillmentStep)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillPubsub(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillPubsub. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) serveFulfillPubsubProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FulfillPubsub")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FulfillmentStep)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FulfillmentStep
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Fulfillment.FulfillPubsub(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillmentStep and nil error while calling FulfillPubsub. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *fulfillmentServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 2
}

func (s *fulfillmentServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *fulfillmentServer) PathPrefix() string {
	return FulfillmentPathPrefix
}

// ============================
// ChannelOffboarding Interface
// ============================

type ChannelOffboarding interface {
	HandlePrefix(context.Context, *Offboarding) (*Offboarding, error)

	DowngradeProducts(context.Context, *Offboarding) (*Offboarding, error)

	DowngradeRevenueConfigs(context.Context, *Offboarding) (*Offboarding, error)

	DeactivateStreamerEntitlement(context.Context, *Offboarding) (*Offboarding, error)
}

// ==================================
// ChannelOffboarding Protobuf Client
// ==================================

type channelOffboardingProtobufClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewChannelOffboardingProtobufClient creates a Protobuf client that implements the ChannelOffboarding interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewChannelOffboardingProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) ChannelOffboarding {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + ChannelOffboardingPathPrefix
	urls := [4]string{
		prefix + "HandlePrefix",
		prefix + "DowngradeProducts",
		prefix + "DowngradeRevenueConfigs",
		prefix + "DeactivateStreamerEntitlement",
	}

	return &channelOffboardingProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *channelOffboardingProtobufClient) HandlePrefix(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "HandlePrefix")
	out := new(Offboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingProtobufClient) DowngradeProducts(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeProducts")
	out := new(Offboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingProtobufClient) DowngradeRevenueConfigs(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeRevenueConfigs")
	out := new(Offboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingProtobufClient) DeactivateStreamerEntitlement(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateStreamerEntitlement")
	out := new(Offboarding)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==============================
// ChannelOffboarding JSON Client
// ==============================

type channelOffboardingJSONClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewChannelOffboardingJSONClient creates a JSON client that implements the ChannelOffboarding interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewChannelOffboardingJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) ChannelOffboarding {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + ChannelOffboardingPathPrefix
	urls := [4]string{
		prefix + "HandlePrefix",
		prefix + "DowngradeProducts",
		prefix + "DowngradeRevenueConfigs",
		prefix + "DeactivateStreamerEntitlement",
	}

	return &channelOffboardingJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *channelOffboardingJSONClient) HandlePrefix(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "HandlePrefix")
	out := new(Offboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingJSONClient) DowngradeProducts(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeProducts")
	out := new(Offboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingJSONClient) DowngradeRevenueConfigs(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeRevenueConfigs")
	out := new(Offboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *channelOffboardingJSONClient) DeactivateStreamerEntitlement(ctx context.Context, in *Offboarding) (*Offboarding, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateStreamerEntitlement")
	out := new(Offboarding)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// ChannelOffboarding Server Handler
// =================================

type channelOffboardingServer struct {
	ChannelOffboarding
	hooks *twirp.ServerHooks
}

func NewChannelOffboardingServer(svc ChannelOffboarding, hooks *twirp.ServerHooks) TwirpServer {
	return &channelOffboardingServer{
		ChannelOffboarding: svc,
		hooks:              hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *channelOffboardingServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ChannelOffboardingPathPrefix is used for all URL paths on a twirp ChannelOffboarding server.
// Requests are always: POST ChannelOffboardingPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ChannelOffboardingPathPrefix = "/twirp/twitch.voyager.ChannelOffboarding/"

func (s *channelOffboardingServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "ChannelOffboarding")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.ChannelOffboarding/HandlePrefix":
		s.serveHandlePrefix(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOffboarding/DowngradeProducts":
		s.serveDowngradeProducts(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOffboarding/DowngradeRevenueConfigs":
		s.serveDowngradeRevenueConfigs(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.ChannelOffboarding/DeactivateStreamerEntitlement":
		s.serveDeactivateStreamerEntitlement(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *channelOffboardingServer) serveHandlePrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHandlePrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHandlePrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOffboardingServer) serveHandlePrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandlePrefix")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Offboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.HandlePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling HandlePrefix. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveHandlePrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandlePrefix")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Offboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.HandlePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling HandlePrefix. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDowngradeProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDowngradeProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDowngradeProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOffboardingServer) serveDowngradeProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Offboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DowngradeProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DowngradeProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDowngradeProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeProducts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Offboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DowngradeProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DowngradeProducts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDowngradeRevenueConfigs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDowngradeRevenueConfigsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDowngradeRevenueConfigsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOffboardingServer) serveDowngradeRevenueConfigsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeRevenueConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Offboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DowngradeRevenueConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DowngradeRevenueConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDowngradeRevenueConfigsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DowngradeRevenueConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Offboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DowngradeRevenueConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DowngradeRevenueConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDeactivateStreamerEntitlement(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeactivateStreamerEntitlementJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeactivateStreamerEntitlementProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *channelOffboardingServer) serveDeactivateStreamerEntitlementJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateStreamerEntitlement")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(Offboarding)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DeactivateStreamerEntitlement(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DeactivateStreamerEntitlement. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) serveDeactivateStreamerEntitlementProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeactivateStreamerEntitlement")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(Offboarding)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Offboarding
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.ChannelOffboarding.DeactivateStreamerEntitlement(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Offboarding and nil error while calling DeactivateStreamerEntitlement. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *channelOffboardingServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 3
}

func (s *channelOffboardingServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *channelOffboardingServer) PathPrefix() string {
	return ChannelOffboardingPathPrefix
}

// ===============================
// UpdateSubscriberCount Interface
// ===============================

type UpdateSubscriberCount interface {
	IncrementSubscriberCount(context.Context, *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error)

	DecrementSubscriberCount(context.Context, *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error)
}

// =====================================
// UpdateSubscriberCount Protobuf Client
// =====================================

type updateSubscriberCountProtobufClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewUpdateSubscriberCountProtobufClient creates a Protobuf client that implements the UpdateSubscriberCount interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewUpdateSubscriberCountProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) UpdateSubscriberCount {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + UpdateSubscriberCountPathPrefix
	urls := [2]string{
		prefix + "IncrementSubscriberCount",
		prefix + "DecrementSubscriberCount",
	}

	return &updateSubscriberCountProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *updateSubscriberCountProtobufClient) IncrementSubscriberCount(ctx context.Context, in *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "IncrementSubscriberCount")
	out := new(UpdateSubscriberCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *updateSubscriberCountProtobufClient) DecrementSubscriberCount(ctx context.Context, in *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "DecrementSubscriberCount")
	out := new(UpdateSubscriberCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// UpdateSubscriberCount JSON Client
// =================================

type updateSubscriberCountJSONClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewUpdateSubscriberCountJSONClient creates a JSON client that implements the UpdateSubscriberCount interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewUpdateSubscriberCountJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) UpdateSubscriberCount {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + UpdateSubscriberCountPathPrefix
	urls := [2]string{
		prefix + "IncrementSubscriberCount",
		prefix + "DecrementSubscriberCount",
	}

	return &updateSubscriberCountJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *updateSubscriberCountJSONClient) IncrementSubscriberCount(ctx context.Context, in *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "IncrementSubscriberCount")
	out := new(UpdateSubscriberCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *updateSubscriberCountJSONClient) DecrementSubscriberCount(ctx context.Context, in *UpdateSubscriberCountRequest) (*UpdateSubscriberCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithMethodName(ctx, "DecrementSubscriberCount")
	out := new(UpdateSubscriberCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================================
// UpdateSubscriberCount Server Handler
// ====================================

type updateSubscriberCountServer struct {
	UpdateSubscriberCount
	hooks *twirp.ServerHooks
}

func NewUpdateSubscriberCountServer(svc UpdateSubscriberCount, hooks *twirp.ServerHooks) TwirpServer {
	return &updateSubscriberCountServer{
		UpdateSubscriberCount: svc,
		hooks:                 hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *updateSubscriberCountServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// UpdateSubscriberCountPathPrefix is used for all URL paths on a twirp UpdateSubscriberCount server.
// Requests are always: POST UpdateSubscriberCountPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const UpdateSubscriberCountPathPrefix = "/twirp/twitch.voyager.UpdateSubscriberCount/"

func (s *updateSubscriberCountServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.voyager")
	ctx = ctxsetters.WithServiceName(ctx, "UpdateSubscriberCount")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.voyager.UpdateSubscriberCount/IncrementSubscriberCount":
		s.serveIncrementSubscriberCount(ctx, resp, req)
		return
	case "/twirp/twitch.voyager.UpdateSubscriberCount/DecrementSubscriberCount":
		s.serveDecrementSubscriberCount(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *updateSubscriberCountServer) serveIncrementSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIncrementSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIncrementSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *updateSubscriberCountServer) serveIncrementSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IncrementSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.IncrementSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriberCountResponse and nil error while calling IncrementSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveIncrementSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IncrementSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateSubscriberCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.IncrementSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriberCountResponse and nil error while calling IncrementSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveDecrementSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDecrementSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDecrementSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *updateSubscriberCountServer) serveDecrementSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DecrementSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.DecrementSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriberCountResponse and nil error while calling DecrementSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) serveDecrementSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DecrementSubscriberCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateSubscriberCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateSubscriberCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.UpdateSubscriberCount.DecrementSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriberCountResponse and nil error while calling DecrementSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *updateSubscriberCountServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 4
}

func (s *updateSubscriberCountServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *updateSubscriberCountServer) PathPrefix() string {
	return UpdateSubscriberCountPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 3137 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x3b, 0x4b, 0x73, 0xdb, 0xd6,
	0xd5, 0x01, 0x1f, 0x16, 0x75, 0x28, 0x51, 0xf0, 0x8d, 0x2d, 0xd1, 0xb4, 0x6c, 0xcb, 0xf0, 0x33,
	0x8a, 0x23, 0x27, 0xb4, 0xe7, 0xcb, 0x97, 0xe4, 0x9b, 0x6f, 0x02, 0x91, 0x90, 0x8c, 0xb1, 0x08,
	0xb2, 0x20, 0x64, 0xd7, 0xc9, 0xb4, 0x18, 0x88, 0xb8, 0x94, 0x10, 0x51, 0x20, 0x03, 0x80, 0xb6,
	0x95, 0xe9, 0x74, 0x91, 0xb6, 0x9e, 0x66, 0xda, 0x5d, 0x1f, 0x8b, 0xec, 0x92, 0xe9, 0xa2, 0xfb,
	0xce, 0x74, 0xd3, 0x5d, 0xa7, 0xeb, 0xfc, 0x83, 0x4e, 0x57, 0xfd, 0x09, 0x6d, 0x97, 0xed, 0x5c,
	0xe0, 0x02, 0x04, 0x40, 0x80, 0xa4, 0xec, 0x38, 0x9d, 0x76, 0xb2, 0xf1, 0x18, 0xe7, 0x7d, 0xce,
	0x3d, 0xf7, 0x71, 0xce, 0xa1, 0xa0, 0xda, 0xe9, 0xeb, 0x78, 0xe3, 0xa3, 0xa1, 0xed, 0x18, 0xe6,
	0x86, 0xf3, 0xf8, 0xb6, 0x76, 0xf4, 0x89, 0x79, 0x5b, 0x79, 0x62, 0x38, 0x9d, 0x83, 0x07, 0xfd,
	0x63, 0x6d, 0x1f, 0x5b, 0xca, 0x13, 0xc3, 0x1a, 0xdc, 0x76, 0xc8, 0xbf, 0x1b, 0x03, 0xab, 0xef,
	0xf4, 0x51, 0xc9, 0x71, 0xf1, 0x1b, 0x8f, 0x3d, 0x82, 0xca, 0xa5, 0xfd, 0x7e, 0x7f, 0xbf, 0x87,
	0x6f, 0xbb, 0xd8, 0xbd, 0x61, 0xf7, 0xb6, 0x63, 0x1c, 0x61, 0xdb, 0xd1, 0x8e, 0x28, 0x03, 0xa7,
	0xc2, 0x82, 0x68, 0x76, 0x0d, 0xd3, 0x70, 0xb0, 0x62, 0x1c, 0x61, 0x74, 0x09, 0x8a, 0x86, 0xad,
	0x1a, 0x14, 0x54, 0x66, 0xd6, 0x98, 0x9b, 0x05, 0x19, 0x0c, 0xdb, 0x27, 0x42, 0x1b, 0x90, 0x23,
	0x32, 0xca, 0x99, 0x35, 0xe6, 0x66, 0xb1, 0x5a, 0xd9, 0xf0, 0x14, 0x6c, 0xf8, 0x0a, 0x36, 0x14,
	0x5f, 0x81, 0xec, 0xd2, 0x71, 0x7f, 0xca, 0xc1, 0x42, 0x7b, 0xb8, 0x67, 0x77, 0x2c, 0x63, 0xe0,
	0x18, 0x7d, 0x13, 0x95, 0x20, 0x63, 0xe8, 0xae, 0xe0, 0x79, 0x39, 0x63, 0xe8, 0xe8, 0x3c, 0xcc,
	0xf7, 0x2d, 0x63, 0xdf, 0x30, 0x55, 0x43, 0x77, 0xa5, 0xce, 0xcb, 0x05, 0x0f, 0x20, 0xea, 0x68,
	0x05, 0xe6, 0x86, 0x36, 0xb6, 0x08, 0x2a, 0xeb, 0xa2, 0x4e, 0x91, 0x4f, 0x51, 0x47, 0x17, 0x00,
	0x3a, 0x07, 0x9a, 0x69, 0xe2, 0x1e, 0xc1, 0xe5, 0x5c, 0xdc, 0x3c, 0x85, 0x78, 0xe8, 0x81, 0xd5,
	0xd7, 0x87, 0x1d, 0x87, 0xa0, 0xf3, 0x1e, 0x9a, 0x42, 0x44, 0x1d, 0xbd, 0x09, 0x79, 0xdb, 0xd1,
	0x2c, 0xa7, 0x7c, 0x6a, 0xaa, 0x17, 0x1e, 0x21, 0xba, 0x05, 0x59, 0x6c, 0xea, 0xe5, 0xb9, 0xa9,
	0xf4, 0x84, 0x8c, 0x44, 0x51, 0xeb, 0x74, 0xb0, 0x6d, 0xab, 0xfb, 0x43, 0x43, 0x2f, 0x17, 0x5c,
	0xfd, 0xe0, 0x81, 0xb6, 0x87, 0x86, 0x8e, 0xde, 0x01, 0xe8, 0x58, 0x58, 0x73, 0xb0, 0xae, 0x6a,
	0x4e, 0x79, 0x7e, 0xaa, 0xd4, 0x79, 0x4a, 0xcd, 0x3b, 0x84, 0x75, 0x38, 0xd0, 0x7d, 0x56, 0x98,
	0xce, 0x4a, 0xa9, 0x79, 0x07, 0xdd, 0x85, 0x9c, 0x73, 0x3c, 0xc0, 0xe5, 0xe2, 0x1a, 0x73, 0xb3,
	0x54, 0x5d, 0xdb, 0x88, 0x26, 0xcb, 0x46, 0x78, 0x99, 0x94, 0xe3, 0x01, 0x96, 0x5d, 0x6a, 0x74,
	0x17, 0x0a, 0x83, 0x9e, 0xe6, 0x74, 0xfb, 0xd6, 0x51, 0x79, 0xc1, 0xe5, 0x2c, 0xc7, 0x39, 0x5b,
	0x14, 0x2f, 0x07, 0x94, 0x68, 0x15, 0xe6, 0x0d, 0xbb, 0xed, 0x68, 0x9d, 0x43, 0xac, 0x97, 0x17,
	0xdd, 0x34, 0x1a, 0x01, 0xd0, 0x6d, 0x92, 0x45, 0xd8, 0x2a, 0x97, 0x5c, 0x79, 0xe7, 0xc7, 0xe4,
	0x79, 0x2b, 0xa5, 0x18, 0xd8, 0x92, 0x5d, 0x42, 0xee, 0x2b, 0x06, 0x16, 0x5a, 0xda, 0xf1, 0x11,
	0x36, 0x1d, 0xbb, 0xae, 0x39, 0x5a, 0x34, 0x6d, 0x98, 0x58, 0xda, 0xdc, 0x04, 0x16, 0x3f, 0x75,
	0xd4, 0xc1, 0xd0, 0xea, 0x1c, 0x68, 0x36, 0x56, 0xed, 0xc3, 0x21, 0x4d, 0xad, 0x12, 0x7e, 0xea,
	0xb4, 0x28, 0xb8, 0x7d, 0x38, 0x44, 0x57, 0x60, 0xd1, 0xb0, 0x55, 0x0b, 0x77, 0x87, 0xa6, 0xae,
	0xed, 0xf5, 0xb0, 0x9b, 0x66, 0x05, 0x79, 0xc1, 0xb0, 0xe5, 0x00, 0x86, 0xce, 0x41, 0xc1, 0xb0,
	0x55, 0xdd, 0xb4, 0xb0, 0x97, 0x6a, 0x05, 0x79, 0xce, 0xb0, 0xeb, 0xe4, 0x13, 0xbd, 0x0d, 0xf3,
	0x16, 0x36, 0xf1, 0x13, 0x9b, 0x2c, 0x46, 0x7e, 0xea, 0x62, 0x14, 0x3c, 0x62, 0xde, 0xe1, 0xbe,
	0x64, 0x60, 0x35, 0x1c, 0xf0, 0x87, 0x86, 0x73, 0x10, 0x71, 0xf0, 0x7d, 0x58, 0xb0, 0x43, 0x78,
	0xd7, 0xc7, 0x62, 0x75, 0x75, 0xd2, 0xa2, 0xc9, 0x11, 0x0e, 0x22, 0x61, 0x10, 0x92, 0x48, 0xb7,
	0xec, 0x98, 0x84, 0xb0, 0x56, 0x39, 0xc2, 0xc1, 0xfd, 0x98, 0x81, 0x92, 0xbf, 0xb6, 0x5b, 0x46,
	0xcf, 0xc1, 0x16, 0xfa, 0x1f, 0x98, 0xf7, 0xd7, 0xd8, 0x2e, 0x33, 0x6b, 0xd9, 0x89, 0xe9, 0x30,
	0x22, 0x45, 0xef, 0x42, 0xa1, 0x3f, 0xc0, 0x96, 0xe6, 0xf4, 0x2d, 0xd7, 0x90, 0x52, 0xf5, 0x62,
	0x9c, 0xcd, 0xd3, 0xd0, 0xa4, 0x54, 0x72, 0x40, 0xcf, 0xfd, 0x9c, 0x81, 0xe5, 0x78, 0x72, 0x06,
	0xe6, 0xe4, 0x49, 0x92, 0xfa, 0xa6, 0x4c, 0xcf, 0x69, 0x8f, 0xfc, 0x85, 0xcc, 0xe9, 0xc1, 0x95,
	0x1d, 0xc3, 0x76, 0x76, 0x6d, 0x6c, 0x09, 0x4f, 0x07, 0x86, 0x85, 0xf5, 0xb0, 0x16, 0x5b, 0xc6,
	0x1f, 0x0f, 0xb1, 0xed, 0x84, 0xcf, 0x2e, 0x26, 0x72, 0x76, 0x9d, 0x81, 0x7c, 0xcf, 0x38, 0x32,
	0x1c, 0x57, 0x71, 0x56, 0xf6, 0x3e, 0xd0, 0x32, 0x9c, 0xea, 0x0c, 0x2d, 0xbb, 0x6f, 0xf9, 0x27,
	0x9d, 0xf7, 0xc5, 0x7d, 0xca, 0xc0, 0xd5, 0xc9, 0xea, 0xec, 0x41, 0xdf, 0xb4, 0x31, 0xda, 0x84,
	0xc5, 0xf0, 0xf2, 0x7b, 0x21, 0x99, 0x96, 0x31, 0x51, 0x96, 0x90, 0x11, 0x99, 0x88, 0x11, 0x7f,
	0x67, 0xe0, 0xfc, 0x36, 0x76, 0x6d, 0x78, 0x89, 0xbe, 0xa2, 0x6d, 0x28, 0x92, 0xe5, 0x51, 0xbb,
	0x6e, 0xe8, 0xdd, 0xbd, 0x56, 0xac, 0x5e, 0x9f, 0xb6, 0xa6, 0xde, 0x42, 0xc9, 0xe0, 0x8c, 0xd2,
	0x62, 0x1b, 0x96, 0xfc, 0xd4, 0xf3, 0x85, 0x79, 0x9b, 0xf3, 0x62, 0x5a, 0xae, 0x52, 0x21, 0xa5,
	0x41, 0xe4, 0x9b, 0xfb, 0x04, 0x56, 0x93, 0xfd, 0xfe, 0x06, 0x82, 0xfe, 0x2c, 0x03, 0xaf, 0x27,
	0x29, 0x8f, 0x1f, 0x15, 0xff, 0xf5, 0x8b, 0xf0, 0x39, 0x03, 0xb7, 0x66, 0x0b, 0x04, 0x5d, 0x15,
	0x39, 0x79, 0x55, 0x6e, 0x4d, 0x72, 0x62, 0x4c, 0xd8, 0x8c, 0xab, 0xf4, 0x7d, 0xe0, 0xa8, 0x6d,
	0xf4, 0xd6, 0x3a, 0xd9, 0x06, 0xb9, 0x04, 0xc5, 0xd1, 0x4b, 0xc5, 0x2e, 0x67, 0xd6, 0xb2, 0xe4,
	0xa9, 0x10, 0x3c, 0x55, 0x6c, 0xce, 0x80, 0x2b, 0x13, 0xe5, 0x7f, 0x7d, 0x89, 0xc8, 0x99, 0x50,
	0x9d, 0xa0, 0xea, 0xc4, 0x69, 0x37, 0xd5, 0xb5, 0xcf, 0x18, 0xb8, 0x73, 0x22, 0x85, 0x2f, 0x6f,
	0x79, 0xb9, 0x0f, 0xe1, 0x32, 0x35, 0xa5, 0xe6, 0xbd, 0x22, 0x23, 0x81, 0x9a, 0xe6, 0x6a, 0xf4,
	0x39, 0x9a, 0x89, 0x3d, 0x47, 0xb9, 0x6e, 0x90, 0x23, 0x89, 0xc2, 0xa9, 0x5b, 0x2f, 0x7c, 0xe3,
	0x73, 0x87, 0xf0, 0x56, 0xba, 0x9e, 0x13, 0xaf, 0xdf, 0x14, 0xa7, 0x9e, 0x31, 0x41, 0xba, 0xcc,
	0xa4, 0x8d, 0x7a, 0xd9, 0x4a, 0xf4, 0xf2, 0x64, 0x6b, 0x17, 0xf5, 0xfa, 0x73, 0x06, 0x2e, 0x6e,
	0x63, 0x27, 0xc1, 0x88, 0x60, 0xfb, 0x45, 0x5d, 0x61, 0xe2, 0xe5, 0xc2, 0xc9, 0x0e, 0xc8, 0xd7,
	0x21, 0xdf, 0xb7, 0x74, 0x7a, 0x34, 0x96, 0xaa, 0x67, 0xe3, 0xa6, 0x37, 0x09, 0x52, 0xf6, 0x68,
	0xb8, 0xdf, 0x30, 0x70, 0x29, 0xd5, 0xb8, 0x97, 0x7f, 0x89, 0xa0, 0x6b, 0x50, 0xb2, 0xf0, 0x63,
	0x6c, 0xd9, 0x58, 0x8d, 0x38, 0xb3, 0x48, 0xa1, 0x35, 0xef, 0x14, 0xfb, 0x07, 0x03, 0x37, 0x52,
	0xcc, 0xe4, 0xbb, 0x0e, 0xb6, 0xc8, 0x13, 0xf6, 0xa5, 0x04, 0xf3, 0x1d, 0x00, 0x8d, 0x28, 0x50,
	0xdd, 0xaa, 0x32, 0x37, 0xbd, 0x9c, 0xd1, 0x7c, 0x73, 0x50, 0x1d, 0x2e, 0x7a, 0xd7, 0x8a, 0xda,
	0xd1, 0xcc, 0x0e, 0xee, 0xf5, 0xb0, 0xae, 0x46, 0xe3, 0x98, 0x77, 0x1f, 0xeb, 0xab, 0x1e, 0x55,
	0xcd, 0x27, 0x8a, 0x78, 0xc7, 0xfd, 0x96, 0x81, 0x9b, 0xd3, 0x3d, 0xff, 0x06, 0x56, 0x6a, 0x0d,
	0x8a, 0x07, 0x9a, 0x2d, 0x91, 0x02, 0x45, 0xdb, 0xf7, 0x0b, 0x91, 0x30, 0x88, 0x7b, 0x04, 0xe7,
	0xb6, 0xb1, 0x7f, 0x46, 0xee, 0x61, 0xab, 0xd6, 0x1f, 0x9a, 0xce, 0x8c, 0xab, 0x12, 0xad, 0x88,
	0x33, 0xb1, 0x8a, 0x98, 0xdb, 0x86, 0x4a, 0x92, 0x68, 0xea, 0xf6, 0x6b, 0xc0, 0xda, 0x01, 0x4a,
	0xed, 0x10, 0x9c, 0xab, 0x21, 0x2b, 0x2f, 0xd9, 0x51, 0x16, 0xae, 0x0b, 0x4b, 0x61, 0xe7, 0xef,
	0xe3, 0xe3, 0xf4, 0x03, 0x66, 0x62, 0xe9, 0x1f, 0x35, 0x38, 0x1b, 0x37, 0xf8, 0x0f, 0x19, 0x58,
	0x69, 0x61, 0x53, 0x37, 0xcc, 0xfd, 0xb0, 0x3e, 0xd1, 0xec, 0xf6, 0xc7, 0x5a, 0x0c, 0xef, 0x42,
	0x61, 0x8f, 0x94, 0x81, 0x87, 0xf8, 0x98, 0x16, 0x41, 0x97, 0x26, 0x2d, 0xd8, 0x7d, 0x7c, 0x2c,
	0xcf, 0x11, 0x06, 0x62, 0xfc, 0xfb, 0x50, 0x1c, 0x0e, 0xf6, 0x2d, 0x4d, 0xf7, 0xd8, 0xb3, 0xb3,
	0xb1, 0x03, 0xe5, 0x21, 0x12, 0x82, 0x66, 0x43, 0x6e, 0xd6, 0x66, 0x83, 0x5f, 0x1d, 0xe7, 0x67,
	0xac, 0x8e, 0x5d, 0x06, 0x52, 0xd8, 0x9f, 0x4a, 0x66, 0xd8, 0xf5, 0x8c, 0x19, 0xd5, 0xf4, 0xdc,
	0xc7, 0xee, 0x6d, 0x97, 0x12, 0x3f, 0x3f, 0xa3, 0x76, 0xe0, 0x74, 0x38, 0x73, 0x89, 0xff, 0x7e,
	0xc2, 0x4f, 0x0d, 0x00, 0x6b, 0x47, 0x01, 0x36, 0xf7, 0x33, 0xc6, 0xbd, 0x04, 0x53, 0x75, 0xd2,
	0x54, 0xc3, 0x50, 0x19, 0x78, 0x24, 0x91, 0xbd, 0xac, 0x1a, 0x66, 0xb7, 0xef, 0x6b, 0xbf, 0x31,
	0x16, 0x91, 0x14, 0xa1, 0xe5, 0x41, 0x32, 0xc2, 0xe6, 0x7e, 0x00, 0x17, 0xb6, 0x2d, 0xcd, 0x74,
	0x78, 0xfd, 0xc8, 0x30, 0x4f, 0x7a, 0xd5, 0x4f, 0xd8, 0x48, 0xb4, 0xa1, 0xa0, 0x6b, 0xd6, 0x61,
	0x4f, 0x1b, 0x9a, 0x9d, 0x83, 0x51, 0x43, 0xa1, 0x1e, 0xc0, 0xb8, 0x35, 0xb8, 0x98, 0xa6, 0xdd,
	0x0b, 0x03, 0xf7, 0x11, 0x9c, 0x6d, 0x9a, 0x7b, 0x7d, 0xcd, 0xd2, 0xe9, 0xc1, 0x34, 0xe3, 0x36,
	0xaf, 0x42, 0xce, 0xea, 0xf7, 0x70, 0x5a, 0x4d, 0x4b, 0x65, 0x1a, 0xe6, 0xbe, 0xdc, 0xef, 0x61,
	0xd9, 0xa5, 0xe5, 0xca, 0xb0, 0x1c, 0xd7, 0x45, 0xad, 0x38, 0x84, 0xe5, 0x66, 0xb7, 0xfb, 0x0d,
	0x99, 0x71, 0x0e, 0x56, 0xc6, 0x94, 0x51, 0x3b, 0x7e, 0x08, 0x73, 0x9b, 0xd8, 0xc4, 0x5d, 0xc3,
	0x19, 0xdb, 0xdb, 0x7e, 0xea, 0x67, 0x92, 0x53, 0x9f, 0xb2, 0x85, 0xda, 0x59, 0x55, 0xba, 0xb9,
	0xb2, 0xd3, 0x4c, 0x0b, 0x75, 0x9f, 0x1a, 0x30, 0x47, 0x37, 0xdd, 0x98, 0x7e, 0x5f, 0x5c, 0xe6,
	0x04, 0xe2, 0x3e, 0xcf, 0x00, 0x8c, 0x10, 0x2f, 0x21, 0x96, 0xe8, 0x0e, 0x14, 0xf6, 0x3c, 0xcf,
	0xed, 0x72, 0xd6, 0xdd, 0x33, 0x2b, 0x29, 0x91, 0x91, 0x03, 0x42, 0xc2, 0x44, 0xf3, 0xd8, 0x2e,
	0xe7, 0x92, 0x99, 0x68, 0x14, 0xe4, 0x80, 0x90, 0x58, 0x67, 0x3b, 0x78, 0x40, 0xcf, 0xaa, 0x09,
	0xd6, 0xb5, 0x1d, 0x3c, 0x90, 0x5d, 0x5a, 0x72, 0xee, 0xef, 0x5b, 0xfd, 0xe1, 0xc0, 0x2d, 0x0b,
	0x4e, 0xb9, 0x65, 0x41, 0xc1, 0x05, 0x90, 0xa2, 0xe0, 0x97, 0x79, 0x58, 0xda, 0x1a, 0xf6, 0xba,
	0x46, 0xaf, 0x47, 0x1e, 0x7c, 0x84, 0x2d, 0xb6, 0xe7, 0x98, 0xf8, 0x9e, 0x0b, 0xed, 0xd5, 0x4c,
	0xfa, 0x05, 0x93, 0x8d, 0x5d, 0x30, 0x97, 0x61, 0xc1, 0x6f, 0x10, 0x5a, 0xa3, 0x26, 0x72, 0x31,
	0x80, 0x89, 0x3a, 0x79, 0x3c, 0x75, 0x47, 0xa6, 0x8c, 0x5a, 0xc9, 0x8b, 0x21, 0xa8, 0xa8, 0xa3,
	0x0a, 0x14, 0x0c, 0xd3, 0xc1, 0xd6, 0x63, 0xad, 0xe7, 0x1e, 0xc1, 0x79, 0x39, 0xf8, 0x46, 0xef,
	0x41, 0xc1, 0x1e, 0xee, 0xa9, 0x6e, 0x8e, 0xce, 0xcd, 0xd8, 0x77, 0x9d, 0xb3, 0x87, 0x7b, 0x4a,
	0xbc, 0xf5, 0x5a, 0x98, 0xb9, 0xf5, 0x1a, 0x5c, 0x38, 0xf3, 0xb3, 0x5e, 0x38, 0x1b, 0x5e, 0x77,
	0x1b, 0x92, 0x0b, 0x8e, 0xf0, 0x80, 0xc0, 0xeb, 0x6f, 0x8f, 0x1d, 0x72, 0xc5, 0xf1, 0x43, 0x2e,
	0x96, 0xd6, 0x0b, 0xf1, 0xb4, 0x3e, 0x0f, 0xf3, 0x24, 0x19, 0x54, 0x53, 0x3b, 0xc2, 0x6e, 0x83,
	0x78, 0x5e, 0x2e, 0x10, 0x80, 0xa4, 0x1d, 0x61, 0xc4, 0xc3, 0xa2, 0x1f, 0x41, 0x75, 0x68, 0x1a,
	0x0e, 0x6d, 0x14, 0x27, 0x98, 0xe6, 0x11, 0xed, 0x9a, 0x86, 0x23, 0x2f, 0x18, 0xa1, 0x2f, 0xd4,
	0x88, 0x3f, 0xd5, 0x96, 0x92, 0xef, 0x8e, 0x70, 0xae, 0x4d, 0xa8, 0x8d, 0x7f, 0x9d, 0x87, 0x95,
	0x14, 0xd2, 0x6f, 0x47, 0x1a, 0xdf, 0x8e, 0x34, 0x4e, 0x3e, 0xd2, 0x40, 0x02, 0xb0, 0x03, 0xcd,
	0xd0, 0xd5, 0xf0, 0xf3, 0x72, 0xc9, 0xf5, 0x7d, 0x9c, 0x59, 0x33, 0x74, 0xfa, 0x88, 0x93, 0x4b,
	0x83, 0xd1, 0xc7, 0x7d, 0x7c, 0xcc, 0x7d, 0xc9, 0x40, 0x31, 0x84, 0x9f, 0x3c, 0x18, 0x49, 0x3d,
	0x29, 0x27, 0xbf, 0xb6, 0xd1, 0xff, 0xc3, 0x82, 0x6f, 0xa6, 0x1b, 0xee, 0xdc, 0xf4, 0x87, 0xa6,
	0xff, 0x6c, 0x26, 0x1f, 0xdc, 0x3f, 0x19, 0x28, 0xfa, 0x97, 0xfb, 0x7f, 0xfc, 0x95, 0x77, 0x27,
	0x72, 0xe5, 0x8d, 0x3d, 0x85, 0x43, 0x7e, 0x8e, 0xee, 0x3c, 0xee, 0x27, 0x0c, 0xac, 0xee, 0xba,
	0x69, 0xfb, 0x32, 0xea, 0x37, 0x74, 0x03, 0x96, 0x0c, 0x1d, 0x1f, 0x0d, 0xfa, 0x0e, 0x36, 0x3b,
	0xc7, 0x41, 0xa9, 0x32, 0x2f, 0x97, 0x42, 0x60, 0x92, 0x2e, 0x97, 0xe0, 0x42, 0x8a, 0x19, 0xde,
	0x5b, 0x6b, 0xfd, 0x17, 0x19, 0x60, 0xe3, 0xdb, 0x06, 0x55, 0x60, 0xb9, 0xbd, 0xbb, 0xd9, 0xae,
	0xc9, 0x62, 0x4b, 0x11, 0x9b, 0x92, 0xaa, 0x3c, 0x6a, 0x09, 0xaa, 0xd4, 0x94, 0x04, 0xf6, 0x95,
	0x64, 0x5c, 0x8b, 0x17, 0xeb, 0x2c, 0x93, 0x8c, 0xdb, 0x16, 0xb7, 0x14, 0x36, 0x83, 0xce, 0xc3,
	0x4a, 0x02, 0x9f, 0x2c, 0x36, 0x04, 0x36, 0x8b, 0xd6, 0x60, 0x35, 0x05, 0xa9, 0xee, 0x88, 0xd2,
	0x7d, 0x36, 0x97, 0xcc, 0xce, 0xd7, 0x1b, 0xa2, 0xc4, 0xe6, 0xd1, 0x4d, 0xb8, 0x3a, 0x8e, 0x8c,
	0x42, 0x9a, 0xf7, 0x05, 0x89, 0x3d, 0x85, 0xae, 0xc1, 0xe5, 0x71, 0xca, 0x5a, 0xb3, 0x2e, 0xa8,
	0xb2, 0x50, 0x17, 0x1a, 0x2e, 0x90, 0x9d, 0x5b, 0xff, 0x82, 0x81, 0x85, 0xf0, 0x65, 0x83, 0x96,
	0x01, 0x89, 0x92, 0x22, 0xc8, 0x0f, 0xf8, 0x1d, 0x75, 0x57, 0x12, 0x15, 0x3f, 0x1a, 0x2b, 0xf0,
	0x6a, 0x14, 0xde, 0x68, 0x4a, 0xca, 0x3d, 0x96, 0x19, 0x67, 0x78, 0x24, 0xf0, 0x32, 0x9b, 0x41,
	0x67, 0xe1, 0x74, 0x14, 0x5e, 0xe7, 0x1f, 0xb1, 0xd9, 0x71, 0xf2, 0x87, 0x82, 0x40, 0xdc, 0x3e,
	0x07, 0x67, 0xa3, 0xf0, 0xa6, 0x24, 0x28, 0x24, 0x66, 0xf9, 0xf5, 0x4f, 0x19, 0x28, 0xf8, 0xc7,
	0x16, 0x3a, 0x0d, 0x8b, 0xad, 0x1d, 0x5e, 0xd9, 0x6a, 0xca, 0x0d, 0xdf, 0x34, 0x16, 0x16, 0x02,
	0xd0, 0x43, 0x61, 0x93, 0x65, 0xd0, 0x19, 0x60, 0x03, 0x08, 0x2f, 0xd5, 0xe5, 0xa6, 0x58, 0x67,
	0x33, 0x11, 0x3a, 0xb1, 0xd9, 0x66, 0xb3, 0xe8, 0x55, 0x58, 0x1a, 0xd1, 0x35, 0xf8, 0x0f, 0x9a,
	0x12, 0x9b, 0x8b, 0x30, 0xd7, 0x85, 0xf6, 0x7d, 0xa5, 0xd9, 0x62, 0xf3, 0xeb, 0x1f, 0x42, 0x29,
	0x3a, 0x38, 0x43, 0x65, 0x38, 0xb3, 0x25, 0xee, 0x28, 0x82, 0xac, 0x36, 0x5b, 0x82, 0xcc, 0x2b,
	0x4d, 0xd9, 0x37, 0x68, 0x19, 0x50, 0x1c, 0x23, 0x4a, 0x2c, 0x43, 0x62, 0x38, 0xc6, 0x21, 0x4a,
	0x6c, 0x66, 0xfd, 0x3a, 0xe4, 0xdd, 0xe6, 0x1a, 0x5a, 0x84, 0x79, 0xf7, 0x3f, 0x2a, 0xdf, 0xae,
	0xb1, 0xaf, 0xa0, 0x12, 0x80, 0xf7, 0x59, 0x17, 0xda, 0x35, 0x96, 0x59, 0xff, 0x8a, 0x81, 0x62,
	0xe8, 0x2c, 0x22, 0x31, 0xde, 0x6d, 0x6d, 0xcb, 0x7c, 0x5d, 0x88, 0x64, 0xee, 0x35, 0xb8, 0x1c,
	0x01, 0x93, 0xc4, 0x54, 0x95, 0xa6, 0x9b, 0xbc, 0x2a, 0xc5, 0xb0, 0x0c, 0xba, 0x0e, 0x5c, 0x84,
	0xcc, 0x4b, 0xc3, 0x38, 0x5d, 0x06, 0xdd, 0x80, 0x2b, 0x11, 0xba, 0xba, 0x24, 0x13, 0x2a, 0x59,
	0x68, 0xef, 0x6e, 0xaa, 0xb2, 0x50, 0xdb, 0x95, 0x65, 0x51, 0xda, 0x66, 0xb3, 0xe8, 0x4d, 0xb8,
	0x15, 0x21, 0x8c, 0xa5, 0xdb, 0x98, 0xe8, 0xdc, 0xfa, 0x31, 0x14, 0x43, 0x17, 0x08, 0xf1, 0xa7,
	0x25, 0x37, 0xeb, 0xbb, 0x35, 0x45, 0x55, 0x44, 0x21, 0x88, 0x27, 0x82, 0x52, 0x04, 0xfc, 0x16,
	0xcb, 0x8c, 0xc1, 0xaa, 0x6c, 0x66, 0x0c, 0x76, 0x87, 0xcd, 0x92, 0x98, 0x47, 0x60, 0xb5, 0xdd,
	0xb6, 0xd2, 0x6c, 0xb0, 0xb9, 0xf5, 0x9f, 0x32, 0x50, 0x8a, 0x56, 0x31, 0x64, 0x45, 0x9b, 0xd2,
	0x66, 0x93, 0x97, 0xeb, 0xa2, 0xb4, 0x1d, 0xb1, 0xe0, 0x2c, 0x9c, 0x8e, 0x63, 0x88, 0x11, 0x09,
	0xe0, 0xaa, 0x97, 0xfa, 0x71, 0x30, 0x35, 0x25, 0x0e, 0xe6, 0xa5, 0x47, 0x5e, 0x14, 0x42, 0xf5,
	0x1c, 0x61, 0xdf, 0x14, 0x24, 0x61, 0x4b, 0x54, 0x22, 0xab, 0x5a, 0x86, 0x33, 0x11, 0x30, 0x5f,
	0x57, 0xb7, 0x64, 0x81, 0x2c, 0xe4, 0x05, 0x38, 0x17, 0xc1, 0x90, 0x75, 0x69, 0x4a, 0x3b, 0x8f,
	0xd4, 0x07, 0x4d, 0x92, 0xf7, 0x15, 0x58, 0x8e, 0xa0, 0x85, 0x46, 0x53, 0x11, 0xd4, 0xb6, 0xa0,
	0xb0, 0xd9, 0x75, 0x25, 0x1c, 0x04, 0x72, 0xeb, 0xa0, 0x02, 0xe4, 0xa8, 0xc2, 0x45, 0x98, 0xe7,
	0xb7, 0xb6, 0xc4, 0x1d, 0x91, 0x57, 0x04, 0x6f, 0x53, 0xb5, 0x15, 0x5e, 0xaa, 0xf3, 0x72, 0x5d,
	0x6d, 0xf1, 0xb2, 0x22, 0x09, 0x64, 0x9b, 0x93, 0x2d, 0x24, 0x0b, 0x0d, 0x71, 0xb7, 0x11, 0x00,
	0xb3, 0xeb, 0x7f, 0x8d, 0xc4, 0xd6, 0x2d, 0x75, 0xa2, 0xb1, 0x6d, 0x2b, 0x42, 0xcb, 0xf7, 0x6b,
	0x0d, 0x56, 0xe3, 0x98, 0xb6, 0xa0, 0xec, 0xb6, 0x3c, 0x3b, 0xdb, 0x2c, 0x83, 0x38, 0xb8, 0x98,
	0x4c, 0x41, 0xdd, 0x6a, 0xb3, 0x99, 0x74, 0x1a, 0xba, 0xfa, 0x64, 0xbb, 0xbf, 0x06, 0xd7, 0x92,
	0x69, 0x64, 0xe1, 0x81, 0x20, 0xed, 0x92, 0x84, 0x95, 0xb6, 0xc4, 0xed, 0x36, 0x9b, 0x43, 0x57,
	0x61, 0x2d, 0x4e, 0x2a, 0x48, 0x8a, 0xa8, 0xec, 0x08, 0x6a, 0x5b, 0x91, 0x05, 0xbe, 0x21, 0xc8,
	0x6c, 0x7e, 0xfd, 0x2f, 0x0c, 0x2c, 0xc5, 0xae, 0x45, 0x72, 0x90, 0x35, 0xb7, 0xb6, 0x12, 0x3d,
	0x25, 0x36, 0xc6, 0x51, 0xf7, 0x78, 0xa9, 0xbe, 0x43, 0xf6, 0x9e, 0xb0, 0x25, 0x7e, 0x97, 0x65,
	0xc8, 0x66, 0x1b, 0xa3, 0xa9, 0x37, 0x1f, 0x4a, 0xde, 0xb6, 0x0a, 0x9c, 0xc9, 0xa0, 0x0d, 0x58,
	0x9f, 0x40, 0x18, 0xf7, 0x28, 0x8b, 0xee, 0xc2, 0x9b, 0xe3, 0xf4, 0x02, 0x5f, 0x53, 0xc4, 0x07,
	0xbc, 0x32, 0xf2, 0xca, 0x77, 0xb3, 0x21, 0x48, 0x0a, 0x9b, 0xab, 0xfe, 0xad, 0x04, 0x8b, 0x91,
	0xdf, 0x66, 0xa1, 0xcf, 0x18, 0x58, 0x9d, 0x34, 0xb7, 0x47, 0x77, 0xe2, 0x0f, 0x87, 0x19, 0x7e,
	0x54, 0x50, 0xb9, 0x7b, 0x32, 0x26, 0xda, 0x54, 0xfb, 0x18, 0xce, 0x24, 0xcd, 0x4f, 0xd1, 0xeb,
	0x71, 0x69, 0x13, 0x66, 0xfc, 0x95, 0x5b, 0xb3, 0x11, 0x53, 0x95, 0x5f, 0x30, 0x70, 0x75, 0x96,
	0x99, 0x2d, 0x7a, 0x6f, 0x16, 0xb1, 0x29, 0xb3, 0xab, 0xca, 0xff, 0x3d, 0x1f, 0x33, 0xb5, 0xf1,
	0xd9, 0xe8, 0x57, 0x0d, 0x49, 0xf3, 0x47, 0x54, 0x4d, 0x91, 0x3e, 0x61, 0xd0, 0x5b, 0xb9, 0x73,
	0x22, 0x1e, 0x6a, 0xc8, 0xef, 0x99, 0x60, 0xd2, 0x3f, 0xcb, 0x20, 0x14, 0x6d, 0x9e, 0x40, 0x49,
	0x5a, 0xe8, 0x6a, 0x2f, 0x24, 0x83, 0x1a, 0xfe, 0x23, 0xc6, 0x9d, 0x1b, 0xa4, 0xcc, 0x00, 0xd1,
	0x5b, 0x29, 0x3a, 0xd2, 0x47, 0xac, 0x95, 0xea, 0x49, 0x58, 0xa8, 0x15, 0xbf, 0x63, 0x60, 0x7d,
	0xf6, 0x49, 0x24, 0xe2, 0x67, 0x57, 0x91, 0x16, 0xbc, 0xcd, 0x17, 0x11, 0x41, 0xad, 0xfe, 0x04,
	0x56, 0x52, 0xe6, 0x4e, 0x68, 0x23, 0x41, 0xfc, 0x84, 0xf1, 0x66, 0xe5, 0xf6, 0xcc, 0xf4, 0x54,
	0xf7, 0xaf, 0x18, 0x58, 0x9b, 0x36, 0xf4, 0x42, 0x6f, 0xcf, 0x28, 0x35, 0x3e, 0x20, 0xac, 0xfc,
	0xef, 0xc9, 0x19, 0xa3, 0xf9, 0x94, 0x36, 0xd8, 0x49, 0xca, 0xa7, 0xc9, 0x43, 0x8c, 0xc4, 0x7c,
	0x9a, 0x36, 0x83, 0x38, 0x04, 0x34, 0x3e, 0x0c, 0x43, 0xaf, 0x25, 0x48, 0x4a, 0xae, 0xe5, 0x2a,
	0xeb, 0xb3, 0x90, 0x52, 0x65, 0x4f, 0x60, 0x39, 0x79, 0x16, 0x80, 0xde, 0x18, 0x93, 0x32, 0x69,
	0x62, 0x51, 0xd9, 0x98, 0x95, 0x9c, 0x2a, 0x56, 0x83, 0xb7, 0x07, 0x5d, 0x1b, 0x74, 0x2d, 0xa5,
	0xd0, 0x8e, 0xf6, 0xfe, 0x2b, 0xd7, 0xa7, 0x91, 0x51, 0x05, 0x7b, 0xa3, 0x4b, 0xdf, 0xd7, 0x70,
	0x3d, 0xad, 0x58, 0x8e, 0xa9, 0xb8, 0x31, 0x95, 0xce, 0xd3, 0x51, 0x7d, 0x96, 0x85, 0xd3, 0x14,
	0x16, 0xea, 0xa8, 0x0b, 0x50, 0x6c, 0x63, 0x67, 0x38, 0x10, 0x8e, 0xfa, 0x0e, 0xb6, 0x51, 0x25,
	0xbd, 0x81, 0x50, 0x99, 0x80, 0x43, 0xdb, 0xb0, 0xe8, 0x8a, 0xd9, 0xf4, 0xdb, 0x05, 0x2f, 0x2a,
	0xa8, 0xe5, 0xb7, 0x10, 0x9e, 0x57, 0x50, 0x03, 0x5e, 0x75, 0x05, 0xc9, 0xf8, 0x31, 0x36, 0x87,
	0xb8, 0xd6, 0x37, 0xbb, 0xc6, 0xfe, 0xf3, 0x8b, 0x13, 0x61, 0x49, 0x30, 0x1d, 0xc3, 0xe9, 0xe1,
	0xb6, 0x63, 0x61, 0xed, 0x08, 0x5b, 0xcf, 0x2b, 0xaa, 0xfa, 0xc7, 0x2c, 0x14, 0x43, 0xfd, 0x51,
	0xf4, 0x1d, 0x58, 0xa4, 0x9f, 0x74, 0x11, 0x2e, 0x4d, 0x6a, 0xbc, 0x3a, 0x78, 0x50, 0x99, 0x46,
	0x10, 0x12, 0xa9, 0x60, 0x73, 0x68, 0xe1, 0xaf, 0x41, 0xe4, 0x87, 0x41, 0x53, 0xb7, 0x76, 0xa0,
	0x39, 0x52, 0xdf, 0x31, 0xba, 0x46, 0x47, 0x73, 0x77, 0xdf, 0x8b, 0x0b, 0xff, 0x1e, 0x9c, 0x6b,
	0x0d, 0xf7, 0x7a, 0x86, 0x7d, 0x10, 0x69, 0x1c, 0xbb, 0x2d, 0xd3, 0xaf, 0x35, 0x1c, 0xad, 0xe1,
	0x9e, 0x3d, 0xdc, 0x7b, 0x71, 0x91, 0xd5, 0x3f, 0x67, 0x00, 0xf9, 0xbb, 0x29, 0xd4, 0xad, 0xbb,
	0x07, 0x0b, 0xf7, 0x34, 0x53, 0xef, 0xe1, 0x96, 0x85, 0xbb, 0xc6, 0x53, 0x74, 0x7e, 0x42, 0xcb,
	0xab, 0x32, 0x09, 0x89, 0x1a, 0x70, 0xba, 0xde, 0x7f, 0x62, 0xba, 0x95, 0x79, 0xb0, 0x19, 0x9e,
	0x5f, 0x5c, 0x1b, 0x56, 0x02, 0x71, 0xb1, 0x2d, 0xf1, 0xfc, 0x42, 0x1f, 0xc1, 0x85, 0x3a, 0xd6,
	0x3a, 0x8e, 0xf1, 0x58, 0x73, 0x82, 0x7d, 0x41, 0xb7, 0x89, 0x9b, 0xda, 0xcf, 0x2d, 0xba, 0xfa,
	0x59, 0x06, 0xce, 0x26, 0x76, 0xdf, 0xd0, 0x13, 0x28, 0x8b, 0x66, 0xc7, 0xc2, 0xa1, 0xd9, 0x42,
	0x80, 0xbb, 0x35, 0xde, 0x66, 0x4d, 0xef, 0x23, 0x56, 0xde, 0x98, 0x91, 0x3a, 0xb8, 0x7e, 0xca,
	0x75, 0xfc, 0x6f, 0x50, 0xbc, 0x79, 0xf3, 0x83, 0xeb, 0xb3, 0xfd, 0x81, 0xcb, 0xde, 0x29, 0x77,
	0x04, 0x70, 0xe7, 0x5f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x9e, 0x5e, 0x85, 0xd2, 0x11, 0x33, 0x00,
	0x00,
}
