# twitchclient

[![GoDoc](http://godoc.internal.justin.tv/code.justin.tv/foundation/twitchclient?status.svg)](http://godoc.internal.justin.tv/code.justin.tv/foundation/twitchclient)

Package twitchclient and twitchserver enables quicker creation of production-ready HTTP clients and servers.

This package contains only the client implementation of the client-server

You only need to depend on this library if you are building / using a client to talk to a twitchserver

## Ctxlog Integration

twitchclient is integrated with [ctxlog](https://git-aws.internal.justin.tv/feeds/ctxlog), which offers two benefits

1. A request ID is propagated between services and stored in the request's context. One example usage is to prepend all
logs with a request id. You can then aggregate and index all of your logs across multiple services by that ID.
After that indexing is complete, it is simple to search for and read all of the log lines relevant to a request.
twitchserver will generate the ID for you, using an x-ray trace ID if it's available. If x-ray is not in use,
a random ID will be generated.

2. Request logs can be elevated. Logging all possible debugging information for a high scale production system is impractical, but
it can be done with sampling. By sending the elevate header, `X-Ctxlog-Elevate: true` in a small percentage of requests,
all log lines for that request which use a compatible logging system may be elevated (for example from DEBUG to INFO).

In order to take advantage of these benefits, all twitchclients and twitchservers in the repository must be created with the
same ElevateKey and DimensionKey so the appropriate headers can be forwarded between services.

Examples are provided in [twitchserver](https://git-aws.internal.justin.tv/foundation/twitchserver/blob/master/example_server_test.go).
