// Code generated by protoc-gen-go.
// source: code.justin.tv/release/trace/events/event.proto
// DO NOT EDIT!

/*
Package events is a generated protocol buffer package.

It is generated from these files:
	code.justin.tv/release/trace/events/event.proto

It has these top-level messages:
	Event
	Extra
	ExtraHTTP
	ExtraSQL
	ExtraMemcached
	ExtraGRPC
	UnusedExtra
	EventSet
*/
package events

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import code_justin_tv_release_trace_common "code.justin.tv/release/trace/common"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// An Event represents a single Trace-worthy event.  This includes RPC
// lifecycle events (client started to send a request, server finishes sending
// a response), and application-specific custom events.
type Event struct {
	// Lifecycle event this message is attached to
	Kind code_justin_tv_release_trace_common.Kind `protobuf:"varint,1,opt,name=kind,enum=code.justin.tv.release.trace.common.event.Kind" json:"kind,omitempty"`
	// Unix epoch time in nanoseconds, as measured by the process
	Time int64 `protobuf:"fixed64,2,opt,name=time" json:"time,omitempty"`
	// FQDN of the process's host
	Hostname string `protobuf:"bytes,3,opt,name=hostname" json:"hostname,omitempty"`
	// Service name of the process
	Svcname string `protobuf:"bytes,4,opt,name=svcname" json:"svcname,omitempty"`
	// PID of the process
	Pid int32 `protobuf:"varint,5,opt,name=pid" json:"pid,omitempty"`
	// 128-bit identifier for the entire transaction.  This field is sent as
	// two 64-bit integers, least significant word first.
	TransactionId []uint64 `protobuf:"fixed64,6,rep,packed,name=transaction_id" json:"transaction_id,omitempty"`
	// Identifier for a single RPC span (one request leading to one response).
	// Each level of the distributed call stack adds a new element to the path
	// field.  The value at each level is the (zero-indexed) number of
	// outbound RPC requests made at that level.
	Path []uint32 `protobuf:"varint,7,rep,packed,name=path" json:"path,omitempty"`
	// Additional protocol-specific information
	Extra *Extra `protobuf:"bytes,8,opt,name=extra" json:"extra,omitempty"`
	// Amazon Resource Name for the process's EC2 instance.  This may be sent
	// instead of the hostname field.
	Ec2Arn string `protobuf:"bytes,20,opt,name=ec2_arn" json:"ec2_arn,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Event) GetExtra() *Extra {
	if m != nil {
		return m.Extra
	}
	return nil
}

// An Extra describes protocol-specific information to be associated with an
// Event.
type Extra struct {
	// The address of the peer.  This could be an ipv4:port pair, [ipv6]:port
	// pair, or hostname:port pair for TCP/UDP-based protocols, a bare IP
	// address or hostname for IP- based protocols, or a path to a unix domain
	// socket.
	//
	// This field is NOT an attempt to identify the client, e.g. via the HTTP
	// X-Forwarded-For header.
	Peer string `protobuf:"bytes,1,opt,name=peer" json:"peer,omitempty"`
	// Additional HTTP-specific information for the Event.
	Http *ExtraHTTP `protobuf:"bytes,2,opt,name=http" json:"http,omitempty"`
	// Additional SQL-specific information for the Event.
	Sql *ExtraSQL `protobuf:"bytes,3,opt,name=sql" json:"sql,omitempty"`
	// Additional Memcached-specific information for the Event.
	Memcached *ExtraMemcached `protobuf:"bytes,4,opt,name=memcached" json:"memcached,omitempty"`
	// Additional gRPC-specific information for the Event.
	Grpc *ExtraGRPC `protobuf:"bytes,5,opt,name=grpc" json:"grpc,omitempty"`
}

func (m *Extra) Reset()                    { *m = Extra{} }
func (m *Extra) String() string            { return proto.CompactTextString(m) }
func (*Extra) ProtoMessage()               {}
func (*Extra) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Extra) GetHttp() *ExtraHTTP {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *Extra) GetSql() *ExtraSQL {
	if m != nil {
		return m.Sql
	}
	return nil
}

func (m *Extra) GetMemcached() *ExtraMemcached {
	if m != nil {
		return m.Memcached
	}
	return nil
}

func (m *Extra) GetGrpc() *ExtraGRPC {
	if m != nil {
		return m.Grpc
	}
	return nil
}

// An ExtraHTTP describes HTTP-specific information to be associated with an
// Event.
type ExtraHTTP struct {
	// Status code of HTTP response.  Common values will include 200 or 404.
	// Values less than zero indicate an error observed by the client which
	// caused it to give up on the request before getting a status code from
	// the server.
	StatusCode int32 `protobuf:"zigzag32,1,opt,name=status_code" json:"status_code,omitempty"`
	// Method of HTTP request.
	Method code_justin_tv_release_trace_common.Method `protobuf:"varint,2,opt,name=method,enum=code.justin.tv.release.trace.common.http.Method" json:"method,omitempty"`
	// Path of the HTTP request.  This is only the path - the scheme,
	// hostname, query, and fragment are not included.
	UriPath string `protobuf:"bytes,16,opt,name=uri_path" json:"uri_path,omitempty"`
}

func (m *ExtraHTTP) Reset()                    { *m = ExtraHTTP{} }
func (m *ExtraHTTP) String() string            { return proto.CompactTextString(m) }
func (*ExtraHTTP) ProtoMessage()               {}
func (*ExtraHTTP) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// An ExtraSQL describes SQL-specific information to be associated with an
// Event.
type ExtraSQL struct {
	// Name of the target database.
	DatabaseName string `protobuf:"bytes,1,opt,name=database_name" json:"database_name,omitempty"`
	// Username used to connect to the target database.
	DatabaseUser string `protobuf:"bytes,2,opt,name=database_user" json:"database_user,omitempty"`
	// Query string with all user data removed: e.g. strings replaced by '',
	// integers replaced by 0, etc.  This value may be truncated (particularly
	// if it's larger than 1kB).
	StrippedQuery string `protobuf:"bytes,16,opt,name=stripped_query" json:"stripped_query,omitempty"`
}

func (m *ExtraSQL) Reset()                    { *m = ExtraSQL{} }
func (m *ExtraSQL) String() string            { return proto.CompactTextString(m) }
func (*ExtraSQL) ProtoMessage()               {}
func (*ExtraSQL) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// An ExtraMemcached describes memcached-specific information to be
// associated with an event. Most of this was written with the
// assistance of the memcached protocol spec at
// https://github.com/memcached/memcached/blob/c10feb9ebe2179f6fbe4ac2e3cd12bfefdd42631/doc/protocol.txt.
type ExtraMemcached struct {
	// The command sent to memcached by a client
	Command code_justin_tv_release_trace_common.Command `protobuf:"varint,1,opt,name=command,enum=code.justin.tv.release.trace.common.memcached.Command" json:"command,omitempty"`
	// The number of keys in this memcached event. This is useful
	// for understanding bulk transactions: the request side might
	// ask for 150 keys, but the response side might have only
	// 100, indicating that the cache was hit for 100 out of the
	// 150 requested keys.
	NKeys uint32 `protobuf:"varint,2,opt,name=n_keys" json:"n_keys,omitempty"`
	// Some commands involve the client setting a 32-bit integer
	// expiration time. According to the memcached protocol spec,
	// this may be either a Unix time, or a number of seconds
	// starting from current time. The memcached server decides
	// which it is by the size of the expiration time: if the
	// value is less than or equal to 60*60*24*30 (30 days), then
	// it's taken as a relative expiration; if it's over this
	// amount then it is interpreted as Unix time. If its set to
	// zero, then the item never expires.
	Expiration uint32 `protobuf:"fixed32,3,opt,name=expiration" json:"expiration,omitempty"`
}

func (m *ExtraMemcached) Reset()                    { *m = ExtraMemcached{} }
func (m *ExtraMemcached) String() string            { return proto.CompactTextString(m) }
func (*ExtraMemcached) ProtoMessage()               {}
func (*ExtraMemcached) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// An ExtraGRPC describes gRPC-specific information to be associated with an
// event.
type ExtraGRPC struct {
	// Fully-qualified method name, including proto package name, service
	// name, and method name.
	Method string `protobuf:"bytes,1,opt,name=method" json:"method,omitempty"`
}

func (m *ExtraGRPC) Reset()                    { *m = ExtraGRPC{} }
func (m *ExtraGRPC) String() string            { return proto.CompactTextString(m) }
func (*ExtraGRPC) ProtoMessage()               {}
func (*ExtraGRPC) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// An UnusedExtra describes protocol-specific information to be associated
// with an Event.  This message is not yet ready for use, meaning that the
// field names, identities, and numbers are subject to change!
type UnusedExtra struct {
	// written by an engineer - "string" means utf-8 encoded, which should be
	// fine?
	Text          string `protobuf:"bytes,20,opt,name=text" json:"text,omitempty"`
	TextTruncated bool   `protobuf:"varint,1020,opt,name=text_truncated" json:"text_truncated,omitempty"`
	// if there's a payload, how big is it?
	PayloadSize int64 `protobuf:"varint,21,opt,name=payload_size" json:"payload_size,omitempty"`
	// request uri
	HttpUri          string `protobuf:"bytes,41,opt,name=http_uri" json:"http_uri,omitempty"`
	HttpUriTruncated bool   `protobuf:"varint,1041,opt,name=http_uri_truncated" json:"http_uri_truncated,omitempty"`
	// headers, partial list
	HttpHeader []*UnusedExtra_KV `protobuf:"bytes,43,rep,name=http_header" json:"http_header,omitempty"`
	// if there are headers that we expect to be very long, we may want to
	// pull them out into their own fields so we can note when we truncate
	// them
	HttpReferer          string `protobuf:"bytes,44,opt,name=http_referer" json:"http_referer,omitempty"`
	HttpRefererTruncated bool   `protobuf:"varint,1044,opt,name=http_referer_truncated" json:"http_referer_truncated,omitempty"`
}

func (m *UnusedExtra) Reset()                    { *m = UnusedExtra{} }
func (m *UnusedExtra) String() string            { return proto.CompactTextString(m) }
func (*UnusedExtra) ProtoMessage()               {}
func (*UnusedExtra) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *UnusedExtra) GetHttpHeader() []*UnusedExtra_KV {
	if m != nil {
		return m.HttpHeader
	}
	return nil
}

// if we use proto3 we can just use maps
type UnusedExtra_KV struct {
	// option map_entry = true;
	Key   string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *UnusedExtra_KV) Reset()                    { *m = UnusedExtra_KV{} }
func (m *UnusedExtra_KV) String() string            { return proto.CompactTextString(m) }
func (*UnusedExtra_KV) ProtoMessage()               {}
func (*UnusedExtra_KV) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6, 0} }

// An EventSet is a list of Events.  It may be used when sending multiple
// events in a datagram, or when saving them to disk.  There is no codified or
// implied relation between Events grouped into an EventSet.
type EventSet struct {
	// List of Events
	Event []*Event `protobuf:"bytes,1,rep,name=event" json:"event,omitempty"`
}

func (m *EventSet) Reset()                    { *m = EventSet{} }
func (m *EventSet) String() string            { return proto.CompactTextString(m) }
func (*EventSet) ProtoMessage()               {}
func (*EventSet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *EventSet) GetEvent() []*Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func init() {
	proto.RegisterType((*Event)(nil), "code.justin.tv.release.trace.events.Event")
	proto.RegisterType((*Extra)(nil), "code.justin.tv.release.trace.events.Extra")
	proto.RegisterType((*ExtraHTTP)(nil), "code.justin.tv.release.trace.events.ExtraHTTP")
	proto.RegisterType((*ExtraSQL)(nil), "code.justin.tv.release.trace.events.ExtraSQL")
	proto.RegisterType((*ExtraMemcached)(nil), "code.justin.tv.release.trace.events.ExtraMemcached")
	proto.RegisterType((*ExtraGRPC)(nil), "code.justin.tv.release.trace.events.ExtraGRPC")
	proto.RegisterType((*UnusedExtra)(nil), "code.justin.tv.release.trace.events.UnusedExtra")
	proto.RegisterType((*UnusedExtra_KV)(nil), "code.justin.tv.release.trace.events.UnusedExtra.KV")
	proto.RegisterType((*EventSet)(nil), "code.justin.tv.release.trace.events.EventSet")
}

var fileDescriptor0 = []byte{
	// 654 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x54, 0x4d, 0x6f, 0xd3, 0x40,
	0x10, 0x25, 0xce, 0xf7, 0xb8, 0x09, 0x61, 0x69, 0x8b, 0xd5, 0x1e, 0xa8, 0xc2, 0xa5, 0x7c, 0x39,
	0x95, 0x2b, 0x21, 0x51, 0x81, 0x84, 0x5a, 0x95, 0x56, 0x2a, 0x95, 0x02, 0x2d, 0x1c, 0xb8, 0x58,
	0x5b, 0x7b, 0x21, 0xa6, 0x89, 0xed, 0xee, 0xae, 0xa3, 0x06, 0x89, 0x1f, 0x81, 0x04, 0x77, 0x7e,
	0x28, 0x42, 0xcc, 0x8e, 0xdd, 0x10, 0x38, 0x54, 0xe6, 0xe4, 0xec, 0xdb, 0xbc, 0xb7, 0x33, 0x6f,
	0xde, 0x2e, 0x0c, 0x82, 0x24, 0x14, 0xee, 0xa7, 0x4c, 0xe9, 0x28, 0x76, 0xf5, 0x74, 0x20, 0xc5,
	0x58, 0x70, 0x25, 0x06, 0x5a, 0xf2, 0x40, 0x0c, 0xc4, 0x54, 0xc4, 0x5a, 0xe5, 0x1f, 0x37, 0x95,
	0x89, 0x4e, 0xd8, 0xbd, 0xbf, 0x09, 0x6e, 0x41, 0x70, 0x89, 0xe0, 0xe6, 0x84, 0xb5, 0xad, 0x6b,
	0x55, 0x83, 0x64, 0x32, 0x49, 0xe2, 0xe2, 0x93, 0xcb, 0xf6, 0x7f, 0x55, 0xa0, 0xbe, 0x6f, 0xc8,
	0xec, 0x39, 0xd4, 0xce, 0xa3, 0x38, 0x74, 0x2a, 0x1b, 0x95, 0xcd, 0xae, 0x37, 0x70, 0xaf, 0x3d,
	0xaf, 0xd0, 0xc8, 0x0b, 0x3c, 0x42, 0x1a, 0x5b, 0x82, 0x9a, 0x8e, 0x26, 0xc2, 0xb1, 0x90, 0xde,
	0x63, 0x3d, 0x68, 0x8d, 0x12, 0xa5, 0x63, 0x8e, 0x48, 0x15, 0x91, 0x36, 0xbb, 0x09, 0x4d, 0x35,
	0x0d, 0x08, 0xa8, 0x11, 0x60, 0x43, 0x35, 0x8d, 0x42, 0xa7, 0x8e, 0x8b, 0x3a, 0x5b, 0x83, 0x2e,
	0x0a, 0xc7, 0x8a, 0x07, 0x3a, 0x4a, 0x62, 0x1f, 0xf1, 0xc6, 0x46, 0x75, 0xb3, 0xb1, 0x6b, 0xf5,
	0x2a, 0xa8, 0x55, 0x4b, 0xb9, 0x1e, 0x39, 0x4d, 0x44, 0x3a, 0x84, 0x3c, 0x85, 0xba, 0xb8, 0xc4,
	0xff, 0x3b, 0x2d, 0x24, 0xdb, 0xde, 0x03, 0xb7, 0x84, 0x37, 0xee, 0xbe, 0x61, 0x98, 0x32, 0x44,
	0xe0, 0xf9, 0x5c, 0xc6, 0xce, 0xb2, 0x29, 0xa3, 0xff, 0xdd, 0x42, 0x03, 0x68, 0x0b, 0x3b, 0x48,
	0x85, 0x90, 0x64, 0x40, 0x9b, 0x3d, 0x83, 0xda, 0x48, 0xeb, 0x94, 0xfa, 0xb1, 0x3d, 0xb7, 0xfc,
	0x11, 0x87, 0xa7, 0xa7, 0x43, 0xb6, 0x03, 0x55, 0x75, 0x31, 0xa6, 0xd6, 0x6d, 0xef, 0x71, 0x79,
	0xf2, 0xc9, 0xeb, 0x57, 0xec, 0x25, 0xb4, 0x27, 0x62, 0x12, 0xf0, 0x60, 0x24, 0x42, 0xf2, 0xca,
	0xf6, 0xb6, 0xcb, 0x2b, 0x1c, 0x5f, 0x51, 0x4d, 0x07, 0x1f, 0x65, 0x1a, 0x90, 0xc3, 0xff, 0xd5,
	0xc1, 0xc1, 0x9b, 0xe1, 0x5e, 0x5f, 0x43, 0xfb, 0x4f, 0x3b, 0xb7, 0xc1, 0x56, 0x9a, 0xeb, 0x4c,
	0xf9, 0x46, 0x84, 0x1c, 0xba, 0xc5, 0x5e, 0x40, 0x63, 0x22, 0xf4, 0x28, 0x09, 0xc9, 0xa3, 0xae,
	0xb7, 0x55, 0x2a, 0x32, 0xc6, 0x54, 0xf7, 0x98, 0x78, 0x26, 0x25, 0x99, 0x8c, 0x7c, 0x9a, 0x6e,
	0x8f, 0xa6, 0x31, 0x84, 0xd6, 0xdc, 0x87, 0x15, 0xe8, 0x84, 0x5c, 0xf3, 0x33, 0x94, 0xf0, 0x29,
	0x37, 0xf9, 0x60, 0x16, 0xe1, 0x4c, 0xe1, 0xbc, 0x2c, 0x82, 0x57, 0xa1, 0xab, 0xb4, 0x8c, 0xd2,
	0x54, 0x84, 0xfe, 0x45, 0x26, 0xe4, 0xac, 0x50, 0xfc, 0x02, 0xdd, 0x7f, 0x7c, 0x39, 0x80, 0xa6,
	0xa9, 0x85, 0xcf, 0xb3, 0xfe, 0xa4, 0x54, 0xe1, 0xf3, 0x99, 0xb8, 0x7b, 0x39, 0x9b, 0x75, 0xa1,
	0x11, 0xfb, 0xe7, 0x62, 0xa6, 0xa8, 0x84, 0x0e, 0x63, 0x00, 0xe2, 0x32, 0x8d, 0x24, 0x37, 0x19,
	0xa6, 0xd9, 0x37, 0xfb, 0xeb, 0x85, 0x8d, 0xc6, 0x53, 0x43, 0x28, 0x1c, 0xa3, 0x56, 0xfa, 0x3f,
	0x2c, 0xb0, 0xdf, 0xc6, 0xd8, 0x44, 0x38, 0x4f, 0xa0, 0xc6, 0x60, 0xe7, 0xc9, 0x64, 0x77, 0xf0,
	0x4e, 0xe0, 0xca, 0xd7, 0x32, 0x8b, 0x03, 0xae, 0x31, 0x0c, 0x3f, 0x9b, 0xb8, 0xd1, 0x62, 0xcb,
	0xb0, 0x94, 0xf2, 0xd9, 0x38, 0xe1, 0xa1, 0xaf, 0xa2, 0xcf, 0xc2, 0x59, 0x41, 0xb4, 0x4a, 0x57,
	0x0e, 0xbd, 0xf5, 0xd1, 0x51, 0xe7, 0x3e, 0x09, 0xac, 0x03, 0xbb, 0x42, 0x16, 0x44, 0xbe, 0xb6,
	0x48, 0xe4, 0x10, 0x6c, 0xda, 0x1c, 0x09, 0x1e, 0xa2, 0x89, 0x0f, 0xf1, 0x72, 0x95, 0xcd, 0xd9,
	0x42, 0xc9, 0xee, 0xd1, 0x3b, 0x53, 0x0e, 0x29, 0x49, 0xf1, 0x41, 0x48, 0x94, 0x7a, 0x44, 0x87,
	0xdf, 0x85, 0xd5, 0x45, 0x74, 0xa1, 0x80, 0x6f, 0x54, 0xc0, 0xda, 0x06, 0x58, 0x48, 0xc6, 0x57,
	0x00, 0x1d, 0x2c, 0x46, 0xdb, 0x81, 0xfa, 0x94, 0x8f, 0xb3, 0xfc, 0x11, 0x69, 0xef, 0x58, 0x4e,
	0xa5, 0xbf, 0x8f, 0x81, 0x30, 0xa7, 0x9e, 0x08, 0x4d, 0xd7, 0xde, 0xfc, 0xc6, 0x7f, 0x57, 0xcb,
	0x5f, 0x7b, 0xf3, 0xd9, 0x6d, 0xbd, 0x6f, 0xe4, 0xeb, 0xe1, 0x8d, 0xb3, 0x06, 0xbd, 0x7c, 0xdb,
	0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xfc, 0x09, 0xef, 0x44, 0x83, 0x05, 0x00, 0x00,
}
