// Code generated by protoc-gen-go. DO NOT EDIT.
// source: twirp/subscriptions.proto

/*
Package substwirp is a generated protocol buffer package.

It is generated from these files:
	twirp/subscriptions.proto

It has these top-level messages:
	EmoticonLevel
	SetScoreRequest
	SetScoreResponse
	SubscriptionCount
	CalculateSubscriberCountRequest
	CalculateSubscriberCountResponse
	GetUserSettingsRequest
	GetUserSettingsResponse
	SetUserSettingsRequest
	SetUserSettingsResponse
	OptionalBool
	Subscription
	FulfillSubscriptionRequest
	FulfillSubscriptionResponse
	CancelSubscriptionRequest
	CancelSubscriptionResponse
	CanSubscribeRequest
	CanSubscribeResponse
	ListUserSubscriptionsRequest
	GetUserChannelSubscriptionWithPaymentsDataRequest
	GetUserChannelSubscriptionRequest
	UserSubscription
	UserSubscriptionResult
	ListUserSubscriptionsResponse
	GetUserChannelSubscriptionWithPaymentsDataResponse
	GetUserChannelSubscriptionResponse
	GetUserProductSubscriptionsRequest
	GetUserProductSubscriptionsResponse
	GetUserSubscriptionsRequest
	GetUserSubscriptionsResponse
	GetExternalProductTemplateSKURequest
	GetExternalProductTemplateSKUResponse
	GetExternalProductPurchasableSKURequest
	GetExternalProductPurchasableSKUResponse
	SubKey
	PaidUpgrade
	GetPaidUpgradesRequest
	GetPaidUpgradesResponse
	CreatePaidUpgradeRequest
	CreatePaidUpgradeResponse
	CancelPaidUpgradeRequest
	CancelPaidUpgradeResponse
	CreateChatNotificationTokenRequest
	CreateChatNotificationTokenResponse
	UseChatNotificationTokenRequest
	UseChatNotificationTokenResponse
	CancelChatNotificationTokenRequest
	CancelChatNotificationTokenResponse
	GetUserChannelChatNotificationTokenRequest
	GetUserChannelChatNotificationTokenResponse
	ChatNotificationToken
	Gift
	GiftKey
	CreateGiftRequest
	CreateGiftResponse
	CancelGiftRequest
	CancelGiftResponse
	GetGiftsRequest
	GetGiftsResponse
	CanGiftRequest
	CanGiftResponse
	GiftPromotion
	GetGiftPromotionRequest
	GetGiftPromotionResponse
	GetEmotePrefixRequest
	GetEmotePrefixResponse
	GetEmoticonPrefixRequest
	GetEmoticonPrefixResponse
	CreateEmoticonRequest
	CreateEmoticonReponse
	GetAllEmoticonsByProductIDsRequest
	GetAllEmoticonsByProductIDsResponse
	EmoticonGroup
	Emoticon
	GetPartnerStandingRequest
	GetPartnerStandingResponse
	SubmitEmoticonPrefixRequest
	SubmitEmoticonPrefixResponse
	GetPendingEmoticonsRequest
	EmoticonBucket
	GetPendingEmoticonsResponse
	PendingEmoticon
	Product
	ProductInterval
	GetProductsByIDsRequest
	GetProductsByIDsResponse
	GetChannelProductsRequest
	GetChannelProductsResponse
	UpdateProductRequest
	UpdateProductResponse
	UpdateChannelProductsRequest
	UpdateChannelProductsResponse
*/
package substwirp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Subscriptions
// =============
type Platform int32

const (
	Platform_PLATFORM_NONE    Platform = 0
	Platform_PLATFORM_WEB     Platform = 1
	Platform_PLATFORM_IOS     Platform = 2
	Platform_PLATFORM_ANDROID Platform = 3
	Platform_PLATFORM_AMAZON  Platform = 4
)

var Platform_name = map[int32]string{
	0: "PLATFORM_NONE",
	1: "PLATFORM_WEB",
	2: "PLATFORM_IOS",
	3: "PLATFORM_ANDROID",
	4: "PLATFORM_AMAZON",
}
var Platform_value = map[string]int32{
	"PLATFORM_NONE":    0,
	"PLATFORM_WEB":     1,
	"PLATFORM_IOS":     2,
	"PLATFORM_ANDROID": 3,
	"PLATFORM_AMAZON":  4,
}

func (x Platform) String() string {
	return proto.EnumName(Platform_name, int32(x))
}
func (Platform) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type GiftState int32

const (
	GiftState_GIFT_NONE     GiftState = 0
	GiftState_GIFT_ACCEPTED GiftState = 1
	GiftState_GIFT_CANCELED GiftState = 2
)

var GiftState_name = map[int32]string{
	0: "GIFT_NONE",
	1: "GIFT_ACCEPTED",
	2: "GIFT_CANCELED",
}
var GiftState_value = map[string]int32{
	"GIFT_NONE":     0,
	"GIFT_ACCEPTED": 1,
	"GIFT_CANCELED": 2,
}

func (x GiftState) String() string {
	return proto.EnumName(GiftState_name, int32(x))
}
func (GiftState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// DiscountType is the type of the discount.
type DiscountType int32

const (
	DiscountType_DISCOUNT_NONE          DiscountType = 0
	DiscountType_DISCOUNT_PERCENTOFF    DiscountType = 1
	DiscountType_DISCOUNT_FIXEDVALUEOFF DiscountType = 2
)

var DiscountType_name = map[int32]string{
	0: "DISCOUNT_NONE",
	1: "DISCOUNT_PERCENTOFF",
	2: "DISCOUNT_FIXEDVALUEOFF",
}
var DiscountType_value = map[string]int32{
	"DISCOUNT_NONE":          0,
	"DISCOUNT_PERCENTOFF":    1,
	"DISCOUNT_FIXEDVALUEOFF": 2,
}

func (x DiscountType) String() string {
	return proto.EnumName(DiscountType_name, int32(x))
}
func (DiscountType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// State of the emote.
type EmoticonState int32

const (
	EmoticonState_EmoticonState_NONE     EmoticonState = 0
	EmoticonState_EmoticonState_ACTIVE   EmoticonState = 1
	EmoticonState_EmoticonState_PENDING  EmoticonState = 2
	EmoticonState_EmoticonState_INACTIVE EmoticonState = 3
)

var EmoticonState_name = map[int32]string{
	0: "EmoticonState_NONE",
	1: "EmoticonState_ACTIVE",
	2: "EmoticonState_PENDING",
	3: "EmoticonState_INACTIVE",
}
var EmoticonState_value = map[string]int32{
	"EmoticonState_NONE":     0,
	"EmoticonState_ACTIVE":   1,
	"EmoticonState_PENDING":  2,
	"EmoticonState_INACTIVE": 3,
}

func (x EmoticonState) String() string {
	return proto.EnumName(EmoticonState_name, int32(x))
}
func (EmoticonState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// State of the emote prefix.
type EmoticonPrefixState int32

const (
	EmoticonPrefixState_PREFIX_UNKNOWN  EmoticonPrefixState = 0
	EmoticonPrefixState_PREFIX_UNSET    EmoticonPrefixState = 1
	EmoticonPrefixState_PREFIX_ACTIVE   EmoticonPrefixState = 2
	EmoticonPrefixState_PREFIX_REJECTED EmoticonPrefixState = 3
	EmoticonPrefixState_PREFIX_PENDING  EmoticonPrefixState = 4
)

var EmoticonPrefixState_name = map[int32]string{
	0: "PREFIX_UNKNOWN",
	1: "PREFIX_UNSET",
	2: "PREFIX_ACTIVE",
	3: "PREFIX_REJECTED",
	4: "PREFIX_PENDING",
}
var EmoticonPrefixState_value = map[string]int32{
	"PREFIX_UNKNOWN":  0,
	"PREFIX_UNSET":    1,
	"PREFIX_ACTIVE":   2,
	"PREFIX_REJECTED": 3,
	"PREFIX_PENDING":  4,
}

func (x EmoticonPrefixState) String() string {
	return proto.EnumName(EmoticonPrefixState_name, int32(x))
}
func (EmoticonPrefixState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type EmoticonFilter int32

const (
	EmoticonFilter_EmoticonFilter_All       EmoticonFilter = 0
	EmoticonFilter_EmoticonFilter_Partner   EmoticonFilter = 1
	EmoticonFilter_EmoticonFilter_Affiliate EmoticonFilter = 2
)

var EmoticonFilter_name = map[int32]string{
	0: "EmoticonFilter_All",
	1: "EmoticonFilter_Partner",
	2: "EmoticonFilter_Affiliate",
}
var EmoticonFilter_value = map[string]int32{
	"EmoticonFilter_All":       0,
	"EmoticonFilter_Partner":   1,
	"EmoticonFilter_Affiliate": 2,
}

func (x EmoticonFilter) String() string {
	return proto.EnumName(EmoticonFilter_name, int32(x))
}
func (EmoticonFilter) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type ProductIntervalUnit int32

const (
	ProductIntervalUnit_ProductIntervalUnit_NONE    ProductIntervalUnit = 0
	ProductIntervalUnit_ProductIntervalUnit_WEEK    ProductIntervalUnit = 1
	ProductIntervalUnit_ProductIntervalUnit_MONTH   ProductIntervalUnit = 2
	ProductIntervalUnit_ProductIntervalUnit_YEAR    ProductIntervalUnit = 3
	ProductIntervalUnit_ProductIntervalUnit_ONETIME ProductIntervalUnit = 4
)

var ProductIntervalUnit_name = map[int32]string{
	0: "ProductIntervalUnit_NONE",
	1: "ProductIntervalUnit_WEEK",
	2: "ProductIntervalUnit_MONTH",
	3: "ProductIntervalUnit_YEAR",
	4: "ProductIntervalUnit_ONETIME",
}
var ProductIntervalUnit_value = map[string]int32{
	"ProductIntervalUnit_NONE":    0,
	"ProductIntervalUnit_WEEK":    1,
	"ProductIntervalUnit_MONTH":   2,
	"ProductIntervalUnit_YEAR":    3,
	"ProductIntervalUnit_ONETIME": 4,
}

func (x ProductIntervalUnit) String() string {
	return proto.EnumName(ProductIntervalUnit_name, int32(x))
}
func (ProductIntervalUnit) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type ListUserSubscriptionsRequest_Filter int32

const (
	ListUserSubscriptionsRequest_ALL      ListUserSubscriptionsRequest_Filter = 0
	ListUserSubscriptionsRequest_PLATFORM ListUserSubscriptionsRequest_Filter = 1
	ListUserSubscriptionsRequest_GIFT     ListUserSubscriptionsRequest_Filter = 2
)

var ListUserSubscriptionsRequest_Filter_name = map[int32]string{
	0: "ALL",
	1: "PLATFORM",
	2: "GIFT",
}
var ListUserSubscriptionsRequest_Filter_value = map[string]int32{
	"ALL":      0,
	"PLATFORM": 1,
	"GIFT":     2,
}

func (x ListUserSubscriptionsRequest_Filter) String() string {
	return proto.EnumName(ListUserSubscriptionsRequest_Filter_name, int32(x))
}
func (ListUserSubscriptionsRequest_Filter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{18, 0}
}

// Score
// =====
type EmoticonLevel struct {
	MinimumScore  int64 `protobuf:"varint,1,opt,name=minimum_score,json=minimumScore" json:"minimum_score,omitempty"`
	EmoticonLimit int64 `protobuf:"varint,2,opt,name=emoticon_limit,json=emoticonLimit" json:"emoticon_limit,omitempty"`
}

func (m *EmoticonLevel) Reset()                    { *m = EmoticonLevel{} }
func (m *EmoticonLevel) String() string            { return proto.CompactTextString(m) }
func (*EmoticonLevel) ProtoMessage()               {}
func (*EmoticonLevel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *EmoticonLevel) GetMinimumScore() int64 {
	if m != nil {
		return m.MinimumScore
	}
	return 0
}

func (m *EmoticonLevel) GetEmoticonLimit() int64 {
	if m != nil {
		return m.EmoticonLimit
	}
	return 0
}

type SetScoreRequest struct {
	ChannelId       string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	SubscriberScore int64  `protobuf:"varint,2,opt,name=subscriber_score,json=subscriberScore" json:"subscriber_score,omitempty"`
}

func (m *SetScoreRequest) Reset()                    { *m = SetScoreRequest{} }
func (m *SetScoreRequest) String() string            { return proto.CompactTextString(m) }
func (*SetScoreRequest) ProtoMessage()               {}
func (*SetScoreRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *SetScoreRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SetScoreRequest) GetSubscriberScore() int64 {
	if m != nil {
		return m.SubscriberScore
	}
	return 0
}

type SetScoreResponse struct {
	SubscriberScore int64          `protobuf:"varint,1,opt,name=subscriber_score,json=subscriberScore" json:"subscriber_score,omitempty"`
	EmoticonLimit   int64          `protobuf:"varint,2,opt,name=emoticon_limit,json=emoticonLimit" json:"emoticon_limit,omitempty"`
	NextLevel       *EmoticonLevel `protobuf:"bytes,3,opt,name=next_level,json=nextLevel" json:"next_level,omitempty"`
}

func (m *SetScoreResponse) Reset()                    { *m = SetScoreResponse{} }
func (m *SetScoreResponse) String() string            { return proto.CompactTextString(m) }
func (*SetScoreResponse) ProtoMessage()               {}
func (*SetScoreResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *SetScoreResponse) GetSubscriberScore() int64 {
	if m != nil {
		return m.SubscriberScore
	}
	return 0
}

func (m *SetScoreResponse) GetEmoticonLimit() int64 {
	if m != nil {
		return m.EmoticonLimit
	}
	return 0
}

func (m *SetScoreResponse) GetNextLevel() *EmoticonLevel {
	if m != nil {
		return m.NextLevel
	}
	return nil
}

type SubscriptionCount struct {
	Score          int64            `protobuf:"varint,1,opt,name=score" json:"score,omitempty"`
	NextLevel      *EmoticonLevel   `protobuf:"bytes,2,opt,name=next_level,json=nextLevel" json:"next_level,omitempty"`
	CountBreakdown map[string]int64 `protobuf:"bytes,3,rep,name=count_breakdown,json=countBreakdown" json:"count_breakdown,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	ScoreBreakdown map[string]int64 `protobuf:"bytes,4,rep,name=score_breakdown,json=scoreBreakdown" json:"score_breakdown,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	TicketCount    int64            `protobuf:"varint,5,opt,name=ticket_count,json=ticketCount" json:"ticket_count,omitempty"`
	EmoticonLimit  int64            `protobuf:"varint,6,opt,name=emoticon_limit,json=emoticonLimit" json:"emoticon_limit,omitempty"`
}

func (m *SubscriptionCount) Reset()                    { *m = SubscriptionCount{} }
func (m *SubscriptionCount) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionCount) ProtoMessage()               {}
func (*SubscriptionCount) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *SubscriptionCount) GetScore() int64 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *SubscriptionCount) GetNextLevel() *EmoticonLevel {
	if m != nil {
		return m.NextLevel
	}
	return nil
}

func (m *SubscriptionCount) GetCountBreakdown() map[string]int64 {
	if m != nil {
		return m.CountBreakdown
	}
	return nil
}

func (m *SubscriptionCount) GetScoreBreakdown() map[string]int64 {
	if m != nil {
		return m.ScoreBreakdown
	}
	return nil
}

func (m *SubscriptionCount) GetTicketCount() int64 {
	if m != nil {
		return m.TicketCount
	}
	return 0
}

func (m *SubscriptionCount) GetEmoticonLimit() int64 {
	if m != nil {
		return m.EmoticonLimit
	}
	return 0
}

type CalculateSubscriberCountRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *CalculateSubscriberCountRequest) Reset()                    { *m = CalculateSubscriberCountRequest{} }
func (m *CalculateSubscriberCountRequest) String() string            { return proto.CompactTextString(m) }
func (*CalculateSubscriberCountRequest) ProtoMessage()               {}
func (*CalculateSubscriberCountRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *CalculateSubscriberCountRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type CalculateSubscriberCountResponse struct {
	SubsCount *SubscriptionCount `protobuf:"bytes,1,opt,name=subs_count,json=subsCount" json:"subs_count,omitempty"`
}

func (m *CalculateSubscriberCountResponse) Reset()         { *m = CalculateSubscriberCountResponse{} }
func (m *CalculateSubscriberCountResponse) String() string { return proto.CompactTextString(m) }
func (*CalculateSubscriberCountResponse) ProtoMessage()    {}
func (*CalculateSubscriberCountResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{5}
}

func (m *CalculateSubscriberCountResponse) GetSubsCount() *SubscriptionCount {
	if m != nil {
		return m.SubsCount
	}
	return nil
}

// UserSettings
// ============
type GetUserSettingsRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *GetUserSettingsRequest) Reset()                    { *m = GetUserSettingsRequest{} }
func (m *GetUserSettingsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUserSettingsRequest) ProtoMessage()               {}
func (*GetUserSettingsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GetUserSettingsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type GetUserSettingsResponse struct {
	GiftsInFollowedChannelsOnly bool `protobuf:"varint,1,opt,name=gifts_in_followed_channels_only,json=giftsInFollowedChannelsOnly" json:"gifts_in_followed_channels_only,omitempty"`
	HideGiftCount               bool `protobuf:"varint,2,opt,name=hide_gift_count,json=hideGiftCount" json:"hide_gift_count,omitempty"`
}

func (m *GetUserSettingsResponse) Reset()                    { *m = GetUserSettingsResponse{} }
func (m *GetUserSettingsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetUserSettingsResponse) ProtoMessage()               {}
func (*GetUserSettingsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetUserSettingsResponse) GetGiftsInFollowedChannelsOnly() bool {
	if m != nil {
		return m.GiftsInFollowedChannelsOnly
	}
	return false
}

func (m *GetUserSettingsResponse) GetHideGiftCount() bool {
	if m != nil {
		return m.HideGiftCount
	}
	return false
}

type SetUserSettingsRequest struct {
	UserId                             string        `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	GiftsInFollowedChannelsOnly        bool          `protobuf:"varint,2,opt,name=gifts_in_followed_channels_only,json=giftsInFollowedChannelsOnly" json:"gifts_in_followed_channels_only,omitempty"`
	ReceiveGiftsInFollowedChannelsOnly *OptionalBool `protobuf:"bytes,3,opt,name=receive_gifts_in_followed_channels_only,json=receiveGiftsInFollowedChannelsOnly" json:"receive_gifts_in_followed_channels_only,omitempty"`
	HideGiftCount                      *OptionalBool `protobuf:"bytes,4,opt,name=hide_gift_count,json=hideGiftCount" json:"hide_gift_count,omitempty"`
}

func (m *SetUserSettingsRequest) Reset()                    { *m = SetUserSettingsRequest{} }
func (m *SetUserSettingsRequest) String() string            { return proto.CompactTextString(m) }
func (*SetUserSettingsRequest) ProtoMessage()               {}
func (*SetUserSettingsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SetUserSettingsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *SetUserSettingsRequest) GetGiftsInFollowedChannelsOnly() bool {
	if m != nil {
		return m.GiftsInFollowedChannelsOnly
	}
	return false
}

func (m *SetUserSettingsRequest) GetReceiveGiftsInFollowedChannelsOnly() *OptionalBool {
	if m != nil {
		return m.ReceiveGiftsInFollowedChannelsOnly
	}
	return nil
}

func (m *SetUserSettingsRequest) GetHideGiftCount() *OptionalBool {
	if m != nil {
		return m.HideGiftCount
	}
	return nil
}

type SetUserSettingsResponse struct {
	GiftsInFollowedChannelsOnly bool `protobuf:"varint,1,opt,name=gifts_in_followed_channels_only,json=giftsInFollowedChannelsOnly" json:"gifts_in_followed_channels_only,omitempty"`
	HideGiftCount               bool `protobuf:"varint,2,opt,name=hide_gift_count,json=hideGiftCount" json:"hide_gift_count,omitempty"`
}

func (m *SetUserSettingsResponse) Reset()                    { *m = SetUserSettingsResponse{} }
func (m *SetUserSettingsResponse) String() string            { return proto.CompactTextString(m) }
func (*SetUserSettingsResponse) ProtoMessage()               {}
func (*SetUserSettingsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *SetUserSettingsResponse) GetGiftsInFollowedChannelsOnly() bool {
	if m != nil {
		return m.GiftsInFollowedChannelsOnly
	}
	return false
}

func (m *SetUserSettingsResponse) GetHideGiftCount() bool {
	if m != nil {
		return m.HideGiftCount
	}
	return false
}

type OptionalBool struct {
	Value bool `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
}

func (m *OptionalBool) Reset()                    { *m = OptionalBool{} }
func (m *OptionalBool) String() string            { return proto.CompactTextString(m) }
func (*OptionalBool) ProtoMessage()               {}
func (*OptionalBool) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *OptionalBool) GetValue() bool {
	if m != nil {
		return m.Value
	}
	return false
}

// Subscription defines a user's entitlement to product for a time period.
type Subscription struct {
	Id           string                     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	ChannelId    string                     `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	OwnerId      string                     `protobuf:"bytes,3,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId    string                     `protobuf:"bytes,4,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId     string                     `protobuf:"bytes,5,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd   *google_protobuf.Timestamp `protobuf:"bytes,7,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	AccessGuid   string                     `protobuf:"bytes,8,opt,name=access_guid,json=accessGuid" json:"access_guid,omitempty"`
}

func (m *Subscription) Reset()                    { *m = Subscription{} }
func (m *Subscription) String() string            { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()               {}
func (*Subscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *Subscription) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Subscription) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *Subscription) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Subscription) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *Subscription) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *Subscription) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *Subscription) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *Subscription) GetAccessGuid() string {
	if m != nil {
		return m.AccessGuid
	}
	return ""
}

type FulfillSubscriptionRequest struct {
	OwnerId      string                     `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId    string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId     string                     `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd   *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	Platform     Platform                   `protobuf:"varint,6,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
}

func (m *FulfillSubscriptionRequest) Reset()                    { *m = FulfillSubscriptionRequest{} }
func (m *FulfillSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*FulfillSubscriptionRequest) ProtoMessage()               {}
func (*FulfillSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *FulfillSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *FulfillSubscriptionRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *FulfillSubscriptionRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *FulfillSubscriptionRequest) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *FulfillSubscriptionRequest) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *FulfillSubscriptionRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

type FulfillSubscriptionResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *FulfillSubscriptionResponse) Reset()                    { *m = FulfillSubscriptionResponse{} }
func (m *FulfillSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*FulfillSubscriptionResponse) ProtoMessage()               {}
func (*FulfillSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *FulfillSubscriptionResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type CancelSubscriptionRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId string `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId  string `protobuf:"bytes,3,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
}

func (m *CancelSubscriptionRequest) Reset()                    { *m = CancelSubscriptionRequest{} }
func (m *CancelSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelSubscriptionRequest) ProtoMessage()               {}
func (*CancelSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *CancelSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CancelSubscriptionRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CancelSubscriptionRequest) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

type CancelSubscriptionResponse struct {
}

func (m *CancelSubscriptionResponse) Reset()                    { *m = CancelSubscriptionResponse{} }
func (m *CancelSubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelSubscriptionResponse) ProtoMessage()               {}
func (*CancelSubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

type CanSubscribeRequest struct {
	OwnerId   string   `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId string   `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Platform  Platform `protobuf:"varint,3,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
}

func (m *CanSubscribeRequest) Reset()                    { *m = CanSubscribeRequest{} }
func (m *CanSubscribeRequest) String() string            { return proto.CompactTextString(m) }
func (*CanSubscribeRequest) ProtoMessage()               {}
func (*CanSubscribeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *CanSubscribeRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CanSubscribeRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CanSubscribeRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

type CanSubscribeResponse struct {
	CanSubscribe bool `protobuf:"varint,1,opt,name=can_subscribe,json=canSubscribe" json:"can_subscribe,omitempty"`
}

func (m *CanSubscribeResponse) Reset()                    { *m = CanSubscribeResponse{} }
func (m *CanSubscribeResponse) String() string            { return proto.CompactTextString(m) }
func (*CanSubscribeResponse) ProtoMessage()               {}
func (*CanSubscribeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *CanSubscribeResponse) GetCanSubscribe() bool {
	if m != nil {
		return m.CanSubscribe
	}
	return false
}

// ListUserSubscriptionsRequest is the body of ListUserSubscriptions request.
type ListUserSubscriptionsRequest struct {
	OwnerId  string                              `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Limit    int64                               `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	Cursor   string                              `protobuf:"bytes,3,opt,name=cursor" json:"cursor,omitempty"`
	Platform Platform                            `protobuf:"varint,4,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	Filter   ListUserSubscriptionsRequest_Filter `protobuf:"varint,5,opt,name=filter,enum=code.justin.tv.revenue.subscriptions.ListUserSubscriptionsRequest_Filter" json:"filter,omitempty"`
}

func (m *ListUserSubscriptionsRequest) Reset()                    { *m = ListUserSubscriptionsRequest{} }
func (m *ListUserSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListUserSubscriptionsRequest) ProtoMessage()               {}
func (*ListUserSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ListUserSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *ListUserSubscriptionsRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListUserSubscriptionsRequest) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

func (m *ListUserSubscriptionsRequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *ListUserSubscriptionsRequest) GetFilter() ListUserSubscriptionsRequest_Filter {
	if m != nil {
		return m.Filter
	}
	return ListUserSubscriptionsRequest_ALL
}

type GetUserChannelSubscriptionWithPaymentsDataRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) Reset() {
	*m = GetUserChannelSubscriptionWithPaymentsDataRequest{}
}
func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelSubscriptionWithPaymentsDataRequest) ProtoMessage() {}
func (*GetUserChannelSubscriptionWithPaymentsDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{19}
}

func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserChannelSubscriptionWithPaymentsDataRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetUserChannelSubscriptionRequest struct {
	OwnerId   string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetUserChannelSubscriptionRequest) Reset()         { *m = GetUserChannelSubscriptionRequest{} }
func (m *GetUserChannelSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserChannelSubscriptionRequest) ProtoMessage()    {}
func (*GetUserChannelSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{20}
}

func (m *GetUserChannelSubscriptionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserChannelSubscriptionRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// UserSubscription defines active subscription for a twitch user.
type UserSubscription struct {
	SubscriptionId string                     `protobuf:"bytes,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
	OwnerId        string                     `protobuf:"bytes,2,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId      string                     `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	OriginId       string                     `protobuf:"bytes,4,opt,name=origin_id,json=originId" json:"origin_id,omitempty"`
	BenefitStart   *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=benefit_start,json=benefitStart" json:"benefit_start,omitempty"`
	BenefitEnd     *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=benefit_end,json=benefitEnd" json:"benefit_end,omitempty"`
	Platform       Platform                   `protobuf:"varint,7,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	RenewsAt       *google_protobuf.Timestamp `protobuf:"bytes,8,opt,name=renews_at,json=renewsAt" json:"renews_at,omitempty"`
	ExtPurchaseSku string                     `protobuf:"bytes,9,opt,name=ext_purchase_sku,json=extPurchaseSku" json:"ext_purchase_sku,omitempty"`
	IsPrime        bool                       `protobuf:"varint,10,opt,name=is_prime,json=isPrime" json:"is_prime,omitempty"`
	IsGift         bool                       `protobuf:"varint,11,opt,name=is_gift,json=isGift" json:"is_gift,omitempty"`
	IsRefundable   bool                       `protobuf:"varint,12,opt,name=is_refundable,json=isRefundable" json:"is_refundable,omitempty"`
}

func (m *UserSubscription) Reset()                    { *m = UserSubscription{} }
func (m *UserSubscription) String() string            { return proto.CompactTextString(m) }
func (*UserSubscription) ProtoMessage()               {}
func (*UserSubscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *UserSubscription) GetSubscriptionId() string {
	if m != nil {
		return m.SubscriptionId
	}
	return ""
}

func (m *UserSubscription) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *UserSubscription) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *UserSubscription) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *UserSubscription) GetBenefitStart() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitStart
	}
	return nil
}

func (m *UserSubscription) GetBenefitEnd() *google_protobuf.Timestamp {
	if m != nil {
		return m.BenefitEnd
	}
	return nil
}

func (m *UserSubscription) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *UserSubscription) GetRenewsAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.RenewsAt
	}
	return nil
}

func (m *UserSubscription) GetExtPurchaseSku() string {
	if m != nil {
		return m.ExtPurchaseSku
	}
	return ""
}

func (m *UserSubscription) GetIsPrime() bool {
	if m != nil {
		return m.IsPrime
	}
	return false
}

func (m *UserSubscription) GetIsGift() bool {
	if m != nil {
		return m.IsGift
	}
	return false
}

func (m *UserSubscription) GetIsRefundable() bool {
	if m != nil {
		return m.IsRefundable
	}
	return false
}

// Element of a list of UserSubscriptions
type UserSubscriptionResult struct {
	Subscription *UserSubscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	Cursor       string            `protobuf:"bytes,2,opt,name=cursor" json:"cursor,omitempty"`
}

func (m *UserSubscriptionResult) Reset()                    { *m = UserSubscriptionResult{} }
func (m *UserSubscriptionResult) String() string            { return proto.CompactTextString(m) }
func (*UserSubscriptionResult) ProtoMessage()               {}
func (*UserSubscriptionResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *UserSubscriptionResult) GetSubscription() *UserSubscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *UserSubscriptionResult) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

// ListUserSubscriptionsResponse is the response to a ListUserSubscriptions request.
type ListUserSubscriptionsResponse struct {
	Results         []*UserSubscriptionResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
	HasPreviousPage bool                      `protobuf:"varint,2,opt,name=has_previous_page,json=hasPreviousPage" json:"has_previous_page,omitempty"`
	HasNextPage     bool                      `protobuf:"varint,3,opt,name=has_next_page,json=hasNextPage" json:"has_next_page,omitempty"`
}

func (m *ListUserSubscriptionsResponse) Reset()                    { *m = ListUserSubscriptionsResponse{} }
func (m *ListUserSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListUserSubscriptionsResponse) ProtoMessage()               {}
func (*ListUserSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ListUserSubscriptionsResponse) GetResults() []*UserSubscriptionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ListUserSubscriptionsResponse) GetHasPreviousPage() bool {
	if m != nil {
		return m.HasPreviousPage
	}
	return false
}

func (m *ListUserSubscriptionsResponse) GetHasNextPage() bool {
	if m != nil {
		return m.HasNextPage
	}
	return false
}

type GetUserChannelSubscriptionWithPaymentsDataResponse struct {
	Subscription *UserSubscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetUserChannelSubscriptionWithPaymentsDataResponse) Reset() {
	*m = GetUserChannelSubscriptionWithPaymentsDataResponse{}
}
func (m *GetUserChannelSubscriptionWithPaymentsDataResponse) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelSubscriptionWithPaymentsDataResponse) ProtoMessage() {}
func (*GetUserChannelSubscriptionWithPaymentsDataResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{24}
}

func (m *GetUserChannelSubscriptionWithPaymentsDataResponse) GetSubscription() *UserSubscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type GetUserChannelSubscriptionResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetUserChannelSubscriptionResponse) Reset()         { *m = GetUserChannelSubscriptionResponse{} }
func (m *GetUserChannelSubscriptionResponse) String() string { return proto.CompactTextString(m) }
func (*GetUserChannelSubscriptionResponse) ProtoMessage()    {}
func (*GetUserChannelSubscriptionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{25}
}

func (m *GetUserChannelSubscriptionResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type GetUserProductSubscriptionsRequest struct {
	OwnerId    string   `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductIds []string `protobuf:"bytes,2,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetUserProductSubscriptionsRequest) Reset()         { *m = GetUserProductSubscriptionsRequest{} }
func (m *GetUserProductSubscriptionsRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserProductSubscriptionsRequest) ProtoMessage()    {}
func (*GetUserProductSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{26}
}

func (m *GetUserProductSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetUserProductSubscriptionsRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

type GetUserProductSubscriptionsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetUserProductSubscriptionsResponse) Reset()         { *m = GetUserProductSubscriptionsResponse{} }
func (m *GetUserProductSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*GetUserProductSubscriptionsResponse) ProtoMessage()    {}
func (*GetUserProductSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27}
}

func (m *GetUserProductSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

type GetUserSubscriptionsRequest struct {
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
}

func (m *GetUserSubscriptionsRequest) Reset()                    { *m = GetUserSubscriptionsRequest{} }
func (m *GetUserSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUserSubscriptionsRequest) ProtoMessage()               {}
func (*GetUserSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *GetUserSubscriptionsRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

type GetUserSubscriptionsResponse struct {
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
}

func (m *GetUserSubscriptionsResponse) Reset()                    { *m = GetUserSubscriptionsResponse{} }
func (m *GetUserSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetUserSubscriptionsResponse) ProtoMessage()               {}
func (*GetUserSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *GetUserSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

// External Product
// ================
type GetExternalProductTemplateSKURequest struct {
	ProductId   string   `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Platform    Platform `protobuf:"varint,2,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	CountryCode string   `protobuf:"bytes,3,opt,name=country_code,json=countryCode" json:"country_code,omitempty"`
}

func (m *GetExternalProductTemplateSKURequest) Reset()         { *m = GetExternalProductTemplateSKURequest{} }
func (m *GetExternalProductTemplateSKURequest) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductTemplateSKURequest) ProtoMessage()    {}
func (*GetExternalProductTemplateSKURequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{30}
}

func (m *GetExternalProductTemplateSKURequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *GetExternalProductTemplateSKURequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *GetExternalProductTemplateSKURequest) GetCountryCode() string {
	if m != nil {
		return m.CountryCode
	}
	return ""
}

type GetExternalProductTemplateSKUResponse struct {
	SkuId string `protobuf:"bytes,1,opt,name=sku_id,json=skuId" json:"sku_id,omitempty"`
}

func (m *GetExternalProductTemplateSKUResponse) Reset()         { *m = GetExternalProductTemplateSKUResponse{} }
func (m *GetExternalProductTemplateSKUResponse) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductTemplateSKUResponse) ProtoMessage()    {}
func (*GetExternalProductTemplateSKUResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{31}
}

func (m *GetExternalProductTemplateSKUResponse) GetSkuId() string {
	if m != nil {
		return m.SkuId
	}
	return ""
}

type GetExternalProductPurchasableSKURequest struct {
	OwnerId     string   `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId   string   `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Platform    Platform `protobuf:"varint,3,opt,name=platform,enum=code.justin.tv.revenue.subscriptions.Platform" json:"platform,omitempty"`
	CountryCode string   `protobuf:"bytes,4,opt,name=country_code,json=countryCode" json:"country_code,omitempty"`
}

func (m *GetExternalProductPurchasableSKURequest) Reset() {
	*m = GetExternalProductPurchasableSKURequest{}
}
func (m *GetExternalProductPurchasableSKURequest) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductPurchasableSKURequest) ProtoMessage()    {}
func (*GetExternalProductPurchasableSKURequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{32}
}

func (m *GetExternalProductPurchasableSKURequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *GetExternalProductPurchasableSKURequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *GetExternalProductPurchasableSKURequest) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_NONE
}

func (m *GetExternalProductPurchasableSKURequest) GetCountryCode() string {
	if m != nil {
		return m.CountryCode
	}
	return ""
}

type GetExternalProductPurchasableSKUResponse struct {
	SkuId string `protobuf:"bytes,1,opt,name=sku_id,json=skuId" json:"sku_id,omitempty"`
}

func (m *GetExternalProductPurchasableSKUResponse) Reset() {
	*m = GetExternalProductPurchasableSKUResponse{}
}
func (m *GetExternalProductPurchasableSKUResponse) String() string { return proto.CompactTextString(m) }
func (*GetExternalProductPurchasableSKUResponse) ProtoMessage()    {}
func (*GetExternalProductPurchasableSKUResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{33}
}

func (m *GetExternalProductPurchasableSKUResponse) GetSkuId() string {
	if m != nil {
		return m.SkuId
	}
	return ""
}

// Paid Upgrades
// =============
// SubKey is used to identify unique subscriptions based on
// product owner and origin.
type SubKey struct {
	Product string `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	Owner   string `protobuf:"bytes,2,opt,name=owner" json:"owner,omitempty"`
	Origin  string `protobuf:"bytes,3,opt,name=origin" json:"origin,omitempty"`
}

func (m *SubKey) Reset()                    { *m = SubKey{} }
func (m *SubKey) String() string            { return proto.CompactTextString(m) }
func (*SubKey) ProtoMessage()               {}
func (*SubKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *SubKey) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *SubKey) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *SubKey) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

type PaidUpgrade struct {
	BaseKey       *SubKey                    `protobuf:"bytes,1,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	UpgradeKey    *SubKey                    `protobuf:"bytes,2,opt,name=upgrade_key,json=upgradeKey" json:"upgrade_key,omitempty"`
	EntitlementId string                     `protobuf:"bytes,3,opt,name=entitlement_id,json=entitlementId" json:"entitlement_id,omitempty"`
	StartDate     *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=start_date,json=startDate" json:"start_date,omitempty"`
	Tier          string                     `protobuf:"bytes,5,opt,name=tier" json:"tier,omitempty"`
	Price         int32                      `protobuf:"varint,6,opt,name=price" json:"price,omitempty"`
}

func (m *PaidUpgrade) Reset()                    { *m = PaidUpgrade{} }
func (m *PaidUpgrade) String() string            { return proto.CompactTextString(m) }
func (*PaidUpgrade) ProtoMessage()               {}
func (*PaidUpgrade) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *PaidUpgrade) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *PaidUpgrade) GetUpgradeKey() *SubKey {
	if m != nil {
		return m.UpgradeKey
	}
	return nil
}

func (m *PaidUpgrade) GetEntitlementId() string {
	if m != nil {
		return m.EntitlementId
	}
	return ""
}

func (m *PaidUpgrade) GetStartDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *PaidUpgrade) GetTier() string {
	if m != nil {
		return m.Tier
	}
	return ""
}

func (m *PaidUpgrade) GetPrice() int32 {
	if m != nil {
		return m.Price
	}
	return 0
}

type GetPaidUpgradesRequest struct {
	Keys []*SubKey `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *GetPaidUpgradesRequest) Reset()                    { *m = GetPaidUpgradesRequest{} }
func (m *GetPaidUpgradesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPaidUpgradesRequest) ProtoMessage()               {}
func (*GetPaidUpgradesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *GetPaidUpgradesRequest) GetKeys() []*SubKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

type GetPaidUpgradesResponse struct {
	PaidUpgrades []*PaidUpgrade `protobuf:"bytes,1,rep,name=paid_upgrades,json=paidUpgrades" json:"paid_upgrades,omitempty"`
}

func (m *GetPaidUpgradesResponse) Reset()                    { *m = GetPaidUpgradesResponse{} }
func (m *GetPaidUpgradesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPaidUpgradesResponse) ProtoMessage()               {}
func (*GetPaidUpgradesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *GetPaidUpgradesResponse) GetPaidUpgrades() []*PaidUpgrade {
	if m != nil {
		return m.PaidUpgrades
	}
	return nil
}

type CreatePaidUpgradeRequest struct {
	BaseKey    *SubKey `protobuf:"bytes,1,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	UpgradeKey *SubKey `protobuf:"bytes,2,opt,name=upgrade_key,json=upgradeKey" json:"upgrade_key,omitempty"`
}

func (m *CreatePaidUpgradeRequest) Reset()                    { *m = CreatePaidUpgradeRequest{} }
func (m *CreatePaidUpgradeRequest) String() string            { return proto.CompactTextString(m) }
func (*CreatePaidUpgradeRequest) ProtoMessage()               {}
func (*CreatePaidUpgradeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *CreatePaidUpgradeRequest) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *CreatePaidUpgradeRequest) GetUpgradeKey() *SubKey {
	if m != nil {
		return m.UpgradeKey
	}
	return nil
}

type CreatePaidUpgradeResponse struct {
	PaidUpgrade *PaidUpgrade `protobuf:"bytes,1,opt,name=paid_upgrade,json=paidUpgrade" json:"paid_upgrade,omitempty"`
}

func (m *CreatePaidUpgradeResponse) Reset()                    { *m = CreatePaidUpgradeResponse{} }
func (m *CreatePaidUpgradeResponse) String() string            { return proto.CompactTextString(m) }
func (*CreatePaidUpgradeResponse) ProtoMessage()               {}
func (*CreatePaidUpgradeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *CreatePaidUpgradeResponse) GetPaidUpgrade() *PaidUpgrade {
	if m != nil {
		return m.PaidUpgrade
	}
	return nil
}

type CancelPaidUpgradeRequest struct {
	BaseKey    *SubKey `protobuf:"bytes,1,opt,name=base_key,json=baseKey" json:"base_key,omitempty"`
	UpgradeKey *SubKey `protobuf:"bytes,2,opt,name=upgrade_key,json=upgradeKey" json:"upgrade_key,omitempty"`
}

func (m *CancelPaidUpgradeRequest) Reset()                    { *m = CancelPaidUpgradeRequest{} }
func (m *CancelPaidUpgradeRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelPaidUpgradeRequest) ProtoMessage()               {}
func (*CancelPaidUpgradeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *CancelPaidUpgradeRequest) GetBaseKey() *SubKey {
	if m != nil {
		return m.BaseKey
	}
	return nil
}

func (m *CancelPaidUpgradeRequest) GetUpgradeKey() *SubKey {
	if m != nil {
		return m.UpgradeKey
	}
	return nil
}

type CancelPaidUpgradeResponse struct {
}

func (m *CancelPaidUpgradeResponse) Reset()                    { *m = CancelPaidUpgradeResponse{} }
func (m *CancelPaidUpgradeResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelPaidUpgradeResponse) ProtoMessage()               {}
func (*CancelPaidUpgradeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

// Chat Notifications
// ======
// Example Body for CreateChatNotificationTokenRequest:
// {
// 	    "owner_id": "29386024", Who does the token belong to?
//      "product_id": "834",    Which ticket product?
//      "available_at": "2018-01-02T15:04:05Z",    When is the token granted?
//      "is_prime" : {"value": true}, specifies whether or not the token is coming from a prime sub. Defaults to paid/not-prime if unspecified.
// }
type CreateChatNotificationTokenRequest struct {
	OwnerId     string                     `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	ProductId   string                     `protobuf:"bytes,2,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	AvailableAt *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=available_at,json=availableAt" json:"available_at,omitempty"`
	IsPrime     *OptionalBool              `protobuf:"bytes,4,opt,name=is_prime,json=isPrime" json:"is_prime,omitempty"`
}

func (m *CreateChatNotificationTokenRequest) Reset()         { *m = CreateChatNotificationTokenRequest{} }
func (m *CreateChatNotificationTokenRequest) String() string { return proto.CompactTextString(m) }
func (*CreateChatNotificationTokenRequest) ProtoMessage()    {}
func (*CreateChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{42}
}

func (m *CreateChatNotificationTokenRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CreateChatNotificationTokenRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateChatNotificationTokenRequest) GetAvailableAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.AvailableAt
	}
	return nil
}

func (m *CreateChatNotificationTokenRequest) GetIsPrime() *OptionalBool {
	if m != nil {
		return m.IsPrime
	}
	return nil
}

type CreateChatNotificationTokenResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *CreateChatNotificationTokenResponse) Reset()         { *m = CreateChatNotificationTokenResponse{} }
func (m *CreateChatNotificationTokenResponse) String() string { return proto.CompactTextString(m) }
func (*CreateChatNotificationTokenResponse) ProtoMessage()    {}
func (*CreateChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{43}
}

func (m *CreateChatNotificationTokenResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// Example Body for UseChatNotificationTokenRequest:
// {
// 	    "token_id": "29386024", which token do we want to use?
//      "authed_user_id": "834",   the id of the authed user calling this endpoint
//      "custom_message": "im a custom message", do we want to post a custom message?
// }
type UseChatNotificationTokenRequest struct {
	TokenId       string `protobuf:"bytes,1,opt,name=token_id,json=tokenId" json:"token_id,omitempty"`
	AuthedUserId  string `protobuf:"bytes,2,opt,name=authed_user_id,json=authedUserId" json:"authed_user_id,omitempty"`
	CustomMessage string `protobuf:"bytes,3,opt,name=custom_message,json=customMessage" json:"custom_message,omitempty"`
}

func (m *UseChatNotificationTokenRequest) Reset()         { *m = UseChatNotificationTokenRequest{} }
func (m *UseChatNotificationTokenRequest) String() string { return proto.CompactTextString(m) }
func (*UseChatNotificationTokenRequest) ProtoMessage()    {}
func (*UseChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{44}
}

func (m *UseChatNotificationTokenRequest) GetTokenId() string {
	if m != nil {
		return m.TokenId
	}
	return ""
}

func (m *UseChatNotificationTokenRequest) GetAuthedUserId() string {
	if m != nil {
		return m.AuthedUserId
	}
	return ""
}

func (m *UseChatNotificationTokenRequest) GetCustomMessage() string {
	if m != nil {
		return m.CustomMessage
	}
	return ""
}

type UseChatNotificationTokenResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *UseChatNotificationTokenResponse) Reset()         { *m = UseChatNotificationTokenResponse{} }
func (m *UseChatNotificationTokenResponse) String() string { return proto.CompactTextString(m) }
func (*UseChatNotificationTokenResponse) ProtoMessage()    {}
func (*UseChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{45}
}

func (m *UseChatNotificationTokenResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type CancelChatNotificationTokenRequest struct {
	SubscriptionId string `protobuf:"bytes,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
}

func (m *CancelChatNotificationTokenRequest) Reset()         { *m = CancelChatNotificationTokenRequest{} }
func (m *CancelChatNotificationTokenRequest) String() string { return proto.CompactTextString(m) }
func (*CancelChatNotificationTokenRequest) ProtoMessage()    {}
func (*CancelChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{46}
}

func (m *CancelChatNotificationTokenRequest) GetSubscriptionId() string {
	if m != nil {
		return m.SubscriptionId
	}
	return ""
}

type CancelChatNotificationTokenResponse struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *CancelChatNotificationTokenResponse) Reset()         { *m = CancelChatNotificationTokenResponse{} }
func (m *CancelChatNotificationTokenResponse) String() string { return proto.CompactTextString(m) }
func (*CancelChatNotificationTokenResponse) ProtoMessage()    {}
func (*CancelChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{47}
}

func (m *CancelChatNotificationTokenResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type GetUserChannelChatNotificationTokenRequest struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetUserChannelChatNotificationTokenRequest) Reset() {
	*m = GetUserChannelChatNotificationTokenRequest{}
}
func (m *GetUserChannelChatNotificationTokenRequest) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelChatNotificationTokenRequest) ProtoMessage() {}
func (*GetUserChannelChatNotificationTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{48}
}

func (m *GetUserChannelChatNotificationTokenRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetUserChannelChatNotificationTokenRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetUserChannelChatNotificationTokenResponse struct {
	ChatNotificationToken *ChatNotificationToken `protobuf:"bytes,1,opt,name=chat_notification_token,json=chatNotificationToken" json:"chat_notification_token,omitempty"`
}

func (m *GetUserChannelChatNotificationTokenResponse) Reset() {
	*m = GetUserChannelChatNotificationTokenResponse{}
}
func (m *GetUserChannelChatNotificationTokenResponse) String() string {
	return proto.CompactTextString(m)
}
func (*GetUserChannelChatNotificationTokenResponse) ProtoMessage() {}
func (*GetUserChannelChatNotificationTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{49}
}

func (m *GetUserChannelChatNotificationTokenResponse) GetChatNotificationToken() *ChatNotificationToken {
	if m != nil {
		return m.ChatNotificationToken
	}
	return nil
}

type ChatNotificationToken struct {
	Id      string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Message string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	Month   string `protobuf:"bytes,3,opt,name=month" json:"month,omitempty"`
	Kind    string `protobuf:"bytes,4,opt,name=kind" json:"kind,omitempty"`
}

func (m *ChatNotificationToken) Reset()                    { *m = ChatNotificationToken{} }
func (m *ChatNotificationToken) String() string            { return proto.CompactTextString(m) }
func (*ChatNotificationToken) ProtoMessage()               {}
func (*ChatNotificationToken) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

func (m *ChatNotificationToken) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ChatNotificationToken) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ChatNotificationToken) GetMonth() string {
	if m != nil {
		return m.Month
	}
	return ""
}

func (m *ChatNotificationToken) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

// Gifts
// ======
type Gift struct {
	Sender    string                     `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string                     `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string                     `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
	Origin    string                     `protobuf:"bytes,4,opt,name=origin" json:"origin,omitempty"`
	State     GiftState                  `protobuf:"varint,5,opt,name=state,enum=code.justin.tv.revenue.subscriptions.GiftState" json:"state,omitempty"`
	GiftDate  *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=gift_date,json=giftDate" json:"gift_date,omitempty"`
}

func (m *Gift) Reset()                    { *m = Gift{} }
func (m *Gift) String() string            { return proto.CompactTextString(m) }
func (*Gift) ProtoMessage()               {}
func (*Gift) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{51} }

func (m *Gift) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *Gift) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *Gift) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *Gift) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *Gift) GetState() GiftState {
	if m != nil {
		return m.State
	}
	return GiftState_GIFT_NONE
}

func (m *Gift) GetGiftDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.GiftDate
	}
	return nil
}

// GiftKey is used to identify gifts using product, origin, owner (receiver), domain.
// This is convention from HATS so that consumers don't need to store extra information.
// Product, owner, origin, domain (POOD) is used as a hash key in the gifts dynamo table
// for blazing fast lookups.
type GiftKey struct {
	Product   string `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	Origin    string `protobuf:"bytes,2,opt,name=origin" json:"origin,omitempty"`
	Recipient string `protobuf:"bytes,3,opt,name=recipient" json:"recipient,omitempty"`
}

func (m *GiftKey) Reset()                    { *m = GiftKey{} }
func (m *GiftKey) String() string            { return proto.CompactTextString(m) }
func (*GiftKey) ProtoMessage()               {}
func (*GiftKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{52} }

func (m *GiftKey) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *GiftKey) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *GiftKey) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

// CreateGiftRequest is the body of a CreateGift rpc request.
type CreateGiftRequest struct {
	Sender    string `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
	Origin    string `protobuf:"bytes,4,opt,name=origin" json:"origin,omitempty"`
}

func (m *CreateGiftRequest) Reset()                    { *m = CreateGiftRequest{} }
func (m *CreateGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateGiftRequest) ProtoMessage()               {}
func (*CreateGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

func (m *CreateGiftRequest) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *CreateGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *CreateGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *CreateGiftRequest) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

// CreateGiftResponse is the response to a CreateGift rpc request.
type CreateGiftResponse struct {
	Gift *Gift `protobuf:"bytes,1,opt,name=gift" json:"gift,omitempty"`
}

func (m *CreateGiftResponse) Reset()                    { *m = CreateGiftResponse{} }
func (m *CreateGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateGiftResponse) ProtoMessage()               {}
func (*CreateGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *CreateGiftResponse) GetGift() *Gift {
	if m != nil {
		return m.Gift
	}
	return nil
}

// CancelGiftRequest is the body of a CancelGift rpc request.
type CancelGiftRequest struct {
	Product   string `protobuf:"bytes,1,opt,name=product" json:"product,omitempty"`
	Origin    string `protobuf:"bytes,2,opt,name=origin" json:"origin,omitempty"`
	Recipient string `protobuf:"bytes,3,opt,name=recipient" json:"recipient,omitempty"`
}

func (m *CancelGiftRequest) Reset()                    { *m = CancelGiftRequest{} }
func (m *CancelGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelGiftRequest) ProtoMessage()               {}
func (*CancelGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

func (m *CancelGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *CancelGiftRequest) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

func (m *CancelGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

// CancelGiftResponse is the response of a CancelGift rpc request.
type CancelGiftResponse struct {
	CanceledGift *Gift `protobuf:"bytes,1,opt,name=canceled_gift,json=canceledGift" json:"canceled_gift,omitempty"`
}

func (m *CancelGiftResponse) Reset()                    { *m = CancelGiftResponse{} }
func (m *CancelGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelGiftResponse) ProtoMessage()               {}
func (*CancelGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

func (m *CancelGiftResponse) GetCanceledGift() *Gift {
	if m != nil {
		return m.CanceledGift
	}
	return nil
}

// GetGifts
type GetGiftsRequest struct {
	Keys []*GiftKey `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *GetGiftsRequest) Reset()                    { *m = GetGiftsRequest{} }
func (m *GetGiftsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGiftsRequest) ProtoMessage()               {}
func (*GetGiftsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

func (m *GetGiftsRequest) GetKeys() []*GiftKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

type GetGiftsResponse struct {
	Gifts []*Gift `protobuf:"bytes,1,rep,name=gifts" json:"gifts,omitempty"`
}

func (m *GetGiftsResponse) Reset()                    { *m = GetGiftsResponse{} }
func (m *GetGiftsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetGiftsResponse) ProtoMessage()               {}
func (*GetGiftsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{58} }

func (m *GetGiftsResponse) GetGifts() []*Gift {
	if m != nil {
		return m.Gifts
	}
	return nil
}

// CanGift
type CanGiftRequest struct {
	Sender    string `protobuf:"bytes,1,opt,name=sender" json:"sender,omitempty"`
	Recipient string `protobuf:"bytes,2,opt,name=recipient" json:"recipient,omitempty"`
	Product   string `protobuf:"bytes,3,opt,name=product" json:"product,omitempty"`
}

func (m *CanGiftRequest) Reset()                    { *m = CanGiftRequest{} }
func (m *CanGiftRequest) String() string            { return proto.CompactTextString(m) }
func (*CanGiftRequest) ProtoMessage()               {}
func (*CanGiftRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{59} }

func (m *CanGiftRequest) GetSender() string {
	if m != nil {
		return m.Sender
	}
	return ""
}

func (m *CanGiftRequest) GetRecipient() string {
	if m != nil {
		return m.Recipient
	}
	return ""
}

func (m *CanGiftRequest) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

type CanGiftResponse struct {
	CanGift bool `protobuf:"varint,1,opt,name=can_gift,json=canGift" json:"can_gift,omitempty"`
}

func (m *CanGiftResponse) Reset()                    { *m = CanGiftResponse{} }
func (m *CanGiftResponse) String() string            { return proto.CompactTextString(m) }
func (*CanGiftResponse) ProtoMessage()               {}
func (*CanGiftResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60} }

func (m *CanGiftResponse) GetCanGift() bool {
	if m != nil {
		return m.CanGift
	}
	return false
}

// GiftPromotion describes the promotion on a subscription product.
type GiftPromotion struct {
	ProductId     string       `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	NewPrice      int64        `protobuf:"varint,2,opt,name=new_price,json=newPrice" json:"new_price,omitempty"`
	OldPrice      int64        `protobuf:"varint,3,opt,name=old_price,json=oldPrice" json:"old_price,omitempty"`
	DiscountType  DiscountType `protobuf:"varint,4,opt,name=discount_type,json=discountType,enum=code.justin.tv.revenue.subscriptions.DiscountType" json:"discount_type,omitempty"`
	DiscountValue int64        `protobuf:"varint,5,opt,name=discount_value,json=discountValue" json:"discount_value,omitempty"`
	Error         string       `protobuf:"bytes,6,opt,name=error" json:"error,omitempty"`
}

func (m *GiftPromotion) Reset()                    { *m = GiftPromotion{} }
func (m *GiftPromotion) String() string            { return proto.CompactTextString(m) }
func (*GiftPromotion) ProtoMessage()               {}
func (*GiftPromotion) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{61} }

func (m *GiftPromotion) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *GiftPromotion) GetNewPrice() int64 {
	if m != nil {
		return m.NewPrice
	}
	return 0
}

func (m *GiftPromotion) GetOldPrice() int64 {
	if m != nil {
		return m.OldPrice
	}
	return 0
}

func (m *GiftPromotion) GetDiscountType() DiscountType {
	if m != nil {
		return m.DiscountType
	}
	return DiscountType_DISCOUNT_NONE
}

func (m *GiftPromotion) GetDiscountValue() int64 {
	if m != nil {
		return m.DiscountValue
	}
	return 0
}

func (m *GiftPromotion) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// GetGiftPromotionRequest describes the request of GetGiftPromotion.
type GetGiftPromotionRequest struct {
	ProductIds []string `protobuf:"bytes,1,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetGiftPromotionRequest) Reset()                    { *m = GetGiftPromotionRequest{} }
func (m *GetGiftPromotionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGiftPromotionRequest) ProtoMessage()               {}
func (*GetGiftPromotionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{62} }

func (m *GetGiftPromotionRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

// GetGiftPromotionResponse describes the response of GetGiftPromotion.
type GetGiftPromotionResponse struct {
	IsPromotionActive bool             `protobuf:"varint,1,opt,name=is_promotion_active,json=isPromotionActive" json:"is_promotion_active,omitempty"`
	GiftPromotions    []*GiftPromotion `protobuf:"bytes,2,rep,name=gift_promotions,json=giftPromotions" json:"gift_promotions,omitempty"`
}

func (m *GetGiftPromotionResponse) Reset()                    { *m = GetGiftPromotionResponse{} }
func (m *GetGiftPromotionResponse) String() string            { return proto.CompactTextString(m) }
func (*GetGiftPromotionResponse) ProtoMessage()               {}
func (*GetGiftPromotionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{63} }

func (m *GetGiftPromotionResponse) GetIsPromotionActive() bool {
	if m != nil {
		return m.IsPromotionActive
	}
	return false
}

func (m *GetGiftPromotionResponse) GetGiftPromotions() []*GiftPromotion {
	if m != nil {
		return m.GiftPromotions
	}
	return nil
}

// Emoticons
// ======
type GetEmotePrefixRequest struct {
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
}

func (m *GetEmotePrefixRequest) Reset()                    { *m = GetEmotePrefixRequest{} }
func (m *GetEmotePrefixRequest) String() string            { return proto.CompactTextString(m) }
func (*GetEmotePrefixRequest) ProtoMessage()               {}
func (*GetEmotePrefixRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{64} }

func (m *GetEmotePrefixRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

type GetEmotePrefixResponse struct {
	Prefixes []string `protobuf:"bytes,1,rep,name=prefixes" json:"prefixes,omitempty"`
}

func (m *GetEmotePrefixResponse) Reset()                    { *m = GetEmotePrefixResponse{} }
func (m *GetEmotePrefixResponse) String() string            { return proto.CompactTextString(m) }
func (*GetEmotePrefixResponse) ProtoMessage()               {}
func (*GetEmotePrefixResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{65} }

func (m *GetEmotePrefixResponse) GetPrefixes() []string {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

type GetEmoticonPrefixRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetEmoticonPrefixRequest) Reset()                    { *m = GetEmoticonPrefixRequest{} }
func (m *GetEmoticonPrefixRequest) String() string            { return proto.CompactTextString(m) }
func (*GetEmoticonPrefixRequest) ProtoMessage()               {}
func (*GetEmoticonPrefixRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{66} }

func (m *GetEmoticonPrefixRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetEmoticonPrefixResponse struct {
	Prefix string              `protobuf:"bytes,1,opt,name=prefix" json:"prefix,omitempty"`
	State  EmoticonPrefixState `protobuf:"varint,2,opt,name=state,enum=code.justin.tv.revenue.subscriptions.EmoticonPrefixState" json:"state,omitempty"`
}

func (m *GetEmoticonPrefixResponse) Reset()                    { *m = GetEmoticonPrefixResponse{} }
func (m *GetEmoticonPrefixResponse) String() string            { return proto.CompactTextString(m) }
func (*GetEmoticonPrefixResponse) ProtoMessage()               {}
func (*GetEmoticonPrefixResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{67} }

func (m *GetEmoticonPrefixResponse) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *GetEmoticonPrefixResponse) GetState() EmoticonPrefixState {
	if m != nil {
		return m.State
	}
	return EmoticonPrefixState_PREFIX_UNKNOWN
}

type CreateEmoticonRequest struct {
	UserId     string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	CodeSuffix string `protobuf:"bytes,2,opt,name=code_suffix,json=codeSuffix" json:"code_suffix,omitempty"`
	ProductId  string `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Image28Id  string `protobuf:"bytes,4,opt,name=image28_id,json=image28Id" json:"image28_id,omitempty"`
	Image56Id  string `protobuf:"bytes,5,opt,name=image56_id,json=image56Id" json:"image56_id,omitempty"`
	Image112Id string `protobuf:"bytes,6,opt,name=image112_id,json=image112Id" json:"image112_id,omitempty"`
}

func (m *CreateEmoticonRequest) Reset()                    { *m = CreateEmoticonRequest{} }
func (m *CreateEmoticonRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateEmoticonRequest) ProtoMessage()               {}
func (*CreateEmoticonRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{68} }

func (m *CreateEmoticonRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *CreateEmoticonRequest) GetCodeSuffix() string {
	if m != nil {
		return m.CodeSuffix
	}
	return ""
}

func (m *CreateEmoticonRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateEmoticonRequest) GetImage28Id() string {
	if m != nil {
		return m.Image28Id
	}
	return ""
}

func (m *CreateEmoticonRequest) GetImage56Id() string {
	if m != nil {
		return m.Image56Id
	}
	return ""
}

func (m *CreateEmoticonRequest) GetImage112Id() string {
	if m != nil {
		return m.Image112Id
	}
	return ""
}

type CreateEmoticonReponse struct {
	Id        string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Code      string `protobuf:"bytes,2,opt,name=code" json:"code,omitempty"`
	ProductId string `protobuf:"bytes,3,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	GroupId   string `protobuf:"bytes,4,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	State     string `protobuf:"bytes,5,opt,name=state" json:"state,omitempty"`
}

func (m *CreateEmoticonReponse) Reset()                    { *m = CreateEmoticonReponse{} }
func (m *CreateEmoticonReponse) String() string            { return proto.CompactTextString(m) }
func (*CreateEmoticonReponse) ProtoMessage()               {}
func (*CreateEmoticonReponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{69} }

func (m *CreateEmoticonReponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CreateEmoticonReponse) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *CreateEmoticonReponse) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *CreateEmoticonReponse) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *CreateEmoticonReponse) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

type GetAllEmoticonsByProductIDsRequest struct {
	ProductIds []string `protobuf:"bytes,1,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetAllEmoticonsByProductIDsRequest) Reset()         { *m = GetAllEmoticonsByProductIDsRequest{} }
func (m *GetAllEmoticonsByProductIDsRequest) String() string { return proto.CompactTextString(m) }
func (*GetAllEmoticonsByProductIDsRequest) ProtoMessage()    {}
func (*GetAllEmoticonsByProductIDsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{70}
}

func (m *GetAllEmoticonsByProductIDsRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

type GetAllEmoticonsByProductIDsResponse struct {
	EmoticonGroups []*EmoticonGroup `protobuf:"bytes,1,rep,name=emoticon_groups,json=emoticonGroups" json:"emoticon_groups,omitempty"`
}

func (m *GetAllEmoticonsByProductIDsResponse) Reset()         { *m = GetAllEmoticonsByProductIDsResponse{} }
func (m *GetAllEmoticonsByProductIDsResponse) String() string { return proto.CompactTextString(m) }
func (*GetAllEmoticonsByProductIDsResponse) ProtoMessage()    {}
func (*GetAllEmoticonsByProductIDsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{71}
}

func (m *GetAllEmoticonsByProductIDsResponse) GetEmoticonGroups() []*EmoticonGroup {
	if m != nil {
		return m.EmoticonGroups
	}
	return nil
}

type EmoticonGroup struct {
	ProductId string      `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	Emoticons []*Emoticon `protobuf:"bytes,2,rep,name=emoticons" json:"emoticons,omitempty"`
}

func (m *EmoticonGroup) Reset()                    { *m = EmoticonGroup{} }
func (m *EmoticonGroup) String() string            { return proto.CompactTextString(m) }
func (*EmoticonGroup) ProtoMessage()               {}
func (*EmoticonGroup) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{72} }

func (m *EmoticonGroup) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *EmoticonGroup) GetEmoticons() []*Emoticon {
	if m != nil {
		return m.Emoticons
	}
	return nil
}

type Emoticon struct {
	Id      string        `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Code    string        `protobuf:"bytes,2,opt,name=code" json:"code,omitempty"`
	GroupId string        `protobuf:"bytes,3,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	State   EmoticonState `protobuf:"varint,4,opt,name=state,enum=code.justin.tv.revenue.subscriptions.EmoticonState" json:"state,omitempty"`
}

func (m *Emoticon) Reset()                    { *m = Emoticon{} }
func (m *Emoticon) String() string            { return proto.CompactTextString(m) }
func (*Emoticon) ProtoMessage()               {}
func (*Emoticon) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{73} }

func (m *Emoticon) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Emoticon) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *Emoticon) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *Emoticon) GetState() EmoticonState {
	if m != nil {
		return m.State
	}
	return EmoticonState_EmoticonState_NONE
}

// GetPartnerStandingRequest takes a user_id to find the partner standing status for.
type GetPartnerStandingRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
}

func (m *GetPartnerStandingRequest) Reset()                    { *m = GetPartnerStandingRequest{} }
func (m *GetPartnerStandingRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPartnerStandingRequest) ProtoMessage()               {}
func (*GetPartnerStandingRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{74} }

func (m *GetPartnerStandingRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

// GetPartnerStandingStatusResponse returns the partner standing status for a given user.
// Partners are considered to be in “good standing” if they have not had a conduct infraction within the last 90 days.
type GetPartnerStandingResponse struct {
	IsInGoodStanding bool `protobuf:"varint,1,opt,name=is_in_good_standing,json=isInGoodStanding" json:"is_in_good_standing,omitempty"`
}

func (m *GetPartnerStandingResponse) Reset()                    { *m = GetPartnerStandingResponse{} }
func (m *GetPartnerStandingResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPartnerStandingResponse) ProtoMessage()               {}
func (*GetPartnerStandingResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{75} }

func (m *GetPartnerStandingResponse) GetIsInGoodStanding() bool {
	if m != nil {
		return m.IsInGoodStanding
	}
	return false
}

// SubmitEmoticonPrefixRequest takes a prefix and a user id.
// Prefix must be between 3 and 10 characters inclusive.
type SubmitEmoticonPrefixRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Prefix    string `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
}

func (m *SubmitEmoticonPrefixRequest) Reset()                    { *m = SubmitEmoticonPrefixRequest{} }
func (m *SubmitEmoticonPrefixRequest) String() string            { return proto.CompactTextString(m) }
func (*SubmitEmoticonPrefixRequest) ProtoMessage()               {}
func (*SubmitEmoticonPrefixRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{76} }

func (m *SubmitEmoticonPrefixRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *SubmitEmoticonPrefixRequest) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

// SubmitEmoticonPrefixResponse will be empty. Check the status code to determine whether the
// request was succesful.
type SubmitEmoticonPrefixResponse struct {
}

func (m *SubmitEmoticonPrefixResponse) Reset()                    { *m = SubmitEmoticonPrefixResponse{} }
func (m *SubmitEmoticonPrefixResponse) String() string            { return proto.CompactTextString(m) }
func (*SubmitEmoticonPrefixResponse) ProtoMessage()               {}
func (*SubmitEmoticonPrefixResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{77} }

// Pending Emoticons
// =========
// GetPendingEmoticonsRequest
type GetPendingEmoticonsRequest struct {
	Filter EmoticonFilter  `protobuf:"varint,1,opt,name=filter,enum=code.justin.tv.revenue.subscriptions.EmoticonFilter" json:"filter,omitempty"`
	Count  int32           `protobuf:"varint,2,opt,name=count" json:"count,omitempty"`
	Bucket *EmoticonBucket `protobuf:"bytes,3,opt,name=bucket" json:"bucket,omitempty"`
}

func (m *GetPendingEmoticonsRequest) Reset()                    { *m = GetPendingEmoticonsRequest{} }
func (m *GetPendingEmoticonsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsRequest) ProtoMessage()               {}
func (*GetPendingEmoticonsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{78} }

func (m *GetPendingEmoticonsRequest) GetFilter() EmoticonFilter {
	if m != nil {
		return m.Filter
	}
	return EmoticonFilter_EmoticonFilter_All
}

func (m *GetPendingEmoticonsRequest) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *GetPendingEmoticonsRequest) GetBucket() *EmoticonBucket {
	if m != nil {
		return m.Bucket
	}
	return nil
}

type EmoticonBucket struct {
	Requested   int32 `protobuf:"varint,1,opt,name=requested" json:"requested,omitempty"`
	BucketCount int32 `protobuf:"varint,2,opt,name=bucket_count,json=bucketCount" json:"bucket_count,omitempty"`
}

func (m *EmoticonBucket) Reset()                    { *m = EmoticonBucket{} }
func (m *EmoticonBucket) String() string            { return proto.CompactTextString(m) }
func (*EmoticonBucket) ProtoMessage()               {}
func (*EmoticonBucket) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{79} }

func (m *EmoticonBucket) GetRequested() int32 {
	if m != nil {
		return m.Requested
	}
	return 0
}

func (m *EmoticonBucket) GetBucketCount() int32 {
	if m != nil {
		return m.BucketCount
	}
	return 0
}

type GetPendingEmoticonsResponse struct {
	Emoticons  []*PendingEmoticon `protobuf:"bytes,1,rep,name=emoticons" json:"emoticons,omitempty"`
	TotalCount int32              `protobuf:"varint,2,opt,name=total_count,json=totalCount" json:"total_count,omitempty"`
}

func (m *GetPendingEmoticonsResponse) Reset()                    { *m = GetPendingEmoticonsResponse{} }
func (m *GetPendingEmoticonsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPendingEmoticonsResponse) ProtoMessage()               {}
func (*GetPendingEmoticonsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{80} }

func (m *GetPendingEmoticonsResponse) GetEmoticons() []*PendingEmoticon {
	if m != nil {
		return m.Emoticons
	}
	return nil
}

func (m *GetPendingEmoticonsResponse) GetTotalCount() int32 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

// PendingEmoticon contains all the data necessary for Moderation to view and judge an emoticon
type PendingEmoticon struct {
	Id         string                     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Prefix     string                     `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
	Code       string                     `protobuf:"bytes,3,opt,name=code" json:"code,omitempty"`
	OwnerId    string                     `protobuf:"bytes,4,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	UploadTime *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=upload_time,json=uploadTime" json:"upload_time,omitempty"`
}

func (m *PendingEmoticon) Reset()                    { *m = PendingEmoticon{} }
func (m *PendingEmoticon) String() string            { return proto.CompactTextString(m) }
func (*PendingEmoticon) ProtoMessage()               {}
func (*PendingEmoticon) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{81} }

func (m *PendingEmoticon) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PendingEmoticon) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *PendingEmoticon) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *PendingEmoticon) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *PendingEmoticon) GetUploadTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.UploadTime
	}
	return nil
}

// Products
// =========
type Product struct {
	Id              string           `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	ShortName       string           `protobuf:"bytes,2,opt,name=short_name,json=shortName" json:"short_name,omitempty"`
	DisplayName     string           `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	EmoticonSetIds  []string         `protobuf:"bytes,4,rep,name=emoticon_set_ids,json=emoticonSetIds" json:"emoticon_set_ids,omitempty"`
	Price           int32            `protobuf:"varint,5,opt,name=price" json:"price,omitempty"`
	HideAds         bool             `protobuf:"varint,6,opt,name=hide_ads,json=hideAds" json:"hide_ads,omitempty"`
	Type            string           `protobuf:"bytes,7,opt,name=type" json:"type,omitempty"`
	OwnerId         string           `protobuf:"bytes,8,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Tier            string           `protobuf:"bytes,9,opt,name=tier" json:"tier,omitempty"`
	Interval        *ProductInterval `protobuf:"bytes,10,opt,name=interval" json:"interval,omitempty"`
	BitrateAccess   []string         `protobuf:"bytes,11,rep,name=bitrate_access,json=bitrateAccess" json:"bitrate_access,omitempty"`
	SubonlyArchives bool             `protobuf:"varint,12,opt,name=subonly_archives,json=subonlyArchives" json:"subonly_archives,omitempty"`
	EmoticonSetId   string           `protobuf:"bytes,13,opt,name=emoticon_set_id,json=emoticonSetId" json:"emoticon_set_id,omitempty"`
}

func (m *Product) Reset()                    { *m = Product{} }
func (m *Product) String() string            { return proto.CompactTextString(m) }
func (*Product) ProtoMessage()               {}
func (*Product) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{82} }

func (m *Product) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Product) GetShortName() string {
	if m != nil {
		return m.ShortName
	}
	return ""
}

func (m *Product) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Product) GetEmoticonSetIds() []string {
	if m != nil {
		return m.EmoticonSetIds
	}
	return nil
}

func (m *Product) GetPrice() int32 {
	if m != nil {
		return m.Price
	}
	return 0
}

func (m *Product) GetHideAds() bool {
	if m != nil {
		return m.HideAds
	}
	return false
}

func (m *Product) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Product) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Product) GetTier() string {
	if m != nil {
		return m.Tier
	}
	return ""
}

func (m *Product) GetInterval() *ProductInterval {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *Product) GetBitrateAccess() []string {
	if m != nil {
		return m.BitrateAccess
	}
	return nil
}

func (m *Product) GetSubonlyArchives() bool {
	if m != nil {
		return m.SubonlyArchives
	}
	return false
}

func (m *Product) GetEmoticonSetId() string {
	if m != nil {
		return m.EmoticonSetId
	}
	return ""
}

type ProductInterval struct {
	Duration int32               `protobuf:"varint,1,opt,name=duration" json:"duration,omitempty"`
	Unit     ProductIntervalUnit `protobuf:"varint,2,opt,name=unit,enum=code.justin.tv.revenue.subscriptions.ProductIntervalUnit" json:"unit,omitempty"`
}

func (m *ProductInterval) Reset()                    { *m = ProductInterval{} }
func (m *ProductInterval) String() string            { return proto.CompactTextString(m) }
func (*ProductInterval) ProtoMessage()               {}
func (*ProductInterval) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{83} }

func (m *ProductInterval) GetDuration() int32 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *ProductInterval) GetUnit() ProductIntervalUnit {
	if m != nil {
		return m.Unit
	}
	return ProductIntervalUnit_ProductIntervalUnit_NONE
}

// Takes in a list of product_ids. Max 100.
type GetProductsByIDsRequest struct {
	ProductIds []string `protobuf:"bytes,1,rep,name=product_ids,json=productIds" json:"product_ids,omitempty"`
}

func (m *GetProductsByIDsRequest) Reset()                    { *m = GetProductsByIDsRequest{} }
func (m *GetProductsByIDsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetProductsByIDsRequest) ProtoMessage()               {}
func (*GetProductsByIDsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{84} }

func (m *GetProductsByIDsRequest) GetProductIds() []string {
	if m != nil {
		return m.ProductIds
	}
	return nil
}

// Returns a list of products.
type GetProductsByIDsResponse struct {
	Products []*Product `protobuf:"bytes,1,rep,name=products" json:"products,omitempty"`
}

func (m *GetProductsByIDsResponse) Reset()                    { *m = GetProductsByIDsResponse{} }
func (m *GetProductsByIDsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetProductsByIDsResponse) ProtoMessage()               {}
func (*GetProductsByIDsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{85} }

func (m *GetProductsByIDsResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

// Accepts a single channel ID.
type GetChannelProductsRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	ClientId  string `protobuf:"bytes,2,opt,name=client_id,json=clientId" json:"client_id,omitempty"`
}

func (m *GetChannelProductsRequest) Reset()                    { *m = GetChannelProductsRequest{} }
func (m *GetChannelProductsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelProductsRequest) ProtoMessage()               {}
func (*GetChannelProductsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{86} }

func (m *GetChannelProductsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetChannelProductsRequest) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

// Returns a list of products.
type GetChannelProductsResponse struct {
	Products []*Product `protobuf:"bytes,1,rep,name=products" json:"products,omitempty"`
}

func (m *GetChannelProductsResponse) Reset()                    { *m = GetChannelProductsResponse{} }
func (m *GetChannelProductsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetChannelProductsResponse) ProtoMessage()               {}
func (*GetChannelProductsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{87} }

func (m *GetChannelProductsResponse) GetProducts() []*Product {
	if m != nil {
		return m.Products
	}
	return nil
}

// UpdateProductRequest is the request for UpdateProduct rpc method.
type UpdateProductRequest struct {
	ProductId   string `protobuf:"bytes,1,opt,name=product_id,json=productId" json:"product_id,omitempty"`
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (m *UpdateProductRequest) Reset()                    { *m = UpdateProductRequest{} }
func (m *UpdateProductRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateProductRequest) ProtoMessage()               {}
func (*UpdateProductRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{88} }

func (m *UpdateProductRequest) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *UpdateProductRequest) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// empty response for UpdateProduct rpc request.
type UpdateProductResponse struct {
}

func (m *UpdateProductResponse) Reset()                    { *m = UpdateProductResponse{} }
func (m *UpdateProductResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateProductResponse) ProtoMessage()               {}
func (*UpdateProductResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{89} }

// UpdateChannelProductsRequest is the body of UpdateChannelProducts rpc method.
type UpdateChannelProductsRequest struct {
	ChannelId       string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	HideAds         bool   `protobuf:"varint,2,opt,name=hide_ads,json=hideAds" json:"hide_ads,omitempty"`
	SubonlyArchives bool   `protobuf:"varint,3,opt,name=subonly_archives,json=subonlyArchives" json:"subonly_archives,omitempty"`
}

func (m *UpdateChannelProductsRequest) Reset()                    { *m = UpdateChannelProductsRequest{} }
func (m *UpdateChannelProductsRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateChannelProductsRequest) ProtoMessage()               {}
func (*UpdateChannelProductsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{90} }

func (m *UpdateChannelProductsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *UpdateChannelProductsRequest) GetHideAds() bool {
	if m != nil {
		return m.HideAds
	}
	return false
}

func (m *UpdateChannelProductsRequest) GetSubonlyArchives() bool {
	if m != nil {
		return m.SubonlyArchives
	}
	return false
}

// empty response for UpdateChannelProduct rpc request.
type UpdateChannelProductsResponse struct {
}

func (m *UpdateChannelProductsResponse) Reset()                    { *m = UpdateChannelProductsResponse{} }
func (m *UpdateChannelProductsResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateChannelProductsResponse) ProtoMessage()               {}
func (*UpdateChannelProductsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{91} }

func init() {
	proto.RegisterType((*EmoticonLevel)(nil), "code.justin.tv.revenue.subscriptions.EmoticonLevel")
	proto.RegisterType((*SetScoreRequest)(nil), "code.justin.tv.revenue.subscriptions.SetScoreRequest")
	proto.RegisterType((*SetScoreResponse)(nil), "code.justin.tv.revenue.subscriptions.SetScoreResponse")
	proto.RegisterType((*SubscriptionCount)(nil), "code.justin.tv.revenue.subscriptions.SubscriptionCount")
	proto.RegisterType((*CalculateSubscriberCountRequest)(nil), "code.justin.tv.revenue.subscriptions.CalculateSubscriberCountRequest")
	proto.RegisterType((*CalculateSubscriberCountResponse)(nil), "code.justin.tv.revenue.subscriptions.CalculateSubscriberCountResponse")
	proto.RegisterType((*GetUserSettingsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserSettingsRequest")
	proto.RegisterType((*GetUserSettingsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserSettingsResponse")
	proto.RegisterType((*SetUserSettingsRequest)(nil), "code.justin.tv.revenue.subscriptions.SetUserSettingsRequest")
	proto.RegisterType((*SetUserSettingsResponse)(nil), "code.justin.tv.revenue.subscriptions.SetUserSettingsResponse")
	proto.RegisterType((*OptionalBool)(nil), "code.justin.tv.revenue.subscriptions.OptionalBool")
	proto.RegisterType((*Subscription)(nil), "code.justin.tv.revenue.subscriptions.Subscription")
	proto.RegisterType((*FulfillSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.FulfillSubscriptionRequest")
	proto.RegisterType((*FulfillSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.FulfillSubscriptionResponse")
	proto.RegisterType((*CancelSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelSubscriptionRequest")
	proto.RegisterType((*CancelSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelSubscriptionResponse")
	proto.RegisterType((*CanSubscribeRequest)(nil), "code.justin.tv.revenue.subscriptions.CanSubscribeRequest")
	proto.RegisterType((*CanSubscribeResponse)(nil), "code.justin.tv.revenue.subscriptions.CanSubscribeResponse")
	proto.RegisterType((*ListUserSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.ListUserSubscriptionsRequest")
	proto.RegisterType((*GetUserChannelSubscriptionWithPaymentsDataRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionWithPaymentsDataRequest")
	proto.RegisterType((*GetUserChannelSubscriptionRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionRequest")
	proto.RegisterType((*UserSubscription)(nil), "code.justin.tv.revenue.subscriptions.UserSubscription")
	proto.RegisterType((*UserSubscriptionResult)(nil), "code.justin.tv.revenue.subscriptions.UserSubscriptionResult")
	proto.RegisterType((*ListUserSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.ListUserSubscriptionsResponse")
	proto.RegisterType((*GetUserChannelSubscriptionWithPaymentsDataResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionWithPaymentsDataResponse")
	proto.RegisterType((*GetUserChannelSubscriptionResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelSubscriptionResponse")
	proto.RegisterType((*GetUserProductSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserProductSubscriptionsRequest")
	proto.RegisterType((*GetUserProductSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserProductSubscriptionsResponse")
	proto.RegisterType((*GetUserSubscriptionsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserSubscriptionsRequest")
	proto.RegisterType((*GetUserSubscriptionsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserSubscriptionsResponse")
	proto.RegisterType((*GetExternalProductTemplateSKURequest)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductTemplateSKURequest")
	proto.RegisterType((*GetExternalProductTemplateSKUResponse)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductTemplateSKUResponse")
	proto.RegisterType((*GetExternalProductPurchasableSKURequest)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductPurchasableSKURequest")
	proto.RegisterType((*GetExternalProductPurchasableSKUResponse)(nil), "code.justin.tv.revenue.subscriptions.GetExternalProductPurchasableSKUResponse")
	proto.RegisterType((*SubKey)(nil), "code.justin.tv.revenue.subscriptions.SubKey")
	proto.RegisterType((*PaidUpgrade)(nil), "code.justin.tv.revenue.subscriptions.PaidUpgrade")
	proto.RegisterType((*GetPaidUpgradesRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPaidUpgradesRequest")
	proto.RegisterType((*GetPaidUpgradesResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPaidUpgradesResponse")
	proto.RegisterType((*CreatePaidUpgradeRequest)(nil), "code.justin.tv.revenue.subscriptions.CreatePaidUpgradeRequest")
	proto.RegisterType((*CreatePaidUpgradeResponse)(nil), "code.justin.tv.revenue.subscriptions.CreatePaidUpgradeResponse")
	proto.RegisterType((*CancelPaidUpgradeRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelPaidUpgradeRequest")
	proto.RegisterType((*CancelPaidUpgradeResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelPaidUpgradeResponse")
	proto.RegisterType((*CreateChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateChatNotificationTokenRequest")
	proto.RegisterType((*CreateChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.CreateChatNotificationTokenResponse")
	proto.RegisterType((*UseChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.UseChatNotificationTokenRequest")
	proto.RegisterType((*UseChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.UseChatNotificationTokenResponse")
	proto.RegisterType((*CancelChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelChatNotificationTokenRequest")
	proto.RegisterType((*CancelChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelChatNotificationTokenResponse")
	proto.RegisterType((*GetUserChannelChatNotificationTokenRequest)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelChatNotificationTokenRequest")
	proto.RegisterType((*GetUserChannelChatNotificationTokenResponse)(nil), "code.justin.tv.revenue.subscriptions.GetUserChannelChatNotificationTokenResponse")
	proto.RegisterType((*ChatNotificationToken)(nil), "code.justin.tv.revenue.subscriptions.ChatNotificationToken")
	proto.RegisterType((*Gift)(nil), "code.justin.tv.revenue.subscriptions.Gift")
	proto.RegisterType((*GiftKey)(nil), "code.justin.tv.revenue.subscriptions.GiftKey")
	proto.RegisterType((*CreateGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateGiftRequest")
	proto.RegisterType((*CreateGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CreateGiftResponse")
	proto.RegisterType((*CancelGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CancelGiftRequest")
	proto.RegisterType((*CancelGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CancelGiftResponse")
	proto.RegisterType((*GetGiftsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetGiftsRequest")
	proto.RegisterType((*GetGiftsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetGiftsResponse")
	proto.RegisterType((*CanGiftRequest)(nil), "code.justin.tv.revenue.subscriptions.CanGiftRequest")
	proto.RegisterType((*CanGiftResponse)(nil), "code.justin.tv.revenue.subscriptions.CanGiftResponse")
	proto.RegisterType((*GiftPromotion)(nil), "code.justin.tv.revenue.subscriptions.GiftPromotion")
	proto.RegisterType((*GetGiftPromotionRequest)(nil), "code.justin.tv.revenue.subscriptions.GetGiftPromotionRequest")
	proto.RegisterType((*GetGiftPromotionResponse)(nil), "code.justin.tv.revenue.subscriptions.GetGiftPromotionResponse")
	proto.RegisterType((*GetEmotePrefixRequest)(nil), "code.justin.tv.revenue.subscriptions.GetEmotePrefixRequest")
	proto.RegisterType((*GetEmotePrefixResponse)(nil), "code.justin.tv.revenue.subscriptions.GetEmotePrefixResponse")
	proto.RegisterType((*GetEmoticonPrefixRequest)(nil), "code.justin.tv.revenue.subscriptions.GetEmoticonPrefixRequest")
	proto.RegisterType((*GetEmoticonPrefixResponse)(nil), "code.justin.tv.revenue.subscriptions.GetEmoticonPrefixResponse")
	proto.RegisterType((*CreateEmoticonRequest)(nil), "code.justin.tv.revenue.subscriptions.CreateEmoticonRequest")
	proto.RegisterType((*CreateEmoticonReponse)(nil), "code.justin.tv.revenue.subscriptions.CreateEmoticonReponse")
	proto.RegisterType((*GetAllEmoticonsByProductIDsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetAllEmoticonsByProductIDsRequest")
	proto.RegisterType((*GetAllEmoticonsByProductIDsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetAllEmoticonsByProductIDsResponse")
	proto.RegisterType((*EmoticonGroup)(nil), "code.justin.tv.revenue.subscriptions.EmoticonGroup")
	proto.RegisterType((*Emoticon)(nil), "code.justin.tv.revenue.subscriptions.Emoticon")
	proto.RegisterType((*GetPartnerStandingRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPartnerStandingRequest")
	proto.RegisterType((*GetPartnerStandingResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPartnerStandingResponse")
	proto.RegisterType((*SubmitEmoticonPrefixRequest)(nil), "code.justin.tv.revenue.subscriptions.SubmitEmoticonPrefixRequest")
	proto.RegisterType((*SubmitEmoticonPrefixResponse)(nil), "code.justin.tv.revenue.subscriptions.SubmitEmoticonPrefixResponse")
	proto.RegisterType((*GetPendingEmoticonsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsRequest")
	proto.RegisterType((*EmoticonBucket)(nil), "code.justin.tv.revenue.subscriptions.EmoticonBucket")
	proto.RegisterType((*GetPendingEmoticonsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetPendingEmoticonsResponse")
	proto.RegisterType((*PendingEmoticon)(nil), "code.justin.tv.revenue.subscriptions.PendingEmoticon")
	proto.RegisterType((*Product)(nil), "code.justin.tv.revenue.subscriptions.Product")
	proto.RegisterType((*ProductInterval)(nil), "code.justin.tv.revenue.subscriptions.ProductInterval")
	proto.RegisterType((*GetProductsByIDsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetProductsByIDsRequest")
	proto.RegisterType((*GetProductsByIDsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetProductsByIDsResponse")
	proto.RegisterType((*GetChannelProductsRequest)(nil), "code.justin.tv.revenue.subscriptions.GetChannelProductsRequest")
	proto.RegisterType((*GetChannelProductsResponse)(nil), "code.justin.tv.revenue.subscriptions.GetChannelProductsResponse")
	proto.RegisterType((*UpdateProductRequest)(nil), "code.justin.tv.revenue.subscriptions.UpdateProductRequest")
	proto.RegisterType((*UpdateProductResponse)(nil), "code.justin.tv.revenue.subscriptions.UpdateProductResponse")
	proto.RegisterType((*UpdateChannelProductsRequest)(nil), "code.justin.tv.revenue.subscriptions.UpdateChannelProductsRequest")
	proto.RegisterType((*UpdateChannelProductsResponse)(nil), "code.justin.tv.revenue.subscriptions.UpdateChannelProductsResponse")
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.Platform", Platform_name, Platform_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.GiftState", GiftState_name, GiftState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.DiscountType", DiscountType_name, DiscountType_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.EmoticonState", EmoticonState_name, EmoticonState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.EmoticonPrefixState", EmoticonPrefixState_name, EmoticonPrefixState_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.EmoticonFilter", EmoticonFilter_name, EmoticonFilter_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.ProductIntervalUnit", ProductIntervalUnit_name, ProductIntervalUnit_value)
	proto.RegisterEnum("code.justin.tv.revenue.subscriptions.ListUserSubscriptionsRequest_Filter", ListUserSubscriptionsRequest_Filter_name, ListUserSubscriptionsRequest_Filter_value)
}

func init() { proto.RegisterFile("twirp/subscriptions.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 4255 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x3c, 0x5d, 0x6f, 0x1b, 0x49,
	0x72, 0x3b, 0x24, 0x25, 0x91, 0x45, 0x52, 0xa2, 0xdb, 0x5f, 0x34, 0x6d, 0x47, 0xde, 0xd9, 0xdd,
	0x5b, 0x9f, 0x72, 0xab, 0x85, 0x75, 0xfb, 0xed, 0x5d, 0xdb, 0x14, 0x45, 0xe9, 0xb8, 0x96, 0x28,
	0xee, 0x90, 0xb2, 0x7d, 0xbe, 0x0b, 0xe6, 0x46, 0x9c, 0x96, 0x34, 0xd1, 0x70, 0x86, 0x3b, 0x1f,
	0xb2, 0x95, 0x2c, 0x70, 0x0f, 0x97, 0xe0, 0x92, 0x5c, 0x10, 0x24, 0xc8, 0x01, 0x17, 0x24, 0x08,
	0x10, 0x04, 0x08, 0x90, 0x3c, 0x1d, 0x72, 0xc9, 0xc3, 0xe5, 0x21, 0x0f, 0xf7, 0x92, 0x00, 0x79,
	0x48, 0x80, 0xbc, 0x07, 0x79, 0xcc, 0x4b, 0x90, 0x9f, 0x10, 0x04, 0xfd, 0x31, 0xc3, 0x19, 0x72,
	0x48, 0xce, 0x90, 0xda, 0xc3, 0xe6, 0xc5, 0x66, 0x57, 0x77, 0x55, 0x57, 0x55, 0x77, 0x57, 0x57,
	0x57, 0xd5, 0x08, 0x6e, 0x38, 0x2f, 0x34, 0xab, 0xff, 0xb6, 0xed, 0x1e, 0xda, 0x5d, 0x4b, 0xeb,
	0x3b, 0x9a, 0x69, 0xd8, 0xeb, 0x7d, 0xcb, 0x74, 0x4c, 0xf4, 0x7a, 0xd7, 0x54, 0xf1, 0xfa, 0xaf,
	0xbb, 0xb6, 0xa3, 0x19, 0xeb, 0xce, 0xd9, 0xba, 0x85, 0xcf, 0xb0, 0xe1, 0xe2, 0xf5, 0xd0, 0xd8,
	0xca, 0xea, 0xb1, 0x69, 0x1e, 0xeb, 0xf8, 0x6d, 0x8a, 0x73, 0xe8, 0x1e, 0xbd, 0xed, 0x68, 0x3d,
	0x6c, 0x3b, 0x4a, 0xaf, 0xcf, 0xc8, 0x88, 0xdf, 0x81, 0x62, 0xbd, 0x67, 0x3a, 0x5a, 0xd7, 0x34,
	0x76, 0xf1, 0x19, 0xd6, 0xd1, 0x6b, 0x50, 0xec, 0x69, 0x86, 0xd6, 0x73, 0x7b, 0xb2, 0xdd, 0x35,
	0x2d, 0x5c, 0x16, 0xee, 0x08, 0x77, 0xd3, 0x52, 0x81, 0x03, 0xdb, 0x04, 0x86, 0xde, 0x80, 0x65,
	0xcc, 0xb1, 0x64, 0x5d, 0xeb, 0x69, 0x4e, 0x39, 0x45, 0x47, 0x15, 0x3d, 0xe8, 0x2e, 0x01, 0x8a,
	0xdf, 0x81, 0x95, 0x36, 0x76, 0x28, 0x8a, 0x84, 0x3f, 0x77, 0xb1, 0xed, 0xa0, 0xdb, 0x00, 0xdd,
	0x13, 0xc5, 0x30, 0xb0, 0x2e, 0x6b, 0x2a, 0xa5, 0x9d, 0x93, 0x72, 0x1c, 0xd2, 0x50, 0xd1, 0xd7,
	0xa1, 0xc4, 0x05, 0x38, 0xc4, 0x16, 0x67, 0x80, 0x91, 0x5e, 0x19, 0xc0, 0x29, 0x41, 0xf1, 0xe7,
	0x02, 0x94, 0x06, 0xd4, 0xed, 0xbe, 0x69, 0xd8, 0x38, 0x12, 0x5f, 0x88, 0xc4, 0x8f, 0x29, 0x03,
	0x92, 0x00, 0x0c, 0xfc, 0xd2, 0x91, 0x75, 0xa2, 0x9d, 0x72, 0xfa, 0x8e, 0x70, 0x37, 0xbf, 0xf1,
	0xcd, 0xf5, 0x38, 0xca, 0x5f, 0x0f, 0x29, 0x56, 0xca, 0x11, 0x32, 0xf4, 0xa7, 0xf8, 0x0f, 0x19,
	0xb8, 0xd4, 0x0e, 0x0c, 0xad, 0x99, 0xae, 0xe1, 0xa0, 0x2b, 0xb0, 0x10, 0x64, 0x98, 0x35, 0x86,
	0xe6, 0x4f, 0x5d, 0xc4, 0xfc, 0xc8, 0x81, 0x95, 0x2e, 0x99, 0x52, 0x3e, 0xb4, 0xb0, 0x72, 0xaa,
	0x9a, 0x2f, 0x8c, 0x72, 0xfa, 0x4e, 0xfa, 0x6e, 0x7e, 0xe3, 0x71, 0x3c, 0xc2, 0x23, 0xbc, 0xaf,
	0xd3, 0x7f, 0x37, 0x3d, 0x6a, 0x75, 0xc3, 0xb1, 0xce, 0xa5, 0xe5, 0x6e, 0x08, 0x48, 0x66, 0xa5,
	0x22, 0x05, 0x66, 0xcd, 0xcc, 0x37, 0x2b, 0x5d, 0xc8, 0xe1, 0x59, 0xed, 0x10, 0x10, 0xbd, 0x0a,
	0x05, 0x47, 0xeb, 0x9e, 0x62, 0x47, 0xa6, 0xec, 0x94, 0x17, 0xa8, 0x72, 0xf3, 0x0c, 0xc6, 0x14,
	0x3f, 0xba, 0x13, 0x16, 0x23, 0x76, 0x42, 0xa5, 0x0a, 0x97, 0x23, 0xc4, 0x44, 0x25, 0x48, 0x9f,
	0xe2, 0x73, 0xbe, 0x95, 0xc9, 0x4f, 0xb2, 0x90, 0x67, 0x8a, 0xee, 0x7a, 0x3b, 0x97, 0x35, 0x3e,
	0x4a, 0x7d, 0x20, 0x10, 0x12, 0x11, 0x3c, 0x27, 0x21, 0x21, 0x3e, 0x82, 0xd5, 0x9a, 0xa2, 0x77,
	0x5d, 0x5d, 0x71, 0x70, 0xdb, 0xdf, 0xd2, 0x94, 0xb1, 0x78, 0x67, 0x4c, 0xfc, 0x0d, 0xb8, 0x33,
	0x9e, 0x02, 0x3f, 0x47, 0x4f, 0x00, 0x88, 0xf2, 0xb9, 0xce, 0x04, 0xba, 0xeb, 0xde, 0x9f, 0x71,
	0x99, 0xa4, 0x1c, 0x19, 0x40, 0x7f, 0x8a, 0xf7, 0xe0, 0xda, 0x0e, 0x76, 0x0e, 0x6c, 0x6c, 0xb5,
	0xb1, 0xe3, 0x68, 0xc6, 0xb1, 0xed, 0x31, 0x7d, 0x1d, 0x96, 0x5c, 0x1b, 0x5b, 0x03, 0x8e, 0x17,
	0x49, 0xb3, 0xa1, 0x8a, 0x3f, 0x14, 0xe0, 0xfa, 0x08, 0x0e, 0x67, 0x73, 0x0b, 0x56, 0x8f, 0xb5,
	0x23, 0xc7, 0x96, 0x35, 0x43, 0x3e, 0x32, 0x75, 0xdd, 0x7c, 0x81, 0x55, 0x99, 0x4b, 0x6a, 0xcb,
	0xa6, 0xa1, 0x33, 0xa5, 0x66, 0xa5, 0x9b, 0x74, 0x58, 0xc3, 0xd8, 0xe6, 0x83, 0x6a, 0x7c, 0xcc,
	0xbe, 0xa1, 0x9f, 0xa3, 0xaf, 0xc1, 0xca, 0x89, 0xa6, 0x62, 0x99, 0x8c, 0xe1, 0x12, 0xa7, 0x28,
	0x56, 0x91, 0x80, 0x77, 0xb4, 0x23, 0xb6, 0x4f, 0xc4, 0xff, 0x48, 0xc1, 0xb5, 0x76, 0x32, 0xee,
	0xe3, 0x70, 0x98, 0x9a, 0xce, 0xe1, 0x0f, 0x05, 0x78, 0xd3, 0xc2, 0x5d, 0xac, 0x9d, 0x31, 0x2e,
	0x27, 0x91, 0x63, 0x26, 0x6a, 0x23, 0xde, 0x62, 0xed, 0xd3, 0xff, 0x15, 0x7d, 0xd3, 0x34, 0x75,
	0x49, 0xe4, 0x53, 0xec, 0x4c, 0xe0, 0xe4, 0xf9, 0xa8, 0xae, 0x32, 0x33, 0x4f, 0x38, 0xa4, 0x5f,
	0xb2, 0xd2, 0xed, 0xaf, 0xc4, 0x4a, 0xbf, 0x0e, 0x85, 0x20, 0xa3, 0x83, 0xe3, 0xc8, 0xe6, 0x60,
	0x0d, 0xf1, 0xef, 0x52, 0x50, 0x08, 0xee, 0x76, 0xb4, 0x0c, 0x29, 0x7f, 0x03, 0xa4, 0x34, 0x75,
	0xe8, 0x20, 0xa6, 0x86, 0x2f, 0xbb, 0x1b, 0x90, 0x35, 0x5f, 0x18, 0x6c, 0xd7, 0xa4, 0x69, 0xe7,
	0x12, 0x6d, 0x37, 0x28, 0x66, 0xdf, 0x32, 0x55, 0xb7, 0xeb, 0x90, 0xce, 0x0c, 0xc3, 0xe4, 0x90,
	0x86, 0x8a, 0x6e, 0x42, 0xce, 0xb4, 0xb4, 0x63, 0xcd, 0x20, 0xbd, 0x0b, 0xb4, 0x37, 0xcb, 0x00,
	0x0d, 0x15, 0x3d, 0x84, 0xe2, 0x21, 0x36, 0xf0, 0x91, 0xe6, 0xc8, 0xb6, 0xa3, 0x58, 0xcc, 0x9a,
	0xe5, 0x37, 0x2a, 0xeb, 0xcc, 0x17, 0x58, 0xf7, 0x7c, 0x81, 0xf5, 0x8e, 0xe7, 0x0b, 0x48, 0x05,
	0x8e, 0xd0, 0x26, 0xe3, 0xd1, 0x7d, 0xc8, 0x7b, 0x04, 0xb0, 0xa1, 0x96, 0x97, 0xa6, 0xa2, 0x03,
	0x1f, 0x5e, 0x37, 0x54, 0xb4, 0x0a, 0x79, 0xa5, 0xdb, 0xc5, 0xb6, 0x2d, 0x1f, 0xbb, 0x9a, 0x5a,
	0xce, 0x52, 0xe6, 0x80, 0x81, 0x76, 0x5c, 0x4d, 0x15, 0xff, 0x31, 0x05, 0x95, 0x6d, 0x57, 0x3f,
	0xd2, 0x74, 0x3d, 0xa8, 0x3c, 0xef, 0x24, 0x05, 0x95, 0x22, 0x4c, 0x52, 0x4a, 0x6a, 0xa2, 0x52,
	0xd2, 0xd3, 0x94, 0x92, 0x99, 0x4f, 0x29, 0x0b, 0x89, 0x94, 0xf2, 0x29, 0x64, 0xfb, 0xba, 0xe2,
	0x1c, 0x99, 0x56, 0x8f, 0xae, 0xc6, 0xf2, 0xc6, 0x7a, 0xbc, 0xe3, 0xd2, 0xe2, 0x58, 0x92, 0x8f,
	0x2f, 0xba, 0x70, 0x33, 0x52, 0x7d, 0xbe, 0xe5, 0x2e, 0x04, 0x49, 0x70, 0xdb, 0xbd, 0x91, 0xdc,
	0x76, 0x4b, 0x21, 0x3a, 0xa2, 0x05, 0x37, 0x6a, 0x8a, 0xd1, 0xc5, 0xbf, 0xc4, 0x45, 0x13, 0x6f,
	0x41, 0x25, 0x6a, 0x4e, 0x26, 0xa9, 0xf8, 0x67, 0x02, 0x5c, 0xae, 0x29, 0x86, 0x7f, 0x85, 0xcd,
	0xcf, 0x4c, 0x70, 0x99, 0xd2, 0x73, 0x2e, 0xd3, 0x7d, 0xb8, 0x12, 0x66, 0x8e, 0xaf, 0xcf, 0x6b,
	0x50, 0xec, 0x2a, 0x86, 0xec, 0x7b, 0xa3, 0xdc, 0xa4, 0x14, 0xba, 0x81, 0xc1, 0xe2, 0x2f, 0x52,
	0x70, 0x6b, 0x57, 0xb3, 0x99, 0x29, 0x0c, 0xce, 0x14, 0x43, 0xc6, 0x2b, 0xb0, 0x10, 0x74, 0x67,
	0x59, 0x03, 0x5d, 0x83, 0xc5, 0xae, 0x6b, 0xd9, 0xa6, 0xc5, 0x95, 0xcc, 0x5b, 0x21, 0x91, 0x33,
	0xf3, 0x89, 0x8c, 0x14, 0x58, 0x3c, 0xd2, 0x74, 0x07, 0x5b, 0xf4, 0x74, 0x2c, 0x6f, 0x34, 0xe2,
	0x51, 0x9a, 0x24, 0xe8, 0xfa, 0x36, 0x25, 0x28, 0x71, 0xc2, 0xe2, 0xd7, 0x61, 0x91, 0x41, 0xd0,
	0x12, 0xa4, 0xab, 0xbb, 0xbb, 0xa5, 0x57, 0x50, 0x01, 0xb2, 0xad, 0xdd, 0x6a, 0x67, 0x7b, 0x5f,
	0xda, 0x2b, 0x09, 0x28, 0x0b, 0x99, 0x9d, 0xc6, 0x76, 0xa7, 0x94, 0x12, 0x7b, 0x70, 0x8f, 0xbb,
	0x0d, 0xfc, 0x0a, 0x08, 0xd2, 0x7f, 0xaa, 0x39, 0x27, 0x2d, 0xe5, 0xbc, 0x87, 0x0d, 0xc7, 0xde,
	0x52, 0x1c, 0x25, 0xde, 0xde, 0x99, 0x60, 0xcc, 0xc5, 0x5f, 0x83, 0x57, 0xc7, 0x4f, 0x37, 0x3f,
	0xf9, 0x3f, 0xc9, 0x40, 0x69, 0x58, 0x49, 0xe8, 0x4d, 0x58, 0x09, 0xaa, 0x72, 0x40, 0x75, 0x39,
	0x08, 0x1e, 0xba, 0x69, 0x52, 0x93, 0x8e, 0x44, 0x7a, 0xe2, 0xf9, 0xcc, 0x4c, 0x33, 0xaa, 0x0b,
	0xf3, 0x19, 0xd5, 0xc5, 0x99, 0x8d, 0xea, 0xd2, 0x9c, 0x5b, 0xf7, 0x7d, 0xc8, 0x59, 0xd8, 0xc0,
	0x2f, 0x6c, 0x59, 0x71, 0xe8, 0x9d, 0x35, 0x99, 0x8d, 0x2c, 0x1b, 0x5c, 0x75, 0xd0, 0x5d, 0x28,
	0x91, 0xd7, 0x59, 0xdf, 0xb5, 0xba, 0x27, 0x8a, 0x8d, 0x65, 0xfb, 0xd4, 0x2d, 0xe7, 0xd8, 0x1a,
	0xe0, 0x97, 0x4e, 0x8b, 0x83, 0xdb, 0xa7, 0x2e, 0x59, 0x03, 0xcd, 0x96, 0xfb, 0x96, 0xd6, 0xc3,
	0x65, 0xa0, 0x67, 0x7e, 0x49, 0xb3, 0x5b, 0xa4, 0x49, 0xbc, 0x47, 0xcd, 0xa6, 0x4e, 0x49, 0x39,
	0x4f, 0x7b, 0x16, 0x35, 0x9b, 0x38, 0x23, 0xc4, 0x58, 0x68, 0xb6, 0x6c, 0xe1, 0x23, 0xd7, 0x50,
	0x95, 0x43, 0x1d, 0x97, 0x0b, 0xcc, 0x58, 0x68, 0xb6, 0xe4, 0xc3, 0xc4, 0xdf, 0x17, 0xe0, 0xda,
	0xf0, 0xd6, 0x90, 0xb0, 0xed, 0xea, 0x0e, 0x7a, 0x1e, 0x79, 0x19, 0xbc, 0x17, 0x4f, 0x4d, 0x23,
	0x34, 0x43, 0xb4, 0x02, 0x16, 0x25, 0x15, 0xb4, 0x28, 0xe2, 0x3f, 0x0b, 0x70, 0x7b, 0xcc, 0x91,
	0xf6, 0xaf, 0xa8, 0x25, 0x8b, 0xf2, 0x67, 0x97, 0x05, 0xfa, 0x00, 0xfc, 0x78, 0x46, 0x86, 0x28,
	0x11, 0xc9, 0x23, 0x86, 0xd6, 0xe0, 0xd2, 0x89, 0x42, 0x54, 0x8c, 0xcf, 0x34, 0xd3, 0xb5, 0xe5,
	0xbe, 0x72, 0x8c, 0xb9, 0x7f, 0xb7, 0x72, 0xa2, 0xd8, 0x2d, 0x0e, 0x6f, 0x29, 0xc7, 0x18, 0x89,
	0x50, 0x24, 0x63, 0xe9, 0xd3, 0x9a, 0x8e, 0x4b, 0xd3, 0x71, 0xf9, 0x13, 0xc5, 0x6e, 0x92, 0x85,
	0x53, 0x8e, 0xb1, 0xf8, 0x87, 0x02, 0x6c, 0x24, 0x31, 0x21, 0x5c, 0xbc, 0x2f, 0x51, 0xe9, 0xe2,
	0x17, 0x20, 0x4e, 0xb2, 0x32, 0x5f, 0xb2, 0x0f, 0xf0, 0x3d, 0x7f, 0xf6, 0x16, 0x33, 0x10, 0x49,
	0xef, 0xa6, 0x55, 0xc8, 0x0f, 0x8c, 0x8d, 0x5d, 0x4e, 0xdd, 0x49, 0x13, 0xe7, 0xd0, 0xb7, 0x36,
	0xb6, 0xf8, 0x7d, 0x78, 0x6d, 0xe2, 0x0c, 0x5c, 0xc0, 0x67, 0x50, 0x0c, 0x31, 0xcd, 0xf7, 0xd1,
	0x2c, 0x12, 0x86, 0x09, 0x89, 0x1f, 0xc0, 0x4d, 0xef, 0xb1, 0x99, 0x4c, 0x36, 0xf1, 0x25, 0xdc,
	0x8a, 0xc6, 0xfc, 0xd2, 0x79, 0xfe, 0x7b, 0x01, 0x5e, 0xdf, 0xc1, 0x4e, 0xfd, 0xa5, 0x83, 0x2d,
	0x43, 0xd1, 0xb9, 0xe6, 0x3a, 0xb8, 0xd7, 0xa7, 0x4f, 0xfc, 0xc7, 0x07, 0x81, 0xc0, 0x40, 0xc0,
	0xd6, 0x0b, 0x93, 0xdc, 0x9f, 0xd4, 0x9c, 0x06, 0xf5, 0x55, 0x28, 0xd0, 0xf7, 0x95, 0x75, 0x2e,
	0x13, 0x12, 0xfc, 0x62, 0xc9, 0x73, 0x58, 0xcd, 0x54, 0xb1, 0xf8, 0x00, 0xde, 0x98, 0xc2, 0x35,
	0xd7, 0xdc, 0x55, 0x58, 0xb4, 0x4f, 0xdd, 0x01, 0xcb, 0x0b, 0xf6, 0xa9, 0xdb, 0x50, 0xc5, 0x7f,
	0x17, 0xe0, 0xcd, 0x51, 0x02, 0xdc, 0xe4, 0x12, 0xcb, 0x18, 0x90, 0xfc, 0x2b, 0xe1, 0x13, 0x8e,
	0x28, 0x25, 0x33, 0xaa, 0x94, 0x2a, 0xdc, 0x9d, 0x2e, 0xd3, 0x64, 0xbd, 0xb4, 0x60, 0xb1, 0xed,
	0x1e, 0x3e, 0xc6, 0xe7, 0xa8, 0x0c, 0x4b, 0x5c, 0x10, 0x4f, 0x68, 0xde, 0x24, 0x4e, 0x22, 0x95,
	0x9f, 0xcb, 0xcb, 0x1a, 0xc4, 0xa4, 0xb3, 0xbb, 0xdd, 0x73, 0x12, 0x59, 0x4b, 0xfc, 0xdb, 0x14,
	0xe4, 0x5b, 0x8a, 0xa6, 0x1e, 0xf4, 0x8f, 0x2d, 0x45, 0xc5, 0x68, 0x07, 0xb2, 0x87, 0xe4, 0xb2,
	0xf3, 0x82, 0x56, 0xf9, 0x8d, 0x6f, 0xc4, 0xde, 0xc5, 0x8f, 0xf1, 0xb9, 0xb4, 0x44, 0xb0, 0x09,
	0x83, 0x7b, 0x90, 0x77, 0x19, 0x4d, 0x4a, 0x2b, 0x35, 0x03, 0x2d, 0xe0, 0x04, 0x08, 0xb9, 0x37,
	0x60, 0x19, 0x1b, 0x8e, 0xe6, 0xe8, 0x98, 0x58, 0xe5, 0x81, 0x3f, 0x53, 0x0c, 0x40, 0x1b, 0x2a,
	0xfa, 0x10, 0x80, 0xba, 0x2b, 0xb2, 0xaa, 0x38, 0x38, 0xc6, 0x43, 0x30, 0x47, 0x47, 0x6f, 0x29,
	0x0e, 0x46, 0x08, 0x32, 0x8e, 0xc6, 0x1d, 0xdc, 0x9c, 0x44, 0x7f, 0x13, 0x5d, 0xf6, 0x2d, 0xad,
	0x8b, 0xa9, 0xfb, 0xb2, 0x20, 0xb1, 0x86, 0xf8, 0x9c, 0x46, 0xba, 0x02, 0x5a, 0xf3, 0x6d, 0xc8,
	0x23, 0xc8, 0x9c, 0xe2, 0x73, 0xef, 0xfc, 0x27, 0x93, 0x96, 0x62, 0x8a, 0x9f, 0xd3, 0x88, 0x58,
	0x98, 0xb6, 0x6f, 0xfa, 0x8b, 0x7d, 0x45, 0x53, 0x65, 0xae, 0x15, 0x6f, 0x96, 0x7b, 0x31, 0xf7,
	0xec, 0x80, 0xa4, 0x54, 0xe8, 0x07, 0xe8, 0x8b, 0x3f, 0x13, 0xa0, 0x5c, 0xb3, 0xb0, 0xe2, 0xe0,
	0xe0, 0x18, 0x2e, 0xd1, 0x57, 0x74, 0x3f, 0x88, 0x9f, 0xc3, 0x8d, 0x08, 0x9e, 0xb9, 0xa6, 0x3a,
	0x50, 0x08, 0x6a, 0x8a, 0x33, 0x3e, 0x83, 0xa2, 0xf2, 0x01, 0x45, 0x31, 0x3d, 0xd1, 0x37, 0xeb,
	0xff, 0x23, 0x3d, 0xdd, 0xf4, 0xde, 0xf6, 0x11, 0x7a, 0x12, 0xff, 0x5b, 0x00, 0x91, 0x69, 0xb1,
	0x76, 0xa2, 0x38, 0x4d, 0xd3, 0xd1, 0x8e, 0xb4, 0xae, 0x42, 0x68, 0x75, 0xcc, 0x53, 0x7c, 0x01,
	0x21, 0x80, 0x4f, 0xa0, 0xa0, 0x9c, 0x29, 0x9a, 0x4e, 0xcc, 0x1b, 0x71, 0xbf, 0xd3, 0x53, 0x0f,
	0x64, 0xde, 0x1f, 0x5f, 0x75, 0xd0, 0x5e, 0xc0, 0xaf, 0x9e, 0x3d, 0x14, 0xe9, 0xf9, 0xe2, 0xe2,
	0x43, 0x78, 0x6d, 0xa2, 0xb4, 0x7c, 0xf7, 0x94, 0x61, 0xa9, 0x87, 0x6d, 0x9b, 0x78, 0x8e, 0x5c,
	0x5a, 0xde, 0x14, 0x7f, 0x57, 0x80, 0xd5, 0x03, 0x7b, 0xaa, 0xb2, 0x1c, 0xd2, 0x0e, 0x28, 0x8b,
	0xb6, 0x1b, 0x2a, 0x7a, 0x1d, 0x96, 0x15, 0xd7, 0x39, 0xc1, 0xaa, 0xec, 0x05, 0x94, 0x99, 0xc2,
	0x0a, 0x0c, 0x7a, 0xc0, 0xc2, 0xca, 0x6f, 0xc0, 0x72, 0xd7, 0xb5, 0x1d, 0xb3, 0x27, 0x7b, 0x5c,
	0x70, 0x4b, 0xc7, 0xa0, 0x7b, 0x9c, 0x97, 0x8f, 0xe1, 0xce, 0x78, 0x56, 0xa6, 0x4a, 0xb2, 0x07,
	0x22, 0xdb, 0x16, 0x13, 0x65, 0x89, 0xfb, 0x08, 0xa5, 0x9a, 0x9d, 0x44, 0x6e, 0x2a, 0x3f, 0x2a,
	0xac, 0x85, 0x9d, 0xdf, 0x89, 0x7c, 0x8d, 0x0d, 0xc9, 0x4f, 0x79, 0x69, 0xff, 0xa5, 0x00, 0xbf,
	0x1a, 0x6b, 0x1a, 0xce, 0xaf, 0x0d, 0xd7, 0xbb, 0x27, 0x8a, 0x23, 0x1b, 0x81, 0x11, 0x32, 0x5d,
	0x4d, 0x7e, 0xc6, 0xef, 0xc7, 0xdb, 0x8e, 0xd1, 0xb3, 0x5c, 0xed, 0x46, 0x81, 0xc5, 0x53, 0xb8,
	0x1a, 0x39, 0x7e, 0x24, 0x04, 0x1d, 0xd0, 0x66, 0x2a, 0xa4, 0x4d, 0x72, 0x6d, 0xf5, 0x4c, 0xc3,
	0x39, 0xe1, 0x3b, 0x87, 0x35, 0xc8, 0x05, 0x77, 0xaa, 0x19, 0xde, 0x53, 0x9f, 0xfe, 0x16, 0xff,
	0x47, 0x80, 0x0c, 0x7d, 0x8e, 0x5e, 0x83, 0x45, 0x1b, 0x1b, 0x2a, 0xb6, 0x3c, 0x8d, 0xb2, 0x16,
	0xba, 0x45, 0x5e, 0xcf, 0x5d, 0xad, 0xaf, 0x61, 0x1e, 0x50, 0xcf, 0x49, 0x03, 0x40, 0xd0, 0x0b,
	0x49, 0x87, 0xbd, 0x90, 0x81, 0xbf, 0x91, 0x09, 0xfa, 0x1b, 0xa8, 0x0e, 0x0b, 0xb6, 0x43, 0xee,
	0x66, 0x16, 0x47, 0x7a, 0x3b, 0x9e, 0x02, 0x09, 0x8b, 0x6d, 0x82, 0x26, 0x31, 0x6c, 0xf2, 0xa8,
	0xa7, 0x81, 0x7e, 0x7a, 0xcd, 0x4f, 0x8f, 0x2d, 0x64, 0xc9, 0x60, 0x72, 0xcb, 0x8b, 0xdf, 0x86,
	0x25, 0x42, 0x6c, 0xb2, 0x0b, 0x35, 0x60, 0x3e, 0x15, 0x62, 0x3e, 0xa4, 0x8c, 0xf4, 0x90, 0x32,
	0xc4, 0xdf, 0x84, 0x4b, 0xcc, 0xbc, 0x90, 0x09, 0xbc, 0xad, 0xfa, 0x4b, 0xd2, 0xab, 0xd8, 0x01,
	0x14, 0x9c, 0x9c, 0x6f, 0xe0, 0x07, 0x90, 0xa1, 0xa1, 0x07, 0xb6, 0x5b, 0xd7, 0xe2, 0x2b, 0x5b,
	0xa2, 0x78, 0x62, 0x17, 0x2e, 0xb1, 0x73, 0x1d, 0x14, 0xe9, 0xa2, 0xf5, 0x86, 0x01, 0x05, 0x27,
	0xe1, 0xac, 0xef, 0xd3, 0x60, 0x6a, 0x17, 0xeb, 0x58, 0x95, 0x67, 0x94, 0xa1, 0xe0, 0x11, 0x20,
	0x2d, 0xb1, 0x03, 0x2b, 0x3b, 0xd8, 0xa1, 0x09, 0x30, 0x4f, 0x92, 0x6a, 0xc8, 0x5d, 0x7b, 0x2b,
	0x3e, 0xe9, 0x81, 0xbf, 0xd6, 0x81, 0xd2, 0x80, 0x2a, 0x67, 0xfd, 0x11, 0x2c, 0xd0, 0x4c, 0x15,
	0xa7, 0x9b, 0x84, 0x65, 0x86, 0x28, 0x7e, 0x0f, 0x96, 0x6b, 0x8a, 0xf1, 0x25, 0xee, 0x23, 0xf1,
	0x1b, 0xb0, 0xe2, 0xcf, 0xc0, 0xd9, 0xbe, 0x01, 0xd9, 0xae, 0x62, 0x0c, 0x94, 0x9d, 0x95, 0x96,
	0xba, 0x6c, 0x88, 0xf8, 0xbf, 0x02, 0x14, 0xc9, 0x8f, 0x96, 0x65, 0xf6, 0x4c, 0x1a, 0x22, 0x9a,
	0xf2, 0xde, 0xbc, 0x09, 0x39, 0x03, 0xbf, 0x90, 0x99, 0xf3, 0xcc, 0xa2, 0xd5, 0x59, 0x03, 0xbf,
	0x68, 0x91, 0x36, 0x0d, 0x3c, 0xea, 0x2a, 0xef, 0x4c, 0xb3, 0x4e, 0x53, 0x57, 0x59, 0xe7, 0x53,
	0x28, 0xaa, 0x9a, 0xcd, 0x6a, 0x18, 0x9c, 0xf3, 0x3e, 0xe6, 0xa1, 0xeb, 0x98, 0x17, 0xff, 0x16,
	0x47, 0xed, 0x9c, 0xf7, 0xb1, 0x54, 0x50, 0x03, 0x2d, 0x72, 0xaf, 0xfa, 0x84, 0x59, 0xc6, 0x8f,
	0xd5, 0x0b, 0xf8, 0xd3, 0x3d, 0x21, 0x40, 0x62, 0x3b, 0xb1, 0x65, 0x99, 0x16, 0xb5, 0x2a, 0x39,
	0x89, 0x35, 0xc4, 0x8f, 0xa8, 0x5b, 0x1e, 0x52, 0x81, 0xb7, 0x32, 0x43, 0x81, 0x0f, 0x61, 0x24,
	0xf0, 0xf1, 0xd7, 0x02, 0x94, 0x47, 0x91, 0xb9, 0xd2, 0xd7, 0xe1, 0x32, 0x75, 0x71, 0x38, 0x5c,
	0x56, 0xba, 0x8e, 0x76, 0xe6, 0x65, 0x0e, 0x2e, 0x11, 0xcf, 0x85, 0xf7, 0x54, 0x69, 0x07, 0xfa,
	0x2e, 0xac, 0x50, 0xc3, 0xe7, 0x63, 0xb0, 0x50, 0x4b, 0xec, 0xc2, 0x91, 0x30, 0x17, 0xcb, 0xc7,
	0xc1, 0xa6, 0x2d, 0x6e, 0xc0, 0x55, 0xf2, 0x44, 0xed, 0x99, 0x0e, 0x6e, 0x59, 0xf8, 0x48, 0x7b,
	0x19, 0x23, 0x38, 0xf2, 0x0e, 0x7d, 0x0d, 0x85, 0x70, 0xb8, 0x6c, 0x15, 0xc8, 0xf6, 0x29, 0x04,
	0x7b, 0x6a, 0xf1, 0xdb, 0xe2, 0x87, 0x54, 0x27, 0x5e, 0x19, 0x4b, 0x78, 0xb2, 0x29, 0x45, 0x0e,
	0xbf, 0x25, 0xc0, 0x8d, 0x08, 0x5c, 0x3e, 0xe9, 0x35, 0x58, 0x64, 0x93, 0x78, 0x07, 0x85, 0xb5,
	0xd0, 0xbe, 0x77, 0xf1, 0xb0, 0xf0, 0xc7, 0x87, 0xc9, 0xea, 0x6c, 0xd8, 0x24, 0xc1, 0x2b, 0x48,
	0xfc, 0x37, 0x01, 0xae, 0x32, 0x93, 0xeb, 0x0d, 0x9a, 0xea, 0x9e, 0xac, 0x42, 0x9e, 0xcc, 0x2a,
	0xdb, 0xee, 0x11, 0x61, 0x90, 0x1d, 0x57, 0x20, 0xa0, 0x36, 0x85, 0x4c, 0x8b, 0xd8, 0xdf, 0x06,
	0xd0, 0x7a, 0xca, 0x31, 0xde, 0xf8, 0x20, 0x90, 0x3a, 0xe6, 0x90, 0x40, 0xf7, 0xbb, 0xef, 0x0d,
	0x72, 0xc7, 0x39, 0x0e, 0x61, 0xb3, 0xd3, 0xc6, 0xbd, 0x7b, 0x1b, 0xa4, 0x9f, 0xed, 0x6f, 0xf0,
	0x40, 0x0d, 0x55, 0xfc, 0x51, 0x84, 0x44, 0x4c, 0xa9, 0xc3, 0xae, 0x07, 0x82, 0x0c, 0x8d, 0x72,
	0x30, 0x09, 0xe8, 0xef, 0x69, 0xbc, 0xdf, 0x80, 0xec, 0xb1, 0x65, 0xba, 0xfd, 0x01, 0xe7, 0x4b,
	0xb4, 0xcd, 0xd2, 0x5a, 0x03, 0x9f, 0x20, 0xe7, 0xe9, 0xb7, 0x4e, 0x23, 0x92, 0x55, 0x5d, 0xf7,
	0x98, 0xb1, 0x37, 0xcf, 0x79, 0xd0, 0xa4, 0xb1, 0x65, 0xc7, 0x3e, 0x7d, 0x3f, 0x10, 0x68, 0xdc,
	0x71, 0x3c, 0x1d, 0xbe, 0x6f, 0xbe, 0x0b, 0x2b, 0x7e, 0xa5, 0x10, 0x65, 0xcc, 0x33, 0xdf, 0x09,
	0x2b, 0xb2, 0x76, 0x08, 0xae, 0xe4, 0x57, 0x1d, 0xd1, 0xa6, 0x2d, 0x7e, 0x31, 0xa8, 0xc5, 0xa3,
	0x90, 0x69, 0xf6, 0x73, 0x17, 0x72, 0x1e, 0x05, 0xef, 0x80, 0xaf, 0x27, 0xe3, 0x43, 0x1a, 0x10,
	0x10, 0x7f, 0x2c, 0x40, 0xd6, 0x83, 0xc7, 0x5a, 0xcb, 0xe0, 0x62, 0xa5, 0xc3, 0x8b, 0xd5, 0xf0,
	0x16, 0x8b, 0xd9, 0xe5, 0x84, 0xda, 0x09, 0x9d, 0xa0, 0x77, 0xe8, 0x39, 0x6e, 0x29, 0x96, 0x63,
	0x60, 0xab, 0xed, 0x28, 0x86, 0xaa, 0x19, 0xc7, 0x53, 0x8b, 0x86, 0x1e, 0x43, 0x25, 0x0a, 0x8b,
	0x2f, 0xe3, 0x5b, 0xd4, 0x9e, 0x6a, 0x86, 0x7c, 0x6c, 0x9a, 0xaa, 0x6c, 0xf3, 0x6e, 0x6e, 0x4f,
	0x4b, 0x9a, 0xdd, 0x30, 0x76, 0x4c, 0x53, 0xf5, 0xd0, 0xc4, 0x0e, 0xdc, 0x6c, 0xbb, 0x87, 0x3d,
	0x6d, 0x26, 0x4b, 0x14, 0xb0, 0x35, 0xa9, 0xa0, 0xad, 0x11, 0x7f, 0x05, 0x6e, 0x45, 0x53, 0xe5,
	0xef, 0xee, 0x7f, 0x15, 0x98, 0x0c, 0x98, 0x32, 0xe1, 0xef, 0x4b, 0x6f, 0xd6, 0x5d, 0x3f, 0xd9,
	0x2a, 0x50, 0x1d, 0xbf, 0x93, 0x4c, 0xc7, 0xe1, 0xbc, 0x2a, 0x39, 0x5d, 0x83, 0x72, 0x98, 0x05,
	0x89, 0x35, 0xc8, 0x1c, 0x87, 0x6e, 0xf7, 0x14, 0x7b, 0x6f, 0xf2, 0x84, 0x73, 0x6c, 0x52, 0x5c,
	0x89, 0xd3, 0x10, 0x3f, 0x83, 0xe5, 0x70, 0x0f, 0xf3, 0x4b, 0xa8, 0x38, 0x98, 0x29, 0x6e, 0x41,
	0x1a, 0x00, 0xd0, 0xab, 0x50, 0x60, 0x98, 0x72, 0x90, 0xb5, 0x3c, 0x83, 0xb1, 0x3a, 0x9d, 0x3f,
	0x16, 0x68, 0xb8, 0x7e, 0x54, 0x47, 0x7c, 0xa1, 0xdb, 0xc1, 0x13, 0xc2, 0x4e, 0xea, 0xbb, 0x31,
	0x03, 0x3c, 0x61, 0x92, 0x81, 0x83, 0x42, 0xac, 0x89, 0x63, 0x3a, 0x8a, 0x1e, 0x62, 0x0b, 0x28,
	0x88, 0x71, 0xf5, 0x57, 0x02, 0xac, 0x0c, 0xe1, 0x8f, 0x1c, 0xa8, 0x31, 0xbb, 0xc2, 0x3f, 0x68,
	0xe9, 0xf0, 0x41, 0xf3, 0xef, 0xd5, 0x4c, 0x38, 0xb4, 0x72, 0x1f, 0xf2, 0x6e, 0x5f, 0x37, 0x15,
	0x55, 0x76, 0xb4, 0x1e, 0x8e, 0x53, 0x95, 0xc2, 0x86, 0x13, 0x80, 0xf8, 0x4f, 0x69, 0x58, 0xe2,
	0x46, 0x2e, 0xaa, 0x74, 0xc9, 0x3e, 0x31, 0x2d, 0x47, 0x36, 0x94, 0x9e, 0x77, 0xec, 0x73, 0x14,
	0xd2, 0x54, 0x7a, 0x98, 0xac, 0x8d, 0xaa, 0xd9, 0x7d, 0x5d, 0x39, 0x67, 0x03, 0x78, 0x78, 0x9f,
	0xc3, 0xe8, 0x90, 0xbb, 0x50, 0xf2, 0x6d, 0xa5, 0x8d, 0x99, 0xe5, 0xcd, 0x50, 0xcb, 0xeb, 0xdb,
	0xbd, 0x36, 0x26, 0xd6, 0x77, 0x10, 0x40, 0x5d, 0x08, 0x04, 0x50, 0x89, 0xd4, 0xb4, 0x56, 0x4b,
	0x51, 0x6d, 0x7a, 0x0d, 0x65, 0xa5, 0x25, 0xd2, 0xae, 0xaa, 0x36, 0x8d, 0xc2, 0x12, 0xaf, 0x6f,
	0x89, 0x47, 0x61, 0x89, 0xe7, 0x16, 0x54, 0x52, 0x36, 0xac, 0x24, 0x2f, 0x68, 0x9b, 0x0b, 0x04,
	0x6d, 0x3f, 0x83, 0xac, 0x66, 0x38, 0xd8, 0x3a, 0x53, 0x74, 0x9a, 0x8d, 0x8d, 0xbf, 0x31, 0xb8,
	0xf9, 0xe5, 0xc8, 0x92, 0x4f, 0x86, 0xf8, 0x8e, 0x87, 0x9a, 0x63, 0x29, 0x0e, 0x96, 0x59, 0xb9,
	0x53, 0x39, 0x4f, 0xc5, 0x2d, 0x72, 0x68, 0x95, 0x02, 0x79, 0x89, 0xb2, 0x69, 0xe8, 0xe7, 0xb2,
	0x62, 0x75, 0x4f, 0xb4, 0x33, 0x6c, 0xf3, 0xb4, 0xee, 0x0a, 0x87, 0x57, 0x39, 0x18, 0x7d, 0x2d,
	0x70, 0xdd, 0x30, 0x15, 0x96, 0x8b, 0x3c, 0xa0, 0x1d, 0xd4, 0xa0, 0xf8, 0x05, 0xac, 0x0c, 0xb1,
	0x45, 0xdc, 0x2a, 0xd5, 0xb5, 0x14, 0x3f, 0xfd, 0xb7, 0x20, 0xf9, 0x6d, 0xb4, 0x07, 0x19, 0xd7,
	0xe0, 0x05, 0x22, 0xb1, 0x9d, 0x9c, 0xa1, 0x09, 0x0e, 0x0c, 0xcd, 0x91, 0x28, 0x19, 0xee, 0xf6,
	0xf2, 0x7e, 0x7b, 0xf3, 0x3c, 0xc9, 0xc5, 0x8b, 0xa9, 0x87, 0x37, 0x84, 0xcb, 0x0f, 0x6f, 0x83,
	0x78, 0x86, 0xac, 0x23, 0xd9, 0xe3, 0x8b, 0x93, 0x93, 0x7c, 0x74, 0xf1, 0x29, 0xbd, 0x44, 0x78,
	0x38, 0xc7, 0x9b, 0x2d, 0xa6, 0xfd, 0xbe, 0x09, 0xb9, 0xae, 0xae, 0xf1, 0x7c, 0x02, 0x3b, 0x08,
	0x59, 0x06, 0x68, 0xa8, 0xe2, 0x31, 0xb5, 0xd1, 0x23, 0x84, 0x2f, 0x5e, 0x82, 0x67, 0x70, 0xe5,
	0xa0, 0xaf, 0x2a, 0xc4, 0x7d, 0x66, 0x5d, 0xf1, 0x52, 0x7a, 0xc3, 0xe7, 0x34, 0x35, 0x72, 0x4e,
	0xc5, 0xeb, 0x70, 0x75, 0x88, 0x32, 0xbf, 0x80, 0x7e, 0x20, 0xc0, 0x2d, 0xd6, 0x33, 0x9b, 0xe2,
	0x82, 0x07, 0x38, 0x15, 0x3e, 0xc0, 0x51, 0x67, 0x20, 0x1d, 0x79, 0x06, 0xc4, 0x55, 0xb8, 0x3d,
	0x86, 0x09, 0xc6, 0xe6, 0x9a, 0x0e, 0x59, 0x2f, 0xd5, 0x86, 0x2e, 0x41, 0xd1, 0xab, 0x05, 0x92,
	0x9b, 0xfb, 0xcd, 0x7a, 0xe9, 0x15, 0x54, 0x82, 0x82, 0x0f, 0x7a, 0x5a, 0xdf, 0x2c, 0x09, 0x21,
	0x48, 0x63, 0xbf, 0x5d, 0x4a, 0xa1, 0x2b, 0x50, 0xf2, 0x21, 0xd5, 0xe6, 0x96, 0xb4, 0xdf, 0xd8,
	0x2a, 0xa5, 0xd1, 0x65, 0x58, 0x19, 0x40, 0xf7, 0xaa, 0xcf, 0xf7, 0x9b, 0xa5, 0xcc, 0xda, 0x23,
	0xc8, 0xf9, 0x71, 0x26, 0x54, 0x84, 0xdc, 0x4e, 0x63, 0xbb, 0xe3, 0x4d, 0x75, 0x09, 0x8a, 0xb4,
	0x59, 0xad, 0xd5, 0xea, 0xad, 0x4e, 0x7d, 0xab, 0x24, 0xf8, 0xa0, 0x5a, 0xb5, 0x59, 0xab, 0xef,
	0xd6, 0xb7, 0x4a, 0xa9, 0xb5, 0x27, 0x50, 0x08, 0x3e, 0x40, 0xc9, 0x90, 0xad, 0x46, 0xbb, 0xb6,
	0x7f, 0xd0, 0xf4, 0x09, 0x5d, 0x87, 0xcb, 0x3e, 0xa8, 0x55, 0x97, 0x6a, 0xf5, 0x66, 0x67, 0x7f,
	0x7b, 0xbb, 0x24, 0xa0, 0x0a, 0x5c, 0xf3, 0x3b, 0xb6, 0x1b, 0xcf, 0xea, 0x5b, 0x4f, 0xaa, 0xbb,
	0x07, 0x75, 0xd2, 0x97, 0x5a, 0x7b, 0x39, 0xf0, 0x1e, 0x19, 0x77, 0xd7, 0x00, 0x85, 0x00, 0x1e,
	0xf5, 0x32, 0x5c, 0x09, 0xc3, 0xab, 0xb5, 0x4e, 0xe3, 0x49, 0xbd, 0x24, 0xa0, 0x1b, 0x70, 0x35,
	0xdc, 0xd3, 0xaa, 0x37, 0xb7, 0x1a, 0xcd, 0x9d, 0x52, 0x8a, 0xcc, 0x1c, 0xee, 0x6a, 0x34, 0x39,
	0x5a, 0x7a, 0xed, 0x05, 0x5c, 0x8e, 0x78, 0x02, 0x21, 0x04, 0xcb, 0x2d, 0xa9, 0xbe, 0xdd, 0x78,
	0x26, 0x1f, 0x34, 0x1f, 0x37, 0xf7, 0x9f, 0x36, 0xf9, 0x6a, 0x78, 0xb0, 0x76, 0xbd, 0xc3, 0x34,
	0xc4, 0x21, 0x9c, 0x5e, 0x8a, 0x2a, 0x9e, 0x81, 0xa4, 0xfa, 0xa7, 0xf5, 0x1a, 0xd1, 0x64, 0x3a,
	0x40, 0xcd, 0x63, 0x2a, 0xb3, 0x76, 0x38, 0xf0, 0x28, 0x78, 0x55, 0x58, 0x40, 0x66, 0x06, 0x91,
	0xab, 0xba, 0x5e, 0x7a, 0x25, 0xc8, 0x3e, 0x87, 0x73, 0xdf, 0xb0, 0x24, 0xa0, 0x5b, 0x50, 0x1e,
	0xc6, 0x39, 0x3a, 0xd2, 0x74, 0x4d, 0x71, 0x70, 0x29, 0xb5, 0xf6, 0x53, 0x01, 0x2e, 0x47, 0xd8,
	0x3e, 0x82, 0x15, 0x01, 0xf6, 0x74, 0x3c, 0xa6, 0xf7, 0x69, 0xbd, 0xfe, 0xb8, 0x24, 0xa0, 0xdb,
	0x70, 0x23, 0xaa, 0x77, 0x6f, 0xbf, 0xd9, 0xf9, 0x56, 0x29, 0x35, 0x0e, 0xf9, 0xdb, 0xf5, 0xaa,
	0x54, 0x4a, 0xa3, 0x55, 0xb8, 0x19, 0xd5, 0xbb, 0xdf, 0xac, 0x77, 0x1a, 0x7b, 0xf5, 0x52, 0x66,
	0xe3, 0xbf, 0xde, 0x82, 0x62, 0xa8, 0x04, 0x01, 0xfd, 0xa9, 0x00, 0x97, 0x23, 0x6a, 0x46, 0xd1,
	0xa3, 0x78, 0xd6, 0x68, 0x7c, 0xb5, 0x6e, 0xa5, 0x3a, 0x07, 0x05, 0x6e, 0x24, 0x7f, 0x22, 0x78,
	0xa1, 0xbd, 0x10, 0x6f, 0x0f, 0x63, 0x46, 0xcd, 0xc7, 0xd5, 0xa4, 0x56, 0x1e, 0xcd, 0x4e, 0x80,
	0x73, 0xf6, 0xdb, 0x02, 0x14, 0x82, 0x35, 0x9c, 0xe8, 0xc3, 0xd8, 0x24, 0x87, 0x8b, 0x52, 0x2b,
	0x1f, 0xcd, 0x82, 0xca, 0xf9, 0xf8, 0x0b, 0x01, 0xae, 0x46, 0x56, 0x54, 0xa1, 0xcd, 0xf9, 0x2b,
	0x2c, 0x2b, 0xb5, 0xb9, 0x68, 0x70, 0x16, 0xff, 0x53, 0x18, 0xce, 0xcd, 0x4c, 0x2a, 0x95, 0x42,
	0x4f, 0x63, 0xc6, 0xa1, 0x92, 0xd6, 0x6f, 0x56, 0x9e, 0x5d, 0x3c, 0x61, 0x2e, 0xe1, 0x9f, 0x0b,
	0x70, 0x25, 0xaa, 0xbe, 0x07, 0x55, 0x13, 0x4d, 0x19, 0xb9, 0x04, 0x9b, 0xf3, 0x90, 0xe0, 0xfc,
	0xfd, 0x94, 0x3d, 0x17, 0xc7, 0x88, 0x85, 0x76, 0xe6, 0x55, 0x8c, 0xc7, 0xeb, 0xb7, 0xe6, 0x27,
	0xc4, 0x39, 0xfe, 0x99, 0xe0, 0xd7, 0x5a, 0x45, 0x15, 0x7b, 0xa1, 0x64, 0x33, 0x4d, 0xa8, 0x48,
	0xab, 0x34, 0x2e, 0x80, 0x12, 0x67, 0xfa, 0x1c, 0xb2, 0xde, 0x47, 0x87, 0x28, 0xe6, 0x8b, 0x61,
	0xe8, 0x13, 0xc8, 0xca, 0x7b, 0x49, 0xd1, 0xf8, 0xd4, 0x7f, 0x43, 0x4b, 0x0b, 0xa2, 0x3f, 0xdc,
	0x42, 0xf5, 0xb8, 0xf6, 0x65, 0xe2, 0xa7, 0x63, 0x95, 0xed, 0x79, 0xc9, 0x04, 0xd6, 0x76, 0x42,
	0x1a, 0x3d, 0xee, 0xda, 0x4e, 0xaf, 0x3b, 0x88, 0xbb, 0xb6, 0x71, 0x72, 0xfa, 0x44, 0xc1, 0xe3,
	0xd2, 0xe5, 0x71, 0x15, 0x3c, 0x25, 0xf3, 0x1f, 0x57, 0xc1, 0x53, 0xb3, 0xf6, 0x54, 0xc1, 0xe3,
	0xb3, 0xe9, 0xb1, 0x15, 0x3c, 0x35, 0xbf, 0x1f, 0x5b, 0xc1, 0x31, 0x52, 0xfb, 0xff, 0x22, 0xf8,
	0xe5, 0x9d, 0x93, 0x52, 0xeb, 0xa8, 0x35, 0x8b, 0x8d, 0x99, 0x28, 0xc4, 0x67, 0x17, 0x48, 0x91,
	0x0b, 0xf3, 0x07, 0x02, 0xcd, 0x15, 0x06, 0xbf, 0x56, 0x43, 0x1f, 0x27, 0x33, 0xe4, 0xe1, 0x8f,
	0x08, 0x2b, 0x9f, 0xcc, 0x88, 0x1d, 0x60, 0xa8, 0x3d, 0x1b, 0x43, 0xed, 0xb9, 0x18, 0x1a, 0xf7,
	0xcd, 0xde, 0xcf, 0x05, 0xb8, 0x3d, 0xb1, 0xc2, 0x13, 0x7d, 0x1a, 0x5b, 0xe2, 0xa9, 0xc5, 0xad,
	0x95, 0xc7, 0x17, 0x42, 0x8b, 0xb3, 0xfe, 0x0b, 0x01, 0xee, 0x4c, 0xab, 0xc3, 0x44, 0x7b, 0xb3,
	0xce, 0x18, 0x59, 0xa3, 0x5a, 0x69, 0x5e, 0x14, 0xb9, 0xf0, 0x06, 0x0d, 0x96, 0x09, 0x26, 0xd8,
	0xa0, 0x11, 0x95, 0x8b, 0x09, 0x36, 0x68, 0x64, 0x6d, 0xe2, 0x8f, 0x05, 0xaf, 0xf8, 0x21, 0x58,
	0x4c, 0xfa, 0x20, 0x89, 0x01, 0x1f, 0x2d, 0xaa, 0xab, 0x3c, 0x9c, 0x19, 0x3f, 0xc8, 0xd6, 0x70,
	0xf9, 0x5b, 0x6c, 0xb6, 0xc6, 0xd4, 0xfa, 0x55, 0x1e, 0xce, 0x8c, 0xcf, 0xd9, 0xfa, 0x3e, 0xc0,
	0xa0, 0x58, 0x03, 0xbd, 0x9f, 0x44, 0xca, 0x40, 0x4d, 0x40, 0xe5, 0x83, 0xe4, 0x88, 0x01, 0x06,
	0xfc, 0x92, 0x8b, 0xd8, 0x0c, 0x0c, 0x57, 0x82, 0xc4, 0x66, 0x60, 0xb4, 0xba, 0xe3, 0x1c, 0xb2,
	0x5e, 0xd9, 0x44, 0x5c, 0x5f, 0x6b, 0xa8, 0x78, 0x23, 0xae, 0xaf, 0x35, 0x52, 0x9d, 0x71, 0x06,
	0x4b, 0xbc, 0xf2, 0x01, 0xbd, 0x13, 0x9b, 0xff, 0xa0, 0xd4, 0xef, 0x26, 0xc4, 0xe2, 0xf3, 0xfe,
	0x91, 0xe0, 0x97, 0x8a, 0x0c, 0xca, 0x28, 0x3e, 0x49, 0x24, 0xc4, 0x70, 0xed, 0x41, 0xe5, 0xc1,
	0xac, 0xe8, 0x9c, 0xa7, 0x1f, 0x09, 0xb0, 0x1c, 0x4e, 0xde, 0xa3, 0xfb, 0xf1, 0x4d, 0xd5, 0x48,
	0x99, 0x40, 0xe5, 0xe3, 0xd9, 0x90, 0x39, 0x37, 0xbf, 0x27, 0xc0, 0x72, 0x38, 0xff, 0x1c, 0x97,
	0x9b, 0xc8, 0x3c, 0x7c, 0x65, 0x46, 0xe4, 0xd0, 0x13, 0x66, 0x5c, 0xde, 0x38, 0xc1, 0x13, 0x66,
	0x4a, 0x0a, 0x3b, 0xc1, 0x13, 0x66, 0x6a, 0x12, 0xfb, 0x27, 0x02, 0xa0, 0xd1, 0xe4, 0x68, 0xdc,
	0x80, 0xcb, 0xd8, 0x64, 0x6c, 0xdc, 0x80, 0xcb, 0x84, 0xbc, 0x2c, 0xb1, 0xc4, 0x23, 0x45, 0x1b,
	0xe8, 0x41, 0xa2, 0xfd, 0x32, 0x92, 0x9f, 0xad, 0x3c, 0x9c, 0x19, 0x3f, 0xf0, 0xf4, 0x8f, 0x4a,
	0xd5, 0xc6, 0x7d, 0xfa, 0x4f, 0x48, 0x1e, 0xc7, 0x7d, 0xfa, 0x4f, 0xca, 0x14, 0xd3, 0xf0, 0x5e,
	0x44, 0x16, 0x14, 0x25, 0x58, 0x90, 0xe8, 0x24, 0x73, 0xa5, 0x3a, 0x07, 0x85, 0xb0, 0x45, 0x0b,
	0xa5, 0x78, 0x12, 0x58, 0xb4, 0xa8, 0xb4, 0x52, 0x02, 0x8b, 0x16, 0x9d, 0x59, 0xe2, 0x27, 0x60,
	0x28, 0xa3, 0x90, 0xe0, 0x04, 0x44, 0x27, 0x44, 0x12, 0x9c, 0x80, 0x71, 0x19, 0xa3, 0xdf, 0x11,
	0xa0, 0x18, 0xca, 0xc6, 0xa0, 0x98, 0x81, 0xc3, 0xa8, 0xe4, 0x50, 0x5c, 0xdb, 0x16, 0x99, 0xfe,
	0xa1, 0x51, 0xc7, 0xc8, 0xcc, 0x4b, 0xdc, 0xa8, 0xe3, 0xa4, 0xdc, 0x51, 0xdc, 0xa8, 0xe3, 0xc4,
	0xd4, 0xcf, 0x66, 0xfe, 0x39, 0xfd, 0xd3, 0x32, 0xf4, 0x8f, 0x64, 0x1d, 0x2e, 0xd2, 0x6c, 0xf7,
	0x37, 0xff, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x2c, 0x22, 0xc0, 0x2f, 0x34, 0x4b, 0x00, 0x00,
}
