// Code generated by protoc-gen-twirp v4.7.0, DO NOT EDIT.
// source: twirp/subscriptions.proto

/*
Package substwirp is a generated twirp stub package.
This code was generated with code.justin.tv/common/twirp/protoc-gen-twirp v4.7.0.

It is generated from these files:
	twirp/subscriptions.proto
*/
package substwirp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/timestamp"

import bytes "bytes"
import context "golang.org/x/net/context"
import http "net/http"
import ioutil "io/ioutil"
import jsonpb "github.com/golang/protobuf/jsonpb"
import log "log"
import proto1 "github.com/golang/protobuf/proto"
import twirp "code.justin.tv/common/twirp"
import fmt1 "fmt"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import strings "strings"
import json "encoding/json"
import url "net/url"
import ctxhttp "golang.org/x/net/context/ctxhttp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// =======================
// Subscriptions Interface
// =======================

type Subscriptions interface {
	// Subscriptions
	// =============
	// FulfillSubscription creates/upgrades subscription for user to product.
	FulfillSubscription(context.Context, *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error)

	// CancelSubscription cancels user's subscription to product.
	CancelSubscription(context.Context, *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error)

	// CanSubscribe returns whether user can subscribe to product for a given platform.
	CanSubscribe(context.Context, *CanSubscribeRequest) (*CanSubscribeResponse, error)

	// ListUserSubscriptions returns a paginated list of user's active subscriptions.
	ListUserSubscriptions(context.Context, *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error)

	// GetUserChannelSubscriptionWithPaymentsData returns the highest max tier active subscription with payments data for an owner channel pair.
	GetUserChannelSubscriptionWithPaymentsData(context.Context, *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error)

	// GetUserSubscriptions returns the list of all a user's active subscriptions without payment data. Will return highest tier sub per channel.
	GetUserSubscriptions(context.Context, *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error)

	// GetUserChannelSubscription returns the highest max tier active subscription without payments data for a user channel pair.
	// This should be used when you need to know if a user channel pair is subscribed.
	GetUserChannelSubscription(context.Context, *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error)

	// GetUserSubscriptions returns the list of a user's active subscriptions without payments data given a list of product_ids.
	GetUserProductSubscriptions(context.Context, *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error)

	// Score
	// =====
	// SetScore sets the subscription high score given a channel and current score.
	SetScore(context.Context, *SetScoreRequest) (*SetScoreResponse, error)

	// CalculateSubscriberScore returns the subscriber score given their channel id.
	CalculateSubscriberCount(context.Context, *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error)

	// ChatNotification
	// =====
	// CreateChatNotificationToken creates a chat notification token
	CreateChatNotificationToken(context.Context, *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error)

	// UseChatNotificationToken posts a chat notification token, marks it as used given a token_id.
	UseChatNotificationToken(context.Context, *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error)

	// CancelChatNotificationToken invalidates a chat notification token, given a subscription_id.
	CancelChatNotificationToken(context.Context, *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error)

	// GetAvailableTokens gets all the tokens that are available that belong to a user and channel.
	GetUserChannelChatNotificationToken(context.Context, *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error)

	// UserSettings
	// ============
	// GetUserSettings gets the user subscription settings.
	GetUserSettings(context.Context, *GetUserSettingsRequest) (*GetUserSettingsResponse, error)

	// SetUserSettings sets the user subscription settings.
	SetUserSettings(context.Context, *SetUserSettingsRequest) (*SetUserSettingsResponse, error)

	// External Product
	// ================
	// GetExternalProductTemplateSKU returns a template SKU which can be used to fetch external product's attributes
	// from third party subscription providers like Apple, Google.
	GetExternalProductTemplateSKU(context.Context, *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error)

	// GetExternalProductPurchasableSKU does subscription eligibility checks and returns SKU for purchase from
	// external subscriptions providers (e.g, Apple, Google)
	GetExternalProductPurchasableSKU(context.Context, *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error)

	// Paid Upgrades
	// =======
	// GetPaidUpgrades returns a list of paid upgrades from a list of subKeys.
	GetPaidUpgrades(context.Context, *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error)

	// CreatePaidUpgrades creates a paid upgrade from a subKey.
	CreatePaidUpgrade(context.Context, *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error)

	// CancelPaidUpgrade cancels the paid upgrade from a subKey.
	CancelPaidUpgrade(context.Context, *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error)

	// Gifts
	// ======
	// CreateGift creates a new gift record in the gifts table.
	CreateGift(context.Context, *CreateGiftRequest) (*CreateGiftResponse, error)

	// CancelGift cancels a subscription gift.
	CancelGift(context.Context, *CancelGiftRequest) (*CancelGiftResponse, error)

	// GetGifts determines if there are gifts associated with supplied POODs.
	GetGifts(context.Context, *GetGiftsRequest) (*GetGiftsResponse, error)

	// CanGift determines if a sender can gift a subscription to a recipient.
	CanGift(context.Context, *CanGiftRequest) (*CanGiftResponse, error)

	// GetGiftPromotion returns the active gift promotion for subscription products.
	GetGiftPromotion(context.Context, *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error)

	// Emoticons
	// ======
	// GetEmotePrefix gets the emote prefix for a given channel ID.
	GetEmotePrefix(context.Context, *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error)

	// CreateEmoticon creates a subscription emoticon.
	CreateEmoticon(context.Context, *CreateEmoticonRequest) (*CreateEmoticonReponse, error)

	GetAllEmoticonsByProductIDs(context.Context, *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error)

	// Get standing status of a user. Can be "in good standing" or "not in good standing".
	// Partners are considered to be in “good standing” if they have not had a conduct infraction within the last 90 days.
	GetPartnerStanding(context.Context, *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error)

	// GetEmoticonPrefix returns the emote prefix and prefix state for a given channel ID.
	GetEmoticonPrefix(context.Context, *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error)

	// SubmitEmoticonPrefix is used when a new partner has a blank emoticon prefix and wants to submit
	// a prefix for approval. Will return precondition failed if the user does not have a blank prefix.
	SubmitEmoticonPrefix(context.Context, *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error)

	// Pending Emoticons
	// ======
	// GetPendingEmoticons returns an array of pending emoticons for the moderation team's approval flow.
	GetPendingEmoticons(context.Context, *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error)

	// Products
	// =========
	// GetProductsByIDs returns a list of products given a list of product ids.
	// Max size of 100 ids.
	GetProductsByIDs(context.Context, *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error)

	// GetChannelProducts accepts a channelID and returns a list of active products owned by the channel.
	// If the channel belongs to a teamsub, it will return the teamsub product.
	GetChannelProducts(context.Context, *GetChannelProductsRequest) (*GetChannelProductsResponse, error)

	// UpdateProduct updates the fields of the given product.
	UpdateProduct(context.Context, *UpdateProductRequest) (*UpdateProductResponse, error)

	// Updates all products for a given channel.
	UpdateChannelProducts(context.Context, *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error)
}

// =============================
// Subscriptions Protobuf Client
// =============================

type subscriptionsProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewSubscriptionsProtobufClient creates a Protobuf client that implements the Subscriptions interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewSubscriptionsProtobufClient(addr string, client *http.Client) Subscriptions {
	return &subscriptionsProtobufClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *subscriptionsProtobufClient) FulfillSubscription(ctx context.Context, in *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillSubscription"
	out := new(FulfillSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelSubscription(ctx context.Context, in *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelSubscription"
	out := new(CancelSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanSubscribe(ctx context.Context, in *CanSubscribeRequest) (*CanSubscribeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSubscribe"
	out := new(CanSubscribeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserSubscriptions"
	out := new(ListUserSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData"
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSubscriptions"
	out := new(GetUserSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscription"
	out := new(GetUserChannelSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptions"
	out := new(GetUserProductSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SetScore(ctx context.Context, in *SetScoreRequest) (*SetScoreResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetScore"
	out := new(SetScoreResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CalculateSubscriberCount(ctx context.Context, in *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CalculateSubscriberCount"
	out := new(CalculateSubscriberCountResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateChatNotificationToken(ctx context.Context, in *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChatNotificationToken"
	out := new(CreateChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UseChatNotificationToken(ctx context.Context, in *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UseChatNotificationToken"
	out := new(UseChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelChatNotificationToken(ctx context.Context, in *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelChatNotificationToken"
	out := new(CancelChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelChatNotificationToken(ctx context.Context, in *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken"
	out := new(GetUserChannelChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSettings"
	out := new(GetUserSettingsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SetUserSettings(ctx context.Context, in *SetUserSettingsRequest) (*SetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetUserSettings"
	out := new(SetUserSettingsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetExternalProductTemplateSKU(ctx context.Context, in *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductTemplateSKU"
	out := new(GetExternalProductTemplateSKUResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetExternalProductPurchasableSKU(ctx context.Context, in *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU"
	out := new(GetExternalProductPurchasableSKUResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPaidUpgrades(ctx context.Context, in *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgrades"
	out := new(GetPaidUpgradesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreatePaidUpgrade(ctx context.Context, in *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreatePaidUpgrade"
	out := new(CreatePaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelPaidUpgrade(ctx context.Context, in *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelPaidUpgrade"
	out := new(CancelPaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateGift(ctx context.Context, in *CreateGiftRequest) (*CreateGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateGift"
	out := new(CreateGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelGift(ctx context.Context, in *CancelGiftRequest) (*CancelGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelGift"
	out := new(CancelGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetGifts(ctx context.Context, in *GetGiftsRequest) (*GetGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGifts"
	out := new(GetGiftsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanGift(ctx context.Context, in *CanGiftRequest) (*CanGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGift"
	out := new(CanGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetGiftPromotion(ctx context.Context, in *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftPromotion"
	out := new(GetGiftPromotionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetEmotePrefix(ctx context.Context, in *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmotePrefix"
	out := new(GetEmotePrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateEmoticon"
	out := new(CreateEmoticonReponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetAllEmoticonsByProductIDs(ctx context.Context, in *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs"
	out := new(GetAllEmoticonsByProductIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPartnerStanding(ctx context.Context, in *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPartnerStanding"
	out := new(GetPartnerStandingResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetEmoticonPrefix(ctx context.Context, in *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmoticonPrefix"
	out := new(GetEmoticonPrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SubmitEmoticonPrefix(ctx context.Context, in *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SubmitEmoticonPrefix"
	out := new(SubmitEmoticonPrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPendingEmoticons(ctx context.Context, in *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticons"
	out := new(GetPendingEmoticonsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByIDs"
	out := new(GetProductsByIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetChannelProducts(ctx context.Context, in *GetChannelProductsRequest) (*GetChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelProducts"
	out := new(GetChannelProductsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest) (*UpdateProductResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateProduct"
	out := new(UpdateProductResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateChannelProducts(ctx context.Context, in *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateChannelProducts"
	out := new(UpdateChannelProductsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

// =========================
// Subscriptions JSON Client
// =========================

type subscriptionsJSONClient struct {
	urlBase string
	client  *http.Client
}

// NewSubscriptionsJSONClient creates a JSON client that implements the Subscriptions interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewSubscriptionsJSONClient(addr string, client *http.Client) Subscriptions {
	return &subscriptionsJSONClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *subscriptionsJSONClient) FulfillSubscription(ctx context.Context, in *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillSubscription"
	out := new(FulfillSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelSubscription(ctx context.Context, in *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelSubscription"
	out := new(CancelSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanSubscribe(ctx context.Context, in *CanSubscribeRequest) (*CanSubscribeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSubscribe"
	out := new(CanSubscribeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserSubscriptions"
	out := new(ListUserSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData"
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSubscriptions"
	out := new(GetUserSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscription"
	out := new(GetUserChannelSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptions"
	out := new(GetUserProductSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SetScore(ctx context.Context, in *SetScoreRequest) (*SetScoreResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetScore"
	out := new(SetScoreResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CalculateSubscriberCount(ctx context.Context, in *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CalculateSubscriberCount"
	out := new(CalculateSubscriberCountResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateChatNotificationToken(ctx context.Context, in *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChatNotificationToken"
	out := new(CreateChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UseChatNotificationToken(ctx context.Context, in *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UseChatNotificationToken"
	out := new(UseChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelChatNotificationToken(ctx context.Context, in *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelChatNotificationToken"
	out := new(CancelChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelChatNotificationToken(ctx context.Context, in *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken"
	out := new(GetUserChannelChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSettings"
	out := new(GetUserSettingsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SetUserSettings(ctx context.Context, in *SetUserSettingsRequest) (*SetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetUserSettings"
	out := new(SetUserSettingsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetExternalProductTemplateSKU(ctx context.Context, in *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductTemplateSKU"
	out := new(GetExternalProductTemplateSKUResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetExternalProductPurchasableSKU(ctx context.Context, in *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU"
	out := new(GetExternalProductPurchasableSKUResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPaidUpgrades(ctx context.Context, in *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgrades"
	out := new(GetPaidUpgradesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreatePaidUpgrade(ctx context.Context, in *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreatePaidUpgrade"
	out := new(CreatePaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelPaidUpgrade(ctx context.Context, in *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelPaidUpgrade"
	out := new(CancelPaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateGift(ctx context.Context, in *CreateGiftRequest) (*CreateGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateGift"
	out := new(CreateGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelGift(ctx context.Context, in *CancelGiftRequest) (*CancelGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelGift"
	out := new(CancelGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetGifts(ctx context.Context, in *GetGiftsRequest) (*GetGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGifts"
	out := new(GetGiftsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanGift(ctx context.Context, in *CanGiftRequest) (*CanGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGift"
	out := new(CanGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetGiftPromotion(ctx context.Context, in *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftPromotion"
	out := new(GetGiftPromotionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetEmotePrefix(ctx context.Context, in *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmotePrefix"
	out := new(GetEmotePrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateEmoticon"
	out := new(CreateEmoticonReponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetAllEmoticonsByProductIDs(ctx context.Context, in *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs"
	out := new(GetAllEmoticonsByProductIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPartnerStanding(ctx context.Context, in *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPartnerStanding"
	out := new(GetPartnerStandingResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetEmoticonPrefix(ctx context.Context, in *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmoticonPrefix"
	out := new(GetEmoticonPrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SubmitEmoticonPrefix(ctx context.Context, in *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SubmitEmoticonPrefix"
	out := new(SubmitEmoticonPrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPendingEmoticons(ctx context.Context, in *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticons"
	out := new(GetPendingEmoticonsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByIDs"
	out := new(GetProductsByIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetChannelProducts(ctx context.Context, in *GetChannelProductsRequest) (*GetChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelProducts"
	out := new(GetChannelProductsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest) (*UpdateProductResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateProduct"
	out := new(UpdateProductResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateChannelProducts(ctx context.Context, in *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateChannelProducts"
	out := new(UpdateChannelProductsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

// ============================
// Subscriptions Server Handler
// ============================

type subscriptionsServer struct {
	Subscriptions
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewSubscriptionsServer(svc Subscriptions, hooks *twirp.ServerHooks, ctxSrc ContextSource) TwirpServer {
	defaultHooks := twirp.NewServerHooks()
	if hooks == nil {
		hooks = defaultHooks
	} else {
		if hooks.RequestReceived == nil {
			hooks.RequestReceived = defaultHooks.RequestReceived
		}
		if hooks.RequestRouted == nil {
			hooks.RequestRouted = defaultHooks.RequestRouted
		}
		if hooks.ResponsePrepared == nil {
			hooks.ResponsePrepared = defaultHooks.ResponsePrepared
		}
		if hooks.ResponseSent == nil {
			hooks.ResponseSent = defaultHooks.ResponseSent
		}
		if hooks.Error == nil {
			hooks.Error = defaultHooks.Error
		}
	}
	if ctxSrc == nil {
		ctxSrc = RequestContextSource
	}

	return &subscriptionsServer{
		Subscriptions: svc,
		hooks:         hooks,
		ctxSource:     ctxSrc,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *subscriptionsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		writeErrorPreV3(ctx, resp, err, s.hooks)
	} else {
		writeErrorPostV3(ctx, resp, err, s.hooks)
	}
}

// SubscriptionsPathPrefix is used for all URL paths on a twirp Subscriptions server.
// Requests are always: POST SubscriptionsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const SubscriptionsPathPrefix = "/twirp/code.justin.tv.revenue.subscriptions.Subscriptions/"

// SubscriptionsPathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const SubscriptionsPathPrefixOld = "/v2/code.justin.tv.revenue.subscriptions.Subscriptions/"

func (s *subscriptionsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "Subscriptions")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		msg := fmt1.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}

	switch req.URL.Path {
	case SubscriptionsPathPrefix + "FulfillSubscription", SubscriptionsPathPrefixOld + "FulfillSubscription", "/v1/Subscriptions/FulfillSubscription":
		s.serveFulfillSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelSubscription", SubscriptionsPathPrefixOld + "CancelSubscription", "/v1/Subscriptions/CancelSubscription":
		s.serveCancelSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanSubscribe", SubscriptionsPathPrefixOld + "CanSubscribe", "/v1/Subscriptions/CanSubscribe":
		s.serveCanSubscribe(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "ListUserSubscriptions", SubscriptionsPathPrefixOld + "ListUserSubscriptions", "/v1/Subscriptions/ListUserSubscriptions":
		s.serveListUserSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData", SubscriptionsPathPrefixOld + "GetUserChannelSubscriptionWithPaymentsData", "/v1/Subscriptions/GetUserChannelSubscriptionWithPaymentsData":
		s.serveGetUserChannelSubscriptionWithPaymentsData(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserSubscriptions", SubscriptionsPathPrefixOld + "GetUserSubscriptions", "/v1/Subscriptions/GetUserSubscriptions":
		s.serveGetUserSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelSubscription", SubscriptionsPathPrefixOld + "GetUserChannelSubscription", "/v1/Subscriptions/GetUserChannelSubscription":
		s.serveGetUserChannelSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserProductSubscriptions", SubscriptionsPathPrefixOld + "GetUserProductSubscriptions", "/v1/Subscriptions/GetUserProductSubscriptions":
		s.serveGetUserProductSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SetScore", SubscriptionsPathPrefixOld + "SetScore", "/v1/Subscriptions/SetScore":
		s.serveSetScore(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CalculateSubscriberCount", SubscriptionsPathPrefixOld + "CalculateSubscriberCount", "/v1/Subscriptions/CalculateSubscriberCount":
		s.serveCalculateSubscriberCount(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateChatNotificationToken", SubscriptionsPathPrefixOld + "CreateChatNotificationToken", "/v1/Subscriptions/CreateChatNotificationToken":
		s.serveCreateChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UseChatNotificationToken", SubscriptionsPathPrefixOld + "UseChatNotificationToken", "/v1/Subscriptions/UseChatNotificationToken":
		s.serveUseChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelChatNotificationToken", SubscriptionsPathPrefixOld + "CancelChatNotificationToken", "/v1/Subscriptions/CancelChatNotificationToken":
		s.serveCancelChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken", SubscriptionsPathPrefixOld + "GetUserChannelChatNotificationToken", "/v1/Subscriptions/GetUserChannelChatNotificationToken":
		s.serveGetUserChannelChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserSettings", SubscriptionsPathPrefixOld + "GetUserSettings", "/v1/Subscriptions/GetUserSettings":
		s.serveGetUserSettings(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SetUserSettings", SubscriptionsPathPrefixOld + "SetUserSettings", "/v1/Subscriptions/SetUserSettings":
		s.serveSetUserSettings(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetExternalProductTemplateSKU", SubscriptionsPathPrefixOld + "GetExternalProductTemplateSKU", "/v1/Subscriptions/GetExternalProductTemplateSKU":
		s.serveGetExternalProductTemplateSKU(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU", SubscriptionsPathPrefixOld + "GetExternalProductPurchasableSKU", "/v1/Subscriptions/GetExternalProductPurchasableSKU":
		s.serveGetExternalProductPurchasableSKU(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPaidUpgrades", SubscriptionsPathPrefixOld + "GetPaidUpgrades", "/v1/Subscriptions/GetPaidUpgrades":
		s.serveGetPaidUpgrades(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreatePaidUpgrade", SubscriptionsPathPrefixOld + "CreatePaidUpgrade", "/v1/Subscriptions/CreatePaidUpgrade":
		s.serveCreatePaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelPaidUpgrade", SubscriptionsPathPrefixOld + "CancelPaidUpgrade", "/v1/Subscriptions/CancelPaidUpgrade":
		s.serveCancelPaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateGift", SubscriptionsPathPrefixOld + "CreateGift", "/v1/Subscriptions/CreateGift":
		s.serveCreateGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelGift", SubscriptionsPathPrefixOld + "CancelGift", "/v1/Subscriptions/CancelGift":
		s.serveCancelGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetGifts", SubscriptionsPathPrefixOld + "GetGifts", "/v1/Subscriptions/GetGifts":
		s.serveGetGifts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanGift", SubscriptionsPathPrefixOld + "CanGift", "/v1/Subscriptions/CanGift":
		s.serveCanGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetGiftPromotion", SubscriptionsPathPrefixOld + "GetGiftPromotion", "/v1/Subscriptions/GetGiftPromotion":
		s.serveGetGiftPromotion(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetEmotePrefix", SubscriptionsPathPrefixOld + "GetEmotePrefix", "/v1/Subscriptions/GetEmotePrefix":
		s.serveGetEmotePrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateEmoticon", SubscriptionsPathPrefixOld + "CreateEmoticon", "/v1/Subscriptions/CreateEmoticon":
		s.serveCreateEmoticon(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs", SubscriptionsPathPrefixOld + "GetAllEmoticonsByProductIDs", "/v1/Subscriptions/GetAllEmoticonsByProductIDs":
		s.serveGetAllEmoticonsByProductIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPartnerStanding", SubscriptionsPathPrefixOld + "GetPartnerStanding", "/v1/Subscriptions/GetPartnerStanding":
		s.serveGetPartnerStanding(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetEmoticonPrefix", SubscriptionsPathPrefixOld + "GetEmoticonPrefix", "/v1/Subscriptions/GetEmoticonPrefix":
		s.serveGetEmoticonPrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SubmitEmoticonPrefix", SubscriptionsPathPrefixOld + "SubmitEmoticonPrefix", "/v1/Subscriptions/SubmitEmoticonPrefix":
		s.serveSubmitEmoticonPrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPendingEmoticons", SubscriptionsPathPrefixOld + "GetPendingEmoticons", "/v1/Subscriptions/GetPendingEmoticons":
		s.serveGetPendingEmoticons(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetProductsByIDs", SubscriptionsPathPrefixOld + "GetProductsByIDs", "/v1/Subscriptions/GetProductsByIDs":
		s.serveGetProductsByIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetChannelProducts", SubscriptionsPathPrefixOld + "GetChannelProducts", "/v1/Subscriptions/GetChannelProducts":
		s.serveGetChannelProducts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateProduct", SubscriptionsPathPrefixOld + "UpdateProduct", "/v1/Subscriptions/UpdateProduct":
		s.serveUpdateProduct(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateChannelProducts", SubscriptionsPathPrefixOld + "UpdateChannelProducts", "/v1/Subscriptions/UpdateChannelProducts":
		s.serveUpdateChannelProducts(ctx, resp, req)
		return
	default:
		msg := fmt1.Sprintf("no handler for path %q", req.URL.Path)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}
}

func (s *subscriptionsServer) serveFulfillSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveFulfillSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveFulfillSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(FulfillSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillSubscriptionResponse and nil error while calling FulfillSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FulfillSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillSubscriptionResponse and nil error while calling FulfillSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelSubscriptionResponse and nil error while calling CancelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelSubscriptionResponse and nil error while calling CancelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSubscribe(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanSubscribeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanSubscribeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanSubscribeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSubscribe")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanSubscribeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSubscribeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSubscribeResponse and nil error while calling CanSubscribe. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSubscribeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSubscribe")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanSubscribeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSubscribeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSubscribeResponse and nil error while calling CanSubscribe. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveListUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListUserSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserProductSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserProductSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserProductSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetScore(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetScoreJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetScoreProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSetScoreJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetScore")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetScoreRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetScoreResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetScoreResponse and nil error while calling SetScore. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetScoreProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetScore")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetScoreRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetScoreResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetScoreResponse and nil error while calling SetScore. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCalculateSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCalculateSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCalculateSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCalculateSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CalculateSubscriberCount")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CalculateSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CalculateSubscriberCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CalculateSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CalculateSubscriberCountResponse and nil error while calling CalculateSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCalculateSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CalculateSubscriberCount")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CalculateSubscriberCountRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CalculateSubscriberCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CalculateSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CalculateSubscriberCountResponse and nil error while calling CalculateSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChatNotificationTokenResponse and nil error while calling CreateChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChatNotificationTokenResponse and nil error while calling CreateChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUseChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUseChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUseChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUseChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UseChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UseChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UseChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UseChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UseChatNotificationTokenResponse and nil error while calling UseChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUseChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UseChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UseChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UseChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UseChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UseChatNotificationTokenResponse and nil error while calling UseChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelChatNotificationTokenResponse and nil error while calling CancelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelChatNotificationTokenResponse and nil error while calling CancelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelChatNotificationTokenResponse and nil error while calling GetUserChannelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelChatNotificationTokenResponse and nil error while calling GetUserChannelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserSettingsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSetUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetUserSettingsResponse and nil error while calling SetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetUserSettingsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetUserSettingsResponse and nil error while calling SetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKU(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetExternalProductTemplateSKUJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExternalProductTemplateSKUProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKUJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductTemplateSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetExternalProductTemplateSKURequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductTemplateSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductTemplateSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductTemplateSKUResponse and nil error while calling GetExternalProductTemplateSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKUProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductTemplateSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExternalProductTemplateSKURequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductTemplateSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductTemplateSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductTemplateSKUResponse and nil error while calling GetExternalProductTemplateSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKU(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetExternalProductPurchasableSKUJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExternalProductPurchasableSKUProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKUJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductPurchasableSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetExternalProductPurchasableSKURequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductPurchasableSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductPurchasableSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductPurchasableSKUResponse and nil error while calling GetExternalProductPurchasableSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKUProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductPurchasableSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExternalProductPurchasableSKURequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductPurchasableSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductPurchasableSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductPurchasableSKUResponse and nil error while calling GetExternalProductPurchasableSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgrades(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPaidUpgradesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPaidUpgradesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPaidUpgradesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgrades")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPaidUpgradesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgrades(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradesResponse and nil error while calling GetPaidUpgrades. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgradesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgrades")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPaidUpgradesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgrades(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradesResponse and nil error while calling GetPaidUpgrades. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreatePaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreatePaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreatePaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreatePaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreatePaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreatePaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreatePaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePaidUpgradeResponse and nil error while calling CreatePaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreatePaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreatePaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreatePaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreatePaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePaidUpgradeResponse and nil error while calling CreatePaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelPaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelPaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelPaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelPaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelPaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelPaidUpgradeResponse and nil error while calling CancelPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelPaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelPaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelPaidUpgradeResponse and nil error while calling CancelPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateGiftResponse and nil error while calling CreateGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateGiftResponse and nil error while calling CreateGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelGiftResponse and nil error while calling CancelGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelGiftResponse and nil error while calling CancelGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGifts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetGiftsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftsResponse and nil error while calling GetGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftsResponse and nil error while calling GetGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftResponse and nil error while calling CanGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftResponse and nil error while calling CanGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftPromotion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftPromotionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftPromotionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetGiftPromotionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftPromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftPromotionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftPromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftPromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftPromotionResponse and nil error while calling GetGiftPromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftPromotionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftPromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftPromotionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftPromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftPromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftPromotionResponse and nil error while calling GetGiftPromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmotePrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmotePrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmotePrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetEmotePrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmotePrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmotePrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmotePrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmotePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmotePrefixResponse and nil error while calling GetEmotePrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmotePrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmotePrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmotePrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmotePrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmotePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmotePrefixResponse and nil error while calling GetEmotePrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateEmoticonProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateEmoticonRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateEmoticonRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetAllEmoticonsByProductIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllEmoticonsByProductIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmoticonsByProductIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetAllEmoticonsByProductIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmoticonsByProductIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmoticonsByProductIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmoticonsByProductIDsResponse and nil error while calling GetAllEmoticonsByProductIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmoticonsByProductIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllEmoticonsByProductIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmoticonsByProductIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmoticonsByProductIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmoticonsByProductIDsResponse and nil error while calling GetAllEmoticonsByProductIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPartnerStanding(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPartnerStandingJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPartnerStandingProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPartnerStandingJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPartnerStanding")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPartnerStandingRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPartnerStandingResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPartnerStanding(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPartnerStandingResponse and nil error while calling GetPartnerStanding. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPartnerStandingProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPartnerStanding")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPartnerStandingRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPartnerStandingResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPartnerStanding(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPartnerStandingResponse and nil error while calling GetPartnerStanding. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmoticonPrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmoticonPrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonPrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetEmoticonPrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmoticonPrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonPrefixResponse and nil error while calling GetEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmoticonPrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmoticonPrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonPrefixResponse and nil error while calling GetEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSubmitEmoticonPrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSubmitEmoticonPrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SubmitEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SubmitEmoticonPrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitEmoticonPrefixResponse and nil error while calling SubmitEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SubmitEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SubmitEmoticonPrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitEmoticonPrefixResponse and nil error while calling SubmitEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPendingEmoticonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPendingEmoticonsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPendingEmoticonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPendingEmoticonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsResponse and nil error while calling GetPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPendingEmoticonsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsResponse and nil error while calling GetPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetProductsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetProductsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetProductsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetProductsByIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetChannelProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetChannelProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetChannelProductsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelProductsResponse and nil error while calling GetChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelProductsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelProductsResponse and nil error while calling GetChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateProduct(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateProductJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateProductProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateProductJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateProduct")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateProductRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateProductResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateProduct(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductResponse and nil error while calling UpdateProduct. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateProductProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateProduct")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateProductRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateProductResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateProduct(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductResponse and nil error while calling UpdateProduct. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateChannelProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateChannelProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateChannelProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateChannelProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateChannelProductsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelProductsResponse and nil error while calling UpdateChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateChannelProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateChannelProductsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelProductsResponse and nil error while calling UpdateChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *subscriptionsServer) ProtocGenTwirpVersion() string {
	return "v4.7.0"
}

// =====
// Utils
// =====

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshaled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// A ContextSource establishes the base context for a Server.
type ContextSource func(http.ResponseWriter, *http.Request) context.Context

var RequestContextSource ContextSource = func(w http.ResponseWriter, req *http.Request) context.Context {
	return req.Context()
}

var BackgroundContextSource ContextSource = func(http.ResponseWriter, *http.Request) context.Context {
	return context.Background()
}

// done returns ctx.Err() if ctx.Done() indicates that the context done
func done(ctx context.Context) error {
	select {
	case <-ctx.Done():
		return ctx.Err()
	default:
		return nil
	}
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
// NOTE: not compatible with old v1/v2 clients (only returns v3+ errors)
func WriteError(resp http.ResponseWriter, err error) {
	writeErrorPostV3(nil, resp, err, nil) // does not trigger server hooks
}

// writeErrorPostV3 writes Twirp v3+ errors in the response.
func writeErrorPostV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, err2 := resp.Write(respBody)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// writeErrorPreV3 writes Twirp v1/v2 backwards-compatible errors in the response.
// This is to make it easy to upgrade to v3, a v3 server keeps serving v2-style errors to v2 clients.
func writeErrorPreV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Unknown 500 (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.NewError(twirp.Unknown, err.Error())
	}

	resp.Header().Set("Content-Type", "text/plain")

	// v2err.Retryable <= v3err.Meta("retryable")
	if twerr.Meta("retryable") != "" {
		resp.Header().Set("Twirp-Error-Retryable", "true")
	}

	// v2err.ErrorID <= v3err.Meta("v2_error_id") if present, otherwise v3err.Code()
	// or "unroutable" if generated from twirp router (BadRoute)
	var v2ErrorID string
	if twerr.Code() == twirp.BadRoute {
		v2ErrorID = "unroutable" // as was generated by previous router
	} else if twerr.Meta("v2_error_id") != "" {
		v2ErrorID = twerr.Meta("v2_error_id")
	} else {
		v2ErrorID = string(twerr.Code()) // the string-format of v3 codes match v2 error ids for the most part: i.e. "not_found", "internal", "unknown", "canceled", etc.
	}
	resp.Header().Set("Twirp-ErrorID", v2ErrorID)

	// v2err.StatusCode <= v3err.Meta("v2_status_code") if present, otherwise same as in v3
	statusCode, err := strconv.Atoi(twerr.Meta("v2_status_code"))
	if err != nil {
		statusCode = twirp.ServerHTTPStatusFromErrorCode(twerr.Code()) // v3 it's the same as v2 for the most part: i.e. "not_found" is 404
	}
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}
	resp.WriteHeader(statusCode)

	msg := []byte(twerr.Msg())
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}
	_, err2 := resp.Write(msg)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// setMethodName, setServerName, and setStatusCode are functions to
// expose internal state through contexts. The context keys hardcoded
// in here are not to be used on their own. Twirp provides accessor
// functions which will retrieve these values out and give them the
// correct type for you.
func setMethodName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_method_name", name)
}
func setServerName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_service_name", name)
}
func setStatusCode(ctx context.Context, code int) context.Context {
	return context.WithValue(ctx, "__tw_status_code", strconv.Itoa(code))
}

type privateContextKey int

var versionKey = new(privateContextKey)

// setVersionFromPath adds "v1", "v2" or "v3" to the context depending on the path.
func setVersionFromPath(ctx context.Context, path string) context.Context {
	var version string
	if strings.HasPrefix(path, "/v1/") {
		version = "v1"
	} else if strings.HasPrefix(path, "/v2/") {
		version = "v2"
	} else {
		version = "v3"
	}
	return context.WithValue(ctx, versionKey, version)
}

// getVersion returns the version number ("v1", "v2", "v3") or empty string if unset.
func getVersion(ctx context.Context) string {
	v, _ := ctx.Value(versionKey).(string)
	return v
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := ctx.Value("__tw_request_header").(http.Header)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// closebody closes a response or request body and just logs
// any error encountered while closing, since errors are
// considered very unusual.
func closebody(body io.Closer) {
	if err := body.Close(); err != nil {
		log.Printf("error closing body: %q", err)
	}
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v4.7.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients dont't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt1.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt1.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtoRequest is common code to make a request to the remote twirp service.
func doProtoRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto1.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

var twirpFileDescriptor0 = []byte{
	// 4255 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x3c, 0x5d, 0x6f, 0x1b, 0x49,
	0x72, 0x3b, 0x24, 0x25, 0x91, 0x45, 0x52, 0xa2, 0xdb, 0x5f, 0x34, 0x6d, 0x47, 0xde, 0xd9, 0xdd,
	0x5b, 0x9f, 0x72, 0xab, 0x85, 0x75, 0xfb, 0xed, 0x5d, 0xdb, 0x14, 0x45, 0xe9, 0xb8, 0x96, 0x28,
	0xee, 0x90, 0xb2, 0x7d, 0xbe, 0x0b, 0xe6, 0x46, 0x9c, 0x96, 0x34, 0xd1, 0x70, 0x86, 0x3b, 0x1f,
	0xb2, 0x95, 0x2c, 0x70, 0x0f, 0x97, 0xe0, 0x92, 0x5c, 0x10, 0x24, 0xc8, 0x01, 0x17, 0x24, 0x08,
	0x10, 0x04, 0x08, 0x90, 0x3c, 0x1d, 0x72, 0xc9, 0xc3, 0xe5, 0x21, 0x0f, 0xf7, 0x92, 0x00, 0x79,
	0x48, 0x80, 0xbc, 0x07, 0x79, 0xcc, 0x4b, 0x90, 0x9f, 0x10, 0x04, 0xfd, 0x31, 0xc3, 0x19, 0x72,
	0x48, 0xce, 0x90, 0xda, 0xc3, 0xe6, 0xc5, 0x66, 0x57, 0x77, 0x55, 0x57, 0x55, 0x77, 0x57, 0x57,
	0x57, 0xd5, 0x08, 0x6e, 0x38, 0x2f, 0x34, 0xab, 0xff, 0xb6, 0xed, 0x1e, 0xda, 0x5d, 0x4b, 0xeb,
	0x3b, 0x9a, 0x69, 0xd8, 0xeb, 0x7d, 0xcb, 0x74, 0x4c, 0xf4, 0x7a, 0xd7, 0x54, 0xf1, 0xfa, 0xaf,
	0xbb, 0xb6, 0xa3, 0x19, 0xeb, 0xce, 0xd9, 0xba, 0x85, 0xcf, 0xb0, 0xe1, 0xe2, 0xf5, 0xd0, 0xd8,
	0xca, 0xea, 0xb1, 0x69, 0x1e, 0xeb, 0xf8, 0x6d, 0x8a, 0x73, 0xe8, 0x1e, 0xbd, 0xed, 0x68, 0x3d,
	0x6c, 0x3b, 0x4a, 0xaf, 0xcf, 0xc8, 0x88, 0xdf, 0x81, 0x62, 0xbd, 0x67, 0x3a, 0x5a, 0xd7, 0x34,
	0x76, 0xf1, 0x19, 0xd6, 0xd1, 0x6b, 0x50, 0xec, 0x69, 0x86, 0xd6, 0x73, 0x7b, 0xb2, 0xdd, 0x35,
	0x2d, 0x5c, 0x16, 0xee, 0x08, 0x77, 0xd3, 0x52, 0x81, 0x03, 0xdb, 0x04, 0x86, 0xde, 0x80, 0x65,
	0xcc, 0xb1, 0x64, 0x5d, 0xeb, 0x69, 0x4e, 0x39, 0x45, 0x47, 0x15, 0x3d, 0xe8, 0x2e, 0x01, 0x8a,
	0xdf, 0x81, 0x95, 0x36, 0x76, 0x28, 0x8a, 0x84, 0x3f, 0x77, 0xb1, 0xed, 0xa0, 0xdb, 0x00, 0xdd,
	0x13, 0xc5, 0x30, 0xb0, 0x2e, 0x6b, 0x2a, 0xa5, 0x9d, 0x93, 0x72, 0x1c, 0xd2, 0x50, 0xd1, 0xd7,
	0xa1, 0xc4, 0x05, 0x38, 0xc4, 0x16, 0x67, 0x80, 0x91, 0x5e, 0x19, 0xc0, 0x29, 0x41, 0xf1, 0xe7,
	0x02, 0x94, 0x06, 0xd4, 0xed, 0xbe, 0x69, 0xd8, 0x38, 0x12, 0x5f, 0x88, 0xc4, 0x8f, 0x29, 0x03,
	0x92, 0x00, 0x0c, 0xfc, 0xd2, 0x91, 0x75, 0xa2, 0x9d, 0x72, 0xfa, 0x8e, 0x70, 0x37, 0xbf, 0xf1,
	0xcd, 0xf5, 0x38, 0xca, 0x5f, 0x0f, 0x29, 0x56, 0xca, 0x11, 0x32, 0xf4, 0xa7, 0xf8, 0x0f, 0x19,
	0xb8, 0xd4, 0x0e, 0x0c, 0xad, 0x99, 0xae, 0xe1, 0xa0, 0x2b, 0xb0, 0x10, 0x64, 0x98, 0x35, 0x86,
	0xe6, 0x4f, 0x5d, 0xc4, 0xfc, 0xc8, 0x81, 0x95, 0x2e, 0x99, 0x52, 0x3e, 0xb4, 0xb0, 0x72, 0xaa,
	0x9a, 0x2f, 0x8c, 0x72, 0xfa, 0x4e, 0xfa, 0x6e, 0x7e, 0xe3, 0x71, 0x3c, 0xc2, 0x23, 0xbc, 0xaf,
	0xd3, 0x7f, 0x37, 0x3d, 0x6a, 0x75, 0xc3, 0xb1, 0xce, 0xa5, 0xe5, 0x6e, 0x08, 0x48, 0x66, 0xa5,
	0x22, 0x05, 0x66, 0xcd, 0xcc, 0x37, 0x2b, 0x5d, 0xc8, 0xe1, 0x59, 0xed, 0x10, 0x10, 0xbd, 0x0a,
	0x05, 0x47, 0xeb, 0x9e, 0x62, 0x47, 0xa6, 0xec, 0x94, 0x17, 0xa8, 0x72, 0xf3, 0x0c, 0xc6, 0x14,
	0x3f, 0xba, 0x13, 0x16, 0x23, 0x76, 0x42, 0xa5, 0x0a, 0x97, 0x23, 0xc4, 0x44, 0x25, 0x48, 0x9f,
	0xe2, 0x73, 0xbe, 0x95, 0xc9, 0x4f, 0xb2, 0x90, 0x67, 0x8a, 0xee, 0x7a, 0x3b, 0x97, 0x35, 0x3e,
	0x4a, 0x7d, 0x20, 0x10, 0x12, 0x11, 0x3c, 0x27, 0x21, 0x21, 0x3e, 0x82, 0xd5, 0x9a, 0xa2, 0x77,
	0x5d, 0x5d, 0x71, 0x70, 0xdb, 0xdf, 0xd2, 0x94, 0xb1, 0x78, 0x67, 0x4c, 0xfc, 0x0d, 0xb8, 0x33,
	0x9e, 0x02, 0x3f, 0x47, 0x4f, 0x00, 0x88, 0xf2, 0xb9, 0xce, 0x04, 0xba, 0xeb, 0xde, 0x9f, 0x71,
	0x99, 0xa4, 0x1c, 0x19, 0x40, 0x7f, 0x8a, 0xf7, 0xe0, 0xda, 0x0e, 0x76, 0x0e, 0x6c, 0x6c, 0xb5,
	0xb1, 0xe3, 0x68, 0xc6, 0xb1, 0xed, 0x31, 0x7d, 0x1d, 0x96, 0x5c, 0x1b, 0x5b, 0x03, 0x8e, 0x17,
	0x49, 0xb3, 0xa1, 0x8a, 0x3f, 0x14, 0xe0, 0xfa, 0x08, 0x0e, 0x67, 0x73, 0x0b, 0x56, 0x8f, 0xb5,
	0x23, 0xc7, 0x96, 0x35, 0x43, 0x3e, 0x32, 0x75, 0xdd, 0x7c, 0x81, 0x55, 0x99, 0x4b, 0x6a, 0xcb,
	0xa6, 0xa1, 0x33, 0xa5, 0x66, 0xa5, 0x9b, 0x74, 0x58, 0xc3, 0xd8, 0xe6, 0x83, 0x6a, 0x7c, 0xcc,
	0xbe, 0xa1, 0x9f, 0xa3, 0xaf, 0xc1, 0xca, 0x89, 0xa6, 0x62, 0x99, 0x8c, 0xe1, 0x12, 0xa7, 0x28,
	0x56, 0x91, 0x80, 0x77, 0xb4, 0x23, 0xb6, 0x4f, 0xc4, 0xff, 0x48, 0xc1, 0xb5, 0x76, 0x32, 0xee,
	0xe3, 0x70, 0x98, 0x9a, 0xce, 0xe1, 0x0f, 0x05, 0x78, 0xd3, 0xc2, 0x5d, 0xac, 0x9d, 0x31, 0x2e,
	0x27, 0x91, 0x63, 0x26, 0x6a, 0x23, 0xde, 0x62, 0xed, 0xd3, 0xff, 0x15, 0x7d, 0xd3, 0x34, 0x75,
	0x49, 0xe4, 0x53, 0xec, 0x4c, 0xe0, 0xe4, 0xf9, 0xa8, 0xae, 0x32, 0x33, 0x4f, 0x38, 0xa4, 0x5f,
	0xb2, 0xd2, 0xed, 0xaf, 0xc4, 0x4a, 0xbf, 0x0e, 0x85, 0x20, 0xa3, 0x83, 0xe3, 0xc8, 0xe6, 0x60,
	0x0d, 0xf1, 0xef, 0x52, 0x50, 0x08, 0xee, 0x76, 0xb4, 0x0c, 0x29, 0x7f, 0x03, 0xa4, 0x34, 0x75,
	0xe8, 0x20, 0xa6, 0x86, 0x2f, 0xbb, 0x1b, 0x90, 0x35, 0x5f, 0x18, 0x6c, 0xd7, 0xa4, 0x69, 0xe7,
	0x12, 0x6d, 0x37, 0x28, 0x66, 0xdf, 0x32, 0x55, 0xb7, 0xeb, 0x90, 0xce, 0x0c, 0xc3, 0xe4, 0x90,
	0x86, 0x8a, 0x6e, 0x42, 0xce, 0xb4, 0xb4, 0x63, 0xcd, 0x20, 0xbd, 0x0b, 0xb4, 0x37, 0xcb, 0x00,
	0x0d, 0x15, 0x3d, 0x84, 0xe2, 0x21, 0x36, 0xf0, 0x91, 0xe6, 0xc8, 0xb6, 0xa3, 0x58, 0xcc, 0x9a,
	0xe5, 0x37, 0x2a, 0xeb, 0xcc, 0x17, 0x58, 0xf7, 0x7c, 0x81, 0xf5, 0x8e, 0xe7, 0x0b, 0x48, 0x05,
	0x8e, 0xd0, 0x26, 0xe3, 0xd1, 0x7d, 0xc8, 0x7b, 0x04, 0xb0, 0xa1, 0x96, 0x97, 0xa6, 0xa2, 0x03,
	0x1f, 0x5e, 0x37, 0x54, 0xb4, 0x0a, 0x79, 0xa5, 0xdb, 0xc5, 0xb6, 0x2d, 0x1f, 0xbb, 0x9a, 0x5a,
	0xce, 0x52, 0xe6, 0x80, 0x81, 0x76, 0x5c, 0x4d, 0x15, 0xff, 0x31, 0x05, 0x95, 0x6d, 0x57, 0x3f,
	0xd2, 0x74, 0x3d, 0xa8, 0x3c, 0xef, 0x24, 0x05, 0x95, 0x22, 0x4c, 0x52, 0x4a, 0x6a, 0xa2, 0x52,
	0xd2, 0xd3, 0x94, 0x92, 0x99, 0x4f, 0x29, 0x0b, 0x89, 0x94, 0xf2, 0x29, 0x64, 0xfb, 0xba, 0xe2,
	0x1c, 0x99, 0x56, 0x8f, 0xae, 0xc6, 0xf2, 0xc6, 0x7a, 0xbc, 0xe3, 0xd2, 0xe2, 0x58, 0x92, 0x8f,
	0x2f, 0xba, 0x70, 0x33, 0x52, 0x7d, 0xbe, 0xe5, 0x2e, 0x04, 0x49, 0x70, 0xdb, 0xbd, 0x91, 0xdc,
	0x76, 0x4b, 0x21, 0x3a, 0xa2, 0x05, 0x37, 0x6a, 0x8a, 0xd1, 0xc5, 0xbf, 0xc4, 0x45, 0x13, 0x6f,
	0x41, 0x25, 0x6a, 0x4e, 0x26, 0xa9, 0xf8, 0x67, 0x02, 0x5c, 0xae, 0x29, 0x86, 0x7f, 0x85, 0xcd,
	0xcf, 0x4c, 0x70, 0x99, 0xd2, 0x73, 0x2e, 0xd3, 0x7d, 0xb8, 0x12, 0x66, 0x8e, 0xaf, 0xcf, 0x6b,
	0x50, 0xec, 0x2a, 0x86, 0xec, 0x7b, 0xa3, 0xdc, 0xa4, 0x14, 0xba, 0x81, 0xc1, 0xe2, 0x2f, 0x52,
	0x70, 0x6b, 0x57, 0xb3, 0x99, 0x29, 0x0c, 0xce, 0x14, 0x43, 0xc6, 0x2b, 0xb0, 0x10, 0x74, 0x67,
	0x59, 0x03, 0x5d, 0x83, 0xc5, 0xae, 0x6b, 0xd9, 0xa6, 0xc5, 0x95, 0xcc, 0x5b, 0x21, 0x91, 0x33,
	0xf3, 0x89, 0x8c, 0x14, 0x58, 0x3c, 0xd2, 0x74, 0x07, 0x5b, 0xf4, 0x74, 0x2c, 0x6f, 0x34, 0xe2,
	0x51, 0x9a, 0x24, 0xe8, 0xfa, 0x36, 0x25, 0x28, 0x71, 0xc2, 0xe2, 0xd7, 0x61, 0x91, 0x41, 0xd0,
	0x12, 0xa4, 0xab, 0xbb, 0xbb, 0xa5, 0x57, 0x50, 0x01, 0xb2, 0xad, 0xdd, 0x6a, 0x67, 0x7b, 0x5f,
	0xda, 0x2b, 0x09, 0x28, 0x0b, 0x99, 0x9d, 0xc6, 0x76, 0xa7, 0x94, 0x12, 0x7b, 0x70, 0x8f, 0xbb,
	0x0d, 0xfc, 0x0a, 0x08, 0xd2, 0x7f, 0xaa, 0x39, 0x27, 0x2d, 0xe5, 0xbc, 0x87, 0x0d, 0xc7, 0xde,
	0x52, 0x1c, 0x25, 0xde, 0xde, 0x99, 0x60, 0xcc, 0xc5, 0x5f, 0x83, 0x57, 0xc7, 0x4f, 0x37, 0x3f,
	0xf9, 0x3f, 0xc9, 0x40, 0x69, 0x58, 0x49, 0xe8, 0x4d, 0x58, 0x09, 0xaa, 0x72, 0x40, 0x75, 0x39,
	0x08, 0x1e, 0xba, 0x69, 0x52, 0x93, 0x8e, 0x44, 0x7a, 0xe2, 0xf9, 0xcc, 0x4c, 0x33, 0xaa, 0x0b,
	0xf3, 0x19, 0xd5, 0xc5, 0x99, 0x8d, 0xea, 0xd2, 0x9c, 0x5b, 0xf7, 0x7d, 0xc8, 0x59, 0xd8, 0xc0,
	0x2f, 0x6c, 0x59, 0x71, 0xe8, 0x9d, 0x35, 0x99, 0x8d, 0x2c, 0x1b, 0x5c, 0x75, 0xd0, 0x5d, 0x28,
	0x91, 0xd7, 0x59, 0xdf, 0xb5, 0xba, 0x27, 0x8a, 0x8d, 0x65, 0xfb, 0xd4, 0x2d, 0xe7, 0xd8, 0x1a,
	0xe0, 0x97, 0x4e, 0x8b, 0x83, 0xdb, 0xa7, 0x2e, 0x59, 0x03, 0xcd, 0x96, 0xfb, 0x96, 0xd6, 0xc3,
	0x65, 0xa0, 0x67, 0x7e, 0x49, 0xb3, 0x5b, 0xa4, 0x49, 0xbc, 0x47, 0xcd, 0xa6, 0x4e, 0x49, 0x39,
	0x4f, 0x7b, 0x16, 0x35, 0x9b, 0x38, 0x23, 0xc4, 0x58, 0x68, 0xb6, 0x6c, 0xe1, 0x23, 0xd7, 0x50,
	0x95, 0x43, 0x1d, 0x97, 0x0b, 0xcc, 0x58, 0x68, 0xb6, 0xe4, 0xc3, 0xc4, 0xdf, 0x17, 0xe0, 0xda,
	0xf0, 0xd6, 0x90, 0xb0, 0xed, 0xea, 0x0e, 0x7a, 0x1e, 0x79, 0x19, 0xbc, 0x17, 0x4f, 0x4d, 0x23,
	0x34, 0x43, 0xb4, 0x02, 0x16, 0x25, 0x15, 0xb4, 0x28, 0xe2, 0x3f, 0x0b, 0x70, 0x7b, 0xcc, 0x91,
	0xf6, 0xaf, 0xa8, 0x25, 0x8b, 0xf2, 0x67, 0x97, 0x05, 0xfa, 0x00, 0xfc, 0x78, 0x46, 0x86, 0x28,
	0x11, 0xc9, 0x23, 0x86, 0xd6, 0xe0, 0xd2, 0x89, 0x42, 0x54, 0x8c, 0xcf, 0x34, 0xd3, 0xb5, 0xe5,
	0xbe, 0x72, 0x8c, 0xb9, 0x7f, 0xb7, 0x72, 0xa2, 0xd8, 0x2d, 0x0e, 0x6f, 0x29, 0xc7, 0x18, 0x89,
	0x50, 0x24, 0x63, 0xe9, 0xd3, 0x9a, 0x8e, 0x4b, 0xd3, 0x71, 0xf9, 0x13, 0xc5, 0x6e, 0x92, 0x85,
	0x53, 0x8e, 0xb1, 0xf8, 0x87, 0x02, 0x6c, 0x24, 0x31, 0x21, 0x5c, 0xbc, 0x2f, 0x51, 0xe9, 0xe2,
	0x17, 0x20, 0x4e, 0xb2, 0x32, 0x5f, 0xb2, 0x0f, 0xf0, 0x3d, 0x7f, 0xf6, 0x16, 0x33, 0x10, 0x49,
	0xef, 0xa6, 0x55, 0xc8, 0x0f, 0x8c, 0x8d, 0x5d, 0x4e, 0xdd, 0x49, 0x13, 0xe7, 0xd0, 0xb7, 0x36,
	0xb6, 0xf8, 0x7d, 0x78, 0x6d, 0xe2, 0x0c, 0x5c, 0xc0, 0x67, 0x50, 0x0c, 0x31, 0xcd, 0xf7, 0xd1,
	0x2c, 0x12, 0x86, 0x09, 0x89, 0x1f, 0xc0, 0x4d, 0xef, 0xb1, 0x99, 0x4c, 0x36, 0xf1, 0x25, 0xdc,
	0x8a, 0xc6, 0xfc, 0xd2, 0x79, 0xfe, 0x7b, 0x01, 0x5e, 0xdf, 0xc1, 0x4e, 0xfd, 0xa5, 0x83, 0x2d,
	0x43, 0xd1, 0xb9, 0xe6, 0x3a, 0xb8, 0xd7, 0xa7, 0x4f, 0xfc, 0xc7, 0x07, 0x81, 0xc0, 0x40, 0xc0,
	0xd6, 0x0b, 0x93, 0xdc, 0x9f, 0xd4, 0x9c, 0x06, 0xf5, 0x55, 0x28, 0xd0, 0xf7, 0x95, 0x75, 0x2e,
	0x13, 0x12, 0xfc, 0x62, 0xc9, 0x73, 0x58, 0xcd, 0x54, 0xb1, 0xf8, 0x00, 0xde, 0x98, 0xc2, 0x35,
	0xd7, 0xdc, 0x55, 0x58, 0xb4, 0x4f, 0xdd, 0x01, 0xcb, 0x0b, 0xf6, 0xa9, 0xdb, 0x50, 0xc5, 0x7f,
	0x17, 0xe0, 0xcd, 0x51, 0x02, 0xdc, 0xe4, 0x12, 0xcb, 0x18, 0x90, 0xfc, 0x2b, 0xe1, 0x13, 0x8e,
	0x28, 0x25, 0x33, 0xaa, 0x94, 0x2a, 0xdc, 0x9d, 0x2e, 0xd3, 0x64, 0xbd, 0xb4, 0x60, 0xb1, 0xed,
	0x1e, 0x3e, 0xc6, 0xe7, 0xa8, 0x0c, 0x4b, 0x5c, 0x10, 0x4f, 0x68, 0xde, 0x24, 0x4e, 0x22, 0x95,
	0x9f, 0xcb, 0xcb, 0x1a, 0xc4, 0xa4, 0xb3, 0xbb, 0xdd, 0x73, 0x12, 0x59, 0x4b, 0xfc, 0xdb, 0x14,
	0xe4, 0x5b, 0x8a, 0xa6, 0x1e, 0xf4, 0x8f, 0x2d, 0x45, 0xc5, 0x68, 0x07, 0xb2, 0x87, 0xe4, 0xb2,
	0xf3, 0x82, 0x56, 0xf9, 0x8d, 0x6f, 0xc4, 0xde, 0xc5, 0x8f, 0xf1, 0xb9, 0xb4, 0x44, 0xb0, 0x09,
	0x83, 0x7b, 0x90, 0x77, 0x19, 0x4d, 0x4a, 0x2b, 0x35, 0x03, 0x2d, 0xe0, 0x04, 0x08, 0xb9, 0x37,
	0x60, 0x19, 0x1b, 0x8e, 0xe6, 0xe8, 0x98, 0x58, 0xe5, 0x81, 0x3f, 0x53, 0x0c, 0x40, 0x1b, 0x2a,
	0xfa, 0x10, 0x80, 0xba, 0x2b, 0xb2, 0xaa, 0x38, 0x38, 0xc6, 0x43, 0x30, 0x47, 0x47, 0x6f, 0x29,
	0x0e, 0x46, 0x08, 0x32, 0x8e, 0xc6, 0x1d, 0xdc, 0x9c, 0x44, 0x7f, 0x13, 0x5d, 0xf6, 0x2d, 0xad,
	0x8b, 0xa9, 0xfb, 0xb2, 0x20, 0xb1, 0x86, 0xf8, 0x9c, 0x46, 0xba, 0x02, 0x5a, 0xf3, 0x6d, 0xc8,
	0x23, 0xc8, 0x9c, 0xe2, 0x73, 0xef, 0xfc, 0x27, 0x93, 0x96, 0x62, 0x8a, 0x9f, 0xd3, 0x88, 0x58,
	0x98, 0xb6, 0x6f, 0xfa, 0x8b, 0x7d, 0x45, 0x53, 0x65, 0xae, 0x15, 0x6f, 0x96, 0x7b, 0x31, 0xf7,
	0xec, 0x80, 0xa4, 0x54, 0xe8, 0x07, 0xe8, 0x8b, 0x3f, 0x13, 0xa0, 0x5c, 0xb3, 0xb0, 0xe2, 0xe0,
	0xe0, 0x18, 0x2e, 0xd1, 0x57, 0x74, 0x3f, 0x88, 0x9f, 0xc3, 0x8d, 0x08, 0x9e, 0xb9, 0xa6, 0x3a,
	0x50, 0x08, 0x6a, 0x8a, 0x33, 0x3e, 0x83, 0xa2, 0xf2, 0x01, 0x45, 0x31, 0x3d, 0xd1, 0x37, 0xeb,
	0xff, 0x23, 0x3d, 0xdd, 0xf4, 0xde, 0xf6, 0x11, 0x7a, 0x12, 0xff, 0x5b, 0x00, 0x91, 0x69, 0xb1,
	0x76, 0xa2, 0x38, 0x4d, 0xd3, 0xd1, 0x8e, 0xb4, 0xae, 0x42, 0x68, 0x75, 0xcc, 0x53, 0x7c, 0x01,
	0x21, 0x80, 0x4f, 0xa0, 0xa0, 0x9c, 0x29, 0x9a, 0x4e, 0xcc, 0x1b, 0x71, 0xbf, 0xd3, 0x53, 0x0f,
	0x64, 0xde, 0x1f, 0x5f, 0x75, 0xd0, 0x5e, 0xc0, 0xaf, 0x9e, 0x3d, 0x14, 0xe9, 0xf9, 0xe2, 0xe2,
	0x43, 0x78, 0x6d, 0xa2, 0xb4, 0x7c, 0xf7, 0x94, 0x61, 0xa9, 0x87, 0x6d, 0x9b, 0x78, 0x8e, 0x5c,
	0x5a, 0xde, 0x14, 0x7f, 0x57, 0x80, 0xd5, 0x03, 0x7b, 0xaa, 0xb2, 0x1c, 0xd2, 0x0e, 0x28, 0x8b,
	0xb6, 0x1b, 0x2a, 0x7a, 0x1d, 0x96, 0x15, 0xd7, 0x39, 0xc1, 0xaa, 0xec, 0x05, 0x94, 0x99, 0xc2,
	0x0a, 0x0c, 0x7a, 0xc0, 0xc2, 0xca, 0x6f, 0xc0, 0x72, 0xd7, 0xb5, 0x1d, 0xb3, 0x27, 0x7b, 0x5c,
	0x70, 0x4b, 0xc7, 0xa0, 0x7b, 0x9c, 0x97, 0x8f, 0xe1, 0xce, 0x78, 0x56, 0xa6, 0x4a, 0xb2, 0x07,
	0x22, 0xdb, 0x16, 0x13, 0x65, 0x89, 0xfb, 0x08, 0xa5, 0x9a, 0x9d, 0x44, 0x6e, 0x2a, 0x3f, 0x2a,
	0xac, 0x85, 0x9d, 0xdf, 0x89, 0x7c, 0x8d, 0x0d, 0xc9, 0x4f, 0x79, 0x69, 0xff, 0xa5, 0x00, 0xbf,
	0x1a, 0x6b, 0x1a, 0xce, 0xaf, 0x0d, 0xd7, 0xbb, 0x27, 0x8a, 0x23, 0x1b, 0x81, 0x11, 0x32, 0x5d,
	0x4d, 0x7e, 0xc6, 0xef, 0xc7, 0xdb, 0x8e, 0xd1, 0xb3, 0x5c, 0xed, 0x46, 0x81, 0xc5, 0x53, 0xb8,
	0x1a, 0x39, 0x7e, 0x24, 0x04, 0x1d, 0xd0, 0x66, 0x2a, 0xa4, 0x4d, 0x72, 0x6d, 0xf5, 0x4c, 0xc3,
	0x39, 0xe1, 0x3b, 0x87, 0x35, 0xc8, 0x05, 0x77, 0xaa, 0x19, 0xde, 0x53, 0x9f, 0xfe, 0x16, 0xff,
	0x47, 0x80, 0x0c, 0x7d, 0x8e, 0x5e, 0x83, 0x45, 0x1b, 0x1b, 0x2a, 0xb6, 0x3c, 0x8d, 0xb2, 0x16,
	0xba, 0x45, 0x5e, 0xcf, 0x5d, 0xad, 0xaf, 0x61, 0x1e, 0x50, 0xcf, 0x49, 0x03, 0x40, 0xd0, 0x0b,
	0x49, 0x87, 0xbd, 0x90, 0x81, 0xbf, 0x91, 0x09, 0xfa, 0x1b, 0xa8, 0x0e, 0x0b, 0xb6, 0x43, 0xee,
	0x66, 0x16, 0x47, 0x7a, 0x3b, 0x9e, 0x02, 0x09, 0x8b, 0x6d, 0x82, 0x26, 0x31, 0x6c, 0xf2, 0xa8,
	0xa7, 0x81, 0x7e, 0x7a, 0xcd, 0x4f, 0x8f, 0x2d, 0x64, 0xc9, 0x60, 0x72, 0xcb, 0x8b, 0xdf, 0x86,
	0x25, 0x42, 0x6c, 0xb2, 0x0b, 0x35, 0x60, 0x3e, 0x15, 0x62, 0x3e, 0xa4, 0x8c, 0xf4, 0x90, 0x32,
	0xc4, 0xdf, 0x84, 0x4b, 0xcc, 0xbc, 0x90, 0x09, 0xbc, 0xad, 0xfa, 0x4b, 0xd2, 0xab, 0xd8, 0x01,
	0x14, 0x9c, 0x9c, 0x6f, 0xe0, 0x07, 0x90, 0xa1, 0xa1, 0x07, 0xb6, 0x5b, 0xd7, 0xe2, 0x2b, 0x5b,
	0xa2, 0x78, 0x62, 0x17, 0x2e, 0xb1, 0x73, 0x1d, 0x14, 0xe9, 0xa2, 0xf5, 0x86, 0x01, 0x05, 0x27,
	0xe1, 0xac, 0xef, 0xd3, 0x60, 0x6a, 0x17, 0xeb, 0x58, 0x95, 0x67, 0x94, 0xa1, 0xe0, 0x11, 0x20,
	0x2d, 0xb1, 0x03, 0x2b, 0x3b, 0xd8, 0xa1, 0x09, 0x30, 0x4f, 0x92, 0x6a, 0xc8, 0x5d, 0x7b, 0x2b,
	0x3e, 0xe9, 0x81, 0xbf, 0xd6, 0x81, 0xd2, 0x80, 0x2a, 0x67, 0xfd, 0x11, 0x2c, 0xd0, 0x4c, 0x15,
	0xa7, 0x9b, 0x84, 0x65, 0x86, 0x28, 0x7e, 0x0f, 0x96, 0x6b, 0x8a, 0xf1, 0x25, 0xee, 0x23, 0xf1,
	0x1b, 0xb0, 0xe2, 0xcf, 0xc0, 0xd9, 0xbe, 0x01, 0xd9, 0xae, 0x62, 0x0c, 0x94, 0x9d, 0x95, 0x96,
	0xba, 0x6c, 0x88, 0xf8, 0xbf, 0x02, 0x14, 0xc9, 0x8f, 0x96, 0x65, 0xf6, 0x4c, 0x1a, 0x22, 0x9a,
	0xf2, 0xde, 0xbc, 0x09, 0x39, 0x03, 0xbf, 0x90, 0x99, 0xf3, 0xcc, 0xa2, 0xd5, 0x59, 0x03, 0xbf,
	0x68, 0x91, 0x36, 0x0d, 0x3c, 0xea, 0x2a, 0xef, 0x4c, 0xb3, 0x4e, 0x53, 0x57, 0x59, 0xe7, 0x53,
	0x28, 0xaa, 0x9a, 0xcd, 0x6a, 0x18, 0x9c, 0xf3, 0x3e, 0xe6, 0xa1, 0xeb, 0x98, 0x17, 0xff, 0x16,
	0x47, 0xed, 0x9c, 0xf7, 0xb1, 0x54, 0x50, 0x03, 0x2d, 0x72, 0xaf, 0xfa, 0x84, 0x59, 0xc6, 0x8f,
	0xd5, 0x0b, 0xf8, 0xd3, 0x3d, 0x21, 0x40, 0x62, 0x3b, 0xb1, 0x65, 0x99, 0x16, 0xb5, 0x2a, 0x39,
	0x89, 0x35, 0xc4, 0x8f, 0xa8, 0x5b, 0x1e, 0x52, 0x81, 0xb7, 0x32, 0x43, 0x81, 0x0f, 0x61, 0x24,
	0xf0, 0xf1, 0xd7, 0x02, 0x94, 0x47, 0x91, 0xb9, 0xd2, 0xd7, 0xe1, 0x32, 0x75, 0x71, 0x38, 0x5c,
	0x56, 0xba, 0x8e, 0x76, 0xe6, 0x65, 0x0e, 0x2e, 0x11, 0xcf, 0x85, 0xf7, 0x54, 0x69, 0x07, 0xfa,
	0x2e, 0xac, 0x50, 0xc3, 0xe7, 0x63, 0xb0, 0x50, 0x4b, 0xec, 0xc2, 0x91, 0x30, 0x17, 0xcb, 0xc7,
	0xc1, 0xa6, 0x2d, 0x6e, 0xc0, 0x55, 0xf2, 0x44, 0xed, 0x99, 0x0e, 0x6e, 0x59, 0xf8, 0x48, 0x7b,
	0x19, 0x23, 0x38, 0xf2, 0x0e, 0x7d, 0x0d, 0x85, 0x70, 0xb8, 0x6c, 0x15, 0xc8, 0xf6, 0x29, 0x04,
	0x7b, 0x6a, 0xf1, 0xdb, 0xe2, 0x87, 0x54, 0x27, 0x5e, 0x19, 0x4b, 0x78, 0xb2, 0x29, 0x45, 0x0e,
	0xbf, 0x25, 0xc0, 0x8d, 0x08, 0x5c, 0x3e, 0xe9, 0x35, 0x58, 0x64, 0x93, 0x78, 0x07, 0x85, 0xb5,
	0xd0, 0xbe, 0x77, 0xf1, 0xb0, 0xf0, 0xc7, 0x87, 0xc9, 0xea, 0x6c, 0xd8, 0x24, 0xc1, 0x2b, 0x48,
	0xfc, 0x37, 0x01, 0xae, 0x32, 0x93, 0xeb, 0x0d, 0x9a, 0xea, 0x9e, 0xac, 0x42, 0x9e, 0xcc, 0x2a,
	0xdb, 0xee, 0x11, 0x61, 0x90, 0x1d, 0x57, 0x20, 0xa0, 0x36, 0x85, 0x4c, 0x8b, 0xd8, 0xdf, 0x06,
	0xd0, 0x7a, 0xca, 0x31, 0xde, 0xf8, 0x20, 0x90, 0x3a, 0xe6, 0x90, 0x40, 0xf7, 0xbb, 0xef, 0x0d,
	0x72, 0xc7, 0x39, 0x0e, 0x61, 0xb3, 0xd3, 0xc6, 0xbd, 0x7b, 0x1b, 0xa4, 0x9f, 0xed, 0x6f, 0xf0,
	0x40, 0x0d, 0x55, 0xfc, 0x51, 0x84, 0x44, 0x4c, 0xa9, 0xc3, 0xae, 0x07, 0x82, 0x0c, 0x8d, 0x72,
	0x30, 0x09, 0xe8, 0xef, 0x69, 0xbc, 0xdf, 0x80, 0xec, 0xb1, 0x65, 0xba, 0xfd, 0x01, 0xe7, 0x4b,
	0xb4, 0xcd, 0xd2, 0x5a, 0x03, 0x9f, 0x20, 0xe7, 0xe9, 0xb7, 0x4e, 0x23, 0x92, 0x55, 0x5d, 0xf7,
	0x98, 0xb1, 0x37, 0xcf, 0x79, 0xd0, 0xa4, 0xb1, 0x65, 0xc7, 0x3e, 0x7d, 0x3f, 0x10, 0x68, 0xdc,
	0x71, 0x3c, 0x1d, 0xbe, 0x6f, 0xbe, 0x0b, 0x2b, 0x7e, 0xa5, 0x10, 0x65, 0xcc, 0x33, 0xdf, 0x09,
	0x2b, 0xb2, 0x76, 0x08, 0xae, 0xe4, 0x57, 0x1d, 0xd1, 0xa6, 0x2d, 0x7e, 0x31, 0xa8, 0xc5, 0xa3,
	0x90, 0x69, 0xf6, 0x73, 0x17, 0x72, 0x1e, 0x05, 0xef, 0x80, 0xaf, 0x27, 0xe3, 0x43, 0x1a, 0x10,
	0x10, 0x7f, 0x2c, 0x40, 0xd6, 0x83, 0xc7, 0x5a, 0xcb, 0xe0, 0x62, 0xa5, 0xc3, 0x8b, 0xd5, 0xf0,
	0x16, 0x8b, 0xd9, 0xe5, 0x84, 0xda, 0x09, 0x9d, 0xa0, 0x77, 0xe8, 0x39, 0x6e, 0x29, 0x96, 0x63,
	0x60, 0xab, 0xed, 0x28, 0x86, 0xaa, 0x19, 0xc7, 0x53, 0x8b, 0x86, 0x1e, 0x43, 0x25, 0x0a, 0x8b,
	0x2f, 0xe3, 0x5b, 0xd4, 0x9e, 0x6a, 0x86, 0x7c, 0x6c, 0x9a, 0xaa, 0x6c, 0xf3, 0x6e, 0x6e, 0x4f,
	0x4b, 0x9a, 0xdd, 0x30, 0x76, 0x4c, 0x53, 0xf5, 0xd0, 0xc4, 0x0e, 0xdc, 0x6c, 0xbb, 0x87, 0x3d,
	0x6d, 0x26, 0x4b, 0x14, 0xb0, 0x35, 0xa9, 0xa0, 0xad, 0x11, 0x7f, 0x05, 0x6e, 0x45, 0x53, 0xe5,
	0xef, 0xee, 0x7f, 0x15, 0x98, 0x0c, 0x98, 0x32, 0xe1, 0xef, 0x4b, 0x6f, 0xd6, 0x5d, 0x3f, 0xd9,
	0x2a, 0x50, 0x1d, 0xbf, 0x93, 0x4c, 0xc7, 0xe1, 0xbc, 0x2a, 0x39, 0x5d, 0x83, 0x72, 0x98, 0x05,
	0x89, 0x35, 0xc8, 0x1c, 0x87, 0x6e, 0xf7, 0x14, 0x7b, 0x6f, 0xf2, 0x84, 0x73, 0x6c, 0x52, 0x5c,
	0x89, 0xd3, 0x10, 0x3f, 0x83, 0xe5, 0x70, 0x0f, 0xf3, 0x4b, 0xa8, 0x38, 0x98, 0x29, 0x6e, 0x41,
	0x1a, 0x00, 0xd0, 0xab, 0x50, 0x60, 0x98, 0x72, 0x90, 0xb5, 0x3c, 0x83, 0xb1, 0x3a, 0x9d, 0x3f,
	0x16, 0x68, 0xb8, 0x7e, 0x54, 0x47, 0x7c, 0xa1, 0xdb, 0xc1, 0x13, 0xc2, 0x4e, 0xea, 0xbb, 0x31,
	0x03, 0x3c, 0x61, 0x92, 0x81, 0x83, 0x42, 0xac, 0x89, 0x63, 0x3a, 0x8a, 0x1e, 0x62, 0x0b, 0x28,
	0x88, 0x71, 0xf5, 0x57, 0x02, 0xac, 0x0c, 0xe1, 0x8f, 0x1c, 0xa8, 0x31, 0xbb, 0xc2, 0x3f, 0x68,
	0xe9, 0xf0, 0x41, 0xf3, 0xef, 0xd5, 0x4c, 0x38, 0xb4, 0x72, 0x1f, 0xf2, 0x6e, 0x5f, 0x37, 0x15,
	0x55, 0x76, 0xb4, 0x1e, 0x8e, 0x53, 0x95, 0xc2, 0x86, 0x13, 0x80, 0xf8, 0x4f, 0x69, 0x58, 0xe2,
	0x46, 0x2e, 0xaa, 0x74, 0xc9, 0x3e, 0x31, 0x2d, 0x47, 0x36, 0x94, 0x9e, 0x77, 0xec, 0x73, 0x14,
	0xd2, 0x54, 0x7a, 0x98, 0xac, 0x8d, 0xaa, 0xd9, 0x7d, 0x5d, 0x39, 0x67, 0x03, 0x78, 0x78, 0x9f,
	0xc3, 0xe8, 0x90, 0xbb, 0x50, 0xf2, 0x6d, 0xa5, 0x8d, 0x99, 0xe5, 0xcd, 0x50, 0xcb, 0xeb, 0xdb,
	0xbd, 0x36, 0x26, 0xd6, 0x77, 0x10, 0x40, 0x5d, 0x08, 0x04, 0x50, 0x89, 0xd4, 0xb4, 0x56, 0x4b,
	0x51, 0x6d, 0x7a, 0x0d, 0x65, 0xa5, 0x25, 0xd2, 0xae, 0xaa, 0x36, 0x8d, 0xc2, 0x12, 0xaf, 0x6f,
	0x89, 0x47, 0x61, 0x89, 0xe7, 0x16, 0x54, 0x52, 0x36, 0xac, 0x24, 0x2f, 0x68, 0x9b, 0x0b, 0x04,
	0x6d, 0x3f, 0x83, 0xac, 0x66, 0x38, 0xd8, 0x3a, 0x53, 0x74, 0x9a, 0x8d, 0x8d, 0xbf, 0x31, 0xb8,
	0xf9, 0xe5, 0xc8, 0x92, 0x4f, 0x86, 0xf8, 0x8e, 0x87, 0x9a, 0x63, 0x29, 0x0e, 0x96, 0x59, 0xb9,
	0x53, 0x39, 0x4f, 0xc5, 0x2d, 0x72, 0x68, 0x95, 0x02, 0x79, 0x89, 0xb2, 0x69, 0xe8, 0xe7, 0xb2,
	0x62, 0x75, 0x4f, 0xb4, 0x33, 0x6c, 0xf3, 0xb4, 0xee, 0x0a, 0x87, 0x57, 0x39, 0x18, 0x7d, 0x2d,
	0x70, 0xdd, 0x30, 0x15, 0x96, 0x8b, 0x3c, 0xa0, 0x1d, 0xd4, 0xa0, 0xf8, 0x05, 0xac, 0x0c, 0xb1,
	0x45, 0xdc, 0x2a, 0xd5, 0xb5, 0x14, 0x3f, 0xfd, 0xb7, 0x20, 0xf9, 0x6d, 0xb4, 0x07, 0x19, 0xd7,
	0xe0, 0x05, 0x22, 0xb1, 0x9d, 0x9c, 0xa1, 0x09, 0x0e, 0x0c, 0xcd, 0x91, 0x28, 0x19, 0xee, 0xf6,
	0xf2, 0x7e, 0x7b, 0xf3, 0x3c, 0xc9, 0xc5, 0x8b, 0xa9, 0x87, 0x37, 0x84, 0xcb, 0x0f, 0x6f, 0x83,
	0x78, 0x86, 0xac, 0x23, 0xd9, 0xe3, 0x8b, 0x93, 0x93, 0x7c, 0x74, 0xf1, 0x29, 0xbd, 0x44, 0x78,
	0x38, 0xc7, 0x9b, 0x2d, 0xa6, 0xfd, 0xbe, 0x09, 0xb9, 0xae, 0xae, 0xf1, 0x7c, 0x02, 0x3b, 0x08,
	0x59, 0x06, 0x68, 0xa8, 0xe2, 0x31, 0xb5, 0xd1, 0x23, 0x84, 0x2f, 0x5e, 0x82, 0x67, 0x70, 0xe5,
	0xa0, 0xaf, 0x2a, 0xc4, 0x7d, 0x66, 0x5d, 0xf1, 0x52, 0x7a, 0xc3, 0xe7, 0x34, 0x35, 0x72, 0x4e,
	0xc5, 0xeb, 0x70, 0x75, 0x88, 0x32, 0xbf, 0x80, 0x7e, 0x20, 0xc0, 0x2d, 0xd6, 0x33, 0x9b, 0xe2,
	0x82, 0x07, 0x38, 0x15, 0x3e, 0xc0, 0x51, 0x67, 0x20, 0x1d, 0x79, 0x06, 0xc4, 0x55, 0xb8, 0x3d,
	0x86, 0x09, 0xc6, 0xe6, 0x9a, 0x0e, 0x59, 0x2f, 0xd5, 0x86, 0x2e, 0x41, 0xd1, 0xab, 0x05, 0x92,
	0x9b, 0xfb, 0xcd, 0x7a, 0xe9, 0x15, 0x54, 0x82, 0x82, 0x0f, 0x7a, 0x5a, 0xdf, 0x2c, 0x09, 0x21,
	0x48, 0x63, 0xbf, 0x5d, 0x4a, 0xa1, 0x2b, 0x50, 0xf2, 0x21, 0xd5, 0xe6, 0x96, 0xb4, 0xdf, 0xd8,
	0x2a, 0xa5, 0xd1, 0x65, 0x58, 0x19, 0x40, 0xf7, 0xaa, 0xcf, 0xf7, 0x9b, 0xa5, 0xcc, 0xda, 0x23,
	0xc8, 0xf9, 0x71, 0x26, 0x54, 0x84, 0xdc, 0x4e, 0x63, 0xbb, 0xe3, 0x4d, 0x75, 0x09, 0x8a, 0xb4,
	0x59, 0xad, 0xd5, 0xea, 0xad, 0x4e, 0x7d, 0xab, 0x24, 0xf8, 0xa0, 0x5a, 0xb5, 0x59, 0xab, 0xef,
	0xd6, 0xb7, 0x4a, 0xa9, 0xb5, 0x27, 0x50, 0x08, 0x3e, 0x40, 0xc9, 0x90, 0xad, 0x46, 0xbb, 0xb6,
	0x7f, 0xd0, 0xf4, 0x09, 0x5d, 0x87, 0xcb, 0x3e, 0xa8, 0x55, 0x97, 0x6a, 0xf5, 0x66, 0x67, 0x7f,
	0x7b, 0xbb, 0x24, 0xa0, 0x0a, 0x5c, 0xf3, 0x3b, 0xb6, 0x1b, 0xcf, 0xea, 0x5b, 0x4f, 0xaa, 0xbb,
	0x07, 0x75, 0xd2, 0x97, 0x5a, 0x7b, 0x39, 0xf0, 0x1e, 0x19, 0x77, 0xd7, 0x00, 0x85, 0x00, 0x1e,
	0xf5, 0x32, 0x5c, 0x09, 0xc3, 0xab, 0xb5, 0x4e, 0xe3, 0x49, 0xbd, 0x24, 0xa0, 0x1b, 0x70, 0x35,
	0xdc, 0xd3, 0xaa, 0x37, 0xb7, 0x1a, 0xcd, 0x9d, 0x52, 0x8a, 0xcc, 0x1c, 0xee, 0x6a, 0x34, 0x39,
	0x5a, 0x7a, 0xed, 0x05, 0x5c, 0x8e, 0x78, 0x02, 0x21, 0x04, 0xcb, 0x2d, 0xa9, 0xbe, 0xdd, 0x78,
	0x26, 0x1f, 0x34, 0x1f, 0x37, 0xf7, 0x9f, 0x36, 0xf9, 0x6a, 0x78, 0xb0, 0x76, 0xbd, 0xc3, 0x34,
	0xc4, 0x21, 0x9c, 0x5e, 0x8a, 0x2a, 0x9e, 0x81, 0xa4, 0xfa, 0xa7, 0xf5, 0x1a, 0xd1, 0x64, 0x3a,
	0x40, 0xcd, 0x63, 0x2a, 0xb3, 0x76, 0x38, 0xf0, 0x28, 0x78, 0x55, 0x58, 0x40, 0x66, 0x06, 0x91,
	0xab, 0xba, 0x5e, 0x7a, 0x25, 0xc8, 0x3e, 0x87, 0x73, 0xdf, 0xb0, 0x24, 0xa0, 0x5b, 0x50, 0x1e,
	0xc6, 0x39, 0x3a, 0xd2, 0x74, 0x4d, 0x71, 0x70, 0x29, 0xb5, 0xf6, 0x53, 0x01, 0x2e, 0x47, 0xd8,
	0x3e, 0x82, 0x15, 0x01, 0xf6, 0x74, 0x3c, 0xa6, 0xf7, 0x69, 0xbd, 0xfe, 0xb8, 0x24, 0xa0, 0xdb,
	0x70, 0x23, 0xaa, 0x77, 0x6f, 0xbf, 0xd9, 0xf9, 0x56, 0x29, 0x35, 0x0e, 0xf9, 0xdb, 0xf5, 0xaa,
	0x54, 0x4a, 0xa3, 0x55, 0xb8, 0x19, 0xd5, 0xbb, 0xdf, 0xac, 0x77, 0x1a, 0x7b, 0xf5, 0x52, 0x66,
	0xe3, 0xbf, 0xde, 0x82, 0x62, 0xa8, 0x04, 0x01, 0xfd, 0xa9, 0x00, 0x97, 0x23, 0x6a, 0x46, 0xd1,
	0xa3, 0x78, 0xd6, 0x68, 0x7c, 0xb5, 0x6e, 0xa5, 0x3a, 0x07, 0x05, 0x6e, 0x24, 0x7f, 0x22, 0x78,
	0xa1, 0xbd, 0x10, 0x6f, 0x0f, 0x63, 0x46, 0xcd, 0xc7, 0xd5, 0xa4, 0x56, 0x1e, 0xcd, 0x4e, 0x80,
	0x73, 0xf6, 0xdb, 0x02, 0x14, 0x82, 0x35, 0x9c, 0xe8, 0xc3, 0xd8, 0x24, 0x87, 0x8b, 0x52, 0x2b,
	0x1f, 0xcd, 0x82, 0xca, 0xf9, 0xf8, 0x0b, 0x01, 0xae, 0x46, 0x56, 0x54, 0xa1, 0xcd, 0xf9, 0x2b,
	0x2c, 0x2b, 0xb5, 0xb9, 0x68, 0x70, 0x16, 0xff, 0x53, 0x18, 0xce, 0xcd, 0x4c, 0x2a, 0x95, 0x42,
	0x4f, 0x63, 0xc6, 0xa1, 0x92, 0xd6, 0x6f, 0x56, 0x9e, 0x5d, 0x3c, 0x61, 0x2e, 0xe1, 0x9f, 0x0b,
	0x70, 0x25, 0xaa, 0xbe, 0x07, 0x55, 0x13, 0x4d, 0x19, 0xb9, 0x04, 0x9b, 0xf3, 0x90, 0xe0, 0xfc,
	0xfd, 0x94, 0x3d, 0x17, 0xc7, 0x88, 0x85, 0x76, 0xe6, 0x55, 0x8c, 0xc7, 0xeb, 0xb7, 0xe6, 0x27,
	0xc4, 0x39, 0xfe, 0x99, 0xe0, 0xd7, 0x5a, 0x45, 0x15, 0x7b, 0xa1, 0x64, 0x33, 0x4d, 0xa8, 0x48,
	0xab, 0x34, 0x2e, 0x80, 0x12, 0x67, 0xfa, 0x1c, 0xb2, 0xde, 0x47, 0x87, 0x28, 0xe6, 0x8b, 0x61,
	0xe8, 0x13, 0xc8, 0xca, 0x7b, 0x49, 0xd1, 0xf8, 0xd4, 0x7f, 0x43, 0x4b, 0x0b, 0xa2, 0x3f, 0xdc,
	0x42, 0xf5, 0xb8, 0xf6, 0x65, 0xe2, 0xa7, 0x63, 0x95, 0xed, 0x79, 0xc9, 0x04, 0xd6, 0x76, 0x42,
	0x1a, 0x3d, 0xee, 0xda, 0x4e, 0xaf, 0x3b, 0x88, 0xbb, 0xb6, 0x71, 0x72, 0xfa, 0x44, 0xc1, 0xe3,
	0xd2, 0xe5, 0x71, 0x15, 0x3c, 0x25, 0xf3, 0x1f, 0x57, 0xc1, 0x53, 0xb3, 0xf6, 0x54, 0xc1, 0xe3,
	0xb3, 0xe9, 0xb1, 0x15, 0x3c, 0x35, 0xbf, 0x1f, 0x5b, 0xc1, 0x31, 0x52, 0xfb, 0xff, 0x22, 0xf8,
	0xe5, 0x9d, 0x93, 0x52, 0xeb, 0xa8, 0x35, 0x8b, 0x8d, 0x99, 0x28, 0xc4, 0x67, 0x17, 0x48, 0x91,
	0x0b, 0xf3, 0x07, 0x02, 0xcd, 0x15, 0x06, 0xbf, 0x56, 0x43, 0x1f, 0x27, 0x33, 0xe4, 0xe1, 0x8f,
	0x08, 0x2b, 0x9f, 0xcc, 0x88, 0x1d, 0x60, 0xa8, 0x3d, 0x1b, 0x43, 0xed, 0xb9, 0x18, 0x1a, 0xf7,
	0xcd, 0xde, 0xcf, 0x05, 0xb8, 0x3d, 0xb1, 0xc2, 0x13, 0x7d, 0x1a, 0x5b, 0xe2, 0xa9, 0xc5, 0xad,
	0x95, 0xc7, 0x17, 0x42, 0x8b, 0xb3, 0xfe, 0x0b, 0x01, 0xee, 0x4c, 0xab, 0xc3, 0x44, 0x7b, 0xb3,
	0xce, 0x18, 0x59, 0xa3, 0x5a, 0x69, 0x5e, 0x14, 0xb9, 0xf0, 0x06, 0x0d, 0x96, 0x09, 0x26, 0xd8,
	0xa0, 0x11, 0x95, 0x8b, 0x09, 0x36, 0x68, 0x64, 0x6d, 0xe2, 0x8f, 0x05, 0xaf, 0xf8, 0x21, 0x58,
	0x4c, 0xfa, 0x20, 0x89, 0x01, 0x1f, 0x2d, 0xaa, 0xab, 0x3c, 0x9c, 0x19, 0x3f, 0xc8, 0xd6, 0x70,
	0xf9, 0x5b, 0x6c, 0xb6, 0xc6, 0xd4, 0xfa, 0x55, 0x1e, 0xce, 0x8c, 0xcf, 0xd9, 0xfa, 0x3e, 0xc0,
	0xa0, 0x58, 0x03, 0xbd, 0x9f, 0x44, 0xca, 0x40, 0x4d, 0x40, 0xe5, 0x83, 0xe4, 0x88, 0x01, 0x06,
	0xfc, 0x92, 0x8b, 0xd8, 0x0c, 0x0c, 0x57, 0x82, 0xc4, 0x66, 0x60, 0xb4, 0xba, 0xe3, 0x1c, 0xb2,
	0x5e, 0xd9, 0x44, 0x5c, 0x5f, 0x6b, 0xa8, 0x78, 0x23, 0xae, 0xaf, 0x35, 0x52, 0x9d, 0x71, 0x06,
	0x4b, 0xbc, 0xf2, 0x01, 0xbd, 0x13, 0x9b, 0xff, 0xa0, 0xd4, 0xef, 0x26, 0xc4, 0xe2, 0xf3, 0xfe,
	0x91, 0xe0, 0x97, 0x8a, 0x0c, 0xca, 0x28, 0x3e, 0x49, 0x24, 0xc4, 0x70, 0xed, 0x41, 0xe5, 0xc1,
	0xac, 0xe8, 0x9c, 0xa7, 0x1f, 0x09, 0xb0, 0x1c, 0x4e, 0xde, 0xa3, 0xfb, 0xf1, 0x4d, 0xd5, 0x48,
	0x99, 0x40, 0xe5, 0xe3, 0xd9, 0x90, 0x39, 0x37, 0xbf, 0x27, 0xc0, 0x72, 0x38, 0xff, 0x1c, 0x97,
	0x9b, 0xc8, 0x3c, 0x7c, 0x65, 0x46, 0xe4, 0xd0, 0x13, 0x66, 0x5c, 0xde, 0x38, 0xc1, 0x13, 0x66,
	0x4a, 0x0a, 0x3b, 0xc1, 0x13, 0x66, 0x6a, 0x12, 0xfb, 0x27, 0x02, 0xa0, 0xd1, 0xe4, 0x68, 0xdc,
	0x80, 0xcb, 0xd8, 0x64, 0x6c, 0xdc, 0x80, 0xcb, 0x84, 0xbc, 0x2c, 0xb1, 0xc4, 0x23, 0x45, 0x1b,
	0xe8, 0x41, 0xa2, 0xfd, 0x32, 0x92, 0x9f, 0xad, 0x3c, 0x9c, 0x19, 0x3f, 0xf0, 0xf4, 0x8f, 0x4a,
	0xd5, 0xc6, 0x7d, 0xfa, 0x4f, 0x48, 0x1e, 0xc7, 0x7d, 0xfa, 0x4f, 0xca, 0x14, 0xd3, 0xf0, 0x5e,
	0x44, 0x16, 0x14, 0x25, 0x58, 0x90, 0xe8, 0x24, 0x73, 0xa5, 0x3a, 0x07, 0x85, 0xb0, 0x45, 0x0b,
	0xa5, 0x78, 0x12, 0x58, 0xb4, 0xa8, 0xb4, 0x52, 0x02, 0x8b, 0x16, 0x9d, 0x59, 0xe2, 0x27, 0x60,
	0x28, 0xa3, 0x90, 0xe0, 0x04, 0x44, 0x27, 0x44, 0x12, 0x9c, 0x80, 0x71, 0x19, 0xa3, 0xdf, 0x11,
	0xa0, 0x18, 0xca, 0xc6, 0xa0, 0x98, 0x81, 0xc3, 0xa8, 0xe4, 0x50, 0x5c, 0xdb, 0x16, 0x99, 0xfe,
	0xa1, 0x51, 0xc7, 0xc8, 0xcc, 0x4b, 0xdc, 0xa8, 0xe3, 0xa4, 0xdc, 0x51, 0xdc, 0xa8, 0xe3, 0xc4,
	0xd4, 0xcf, 0x66, 0xfe, 0x39, 0xfd, 0xd3, 0x32, 0xf4, 0x8f, 0x64, 0x1d, 0x2e, 0xd2, 0x6c, 0xf7,
	0x37, 0xff, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x2c, 0x22, 0xc0, 0x2f, 0x34, 0x4b, 0x00, 0x00,
}
