# roll

Rollbar client with deep API support.

## Features
* Individually craft rollbar occurances.
* Synchronous with context support. Means fatal errors will get sent.
* Not a complete mess like other rollbar clients.

## Usage
[Documentation](https://godoc.internal.justin.tv/code.justin.tv/video/roll)


```
import (
	"errors"
	"log"

	"code.justin.tv/video/roll"
)

func main() {
	token := "0123456789abcdef"
	environment := "staging"

	client := roll.New(token, environment)
	client.SetHost("video-edge-abc123.sfo01")
	client.SetVersion("1.2.3")

	ctx := context.Background()

	item := client.NewItem()
	item.SetLevel(roll.WARNING)
	item.SetError(errors.New("foobar"))

	err := item.Send(ctx)
	if err != nil {
		log.Fatal(err)
	}
}
```

