# rollrus

[logrus](https://github.com/sirupsen/logrus) hook that sends errors and messages to Rollbar.

## Features
* Populates error details with `logrus.WithError(err)` or `logrus.WithField("error", err)`
* Populates error stack trace(s) with [pkg/errors](https://github.com/pkg/errors)
* Populates request details with `logrus.WithField("request", http.Request)`

## Usage
[Documentation](https://godoc.internal.justin.tv/code.justin.tv/video/rollrus)

```
import (
	"github.com/sirupsen/logrus"
	
	"code.justin.tv/video/roll"
	"code.justin.tv/video/rollrus"
)

func main() {
	token := "0123456789abcdef"
	environment := "staging"

	client := roll.New(token, environment)
	log.AddHook(rollrus.NewHook(client, log.ErrorLevel))

	err := errors.New("alien attack")
	log.WithError(err).Error("oh no")
}
```
