// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.

const React = require("react")
const ReactDOM = require("react-dom")
const Mount = require("./views/Mount.view.js")

// Model //
const GameManagerClient = require("./models/GameManagerClient.js")
let client = new GameManagerClient.GameManagerClient("nkdec")

// View //
const render = ReactDOM.render(<Mount clientModel={client}/>, document.getElementById("mount"))

// Update //
const Yaafloop = require("yaafloop")
const loop = new Yaafloop(function(delta) {
    client.update(delta)
    render.forceUpdate()
})

// Overrides //
document.body.addEventListener("dblclick", function(event) {
    event.stopPropagation()
})