// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.

const POSSIBLE_CHOICES = {
    HEADS: "HEADS",
    TAILS: "TAILS",
};

class GameCoinflipClient {
    constructor(gameManager) {
        this.gameManager = gameManager

        this.choice = null
        this.sentChoice = false
        this.won = false
        this.allPlayersLost = false
    }

    // game.update(delta)
    // @param <Object> "delta" How much time has passed since the last frame.
    // @description Updates the state of the game for this frame of the loop.
    update(delta) {
    }

    makeChoice (choice) {
        if (this.choice == null) {
            this.choice = choice
            this.sentChoice = true
            this.gameManager.sendPlayerInput(choice)
        }
    }

    get standbyForResult() {
        return this.sentChoice
    }

    get standbyForResultSummary() {
        return "You predicted " + this.choice;
    }

    get resultSummary() {
        if (this.allPlayersLost) {
            return "Everyone got it wrong!"
        } else if (this.choice == null) {
            return "You didn't predict in time!"
        } else if (!this.won) {
            return "Sorry!"
        } else {
            return "Nice!"
        }
    }
}

module.exports = {GameCoinflipClient, POSSIBLE_CHOICES}
