// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.

const React = require("react")
const GameCoinflipProps = require("../models/GameCoinflipClient.js")

require("./GameCoinflip.view.less")


class GameCoinflip extends React.Component {
    constructor(props) {
        super(props)
        this.model = props.clientModel
    }

    render() {
        let gameLogic = this.model.gameClient
        let timeLeft = this.model.gameTimer.secondsLeftInState

        
        return (
            <div className={this.className}>
                <div className='title'>Pick one</div>
                <div>
                    <button className="button-heads" onMouseDown={() => {gameLogic.makeChoice(GameCoinflipProps.POSSIBLE_CHOICES.HEADS)}}>
                        HEADS
                    </button>
                    <button className="button-tails" onMouseDown={() => {gameLogic.makeChoice(GameCoinflipProps.POSSIBLE_CHOICES.TAILS)}}>
                        TAILS
                    </button>
                </div>
                <div className='subtext'>{timeLeft + 's left to pick'}</div>
            </div>
        )
    }
}

module.exports = GameCoinflip;