const TIME_PER_GAME = 6000
const TIME_FOR_RESULTS = 6000

const STATE = {
    WAITING: "WAITING",
    PLAYING: "PLAYING",
    RESULTS: "RESULTS",
    COMPLETE: "COMPLETE"
}

class GameTimer {

    constructor(startPlayFunc = null, startResultsFunc = null) {
        this.state = STATE.WAITING
        this.stateStart = 0
        this.startPlayFunc = startPlayFunc;
        this.startResultsFunc = startResultsFunc;

        setInterval(this.update.bind(this), 10);
    }

    startPlayingNow() {
        this.startPlaying(Date.now())
    }

    startPlayingSince(date) {
        this.startPlaying(date)
    }

    startPlaying(startDate) {
        this.stateStart = startDate
        this.state = STATE.PLAYING
        if (this.startPlayFunc != null) {
            this.startPlayFunc()
        }
    }

    startResultsNow() {
        this.startResults(Date.now())
    }

    startResultsSince(date) {
        this.startResults(date)
    }

    startResults(date) {
        this.stateStart = date
        this.state = STATE.RESULTS
        if (this.startResultsFunc != null) {
            this.startResultsFunc()
        }
    }

    get maxTimeInState() {
        return (this.state == STATE.PLAYING? TIME_PER_GAME: TIME_FOR_RESULTS)
    }

    get msLeftInState() {
        return this.maxTimeInState - (Date.now() - this.stateStart)
    }

    get secondsLeftInState() {
        return Math.floor(this.msLeftInState / 1000.0)
    }

    end() {
        this.state = STATE.COMPLETE
    }

    update() {
        if (!this.timerIsActive) {
            return;
        }
        if (this.msLeftInState < 0) {
            switch (this.state) {
                case STATE.PLAYING:
                    this.startResultsNow()
                    break
                case STATE.RESULTS:
                    this.startPlayingNow()
                    break
            }
        }
    }

    get timerIsActive() {
        return this.state != STATE.WAITING && this.state != STATE.COMPLETE
    }

    get getProgressToNextPhase() {
        return (this.maxTimeInState-this.msLeftInState) / this.maxTimeInState;
    }
}

module.exports = {GameTimer, STATE}