// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.

const POSSIBLE_CHOICES = {
        HEADS: "HEADS",
        TAILS: "TAILS",
    }
class GameCoinflipServer {
    constructor() {
        this.correctChoice = null
        this.setCorrectChoice()
        this.winningPlayers = []
        this.playersWhoAlreadyAnswered = []
    }

    setCorrectChoice() {
        /*let randomIndex = Math.floor(Math.random() * this.POSSIBLE_CHOICES.length);
        this.correctChoice = POSSIBLE_CHOICES[randomIndex];*/
        this.correctChoice = Math.random() > 0.5? POSSIBLE_CHOICES.HEADS : POSSIBLE_CHOICES.TAILS
        console.log("Server has correct choice: "+this.correctChoice)
    }

    processPlayerInput (clientID, input) {
        if (!this.playersWhoAlreadyAnswered.includes(clientID)) {
            if (input == this.correctChoice) {
                this.winningPlayers.push(clientID)
            }
            this.playersWhoAlreadyAnswered.push(clientID)
        }
    }
}

module.exports = GameCoinflipServer
