# Phantom

A simple game server framework running on GameLift written in Node.js.

Wiki: https://wiki.agscollab.com/pages/viewpage.action?spaceKey=lmbr&title=Node+Server

NOTE: THIS PROJECT IS A DEMO AND IS INCOMPLETE; please see TODO.md for additional details.


## Developer Setup


### Notes for Amazon Staff

The port numbers chosen in bin/make-gamelift-fleet were selected based on https://sage.amazon.com/posts/57324. Please note that only some of those ports are reachable from CORP.


### Windows

Install Chocolatey package manager, Node.js, Java (for GameLift local), jq (for scripting), shellcheck (for script validation)
````
./bin/windows-setup.ps1
````


## Running the demo

To test on your local system:
````
npm install
npm run start
bin/open-browser
bin/open-browser
````


## Developer tools

- Install/update packages: ````npm install````
- Run the application: ````npm start```` or ````bin/run````
- Run the application using GameLift-Local: ````npm run local```` or ````bin/gamelift-local````
- Run the unit tests: ````npm test````
- Run only the client: ````bin/cli````
- Lint game server code, bin utilities and server templates: ````npm run lint````
- Make "distribution" folder: ````bin/make-dist```` (not necessary, as this is done automatically by ````bin/make-gamelift-fleet````)
- Make a gamelift fleet on AWS for testing: ````bin/make-gamelift-fleet```` (note: charges will occur for AWS usage)
- Gamelift fleet capacity management: ````bin/set-gamelift-fleet-capacity```` and ````bin/wait-gamelift-fleet-capacity````


### Connecting to a server via ssh for debugging

Get fleet id and instance id for use in ssh:
````
export FLEET_ID="$(bin/my-fleets -t | head -1)" && echo "FleetId: $FLEET_ID"
export INSTANCE_ID="$(bin/my-instances -t -f "$FLEET_ID" | head -1)" && echo "InstanceId: $INSTANCE_ID"
bin/ssh-instance
````


## Interacting with GameLift through the command-line

````
aws gamelift create-game-session --endpoint-url http://localhost:8080 --maximum-player-session-count 2 --fleet-id fleet-123 --game-session-id gsess-abc
aws gamelift describe-game-sessions --endpoint-url http://localhost:8080 --game-session-id gsess-abc
aws gamelift create-player-session --endpoint-url http://localhost:8080 --game-session-id gsess-abc --player-id Esteban
aws gamelift describe-player-sessions --endpoint-url http://localhost:8080 --game-session-id gsess-abc
````


## Protocol Buffers

GameSparks Realtime uses protocol buffers as their data interchange format. This allows them to generate serialization/deserialization code for multiple languages from the same definition files.

If all you want to do is use the server then you can safely ignore the rest of these instructions; all required dependencies are included. However if you want to update the files in the `./src/proto` folder read on.


### Setup

While protobuf is available in various package managers (e.g. `brew install protobuf` works on Mac) they don't seem to have the latest version and therefore they don't include the JavaScript code generator.

This means you get to install from source. Yay!

Thankfully this is pretty easy and can be achieved by downloading the latest release and following the provided instructions. Link: https://github.com/protocolbuffers/protobuf/releases


### Compiling

Included in this package is serialization/deserialization code for the latest CoreCommands.proto and Packet.proto copied from: https://code.amazon.com/packages/GamesparksRealtimeServer/trees/mainline/--/src/main/java/com/gamesparks/realtime/proto

If these files change you can follow these steps to update our code:
* Copy the new `.proto` files into the `./src/proto` folder
* Open a terminal in the `./src/proto` folder
* Run the following command: `protoc --js_out=import_style=commonjs,binary:. CoreComponents.proto Packet.proto`

