# TODO

This project provides a framework for building your own game server that runs on AWS GameLift and can scale dynamically based on the number of players who join.

However, this project is only at a DEMO state of completion.


## Work left to do:

### Features

1. There is no player-authentication mechanism built into the application.
1. The application has the basic plumbing to be able to use GameLift for player-session validation, it hasn't been implemented yet.

### Load testing

The value chosen for APPS_PER_INSTANCE in bin/make-gamelift-fleet was set arbitrarily; we have not had time to determine appropriate values.

### Operations

While logging to a file is enabled, there is no provision for log-rotation. If your application logs extensively and runs for a long time the disk will fill up. There are many tools that perform this function well; see "https://superuser.com/a/291397".

### Security

1. The server uses HTTP, not HTTPS. DO NOT SHIP LIKE THIS.
1. You'll need to provision TLS certificates for HTTPS.
1. While there is a rate-limiter included (packages/rate-limiter), it is not used yet.
1. The check for maximum message size (to avoid memory exhaustion attacks) is performed after the message is received and is therefore not very useful; please remove it and instead use the capability in the "ws" library, as mentioned here: https://stackoverflow.com/a/47808914.
1. This server has had limited testing, and virtually no automated testing, and so it is likely that invalid messages may cause the application to panic. We strongly urge the use of a "fuzz-tester" to verify that invalid/malformed/malicious messages do not cause the application to crash.

#### Security: network protocol

The network protocol used by this application was written to be compatible with GameSparks RealTime, which is entirely client-side driven. In particular, clients choose the recipients for their messages. While this makes using the server quite straightforward (no server redeploys are required when changing the application protocol), this is undesirable if the intent is that one server process will run multiple game sessions internally, as hackers can "break out" of their game session.
