// Example server file

/* eslint no-unused-vars: 0 */
const gameManager = require("./game-manager.js")

// Example override configuration
const configuration = {
};

// Called when game server is initialized, is passed server object of current session
function init(session) {
}

// On Packet is called whenever the server receives a packet
// It is supplied with the sent packet
// If a packet is not returned, then the packet will not be sent to target players
function onPacket(packet) {
    return packet;
}

// On Player Connect is called when a player has passed initial validation
// Return true if player should connect
function onPlayerConnect(player) {
    return true;
}

// On Player Disconnect is called when a player has left or been forcibly terminated
// Is only called players that actually connect to the server and not those rejected by validation
// This is called before the player is removed from the player list
function onPlayerDisconnect(player) {
}

exports.ssExports = {
    configuration: configuration,
    init: init,
    onPacket: onPacket,
    onPlayerConnect: onPlayerConnect,
    onPlayerDisconnect: onPlayerDisconnect
};
