/// <reference types="debug" />
/// <reference types="socket.io-client" />
import Socket = SocketIOClient.Socket;
import getDebug = require('debug');
import { IAuxProxyMessageHandler } from './IAuxProxyMessageHandler';
import { GenericOutcome } from '../Common/GenericOutcome';
export declare class Network {
    static readonly debug: getDebug.IDebugger;
    socketToAuxProxy: Socket;
    socketFromAuxProxy: Socket;
    handler: IAuxProxyMessageHandler;
    connected?: any;
    constructor(socketToAuxProxy: Socket, socketFromAuxProxy: Socket, handler: IAuxProxyMessageHandler);
    SetHandlerCallbacks(socket: Socket): void;
    Connect(): GenericOutcome;
    PerformConnect(socket: Socket): Promise<boolean>;
    Disconnect(): GenericOutcome;
}
