const fs = require('fs');
const minimist = require('minimist');

// Add a WebSocket client to the global scope as Node doesn't provide one
global.WebSocket = require('isomorphic-ws');

const GameSparksRT = require('../gamesparks/gamesparks.rt');

// Return the given argument if it exists otherwise return the default value
function getArgOrDefault(args, argName, defaultValue) {
    const argValue = args[argName];
    return argValue ? argValue : defaultValue;
}

const args = minimist(process.argv.slice(2));
const hostname = getArgOrDefault(args, 'hostname', 'localhost');
const port = getArgOrDefault(args, 'port', '3001');
const token = getArgOrDefault(args, 'token', 'test_token');
const input = getArgOrDefault(args, 'input', null);

// If provided an input file send each line as a packet
function sendInput(input) {
    const lines = fs.readFileSync(input).toString().split('\n');
    lines.forEach((line) => {
        if (line) {
            console.log(line);
            const data = GameSparksRT.RTData.get();
            data.setString(1, line);
            session.sendRTData(1, GameSparksRT.deliveryIntent.RELIABLE, data, []);
        }
    });
}

// Stub out a GameSparks object since we don't actually need to sign our tokens
const gamesparks = {
    signRealtimeToken: (host, port, connectToken) => connectToken
};

// Create a listener with our session callbacks
const listener = {
    onPlayerConnect: (peerId) => console.log(`Player with ID '${peerId}' connected`),
    onPlayerDisconnect: (peerId) => console.log(`Player with ID '${peerId}' disconnected`),
    onPacket: (packet) => console.log('Received packet:', packet),
    onReady: (ready) => ready && input && sendInput(input)
};

// Start a GameSparks session
const session = GameSparksRT.getSession(gamesparks, token, hostname, port, listener);
session.start();

// Start the event loop
setInterval(() => session.update(), 10);
