/* eslint no-unused-vars: 0 */
/* eslint no-undef: 0 */
/* eslint no-redeclare: 0 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
        typeof define === 'function' && define.amd ? define(factory) :
            (global.GameSparks = factory());
}(this, (function () { 'use strict';

    var commonjsGlobal = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    function createCommonjsModule(fn, module) {
        return module = { exports: {} }, fn(module, module.exports), module.exports;
    }

    var core = createCommonjsModule(function (module, exports) {
        (function (root, factory) {
            {
                // CommonJS
                module.exports = exports = factory();
            }
        }(commonjsGlobal, function () {

            /**
         * CryptoJS core components.
         */
            var CryptoJS = CryptoJS || (function (Math, undefined) {
            /*
             * Local polyfil of Object.create
             */
                var create = Object.create || (function () {
                    function F() {}
                    return function (obj) {
                        var subtype;

                        F.prototype = obj;

                        subtype = new F();

                        F.prototype = null;

                        return subtype;
                    };
                }());

                /**
             * CryptoJS namespace.
             */
                var C = {};

                /**
             * Library namespace.
             */
                var C_lib = C.lib = {};

                /**
             * Base object for prototypal inheritance.
             */
                var Base = C_lib.Base = (function () {


                    return {
                    /**
                     * Creates a new object that inherits from this object.
                     *
                     * @param {Object} overrides Properties to copy into the new object.
                     *
                     * @return {Object} The new object.
                     *
                     * @static
                     *
                     * @example
                     *
                     *     var MyType = CryptoJS.lib.Base.extend({
                     *         field: 'value',
                     *
                     *         method: function () {
                     *         }
                     *     });
                     */
                        extend: function (overrides) {
                        // Spawn
                            var subtype = create(this);

                            // Augment
                            if (overrides) {
                                subtype.mixIn(overrides);
                            }

                            // Create default initializer
                            if (!subtype.hasOwnProperty('init') || this.init === subtype.init) {
                                subtype.init = function () {
                                    subtype.$super.init.apply(this, arguments);
                                };
                            }

                            // Initializer's prototype is the subtype object
                            subtype.init.prototype = subtype;

                            // Reference supertype
                            subtype.$super = this;

                            return subtype;
                        },

                        /**
                     * Extends this object and runs the init method.
                     * Arguments to create() will be passed to init().
                     *
                     * @return {Object} The new object.
                     *
                     * @static
                     *
                     * @example
                     *
                     *     var instance = MyType.create();
                     */
                        create: function () {
                            var instance = this.extend();
                            instance.init.apply(instance, arguments);

                            return instance;
                        },

                        /**
                     * Initializes a newly created object.
                     * Override this method to add some logic when your objects are created.
                     *
                     * @example
                     *
                     *     var MyType = CryptoJS.lib.Base.extend({
                     *         init: function () {
                     *             // ...
                     *         }
                     *     });
                     */
                        init: function () {
                        },

                        /**
                     * Copies properties into this object.
                     *
                     * @param {Object} properties The properties to mix in.
                     *
                     * @example
                     *
                     *     MyType.mixIn({
                     *         field: 'value'
                     *     });
                     */
                        mixIn: function (properties) {
                            for (var propertyName in properties) {
                                if (properties.hasOwnProperty(propertyName)) {
                                    this[propertyName] = properties[propertyName];
                                }
                            }

                            // IE won't copy toString using the loop above
                            if (properties.hasOwnProperty('toString')) {
                                this.toString = properties.toString;
                            }
                        },

                        /**
                     * Creates a copy of this object.
                     *
                     * @return {Object} The clone.
                     *
                     * @example
                     *
                     *     var clone = instance.clone();
                     */
                        clone: function () {
                            return this.init.prototype.extend(this);
                        }
                    };
                }());

                /**
             * An array of 32-bit words.
             *
             * @property {Array} words The array of 32-bit words.
             * @property {number} sigBytes The number of significant bytes in this word array.
             */
                var WordArray = C_lib.WordArray = Base.extend({
                /**
                 * Initializes a newly created word array.
                 *
                 * @param {Array} words (Optional) An array of 32-bit words.
                 * @param {number} sigBytes (Optional) The number of significant bytes in the words.
                 *
                 * @example
                 *
                 *     var wordArray = CryptoJS.lib.WordArray.create();
                 *     var wordArray = CryptoJS.lib.WordArray.create([0x00010203, 0x04050607]);
                 *     var wordArray = CryptoJS.lib.WordArray.create([0x00010203, 0x04050607], 6);
                 */
                    init: function (words, sigBytes) {
                        words = this.words = words || [];

                        if (sigBytes != undefined) {
                            this.sigBytes = sigBytes;
                        } else {
                            this.sigBytes = words.length * 4;
                        }
                    },

                    /**
                 * Converts this word array to a string.
                 *
                 * @param {Encoder} encoder (Optional) The encoding strategy to use. Default: CryptoJS.enc.Hex
                 *
                 * @return {string} The stringified word array.
                 *
                 * @example
                 *
                 *     var string = wordArray + '';
                 *     var string = wordArray.toString();
                 *     var string = wordArray.toString(CryptoJS.enc.Utf8);
                 */
                    toString: function (encoder) {
                        return (encoder || Hex).stringify(this);
                    },

                    /**
                 * Concatenates a word array to this word array.
                 *
                 * @param {WordArray} wordArray The word array to append.
                 *
                 * @return {WordArray} This word array.
                 *
                 * @example
                 *
                 *     wordArray1.concat(wordArray2);
                 */
                    concat: function (wordArray) {
                    // Shortcuts
                        var thisWords = this.words;
                        var thatWords = wordArray.words;
                        var thisSigBytes = this.sigBytes;
                        var thatSigBytes = wordArray.sigBytes;

                        // Clamp excess bits
                        this.clamp();

                        // Concat
                        if (thisSigBytes % 4) {
                        // Copy one byte at a time
                            for (var i = 0; i < thatSigBytes; i++) {
                                var thatByte = (thatWords[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff;
                                thisWords[(thisSigBytes + i) >>> 2] |= thatByte << (24 - ((thisSigBytes + i) % 4) * 8);
                            }
                        } else {
                        // Copy one word at a time
                            for (var i = 0; i < thatSigBytes; i += 4) {
                                thisWords[(thisSigBytes + i) >>> 2] = thatWords[i >>> 2];
                            }
                        }
                        this.sigBytes += thatSigBytes;

                        // Chainable
                        return this;
                    },

                    /**
                 * Removes insignificant bits.
                 *
                 * @example
                 *
                 *     wordArray.clamp();
                 */
                    clamp: function () {
                    // Shortcuts
                        var words = this.words;
                        var sigBytes = this.sigBytes;

                        // Clamp
                        words[sigBytes >>> 2] &= 0xffffffff << (32 - (sigBytes % 4) * 8);
                        words.length = Math.ceil(sigBytes / 4);
                    },

                    /**
                 * Creates a copy of this word array.
                 *
                 * @return {WordArray} The clone.
                 *
                 * @example
                 *
                 *     var clone = wordArray.clone();
                 */
                    clone: function () {
                        var clone = Base.clone.call(this);
                        clone.words = this.words.slice(0);

                        return clone;
                    },

                    /**
                 * Creates a word array filled with random bytes.
                 *
                 * @param {number} nBytes The number of random bytes to generate.
                 *
                 * @return {WordArray} The random word array.
                 *
                 * @static
                 *
                 * @example
                 *
                 *     var wordArray = CryptoJS.lib.WordArray.random(16);
                 */
                    random: function (nBytes) {
                        var words = [];

                        var r = (function (m_w) {
                            var m_w = m_w;
                            var m_z = 0x3ade68b1;
                            var mask = 0xffffffff;

                            return function () {
                                m_z = (0x9069 * (m_z & 0xFFFF) + (m_z >> 0x10)) & mask;
                                m_w = (0x4650 * (m_w & 0xFFFF) + (m_w >> 0x10)) & mask;
                                var result = ((m_z << 0x10) + m_w) & mask;
                                result /= 0x100000000;
                                result += 0.5;
                                return result * (Math.random() > .5 ? 1 : -1);
                            };
                        });

                        for (var i = 0, rcache; i < nBytes; i += 4) {
                            var _r = r((rcache || Math.random()) * 0x100000000);

                            rcache = _r() * 0x3ade67b7;
                            words.push((_r() * 0x100000000) | 0);
                        }

                        return new WordArray.init(words, nBytes);
                    }
                });

                /**
             * Encoder namespace.
             */
                var C_enc = C.enc = {};

                /**
             * Hex encoding strategy.
             */
                var Hex = C_enc.Hex = {
                /**
                 * Converts a word array to a hex string.
                 *
                 * @param {WordArray} wordArray The word array.
                 *
                 * @return {string} The hex string.
                 *
                 * @static
                 *
                 * @example
                 *
                 *     var hexString = CryptoJS.enc.Hex.stringify(wordArray);
                 */
                    stringify: function (wordArray) {
                    // Shortcuts
                        var words = wordArray.words;
                        var sigBytes = wordArray.sigBytes;

                        // Convert
                        var hexChars = [];
                        for (var i = 0; i < sigBytes; i++) {
                            var bite = (words[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff;
                            hexChars.push((bite >>> 4).toString(16));
                            hexChars.push((bite & 0x0f).toString(16));
                        }

                        return hexChars.join('');
                    },

                    /**
                 * Converts a hex string to a word array.
                 *
                 * @param {string} hexStr The hex string.
                 *
                 * @return {WordArray} The word array.
                 *
                 * @static
                 *
                 * @example
                 *
                 *     var wordArray = CryptoJS.enc.Hex.parse(hexString);
                 */
                    parse: function (hexStr) {
                    // Shortcut
                        var hexStrLength = hexStr.length;

                        // Convert
                        var words = [];
                        for (var i = 0; i < hexStrLength; i += 2) {
                            words[i >>> 3] |= parseInt(hexStr.substr(i, 2), 16) << (24 - (i % 8) * 4);
                        }

                        return new WordArray.init(words, hexStrLength / 2);
                    }
                };

                /**
             * Latin1 encoding strategy.
             */
                var Latin1 = C_enc.Latin1 = {
                /**
                 * Converts a word array to a Latin1 string.
                 *
                 * @param {WordArray} wordArray The word array.
                 *
                 * @return {string} The Latin1 string.
                 *
                 * @static
                 *
                 * @example
                 *
                 *     var latin1String = CryptoJS.enc.Latin1.stringify(wordArray);
                 */
                    stringify: function (wordArray) {
                    // Shortcuts
                        var words = wordArray.words;
                        var sigBytes = wordArray.sigBytes;

                        // Convert
                        var latin1Chars = [];
                        for (var i = 0; i < sigBytes; i++) {
                            var bite = (words[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff;
                            latin1Chars.push(String.fromCharCode(bite));
                        }

                        return latin1Chars.join('');
                    },

                    /**
                 * Converts a Latin1 string to a word array.
                 *
                 * @param {string} latin1Str The Latin1 string.
                 *
                 * @return {WordArray} The word array.
                 *
                 * @static
                 *
                 * @example
                 *
                 *     var wordArray = CryptoJS.enc.Latin1.parse(latin1String);
                 */
                    parse: function (latin1Str) {
                    // Shortcut
                        var latin1StrLength = latin1Str.length;

                        // Convert
                        var words = [];
                        for (var i = 0; i < latin1StrLength; i++) {
                            words[i >>> 2] |= (latin1Str.charCodeAt(i) & 0xff) << (24 - (i % 4) * 8);
                        }

                        return new WordArray.init(words, latin1StrLength);
                    }
                };

                /**
             * UTF-8 encoding strategy.
             */
                var Utf8 = C_enc.Utf8 = {
                /**
                 * Converts a word array to a UTF-8 string.
                 *
                 * @param {WordArray} wordArray The word array.
                 *
                 * @return {string} The UTF-8 string.
                 *
                 * @static
                 *
                 * @example
                 *
                 *     var utf8String = CryptoJS.enc.Utf8.stringify(wordArray);
                 */
                    stringify: function (wordArray) {
                        try {
                            return decodeURIComponent(escape(Latin1.stringify(wordArray)));
                        } catch (e) {
                            throw new Error('Malformed UTF-8 data');
                        }
                    },

                    /**
                 * Converts a UTF-8 string to a word array.
                 *
                 * @param {string} utf8Str The UTF-8 string.
                 *
                 * @return {WordArray} The word array.
                 *
                 * @static
                 *
                 * @example
                 *
                 *     var wordArray = CryptoJS.enc.Utf8.parse(utf8String);
                 */
                    parse: function (utf8Str) {
                        return Latin1.parse(unescape(encodeURIComponent(utf8Str)));
                    }
                };

                /**
             * Abstract buffered block algorithm template.
             *
             * The property blockSize must be implemented in a concrete subtype.
             *
             * @property {number} _minBufferSize The number of blocks that should be kept unprocessed in the buffer. Default: 0
             */
                var BufferedBlockAlgorithm = C_lib.BufferedBlockAlgorithm = Base.extend({
                /**
                 * Resets this block algorithm's data buffer to its initial state.
                 *
                 * @example
                 *
                 *     bufferedBlockAlgorithm.reset();
                 */
                    reset: function () {
                    // Initial values
                        this._data = new WordArray.init();
                        this._nDataBytes = 0;
                    },

                    /**
                 * Adds new data to this block algorithm's buffer.
                 *
                 * @param {WordArray|string} data The data to append. Strings are converted to a WordArray using UTF-8.
                 *
                 * @example
                 *
                 *     bufferedBlockAlgorithm._append('data');
                 *     bufferedBlockAlgorithm._append(wordArray);
                 */
                    _append: function (data) {
                    // Convert string to WordArray, else assume WordArray already
                        if (typeof data == 'string') {
                            data = Utf8.parse(data);
                        }

                        // Append
                        this._data.concat(data);
                        this._nDataBytes += data.sigBytes;
                    },

                    /**
                 * Processes available data blocks.
                 *
                 * This method invokes _doProcessBlock(offset), which must be implemented by a concrete subtype.
                 *
                 * @param {boolean} doFlush Whether all blocks and partial blocks should be processed.
                 *
                 * @return {WordArray} The processed data.
                 *
                 * @example
                 *
                 *     var processedData = bufferedBlockAlgorithm._process();
                 *     var processedData = bufferedBlockAlgorithm._process(!!'flush');
                 */
                    _process: function (doFlush) {
                    // Shortcuts
                        var data = this._data;
                        var dataWords = data.words;
                        var dataSigBytes = data.sigBytes;
                        var blockSize = this.blockSize;
                        var blockSizeBytes = blockSize * 4;

                        // Count blocks ready
                        var nBlocksReady = dataSigBytes / blockSizeBytes;
                        if (doFlush) {
                        // Round up to include partial blocks
                            nBlocksReady = Math.ceil(nBlocksReady);
                        } else {
                        // Round down to include only full blocks,
                        // less the number of blocks that must remain in the buffer
                            nBlocksReady = Math.max((nBlocksReady | 0) - this._minBufferSize, 0);
                        }

                        // Count words ready
                        var nWordsReady = nBlocksReady * blockSize;

                        // Count bytes ready
                        var nBytesReady = Math.min(nWordsReady * 4, dataSigBytes);

                        // Process blocks
                        if (nWordsReady) {
                            for (var offset = 0; offset < nWordsReady; offset += blockSize) {
                            // Perform concrete-algorithm logic
                                this._doProcessBlock(dataWords, offset);
                            }

                            // Remove processed words
                            var processedWords = dataWords.splice(0, nWordsReady);
                            data.sigBytes -= nBytesReady;
                        }

                        // Return processed words
                        return new WordArray.init(processedWords, nBytesReady);
                    },

                    /**
                 * Creates a copy of this object.
                 *
                 * @return {Object} The clone.
                 *
                 * @example
                 *
                 *     var clone = bufferedBlockAlgorithm.clone();
                 */
                    clone: function () {
                        var clone = Base.clone.call(this);
                        clone._data = this._data.clone();

                        return clone;
                    },

                    _minBufferSize: 0
                });

                /**
             * Abstract hasher template.
             *
             * @property {number} blockSize The number of 32-bit words this hasher operates on. Default: 16 (512 bits)
             */
                var Hasher = C_lib.Hasher = BufferedBlockAlgorithm.extend({
                /**
                 * Configuration options.
                 */
                    cfg: Base.extend(),

                    /**
                 * Initializes a newly created hasher.
                 *
                 * @param {Object} cfg (Optional) The configuration options to use for this hash computation.
                 *
                 * @example
                 *
                 *     var hasher = CryptoJS.algo.SHA256.create();
                 */
                    init: function (cfg) {
                    // Apply config defaults
                        this.cfg = this.cfg.extend(cfg);

                        // Set initial values
                        this.reset();
                    },

                    /**
                 * Resets this hasher to its initial state.
                 *
                 * @example
                 *
                 *     hasher.reset();
                 */
                    reset: function () {
                    // Reset data buffer
                        BufferedBlockAlgorithm.reset.call(this);

                        // Perform concrete-hasher logic
                        this._doReset();
                    },

                    /**
                 * Updates this hasher with a message.
                 *
                 * @param {WordArray|string} messageUpdate The message to append.
                 *
                 * @return {Hasher} This hasher.
                 *
                 * @example
                 *
                 *     hasher.update('message');
                 *     hasher.update(wordArray);
                 */
                    update: function (messageUpdate) {
                    // Append
                        this._append(messageUpdate);

                        // Update the hash
                        this._process();

                        // Chainable
                        return this;
                    },

                    /**
                 * Finalizes the hash computation.
                 * Note that the finalize operation is effectively a destructive, read-once operation.
                 *
                 * @param {WordArray|string} messageUpdate (Optional) A final message update.
                 *
                 * @return {WordArray} The hash.
                 *
                 * @example
                 *
                 *     var hash = hasher.finalize();
                 *     var hash = hasher.finalize('message');
                 *     var hash = hasher.finalize(wordArray);
                 */
                    finalize: function (messageUpdate) {
                    // Final message update
                        if (messageUpdate) {
                            this._append(messageUpdate);
                        }

                        // Perform concrete-hasher logic
                        var hash = this._doFinalize();

                        return hash;
                    },

                    blockSize: 512/32,

                    /**
                 * Creates a shortcut function to a hasher's object interface.
                 *
                 * @param {Hasher} hasher The hasher to create a helper for.
                 *
                 * @return {Function} The shortcut function.
                 *
                 * @static
                 *
                 * @example
                 *
                 *     var SHA256 = CryptoJS.lib.Hasher._createHelper(CryptoJS.algo.SHA256);
                 */
                    _createHelper: function (hasher) {
                        return function (message, cfg) {
                            return new hasher.init(cfg).finalize(message);
                        };
                    },

                    /**
                 * Creates a shortcut function to the HMAC's object interface.
                 *
                 * @param {Hasher} hasher The hasher to use in this HMAC helper.
                 *
                 * @return {Function} The shortcut function.
                 *
                 * @static
                 *
                 * @example
                 *
                 *     var HmacSHA256 = CryptoJS.lib.Hasher._createHmacHelper(CryptoJS.algo.SHA256);
                 */
                    _createHmacHelper: function (hasher) {
                        return function (message, key) {
                            return new C_algo.HMAC.init(hasher, key).finalize(message);
                        };
                    }
                });

                /**
             * Algorithm namespace.
             */
                var C_algo = C.algo = {};

                return C;
            }(Math));


            return CryptoJS;

        }));
    });

    var sha256 = createCommonjsModule(function (module, exports) {
        (function (root, factory) {
            {
                // CommonJS
                module.exports = exports = factory(core);
            }
        }(commonjsGlobal, function (CryptoJS) {

            (function (Math) {
            // Shortcuts
                var C = CryptoJS;
                var C_lib = C.lib;
                var WordArray = C_lib.WordArray;
                var Hasher = C_lib.Hasher;
                var C_algo = C.algo;

                // Initialization and round constants tables
                var H = [];
                var K = [];

                // Compute constants
                (function () {
                    function isPrime(n) {
                        var sqrtN = Math.sqrt(n);
                        for (var factor = 2; factor <= sqrtN; factor++) {
                            if (!(n % factor)) {
                                return false;
                            }
                        }

                        return true;
                    }

                    function getFractionalBits(n) {
                        return ((n - (n | 0)) * 0x100000000) | 0;
                    }

                    var n = 2;
                    var nPrime = 0;
                    while (nPrime < 64) {
                        if (isPrime(n)) {
                            if (nPrime < 8) {
                                H[nPrime] = getFractionalBits(Math.pow(n, 1 / 2));
                            }
                            K[nPrime] = getFractionalBits(Math.pow(n, 1 / 3));

                            nPrime++;
                        }

                        n++;
                    }
                }());

                // Reusable object
                var W = [];

                /**
             * SHA-256 hash algorithm.
             */
                var SHA256 = C_algo.SHA256 = Hasher.extend({
                    _doReset: function () {
                        this._hash = new WordArray.init(H.slice(0));
                    },

                    _doProcessBlock: function (M, offset) {
                    // Shortcut
                        var H = this._hash.words;

                        // Working variables
                        var a = H[0];
                        var b = H[1];
                        var c = H[2];
                        var d = H[3];
                        var e = H[4];
                        var f = H[5];
                        var g = H[6];
                        var h = H[7];

                        // Computation
                        for (var i = 0; i < 64; i++) {
                            if (i < 16) {
                                W[i] = M[offset + i] | 0;
                            } else {
                                var gamma0x = W[i - 15];
                                var gamma0  = ((gamma0x << 25) | (gamma0x >>> 7))  ^
                            ((gamma0x << 14) | (gamma0x >>> 18)) ^
                            (gamma0x >>> 3);

                                var gamma1x = W[i - 2];
                                var gamma1  = ((gamma1x << 15) | (gamma1x >>> 17)) ^
                            ((gamma1x << 13) | (gamma1x >>> 19)) ^
                            (gamma1x >>> 10);

                                W[i] = gamma0 + W[i - 7] + gamma1 + W[i - 16];
                            }

                            var ch  = (e & f) ^ (~e & g);
                            var maj = (a & b) ^ (a & c) ^ (b & c);

                            var sigma0 = ((a << 30) | (a >>> 2)) ^ ((a << 19) | (a >>> 13)) ^ ((a << 10) | (a >>> 22));
                            var sigma1 = ((e << 26) | (e >>> 6)) ^ ((e << 21) | (e >>> 11)) ^ ((e << 7)  | (e >>> 25));

                            var t1 = h + sigma1 + ch + K[i] + W[i];
                            var t2 = sigma0 + maj;

                            h = g;
                            g = f;
                            f = e;
                            e = (d + t1) | 0;
                            d = c;
                            c = b;
                            b = a;
                            a = (t1 + t2) | 0;
                        }

                        // Intermediate hash value
                        H[0] = (H[0] + a) | 0;
                        H[1] = (H[1] + b) | 0;
                        H[2] = (H[2] + c) | 0;
                        H[3] = (H[3] + d) | 0;
                        H[4] = (H[4] + e) | 0;
                        H[5] = (H[5] + f) | 0;
                        H[6] = (H[6] + g) | 0;
                        H[7] = (H[7] + h) | 0;
                    },

                    _doFinalize: function () {
                    // Shortcuts
                        var data = this._data;
                        var dataWords = data.words;

                        var nBitsTotal = this._nDataBytes * 8;
                        var nBitsLeft = data.sigBytes * 8;

                        // Add padding
                        dataWords[nBitsLeft >>> 5] |= 0x80 << (24 - nBitsLeft % 32);
                        dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 14] = Math.floor(nBitsTotal / 0x100000000);
                        dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 15] = nBitsTotal;
                        data.sigBytes = dataWords.length * 4;

                        // Hash final blocks
                        this._process();

                        // Return final computed hash
                        return this._hash;
                    },

                    clone: function () {
                        var clone = Hasher.clone.call(this);
                        clone._hash = this._hash.clone();

                        return clone;
                    }
                });

                /**
             * Shortcut function to the hasher's object interface.
             *
             * @param {WordArray|string} message The message to hash.
             *
             * @return {WordArray} The hash.
             *
             * @static
             *
             * @example
             *
             *     var hash = CryptoJS.SHA256('message');
             *     var hash = CryptoJS.SHA256(wordArray);
             */
                C.SHA256 = Hasher._createHelper(SHA256);

                /**
             * Shortcut function to the HMAC's object interface.
             *
             * @param {WordArray|string} message The message to hash.
             * @param {WordArray|string} key The secret key.
             *
             * @return {WordArray} The HMAC.
             *
             * @static
             *
             * @example
             *
             *     var hmac = CryptoJS.HmacSHA256(message, key);
             */
                C.HmacSHA256 = Hasher._createHmacHelper(SHA256);
            }(Math));


            return CryptoJS.SHA256;

        }));
    });

    var hmac = createCommonjsModule(function (module, exports) {
        (function (root, factory) {
            {
                // CommonJS
                module.exports = exports = factory(core);
            }
        }(commonjsGlobal, function (CryptoJS) {

            (function () {
            // Shortcuts
                var C = CryptoJS;
                var C_lib = C.lib;
                var Base = C_lib.Base;
                var C_enc = C.enc;
                var Utf8 = C_enc.Utf8;
                var C_algo = C.algo;

                /**
             * HMAC algorithm.
             */
                var HMAC = C_algo.HMAC = Base.extend({
                /**
                 * Initializes a newly created HMAC.
                 *
                 * @param {Hasher} hasher The hash algorithm to use.
                 * @param {WordArray|string} key The secret key.
                 *
                 * @example
                 *
                 *     var hmacHasher = CryptoJS.algo.HMAC.create(CryptoJS.algo.SHA256, key);
                 */
                    init: function (hasher, key) {
                    // Init hasher
                        hasher = this._hasher = new hasher.init();

                        // Convert string to WordArray, else assume WordArray already
                        if (typeof key == 'string') {
                            key = Utf8.parse(key);
                        }

                        // Shortcuts
                        var hasherBlockSize = hasher.blockSize;
                        var hasherBlockSizeBytes = hasherBlockSize * 4;

                        // Allow arbitrary length keys
                        if (key.sigBytes > hasherBlockSizeBytes) {
                            key = hasher.finalize(key);
                        }

                        // Clamp excess bits
                        key.clamp();

                        // Clone key for inner and outer pads
                        var oKey = this._oKey = key.clone();
                        var iKey = this._iKey = key.clone();

                        // Shortcuts
                        var oKeyWords = oKey.words;
                        var iKeyWords = iKey.words;

                        // XOR keys with pad constants
                        for (var i = 0; i < hasherBlockSize; i++) {
                            oKeyWords[i] ^= 0x5c5c5c5c;
                            iKeyWords[i] ^= 0x36363636;
                        }
                        oKey.sigBytes = iKey.sigBytes = hasherBlockSizeBytes;

                        // Set initial values
                        this.reset();
                    },

                    /**
                 * Resets this HMAC to its initial state.
                 *
                 * @example
                 *
                 *     hmacHasher.reset();
                 */
                    reset: function () {
                    // Shortcut
                        var hasher = this._hasher;

                        // Reset
                        hasher.reset();
                        hasher.update(this._iKey);
                    },

                    /**
                 * Updates this HMAC with a message.
                 *
                 * @param {WordArray|string} messageUpdate The message to append.
                 *
                 * @return {HMAC} This HMAC instance.
                 *
                 * @example
                 *
                 *     hmacHasher.update('message');
                 *     hmacHasher.update(wordArray);
                 */
                    update: function (messageUpdate) {
                        this._hasher.update(messageUpdate);

                        // Chainable
                        return this;
                    },

                    /**
                 * Finalizes the HMAC computation.
                 * Note that the finalize operation is effectively a destructive, read-once operation.
                 *
                 * @param {WordArray|string} messageUpdate (Optional) A final message update.
                 *
                 * @return {WordArray} The HMAC.
                 *
                 * @example
                 *
                 *     var hmac = hmacHasher.finalize();
                 *     var hmac = hmacHasher.finalize('message');
                 *     var hmac = hmacHasher.finalize(wordArray);
                 */
                    finalize: function (messageUpdate) {
                    // Shortcut
                        var hasher = this._hasher;

                        // Compute HMAC
                        var innerHash = hasher.finalize(messageUpdate);
                        hasher.reset();
                        var hmac = hasher.finalize(this._oKey.clone().concat(innerHash));

                        return hmac;
                    }
                });
            }());


        }));
    });

    var hmacSha256 = createCommonjsModule(function (module, exports) {
        (function (root, factory, undef) {
            {
                // CommonJS
                module.exports = exports = factory(core, sha256, hmac);
            }
        }(commonjsGlobal, function (CryptoJS) {

            return CryptoJS.HmacSHA256;

        }));
    });

    var classCallCheck = function (instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    };

    var createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function getSignatureKey(key, dateStamp, regionName) {
        var kDate = hmacSha256(dateStamp, 'AWS4' + key, { asBytes: true });
        var kRegion = hmacSha256(regionName, kDate, { asBytes: true });
        var kService = hmacSha256('gamesparks', kRegion, { asBytes: true });
        var kSigning = hmacSha256('aws4_request', kService, { asBytes: true });
        return kSigning;
    }

    function getDateTimeString(date) {
        return date.getUTCFullYear() + '' + padDigits(date.getUTCMonth() + 1) + '' + padDigits(date.getUTCDate()) + 'T' + padDigits(date.getUTCHours()) + '' + padDigits(date.getUTCMinutes()) + '' + padDigits(date.getUTCSeconds()) + 'Z';
    }

    function padDigits(n) {
        return n > 9 ? n : '0' + n;
    }

    function parseUrl(url) {
        var urlParts = url.match(/^(?:(\w+):)?(?:\/\/([^/?]+))?(\/?(?:[^/?#][^?#]*)?)?(?:\?([^#]+))?/);
        return {
            scheme: urlParts[1],
            host: urlParts[2].toLowerCase(),
            path: urlParts[3] || '/',
            queryString: urlParts[4] || ''
        };
    }

    function parseQueryString(queryString) {
        var parameters = {};
        if (queryString.length > 0) {
            var pairs = queryString.split('&');

            for (var i = 0; i < pairs.length; i++) {
                var pair = pairs[i].split('=');
                parameters[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1]);
            }
        }

        return parameters;
    }

    var CredentialsManager = function () {
        function CredentialsManager(accessKeyId, secretAccessKey, region) {
            classCallCheck(this, CredentialsManager);

            this.credential = {
                accessKeyId: accessKeyId,
                secretAccessKey: secretAccessKey,
                sessionToken: null
            };
            this.region = region;
        }

        createClass(CredentialsManager, [{
            key: 'setSessionCredential',
            value: function setSessionCredential(sessionCredential) {
                this.sessionCredential = sessionCredential;
            }

            /**
             * Returns data that can be used for either the query string or realtime
             * token signing.
             */

        }, {
            key: 'getSignatureData',
            value: function getSignatureData(host, path, queryString) {
                var date = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : new Date();


                var credential = this.sessionCredential || this.credential;

                var now = getDateTimeString(date);
                var today = now.substring(0, now.indexOf('T'));

                var canonicalHeaders = 'host:' + host + '\n';

                var canonicalRequest = 'GET\n' + path + '\n' + queryString + '\n' + canonicalHeaders + '\n' + 'host\n' + sha256('', { asBytes: true });

                var hashedCanonicalRequest = sha256(canonicalRequest, { asBytes: true });

                var credentialScope = today + '/' + this.region + '/gamesparks/aws4_request';

                var stringToSign = 'AWS4-HMAC-SHA256\n' + now + '\n' + credentialScope + '\n' + hashedCanonicalRequest;

                var signingKey = getSignatureKey(credential.secretAccessKey, today, this.region);

                var signature = hmacSha256(stringToSign, signingKey, { asBytes: true });

                return {
                    amzDate: now,
                    authorization: 'AWS4-HMAC-SHA256 Credential=' + credential.accessKeyId + '/' + credentialScope + ', SignedHeaders=host, Signature=' + signature,
                    credential: credential,
                    signature: signature
                };
            }
        }, {
            key: 'getSignedUrl',
            value: function getSignedUrl(baseUrl) {
                var _parseUrl = parseUrl(baseUrl),
                    scheme = _parseUrl.scheme,
                    host = _parseUrl.host,
                    path = _parseUrl.path,
                    queryString = _parseUrl.queryString;

                var queryStringParameters = parseQueryString(queryString);

                // Remove any X-Amz query string parts.
                for (var key in queryStringParameters) {
                    if (key.toLowerCase().indexOf('x-amz') === 0) {
                        delete queryStringParameters[key];
                    }
                }

                var credential = this.sessionCredential || this.credential;

                var date = new Date();
                var now = getDateTimeString(date);
                var today = now.substring(0, now.indexOf('T'));

                queryStringParameters['X-Amz-Algorithm'] = 'AWS4-HMAC-SHA256';
                queryStringParameters['X-Amz-Credential'] = credential.accessKeyId + '/' + today + '/' + this.region + '/gamesparks/aws4_request';
                queryStringParameters['X-Amz-Date'] = now;
                queryStringParameters['X-Amz-SignedHeaders'] = 'host';

                if (credential.sessionToken) {
                    queryStringParameters['X-Amz-Security-Token'] = credential.sessionToken;
                }

                // Rebuild query string in alphabetical order.
                var signedQueryParams = Object.keys(queryStringParameters).sort().map(function (key) {
                    return encodeURIComponent(key) + '=' + encodeURIComponent(queryStringParameters[key]);
                }).join('&');

                var signatureData = this.getSignatureData(host, path, signedQueryParams, date);

                var url = scheme + '://' + host + path + '?' + signedQueryParams + '&X-Amz-Signature=' + signatureData.signature;

                return { url: url, credential: credential };
            }
        }, {
            key: 'signRealtimeToken',
            value: function signRealtimeToken(host, port, token) {
                var hostWithPort = host + (port ? ':' + port : '');
                var data = this.getSignatureData(hostWithPort, '/', '');
                return JSON.stringify({
                    'Host': hostWithPort,
                    'X-Amz-Date': data.amzDate,
                    'Authorization': data.authorization,
                    'X-Amz-Security-Token': data.credential.sessionToken,
                    'Match-Token': token
                });
            }
        }]);
        return CredentialsManager;
    }();

    var KEEPALIVE_INTERVAL = 30000;
    var REQUEST_TIMEOUT = 32000;

    var GameSparks = function () {
        function GameSparks() {
            classCallCheck(this, GameSparks);
        }

        createClass(GameSparks, [{
            key: 'init',
            value: function init(options) {
                var connect = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

                this.options = options;

                if (options.credentials) {
                    this.setCredentials(options.credentials);
                }

                this.pendingRequests = {};
                this.requestCounter = 0;

                this.endpoint = 'wss://' + this.options.apiKey + '.service.gamesparks.' + this.options.region + '.amazonaws.com';

                if (connect) {
                    this.connect();
                }
            }
        }, {
            key: 'setCredentials',
            value: function setCredentials(credentials) {
                this.signer = new CredentialsManager(credentials.accessKeyId, credentials.secretAccessKey, this.options.region);
            }
        }, {
            key: 'getEndpoint',
            value: function getEndpoint() {
                return this.endpoint;
            }
        }, {
            key: 'getConnectionType',
            value: function getConnectionType() {
                return 'device';
            }
        }, {
            key: 'getPath',
            value: function getPath() {
                return '/ws/game/' + this.options.apiKey + '/stage/' + this.options.stage + '/type/' + this.getConnectionType();
            }
        }, {
            key: 'getUrl',
            value: function getUrl() {
                return this.getEndpoint() + this.getPath();
            }
        }, {
            key: 'getSignedUrl',
            value: function getSignedUrl() {
                var signerCreds = this.signer.getSignedUrl(this.getUrl());
                return signerCreds.url;
            }
        }, {
            key: 'reset',
            value: function reset() {
                this.initialised = false;
                this.connected = false;
                this.error = false;
                this.disconnected = false;

                if (this.webSocket != null) {
                    this.webSocket.onclose = null;
                    this.webSocket.close();
                }
            }
        }, {
            key: 'connect',
            value: function connect() {
                this.reset();

                try {
                    this.webSocket = new WebSocket(this.getSignedUrl());
                    this.webSocket.onopen = this.onWebSocketOpen.bind(this);
                    this.webSocket.onclose = this.onWebSocketClose.bind(this);
                    this.webSocket.onerror = this.onWebSocketError.bind(this);
                    this.webSocket.onmessage = this.onWebSocketMessage.bind(this);
                } catch (e) {
                    this.log(e.message);
                }
            }
        }, {
            key: 'disconnect',
            value: function disconnect() {
                if (this.webSocket && this.connected) {
                    this.disconnected = true;
                    this.webSocket.close();
                }
            }
        }, {
            key: 'onWebSocketOpen',
            value: function onWebSocketOpen(ev) {
                this.log('WebSocket onOpen');

                if (this.options.onOpen) {
                    this.options.onOpen(ev);
                }

                this.connected = true;
            }
        }, {
            key: 'onWebSocketClose',
            value: function onWebSocketClose(ev) {
                this.log('WebSocket onClose');

                if (this.options.onClose) {
                    this.options.onClose(ev);
                }

                this.connected = false;
                if (this.keepAliveInterval) {
                    clearInterval(this.keepAliveInterval);
                }

                // Attemp a re-connection if not in error state or deliberately disconnected.
                if (!this.error && !this.disconnected) {
                    this.connect();
                }
            }
        }, {
            key: 'onWebSocketError',
            value: function onWebSocketError(ev) {

                this.log('WebSocket onError: Sorry, but there is some problem with your socket or the server is down');

                if (this.options.onError) {
                    this.options.onError(ev);
                }

                this.error = true;
            }
        }, {
            key: 'onWebSocketMessage',
            value: function onWebSocketMessage(message) {
                this.log('WebSocket onMessage: ' + message.data);

                var result = void 0;
                try {
                    result = JSON.parse(message.data);
                } catch (error) {
                    var errorMessage = 'An error ocurred while parsing the JSON data: ' + message.data + '; Error: ' + error;
                    this.log(errorMessage);

                    // We need to extract the requestId if there is one or any callback won't be fired.
                    var matches = message.data.match(/"requestId"\s*:\s*"(\w*)"/);
                    var requestId = matches ? matches[1] : null;
                    result = {
                        '@class': '.GameSparksErrorResponse',
                        requestId: requestId,
                        error: {
                            message: errorMessage
                        }
                    };
                }

                // Extract AWS credentials.
                if (result.credentials) {
                    this.signer.setSessionCredential(result.credentials);
                    delete result.credentials;
                }

                if (this.options.onMessage) {
                    this.options.onMessage(result);
                }

                if (result['connectUrl']) {
                    // Any time a connectUrl is in the response we should switch to it and reconnect.
                    this.endpoint = result['connectUrl'];
                    this.connect();
                }

                var resultType = result['@class'];

                if (resultType === '.ConnectResponse') {
                    this.handshake(result);
                } else if (resultType.match(/Response$/)) {
                    if (result.requestId) {
                        var _requestId = result.requestId;
                        delete result.requestId;

                        if (this.pendingRequests[_requestId]) {
                            this.pendingRequests[_requestId](result);
                            this.pendingRequests[_requestId] = null;
                        }
                    }
                }
            }
        }, {
            key: 'handshake',
            value: function handshake(result) {
                if (result.sessionId) {
                    // Connection has been established and we have a session.
                    this.sessionId = result.sessionId;
                    this.initialised = true;

                    if (this.options.onInit) {
                        this.options.onInit();
                    }

                    this.keepAliveInterval = setInterval(this.keepAlive.bind(this), KEEPALIVE_INTERVAL);
                } else {
                    // Need to issue a ConnectRequest
                    this.webSocketSend({ '@class': '.ConnectRequest' });
                }
            }
        }, {
            key: 'keepAlive',
            value: function keepAlive() {
                if (this.initialised && this.connected) {
                    this.webSocket.send(' ');
                }
            }
        }, {
            key: 'send',
            value: function send(requestType, onResponse) {
                this.sendWithData(requestType, {}, onResponse);
            }
        }, {
            key: 'sendWithData',
            value: function sendWithData(requestType, json, onResponse) {
                if (!this.initialised) {
                    onResponse({ error: 'NOT_INITIALISED' });
                    return;
                }

                // Ensure requestType starts with a dot.
                if (requestType.indexOf('.') !== 0) {
                    requestType = '.' + requestType;
                }

                json['@class'] = requestType;

                json.requestId = new Date().getTime() + '_' + ++this.requestCounter;

                if (onResponse != null) {
                    this.pendingRequests[json.requestId] = onResponse;
                    // Time out handler.
                    setTimeout(function () {
                        if (this.pendingRequests[json.requestId]) {
                            this.pendingRequests[json.requestId]({ error: 'NO_RESPONSE' });
                        }
                    }.bind(this), REQUEST_TIMEOUT);
                }

                this.webSocketSend(json);
            }
        }, {
            key: 'webSocketSend',
            value: function webSocketSend(data) {

                if (this.options.onSend) {
                    this.options.onSend(data);
                }

                var requestString = JSON.stringify(data);
                this.log('WebSocket send: ' + requestString);
                this.webSocket.send(requestString);
            }
        }, {
            key: 'getSessionId',
            value: function getSessionId() {
                return this.sessionId;
            }
        }, {
            key: 'isConnected',
            value: function isConnected() {
                return this.connected;
            }
        }, {
            key: 'signRealtimeToken',
            value: function signRealtimeToken(host, port, token) {
                return this.signer.signRealtimeToken(host, port, token);
            }
        }, {
            key: 'log',
            value: function log(message) {
                if (this.options.logger) {
                    this.options.logger(message);
                }
            }
        }]);
        return GameSparks;
    }();

    return GameSparks;

})));
