const RTPlayer = require('../model/rt-player.js').RTPlayer;

const maxPeerId = 0xFFFFFFFF; // 2^^32

exports.RTPlayerContainer = class {
    constructor(maxPlayers) {
        this.maxPlayers = maxPlayers;
        this.peerCounter = 0; // 0 is not a valid peer id
        this.RTPlayers = new Map(); // {peerId: RTPlayer}
    }

    getPlayers() {
        return this.RTPlayers;
    }

    getNumberOfPlayers() {
        return this.RTPlayers.size;
    }

    // Creates new RTPlayer and adds it to RTPlayers object, returns peer id of new player
    createPlayer(client, onPlayerConnect) {
        // Create new RTPlayer
        const peerId = this.findNextPeerId();
        const player = new RTPlayer(client, peerId);

        // On Player Connect callback
        if(onPlayerConnect(player)) {
            this.RTPlayers.set(peerId, player);
            return peerId;
        }
        return null;
    }

    // Removes player with specified peer id
    removePlayer(peerId) {
        this.RTPlayers.delete(peerId);
    }

    findNextPeerId() {
        // Guaranteed to find a new peer ID since max number of players will be less then max peer ID
        this.incrementPeerCounter();
        while(this.RTPlayers.has(this.peerCounter)) {
            this.incrementPeerCounter();
        }
        return this.peerCounter;
    }

    incrementPeerCounter() {
        if(this.peerCounter >= maxPeerId) {
            this.peerCounter = 1;
        } else {
            this.peerCounter += 1;
        }
    }
};
