const RTValue = require('./rt-value.js').RTValue;

const gsrt = require('../../gamesparks/gamesparks.rt.js');

exports.RTData = class {
    constructor() {
        this.data = new Array(128); // Same as GameSparks client;
        this.data.fill(new RTValue());
    }

    getRTVector(index) {
        return this.data[index].vec_val;
    }

    getLong(index) {
        return this.data[index].long_val;
    }

    getFloat(index) {
        return this.data[index].float_val;
    }

    getDouble(index) {
        return this.data[index].double_val;
    }

    getString(index) {
        return this.data[index].string_val;
    }

    getData(index) {
        return this.data[index].data_val;
    }

    setRTVector(index, value) {
        this.data[index] = RTValue.newRTVector(value);

        return this;
    }

    setLong(index, value) {
        if (isFinite(value)) {
            this.data[index] = RTValue.newLong(value);
        } else {
            throw new Error('RTData: Not a valid number error');
        }

        return this;
    }

    setFloat(index, value) {
        if (isFinite(value)) {
            this.data[index] = RTValue.newFloat(value);
        } else {
            throw new Error('RTData: Not a valid number error');
        }

        return this;
    }

    setDouble(index, value) {
        if (isFinite(value)) {
            this.data[index] = RTValue.newDouble(value);
        } else {
            throw new Error('RTData: Not a valid number error');
        }

        return this;
    }
    setString(index, value) {
        this.data[index] = RTValue.newString(value);

        return this;
    }

    setData(index, value) {
        this.data[index] = RTValue.newRTData(value);

        return this;
    }

    getMessage(packet) {
        const data = gsrt.RTData.get();
        data.data = this.data;

        const message = gsrt.getMessageFromData(packet.getOpCode(), gsrt.deliveryIntent.RELIABLE, data, packet.getTargetPlayers());
        return message;
    }
};
