exports.RTPacket = class {
    constructor(opCode, senderPeerId, targetPlayers, data) {
        this.setOpCode(opCode);
        this.setSenderPeerId(senderPeerId);
        this.setTargetPlayers(targetPlayers);
        this.setData(data);
    }

    getOpCode() {
        return this.opCode;
    }

    setOpCode(opCode) {
        this.opCode = opCode || 0;
    }

    getSenderPeerId() {
        return this.senderPeerId;
    }

    setSenderPeerId(senderPeerId) {
        this.senderPeerId = senderPeerId || 0;
    }

    getTargetPlayers() {
        return this.targetPlayers;
    }

    setTargetPlayers(targetPlayers) {
        this.targetPlayers = targetPlayers || [];
    }

    addTargetPlayer(targetPlayer) {
        this.targetPlayers.push(targetPlayer);
    }

    getData() {
        return this.data;
    }

    setData(data) {
        this.data = data;
    }

    getAsPacket() {
        if(this.data) {
            const newPacket = new exports.RTPacket(this.opCode, this.senderPeerId, this.targetPlayers, this.data);
            // Reset packet to default state
            this.opCode = 0;
            this.senderPeerId = 0;
            this.targetPlayers = [];
            this.data = null;

            return newPacket.data.getMessage(newPacket);
        }
        return null;
    }

    // Once finished this will replace our dependency on the GameSparks JS client SDK
    static deserialize(buffer) {
        const packet = {};
        let position = 0;

        const limit = buffer.readInt8(position);
        position++;
        console.log(limit);

        while(position < limit) {
            const key = buffer.readInt8(position);
            switch(key) {
            case -1: {
                return packet;
            }
            case 8: {
                packet.opCode = buffer.readInt8(position);
                position++;
                break;
            }
            case 16: {
                packet.sequenceNumber = buffer.readUInt8(position);
                position++;
                break;
            }
            case 24: {
                packet.requestId = buffer.readUInt8(position);
                position++;
                break;
            }
            case 40: {
                packet.sender = buffer.readUInt8(position);
                position++;
                break;
            }
            case 48: {
                packet.reliable = buffer.readUInt8(position);
                position++;
                break;
            }
            case 114: {
                if (packet.data == null) {
                    packet.data = [];
                }

                const data = []; // TODO: hook up to RTData deserializer
                packet.push(data);
                position += data.length;
                break;
            }
            case 122: {
                packet.payload = buffer.slice(position, limit);
                position++;
                break;
            }
            default: {
                // TODO: implement skipping unknown keys
                position++;
            }
            }
        }
        return packet;
    }
};
