const RTData = require('./rt-data.js').RTData;
const RTPacket = require('./rt-packet.js').RTPacket;

exports.RTSession = class {
    constructor(server) {
        this.server = server;
    }

    newData() {
        return new RTData();
    }

    newPacket() {
        return new RTPacket();
    }

    getPlayers() {
        return new Map(this.server.RTPlayerContainer.getPlayers());
    }

    sendPacket(packet) {
        const message = packet.getAsPacket();
        if(message) {
            this.server.onMessage(packet.senderPeerId, message);
            return message;
        } else {
            throw new Error("Could not send packet with no data");
        }
    }
};
