// Example Client script

/* eslint no-undef: 0 */
function writeToScreen(message, color) {
    document.getElementById('iframe').contentDocument.write(`<p style="color: ${color || 'black'};margin: 0">${message}</p>`);
}

// Send text via the GameSparks client (bound to onSubmit)
// eslint-disable-next-line no-unused-vars
function send(event) {
    event.preventDefault();
    if (event.target.input.value) {
        const data = GameSparksRT.RTData.get();
        data.setString(1, event.target.name.value || "Anon");
        data.setString(2, event.target.input.value);
        session.sendRTData(1, GameSparksRT.deliveryIntent.RELIABLE, data, []);
        writeToScreen(`Sent: ${event.target.input.value}`);
    }
    event.target.input.value = '';
}

// eslint-disable-next-line no-unused-vars
function sendWhisper(event) {
    event.preventDefault();
    const message = event.target.whisperInput.value;
    const name = event.target.whisperName.value || "Anon";
    const target = parseInt(event.target.whisperTarget.value);
    const targetArray = target ? [target] : [];
    if (message && target) {
        const data = GameSparksRT.RTData.get();
        data.setString(1, name);
        data.setString(2, message);
        session.sendRTData(1, GameSparksRT.deliveryIntent.RELIABLE, data, targetArray);
        writeToScreen(`Whisper to ${target}: ${message}`);
        event.target.whisperInput.value = '';
    }
}

const hostname = 'localhost';
const port = '3001';

// Stub out a GameSparks object since we don't actually need to sign our tokens
const gamesparks = {
    signRealtimeToken: (host, port, connectToken) => connectToken
};

// Create a listener with our session callbacks
// Note: the specified functions refer to the gamesparks functions, not the server functions.
const listener = {
    onPlayerConnect: (peerId) => writeToScreen(`Player with ID '${peerId}' connected`, "blue"),
    onPlayerDisconnect: (peerId) => writeToScreen(`Player with ID '${peerId}' disconnected`, "red"),
    onReady: (ready) => writeToScreen(`Received ready state: '${ready}'`),
    onPacket: (packet) => {
        console.log(packet);
        switch(packet.opCode) {
        case 2: {
            writeToScreen(packet.data.getString(1), "blue");
            break;
        }
        default: {
            writeToScreen(packet.data.getString(1) + ": " + packet.data.getString(2));
        }
        }

    }
};

// Start a GameSparks session
const session = GameSparksRT.getSession(gamesparks, 'test_token', hostname, port, listener);
session.start();

// Start the event loop
setInterval(() => session.update(), 10);
