const fs = require('fs');
const http = require('http');

exports.Server = class {
    // Setup the HTTP server
    constructor() {
        this.httpServer = http.createServer((req, res) => {
            switch(req.url) {
            case '/':
                res.writeHead(200, { 'Content-Type': 'text/html' });
                res.end(fs.readFileSync('./src/tester/index.html'));
                break;
            case '/client.js':
                res.writeHead(200, { 'Content-Type': 'text/plain' });
                res.end(fs.readFileSync('./src/tester/client.js'));
                break;
            case '/gamesparks.js':
                res.writeHead(200, { 'Content-Type': 'text/plain' });
                res.end(fs.readFileSync('./src/gamesparks/gamesparks.js'));
                break;
            case '/gamesparks.rt.js':
                res.writeHead(200, { 'Content-Type': 'text/plain' });
                res.end(fs.readFileSync('./src/gamesparks/gamesparks.rt.js'));
                break;
            default:
                res.writeHead(404, { 'Content-Type': 'text/plain' });
                res.end('404 Not Found');
            }
        });
    }

    // Start the HTTP server
    start(port) {
        return new Promise((resolve, reject) => {
            this.httpServer.listen(port, () => resolve(port))
                .on('error', err => reject(err));
        });
    }
};
