#!/bin/bash
set -euo pipefail
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

function log ()
{
    echo "$@" | tee -a "$LOG_DIR/install.log"
}

function failed ()
{
    log "Installation failed!"
    exit 1
}

# Log errors on failure
LOG_DIR="$SCRIPT_DIR/logs"
mkdir -p "$LOG_DIR"
chown :gl-user "$LOG_DIR"
chmod g+w "$LOG_DIR"
trap "failed" INT TERM ERR

# Unpack node
log "Unpacking node application ..."
mkdir -p "$SCRIPT_DIR/node"
tar -xf "$SCRIPT_DIR/node.tar.gz" --strip-components=1 -C "$SCRIPT_DIR/node"

# Unpack application
mkdir -p "$SCRIPT_DIR/app"
log "Unpacking node packages ..."
tar -xf "$SCRIPT_DIR/node_modules.tar.gz" -C "$SCRIPT_DIR/app/"
log "Unpacking game server ..."
tar -xf "$SCRIPT_DIR/application.tar" -C "$SCRIPT_DIR/app/"

# Success!
log "Installation complete."
