#!/bin/bash
set -euo pipefail
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

case "$OSTYPE" in
    linux*)
        # Use the linux version of node that is installed side-by-side with the application
        NODE="$SCRIPT_DIR/node/bin/node"
    ;;

    *)
        # This is only for testing on non-Linux computers with GameLift-Local. It is assumed that:
        # - Node is already installed and can be found in $PATH => In Powershell: "..\bin\windows-setup.ps1"
        # - GameLift local is running => In Bash: "RUN_JAVA_ONLY=true ../bin/gamelift-local"
        NODE=node
    ;;
esac

# Set working directory to the root directory of the application
cd "$SCRIPT_DIR/app"
LOGNAME="$SCRIPT_DIR/logs/server-$(date '+%Y-%m-%d')_$$"
exec "$NODE" -- "./src/gamelift.js" "$@" > "$LOGNAME.log" 2> "$LOGNAME.err"
