const expect = require("chai").expect;
const Server = require('../src/server/index.js').Server;
const RTSession = require('../src/server/model/rt-session.js').RTSession;
const RTPacket = require('../src/server/model/rt-packet.js').RTPacket;
const RTData = require('../src/server/model/rt-data.js').RTData;

// eslint-disable-next-line no-undef
describe("onMessage", function() {
    // eslint-disable-next-line no-undef
    it("calls send with correct client and message", function() {
        // Initialize server
        var messageSent = {client: null, message: null};
        const sendMessage = (client, message) => {
            messageSent.client = client;
            messageSent.message = message;
        };
        const fakeServer = new Server({}, {}, {sendMessageToClient: sendMessage});
        const session = new RTSession(fakeServer);

        // Add two players so one will get the message
        const client0 = {name: "Player 0"};
        const client1 = {name: "Player 1"};
        fakeServer.addRTPlayer(client0);
        fakeServer.addRTPlayer(client1);

        // Sends a message from player 0 to player 1
        const packet = new RTPacket();
        packet.setOpCode(1);
        const data = new RTData();
        data.setString(1, "Test");
        packet.setData(data);
        const message = session.sendPacket(packet);

        expect(messageSent.client).to.be.equal(client1);
        expect(messageSent.message).to.be.deep.equal(message);
    });
});
