Nitro Overview
=============
[![BuildStatus](hhttps://jenkins-og.xarth.tv//buildStatus/icon?job=samus/nitro/master)](https://jenkins-og.xarth.tv//job/samus/job/nitro/job/master/)
[![Go Report Card](http://goreportcard.internal.justin.tv/badge/code.justin.tv/samus/nitro)](http://goreportcard.internal.justin.tv/report/code.justin.tv/samus/nitro)

This service manages Twitch Prime status and Turbo status on Twitch.tv.

Changes to the root, rpc, and vendor dirs need to be updated in the Amazon [SamusNitro package](https://code.amazon.com/packages/SamusNitro/trees/mainline)

API
=============
[API Documentation](/internal/api/api.md)

| Environment   | Endpoint                                   |
| ------------- |--------------------------------------------|
| Development   | http://localhost:8000     |
| Staging       | http://staging-nitro.us-west-2.elasticbeanstalk.com     |
| Production    | http://prod-nitro.us-west-2.elasticbeanstalk.com    |

## Components
* `internal/app/premium` directory contains business logic
* `internal/clients` contains downstream service clients
* `internal/api` contains API entry points

## Setting Up the Go Service

### Setting up your Github account

 - Go to your account settings page (https://git.xarth.tv/settings/keys) and follow the instructions there to add a new SSH key to your account.

### Setting up your workspace

 - Install go:

		brew install go

 - Create a Go workspace folder in your home directory. Ex:

		mkdir /Users/$(whoami)/GoWorkspace

 - Set your environment variable for GOPATH (in your .bashrc, .zshrc, or etc.):

		export GOPATH=/Users/$(whoami)/GoWorkspace

 - Append GOPATH/bin to PATH environment variable:

		export PATH=$PATH:$GOPATH/bin

 - To check if Go installed correctly, run `go version` from the command line. This version should greater than 1.9.

 - Clone down nitro source within the new gopath. You'll need to be on the twitch VPN for this to work.

		go get code.justin.tv/samus/nitro

 - Directory structure will now look like this:

		/Users/$(whoami)/GoWorkspace/src/code.justin.tv/samus/nitro

### Retool
This project uses [Retool](https://github.com/twitchtv/retool) to ensure collaborators use the same versions of development tools.

Note that running `make setup` will install Retool for you.

 - Install Retool:

 ```
 go get -u github.com/twitchtv/retool
 ```

  - Use Retool to ensure your installed tools match those specified in `tools.json`:

```
retool sync
```

 - Execute a command with a versioned tool:

 ```
retool do dep ensure
 ```

 - If running retool doesn't work for a specific dependency, try :

 ```
retool upgrade <dependency path> master

i.e.
retool upgrade golang.org/x/tools/cmd/goimports master
 ```

### Set up dependencies

 - Install dep - THIS DOESN'T USE GLIDE BUT THERE IS STILL THE FILE FROM PACKAGE CREATION AND GLIDE.LOCK IS USED.

		brew install dep

 - Navigate to your workspace:

		cd /Users/$(whoami)/GoWorkspace/src/code.justin.tv/samus/nitro

 - Clone down all the dependencies into your GoWorkspace directory by running (You will need to be on the Twitch VPN for this step to work properly) :

		make dep

#### Adding Dependencies
Run `dep ensure -add` to update your configuration with new dependencies

```
$ dep ensure -add github.com/foo/bar github.com/foo/baz
```

`dep` will update `Gopkg.toml`, `Gopkg.lock`, and your `vendor/` files to the latest version unless a version constraint is specified, IE:

```
$ dep ensure -add github.com/foo/bar@1.0.0
```

**Note**: If you do not use `-add`, this package will not get saved in the `gopkg.toml` file

**Note**: You can also manually update the `gopkg.toml` file if you need to, then run make dep to pull in those updates

#### Checking Dependencies' Status
You can check if there is a mismatch between the configuration and the state of your project by checking the status.

```
$ dep status
```

#### Removing Dependencies
1. Remove any `import` package statements and usage from the code
2. Remove relevant `[[constraint]]` rules from `Gopkg.toml`
3. Run `dep ensure`

#### Further Reading
- [dep Github](https://github.com/golang/dep)
- [dep FAQ](https://github.com/golang/dep/blob/master/docs/FAQ.md)

### AWS
Running Nitro locally requires an IAM user with access credentials on the appropriate AWS account. [Ensure you have the AWS CLI installed](https://docs.aws.amazon.com/cli/latest/userguide/installing.html), then set up your IAM user and credentials:

1. In [Isengard](https://isengard.amazon.com), access the Admin console for the Nitro account (samus-aws+samus-nitro@amazon.com)
2. Navigate to the IAM Users tab
3. Unlock the account for edits (top right), scroll down, and click "Add or Import IAM User"
4. Fill in the required fields and select "Create a new Odin material set"
4. Once the IAM User is created, make sure the account is still unlocked and attach the "AdministratorAccess" permission policy to your new user
5. Navigate to the Odin material set listing and add your dev desktop to the destination listing
6. Grant your alias Retrieve permissions
7. Log in to your dev desktop and run `odin-get [material-set-name]` to retrieve the access key ID and secret key
8. In your terminal, run `aws configure --profile samus-nitro-dev`. Enter the ID and key you just retrieved when prompted


### Making a code change
 - Create a new local git branch: `git checkout -b <branch name>`.

 - Push that local branch to a new remote branch: `git push -u origin <branch name>`.

 - Open the git website for your repo and click "compare and pull request" at the top of the page for your new branch.

 - Make changes and commit to the branch. Do not use `commit --amend --no-edit`. Push the commits.

 - When you get a +1 to your pull request, do "Squash and merge your changes".
 Note: Make a separate branch/commit for your vendor changes if possible to avoid reviewers having to see massive file changes.

### Building, Compiling, Testing, Running

        make install
        make test

 - The production build is created with:

        make release


Development and Elastic Beanstalk setup
===========
1. In order to use the tools described in this section, you must install them as a one time setup step. Use the following commands to install the tools:
```
		retool sync
```

2. Take a look at the Makefile to see the targets that are available. Examples:
```
		make fmt     // runs formatting on your Go files
		make lint    // checks for mechanical errors and ill-formatted conventions
		make release // similar to brazil-build release, the target to run in preparation for a release candidate
		make dev     // similar to brazil-build server (starts the service but must be on the Twitch VPN)
```

3. Application is created using ElasticBeanstalk and Twitch Create Service.
* [EB Config](.elasticbeanstalk). [Refer here.](http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/eb3-config.html)
* [Twitch Create Service](https://git.xarth.tv/dta/tcs)

4. Run tests and check code coverage using [GoConvey](https://github.com/smartystreets/goconvey):
```
    make test
```

Run the server:
```
    make dev
```

# Mocks

Generate mocks with:

```
$ make mocks
```

Add new mock generations to the `make mocks` recipe. If you want to mock a vendor interface, you need to mimic the existing `mockery` commands.
Non-vendor mocks should be mocked with the `-inpkg` flag.

- [Testify](https://github.com/stretchr/testify) to mock out behavior in tests
- [Mockery](https://github.com/vektra/mockery) to autogenerate mock classes

# Integration tests

Integration tests live in the integration_test directory.
To test, first start a local instance of the server. Then in a separate session, run:

```
$ make dev # start the server
. . .
$ make integration-test # in a separate session
```

# Jenkins pipeline
Our code is deployed using Jenkins pipelines.  The deployment process is modeled in the `Jenkinsfile`.  For every branch that is pushed to our Github, Jenkins will build, deploy the changes to staging and run the integration tests.  For the `master` branch, Jenkins will do all of the above as well as deploying to production.

The pipeline can only run for one branch at a time so that we don't have issues with staging and the integration tests.

There is currently a file called `jenkins.groovy` in addition to the `Jenkinsfile`.  `jenkins.groovy` runs the standalone jobs for deploying our code via clean-deploy.  These are left in case of emergency, but should not be necessary.

### Running Terraform

__WARNING__: Running terraform can be extremely dangerous. It is trivially easy to destroy all the AWS resources in an account, bringing down all the service environments. If you don't know what you're doing, seek help.

1. Go to nitro/terraform/development (or whichever environment you want to change)
2. Run `terraform get` to pull in any terraform modules
3. Run `terraform init` to initialize the working directory
4. Run `terraform plan` to examine what changes are about to be made. Read the output careful to make sure it is correct.
5. Run `terraform apply` to make the changes.

Note: the human-readable endpoints such as `nitro.internal.justin.tv` were manually created in Twitch's DNS tool on the dashboard, not through terraform.

### Debugging

Logs are located on the hosts at: `cd /var/log/eb-docker/containers/eb-current-app` <br>
To determine the hosts, you will need to go to the [EC2 Console](https://us-west-2.console.aws.amazon.com/ec2/v2/home?region=us-west-2#) and grab the `Private IP` Address values for the `prod-samus-nitro` grouping
<br>

Execute the following to SSH into Nitro hosts while on the Amazon VPN (If this does not work for you, VPN to the Twitch network and ensure teleport-bastion is disabled):
```
brew tap --full twitch/security https://twitch-security-packages.s3.amazonaws.com/homebrew.git
brew update
brew install twitch-bastion-util
teleport-bastion enable
```

Add your dev desktop as a destination to the material set for the Odin credential needed below. You can do this by clicking the link present in the Key Pair column and clicking "Add a destination". This is necessary or you will receive errors running odin-get.

SSH to your dev desktop and download the PEM key pair from Odin by using the following command: `odin-get <key_pair> > key_pair.PEM`:

| Environment   | Key Pair                                   |
| ------------- |--------------------------------------------|
| Staging       | [com.amazon.samus.nitro.keys.staging](https://odin.amazon.com/#view/materialSet/com.amazon.samus.nitro.keys.staging) |
| Production    | [com.amazon.samus.nitro.keys.prod](https://odin.amazon.com/#view/materialSet/com.amazon.samus.nitro.keys.prod) |

Then choose the IP address of the host:
```
ssh -i key_pair.PEM ec2-user@<ip_address>
```

**Quick Tip:**
`pssh` works best for grabbing logs from multiple hosts. Save the hosts IP addresses (one per line) in a file.
```
pssh -O StrictHostKeyChecking=no -h ./nitro_prod_ips.txt -l $USER -t 0 -p 6 -i -A 'grep "ERR" /var/log/eb-docker/containers/eb-current-app/*.log'
```

### Sample Requests 

- Use [Postman](https://www.getpostman.com/) as a tool for making API calls 
