package config

import (
	log "github.com/sirupsen/logrus"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/samus/nitro/config"
	"code.justin.tv/samus/nitro/rpc"
)

func GetNitroClient() nitro.Nitro {
	environment := config.GetEnvironment()
	cfg, err := config.LoadConfigForEnvironment(environment)
	if err != nil {
		log.Fatal(err)
	}

	nitroConf := twitchclient.ClientConf{
		Host: cfg.IntegrationTestingURI,
	}
	client := nitro.NewNitroProtobufClient(cfg.IntegrationTestingURI, twitchclient.NewHTTPClient(nitroConf))
	return client
}
