package config

import (
	log "github.com/sirupsen/logrus"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/revenue/subscriptions/twirp"
	"code.justin.tv/samus/nitro/config"
)

func GetSubsClient() substwirp.Subscriptions {
	environment := config.GetEnvironment()
	cfg, err := config.LoadConfigForEnvironment(environment)
	if err != nil {
		log.Fatal(err)
	}

	subsConf := twitchclient.ClientConf{
		Host: cfg.SubscriptionsHost,
	}
	client := substwirp.NewSubscriptionsProtobufClient(cfg.SubscriptionsHost, twitchclient.NewHTTPClient(subsConf))
	return client
}
