package config

import (
	log "github.com/sirupsen/logrus"

	voyagertwirp "code.justin.tv/amzn/TwitchVoyagerTwirp"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/samus/nitro/config"
)

func GetVoyagerClient() voyagertwirp.TwitchVoyager {
	environment := config.GetEnvironment()
	cfg, err := config.LoadConfigForEnvironment(environment)
	if err != nil {
		log.Fatal(err)
	}

	voyagerConf := twitchclient.ClientConf{
		Host: cfg.TwitchVoyagerHost,
	}
	client := voyagertwirp.NewTwitchVoyagerProtobufClient(cfg.TwitchVoyagerHost, twitchclient.NewHTTPClient(voyagerConf))
	return client
}
