package integration_test

import (
	"context"
	"testing"

	"code.justin.tv/samus/nitro/integration_test/config"
	"code.justin.tv/samus/nitro/rpc"
	. "github.com/smartystreets/goconvey/convey"
)

func TestTurboCode(t *testing.T) {
	client := config.GetNitroClient()

	Convey("Testing GetTurboCode API", t, func() {

		SkipConvey("with a Turbo user", func() {
			req := &nitro.GetTurboCodeRequest{
				TwitchUserID: qaSamusTurbo,
			}

			resp, err := client.GetTurboCode(context.TODO(), req)

			So(err, ShouldBeNil)
			So(resp.TurboCode, ShouldNotBeEmpty)
		})

		Convey("with a Twitch Prime user", func() {
			req := &nitro.GetTurboCodeRequest{
				TwitchUserID: diegoManchego,
			}

			resp, err := client.GetTurboCode(context.TODO(), req)

			So(err, ShouldBeNil)
			So(resp.TurboCode, ShouldBeEmpty)
		})

		Convey("with a non-Twitch Prime, non-Turbo user", func() {
			req := &nitro.GetTurboCodeRequest{
				TwitchUserID: qa_no_prime,
			}

			resp, err := client.GetTurboCode(context.TODO(), req)

			So(err, ShouldBeNil)
			So(resp.TurboCode, ShouldBeEmpty)
		})
	})
}
