# Overview
Nitro is a Twirp service that provides a set of methods for managing a user's Twitch Prime and Turbo statuses.

## Premium Statuses
### GetPremiumStatuses
Given a Twitch user id, returns a boolean for whether this user has Twitch Prime and Turbo.

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/GetPremiumStatuses

    {
        "twitchUserID": "123456789"
    }
    
#### Response
    {
        "hasPrime": true | false
        "hasTurbo": true | false
    }

### GrantPremiumStatus
Given a Twitch user id, grants the user the Twitch Prime benefit.

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/GrantPremiumStatus
    
    {
        "twitchUserID": "123456789",
        "productName": "PRIME"
    }
    
#### Response
    {
        "hasPrime": true
    }

### CancelPremiumStatus
Given a Twitch user id, cancels the user's Twitch Prime benefit.

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/CancelPremiumStatus
    
    {
        "twitchUserID": "123456789",
        "productName": "PRIME"
    }

#### Response
    {
        "hasPrime": false
    }
    
### GetTurboCode
Given a Twitch user id, returns the user's Turbo code.

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/GetTurboCode 
    
    {
        "twitchUserID": "123456789"
    }
    
#### Response
    {
        "turboCode": <turbo_code>
    }
    
### Sync
Given a Twitch user id and an end date, backfills existing customer with the new Prime. This will grant the new Prime to the user, add the user to the GrandfatheredUsers table if not there, and update the end of the old Prime subscription product.

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/Sync 
    
    {
        "twitchUserID": "123456789"
        "endOfOldTwitchPrimeDate": "2018-09-14T15:00:00Z"
    }
    
#### Response
    { }

## Grandfathering
### GetGrandfatheredUser

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/GetGrandfatheredUser

    {
        "twitchUserID": "123456789"
    }

#### Response
    {
        "twitchUserID": "123456789",
        "hasOldTwitchPrime": true,
        "hasNewTwitchPrime": true,
        "endOfOldTwitchPrimeDate": "2018-09-14T15:00:00Z"
    }

### CreateGrandfatheredUser

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/CreateGrandfatheredUser

    {
        "twitchUserID": "123456789"
    }

#### Response
    {
        "twitchUserID": "123456789",
        "hasOldTwitchPrime": true,
        "hasNewTwitchPrime": true,
        "endOfOldTwitchPrimeDate": "2018-09-14T15:00:00Z"
    }

### UpdateGrandfatheredUser

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/UpdateGrandfatheredUser
    
`EndOfOldTwitchPrimeDate` must be an RFC 3339 string!
    
    {
        "twitchUserID": "123456789",
        "hasOldTwitchPrime": true,
        "hasNewTwitchPrime": true,
        "endOfOldTwitchPrimeDate": "2018-09-14T15:00:00Z"
    }

#### Response
    { }

### DeleteGrandfatheredUser

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/DeleteGrandfatheredUser
    
    {
        "twitchUserID": "123456789",
    }

#### Response
    { }
    
### IsGrandfathering
Returns whether the Grandfathering Clause is in effect or not.

#### Request
**POST** /twirp/code.justin.tv.samus.nitro.Nitro/IsGrandfathering

#### Response
    {
        "isInEffect": true | false
    }
