package api

import (
	"code.justin.tv/samus/nitro/internal/app/premium"
	nitro "code.justin.tv/samus/nitro/rpc"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
	"golang.org/x/net/context"
)

// CancelPremiumStatusAPI
type CancelPremiumStatusAPI struct {
	IPremiumStatuses premium.PremiumStatuses
}

// CancelPremiumStatus...
func (api *CancelPremiumStatusAPI) CancelPremiumStatus(context context.Context, request *nitro.CancelPremiumStatusRequest) (*nitro.CancelPremiumStatusResponse, error) {
	logger := log.WithFields(log.Fields{
		"userID":      request.TwitchUserID,
		"productName": request.ProductName,
	})
	logger.Info("[CancelPremiumStatuses] Cancelling premium status...")

	statuses, err := api.IPremiumStatuses.CancelPremiumStatus(context, request.TwitchUserID, request.ProductName)
	if err != nil {
		logger.Error("[CancelPremiumStatuses] : ", err)
		return nil, errors.Wrap(err, "Failed to cancel premium status")
	}

	return &nitro.CancelPremiumStatusResponse{
		HasPrime:  statuses.HasPrime,
		HasPresto: statuses.HasPresto,
	}, nil
}
