package api_test

import (
	"testing"

	"context"

	"code.justin.tv/samus/nitro/internal/api"
	"code.justin.tv/samus/nitro/internal/app/premium"
	"code.justin.tv/samus/nitro/rpc"
	"github.com/pkg/errors"
	. "github.com/smartystreets/goconvey/convey"
)

func TestCancelPremiumStatusSuccess(t *testing.T) {
	Convey("Test CancelPremiumStatus Success when user no longer has prime", t, func() {

		mockIPremiumStatuses := new(premium.MockPremiumStatuses)

		cps := api.CancelPremiumStatusAPI{
			IPremiumStatuses: mockIPremiumStatuses,
		}

		userID := "fake-user-id"
		productName := nitro.PremiumProduct_PRIME

		req := &nitro.CancelPremiumStatusRequest{
			TwitchUserID: userID,
			ProductName:  productName,
		}

		Convey("with success", func() {
			mockIPremiumStatuses.On("CancelPremiumStatus", context.TODO(), userID, productName).Return(&premium.Statuses{HasPrime: false}, nil)

			result, err := cps.CancelPremiumStatus(context.TODO(), req)
			So(err, ShouldBeNil)
			So(result.HasPrime, ShouldBeFalse)
		})

		Convey("with failure", func() {
			mockIPremiumStatuses.On("CancelPremiumStatus", context.TODO(), userID, productName).Return(nil, errors.New("Failed to cancel premium status"))

			result, err := cps.CancelPremiumStatus(context.TODO(), req)
			So(err, ShouldNotBeNil)
			So(result, ShouldBeNil)
		})
	})
}
