package api

import (
	"context"

	"code.justin.tv/samus/nitro/rpc"
	log "github.com/sirupsen/logrus"

	"code.justin.tv/samus/nitro/internal/app/grandfathering"

	"github.com/pkg/errors"
)

type CreateGrandfatheredUserAPI struct {
	IGrandfathering grandfathering.IGrandfathering
}

// CreateGrandfatheredUser API
func (api *CreateGrandfatheredUserAPI) CreateGrandfatheredUser(context context.Context, request *nitro.CreateGrandfatheredUserRequest) (*nitro.CreateGrandfatheredUserResponse, error) {
	logger := log.WithFields(log.Fields{
		"userID": request.TwitchUserID,
	})

	twitchUserID := request.TwitchUserID
	user, err := api.IGrandfathering.CreateGrandfatheredUser(twitchUserID)

	if err != nil {
		logger.Error("[CreateGrandfatheredUserAPI] : ", err)
		return nil, errors.Wrap(err, "CreateGrandfatheredUser API failed")
	}

	return &nitro.CreateGrandfatheredUserResponse{
		TwitchUserID:      user.TwitchUserID,
		HasOldTwitchPrime: user.HasOldTwitchPrime,
		HasNewTwitchPrime: user.HasNewTwitchPrime,
	}, nil
}
