package api

import (
	"context"

	"code.justin.tv/samus/nitro/rpc"
	log "github.com/sirupsen/logrus"

	"code.justin.tv/samus/nitro/internal/app/grandfathering"
	"github.com/pkg/errors"
)

type DeleteGrandfatheredUserAPI struct {
	IGrandfathering grandfathering.IGrandfathering
}

// DeleteGrandfatheredUser API
func (api *DeleteGrandfatheredUserAPI) DeleteGrandfatheredUser(context context.Context, request *nitro.DeleteGrandfatheredUserRequest) (*nitro.DeleteGrandfatheredUserResponse, error) {
	logger := log.WithFields(log.Fields{
		"userID": request.TwitchUserID,
	})

	err := api.IGrandfathering.DeleteGrandfatheredUser(request.TwitchUserID)

	if err != nil {
		logger.Error("[DeleteGrandfatheredUserAPI] : ", err)
		return nil, errors.Wrap(err, "DeleteGrandfatheredUser API failed")
	}

	return &nitro.DeleteGrandfatheredUserResponse{}, nil
}
