package api

import (
	"context"

	"code.justin.tv/samus/nitro/rpc"
	log "github.com/sirupsen/logrus"

	"code.justin.tv/samus/nitro/internal/app/grandfathering"

	"time"

	"github.com/pkg/errors"
)

type GetGrandfatheredUserAPI struct {
	IGrandfathering grandfathering.IGrandfathering
}

// GetGrandfatheredUser API
func (api *GetGrandfatheredUserAPI) GetGrandfatheredUser(context context.Context, request *nitro.GetGrandfatheredUserRequest) (*nitro.GetGrandfatheredUserResponse, error) {
	logger := log.WithFields(log.Fields{
		"userID": request.TwitchUserID,
	})

	user, err := api.IGrandfathering.GetGrandfatheredUser(request.TwitchUserID)

	if err != nil {
		logger.Error("[GetGrandfatheredUserAPI] : ", err)
		return nil, errors.Wrap(err, "UpdateGrandfatheredUser API failed")
	}

	if user == nil {
		return &nitro.GetGrandfatheredUserResponse{}, nil
	}

	return &nitro.GetGrandfatheredUserResponse{
		TwitchUserID:            user.TwitchUserID,
		HasOldTwitchPrime:       user.HasOldTwitchPrime,
		HasNewTwitchPrime:       user.HasNewTwitchPrime,
		EndOfOldTwitchPrimeDate: user.EndOfOldTwitchPrimeDate.UTC().Format(time.RFC3339),
	}, nil
}
