package api

import (
	"golang.org/x/net/context"

	"code.justin.tv/samus/nitro/internal/app/premium"
	nitro "code.justin.tv/samus/nitro/rpc"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

// GetPremiumStatusesAPI
type GetPremiumStatusesAPI struct {
	Statuses premium.PremiumStatuses
}

// GetPremiumStatuses API returns whether the user has Prime and Turbo based on TwitchUserID
func (gps *GetPremiumStatusesAPI) GetPremiumStatuses(context context.Context, request *nitro.GetPremiumStatusesRequest) (*nitro.GetPremiumStatusesResponse, error) {
	logger := log.WithFields(log.Fields{
		"userID": request.TwitchUserID,
	})
	responseStatuses, err := gps.Statuses.GetPremiumStatuses(request.TwitchUserID)
	if err != nil {
		logger.Error("[GetPremiumStatuses] : ", err)
		return nil, errors.Wrap(err, "Can't call GetPremiumStatuses")
	}

	return &nitro.GetPremiumStatusesResponse{
		HasTurbo:  responseStatuses.HasTurbo,
		HasPrime:  responseStatuses.HasPrime,
		HasPresto: responseStatuses.HasPresto,
	}, nil
}
