package api

import (
	"testing"

	"code.justin.tv/samus/nitro/_tools/src/github.com/pkg/errors"
	"code.justin.tv/samus/nitro/internal/app/premium"
	"code.justin.tv/samus/nitro/rpc"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestPremiumStatuses(t *testing.T) {
	Convey("TestPremiumStatuses", t, func() {
		mockPremiumStatusesAppLayer := new(premium.MockPremiumStatuses)
		mockGetPremiumStatusesAPI := GetPremiumStatusesAPI{
			Statuses: mockPremiumStatusesAppLayer,
		}

		req := &nitro.GetPremiumStatusesRequest{
			TwitchUserID: "id",
		}

		Convey("Test GetPremiumStatuses", func() {
			Convey("returns hasprime = true if a user has the prime subscription", func() {
				mockPremiumStatusesAppLayer.On("GetPremiumStatuses", mock.Anything).Return(&premium.Statuses{
					HasPrime: true,
					HasTurbo: false,
				}, nil)

				result, err := mockGetPremiumStatusesAPI.GetPremiumStatuses(nil, req)
				So(err, ShouldBeNil)
				So(result.HasPrime, ShouldEqual, true)
				So(result.HasTurbo, ShouldEqual, false)
			})

			Convey("returns hasturbo = true if a user has the turbo subscription", func() {
				mockPremiumStatusesAppLayer.On("GetPremiumStatuses", mock.Anything).Return(&premium.Statuses{
					HasPrime: false,
					HasTurbo: true,
				}, nil)

				result, err := mockGetPremiumStatusesAPI.GetPremiumStatuses(nil, req)
				So(err, ShouldBeNil)
				So(result.HasPrime, ShouldEqual, false)
				So(result.HasTurbo, ShouldEqual, true)
			})

			Convey("returns hasturbo = true and hasprime = true if a user has both the turbo and prime subscriptions", func() {
				mockPremiumStatusesAppLayer.On("GetPremiumStatuses", mock.Anything).Return(&premium.Statuses{
					HasPrime: true,
					HasTurbo: true,
				}, nil)

				result, err := mockGetPremiumStatusesAPI.GetPremiumStatuses(nil, req)
				So(err, ShouldBeNil)
				So(result.HasPrime, ShouldEqual, true)
				So(result.HasTurbo, ShouldEqual, true)
			})

			Convey("returns hasturbo = false and hasprime = false if a user has no subscriptions", func() {
				mockPremiumStatusesAppLayer.On("GetPremiumStatuses", mock.Anything).Return(&premium.Statuses{
					HasPrime: false,
					HasTurbo: false,
				}, nil)

				result, err := mockGetPremiumStatusesAPI.GetPremiumStatuses(nil, req)
				So(err, ShouldBeNil)
				So(result.HasPrime, ShouldEqual, false)
				So(result.HasTurbo, ShouldEqual, false)
			})

			Convey("returns error when subs service has an error", func() {
				mockPremiumStatusesAppLayer.On("GetPremiumStatuses", mock.Anything).Return(nil, errors.New("Error calling subs service"))

				_, err := mockGetPremiumStatusesAPI.GetPremiumStatuses(nil, req)
				So(err, ShouldNotBeNil)
			})
		})
	})
}
