package api

import (
	"golang.org/x/net/context"

	"code.justin.tv/samus/nitro/internal/app/premium"
	nrpc "code.justin.tv/samus/nitro/rpc"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

// GetTurboCode Get Turbo Code API (for /api/user)
type GetTurboCodeAPI struct {
	Statuses premium.PremiumStatuses
}

// GetTurboCode API returns the user's turbo_code (access_guid of their prime or turbo sub) if the user has prime or turbo
func (gtc *GetTurboCodeAPI) GetTurboCode(context context.Context, request *nrpc.GetTurboCodeRequest) (*nrpc.GetTurboCodeResponse, error) {
	logger := log.WithFields(log.Fields{
		"userID": request.TwitchUserID,
	})
	responseCode, err := gtc.Statuses.GetTurboCode(request.TwitchUserID)
	if err != nil {
		logger.Error("[GetTurboCode] : ", err)
		return nil, errors.Wrap(err, "Can't call GetTurboCode")
	}

	return &nrpc.GetTurboCodeResponse{
		TurboCode: responseCode,
	}, nil
}
