package api

import (
	"testing"

	"code.justin.tv/samus/nitro/_tools/src/github.com/pkg/errors"
	"code.justin.tv/samus/nitro/internal/app/premium"
	"code.justin.tv/samus/nitro/rpc"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestTurboCode(t *testing.T) {
	Convey("TestTurboCode", t, func() {
		mockPremiumStatusesAppLayer := new(premium.MockPremiumStatuses)
		mockGetTurboCodeAPI := GetTurboCodeAPI{
			Statuses: mockPremiumStatusesAppLayer,
		}

		req := &nitro.GetTurboCodeRequest{
			TwitchUserID: "id",
		}

		turboCode := "qwertyuiopaccessguid"

		Convey("Test GetTurboCode", func() {
			Convey("returns the turbo code returned by the app layer", func() {
				mockPremiumStatusesAppLayer.On("GetTurboCode", mock.Anything).Return(turboCode, nil)

				result, err := mockGetTurboCodeAPI.GetTurboCode(nil, req)
				So(err, ShouldBeNil)
				So(result.TurboCode, ShouldEqual, turboCode)
			})

			Convey("returns emptyString if no turbo code exists", func() {
				mockPremiumStatusesAppLayer.On("GetTurboCode", mock.Anything).Return("", nil)

				result, err := mockGetTurboCodeAPI.GetTurboCode(nil, req)
				So(err, ShouldBeNil)
				So(result.TurboCode, ShouldEqual, "")
			})

			Convey("returns error when subs service has an error", func() {
				mockPremiumStatusesAppLayer.On("GetTurboCode", mock.Anything).Return("", errors.New("Error calling subs service"))

				_, err := mockGetTurboCodeAPI.GetTurboCode(nil, req)
				So(err, ShouldNotBeNil)
			})
		})
	})
}
