package api

import (
	nitro "code.justin.tv/samus/nitro/rpc"
	log "github.com/sirupsen/logrus"

	"code.justin.tv/samus/nitro/internal/app/premium"
	"github.com/pkg/errors"
	"golang.org/x/net/context"
)

// GrantPremiumStatusAPI
type GrantPremiumStatusAPI struct {
	IPremiumStatuses premium.PremiumStatuses
}

// GrantPremiumStatus
func (api *GrantPremiumStatusAPI) GrantPremiumStatus(context context.Context, request *nitro.GrantPremiumStatusRequest) (*nitro.GrantPremiumStatusResponse, error) {
	logger := log.WithFields(log.Fields{
		"userID":      request.TwitchUserID,
		"productName": request.ProductName,
	})
	logger.Info("[GrantPremiumStatuses] Granting premium status...")

	statuses, err := api.IPremiumStatuses.GrantPremiumStatus(context, request.TwitchUserID, request.ProductName)
	if err != nil {
		logger.Error("[GrantPremiumStatus] : ", err)
		return nil, errors.Wrap(err, "Failed to grant premium status")
	}

	return &nitro.GrantPremiumStatusResponse{
		HasPrime:  statuses.HasPrime,
		HasPresto: statuses.HasPresto,
	}, nil
}
