package api_test

import (
	"testing"

	"context"

	"code.justin.tv/samus/nitro/_tools/src/github.com/pkg/errors"
	"code.justin.tv/samus/nitro/internal/api"
	"code.justin.tv/samus/nitro/internal/app/premium"
	"code.justin.tv/samus/nitro/rpc"
	. "github.com/smartystreets/goconvey/convey"
)

func TestGrantPremiumStatus(t *testing.T) {
	Convey("Testing GrantPremiumStatus", t, func() {

		mockIPremiumStatuses := new(premium.MockPremiumStatuses)

		gps := api.GrantPremiumStatusAPI{
			IPremiumStatuses: mockIPremiumStatuses,
		}

		userID := "fake-user-id"
		productName := nitro.PremiumProduct_PRIME

		req := &nitro.GrantPremiumStatusRequest{
			TwitchUserID: userID,
			ProductName:  productName,
		}

		Convey("with success", func() {
			mockIPremiumStatuses.On("GrantPremiumStatus", context.TODO(), userID, productName).Return(&premium.Statuses{HasPrime: true}, nil)

			result, err := gps.GrantPremiumStatus(context.TODO(), req)
			So(err, ShouldBeNil)
			So(result.HasPrime, ShouldBeTrue)
		})

		Convey("with failure", func() {
			mockIPremiumStatuses.On("GrantPremiumStatus", context.TODO(), userID, productName).Return(nil, errors.New("Failed to grant premium status"))

			result, err := gps.GrantPremiumStatus(context.TODO(), req)
			So(err, ShouldNotBeNil)
			So(result, ShouldBeNil)
		})
	})
}
