package api

import (
	"context"

	"code.justin.tv/samus/nitro/internal/app/grandfathering"
	"code.justin.tv/samus/nitro/rpc"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

// IsAcceptingUsersAPI
type IsGrandfatheringAPI struct {
	IGrandfathering grandfathering.IGrandfathering
}

// IsGrandfathering API
func (api *IsGrandfatheringAPI) IsGrandfathering(context context.Context, request *nitro.IsGrandfatheringRequest) (*nitro.IsGrandfatheringResponse, error) {

	flag, err := api.IGrandfathering.IsGrandfatheringUsers()

	if err != nil {
		log.Error("[IsGrandfatheringAPI] : ", err)
		return nil, errors.Wrap(err, "IsGrandfathering API failed")
	}

	return &nitro.IsGrandfatheringResponse{
		IsGrandfathering: flag.Status,
	}, nil
}
