package api

import (
	"context"
	"time"

	"code.justin.tv/samus/nitro/internal/app/premium"
	"code.justin.tv/samus/nitro/rpc"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

type SyncAPI struct {
	IPremiumStatuses premium.PremiumStatuses
}

func (api *SyncAPI) Sync(context context.Context, request *nitro.SyncRequest) (*nitro.SyncResponse, error) {
	twitchUserId := request.TwitchUserID
	endTimestamp := request.EndOfOldTwitchPrimeDate

	logger := log.WithFields(log.Fields{
		"userID": twitchUserId,
	})

	endTime, err := time.Parse(time.RFC3339Nano, endTimestamp)
	if err != nil {
		logger.Error("[SyncAPI]: ", err)
		return nil, errors.Wrap(err, "SyncAPI failed: could not parse date")
	}

	err = api.IPremiumStatuses.Sync(context, twitchUserId, endTime)

	if err != nil {
		logger.Error("[SyncAPI]: ", err)
		return nil, errors.Wrap(err, "SyncAPI failed: could not call Sync")
	}

	return &nitro.SyncResponse{}, nil
}
