package api

import (
	"context"

	"code.justin.tv/samus/nitro/internal/app/premium"
	"code.justin.tv/samus/nitro/rpc"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

type UndoSyncAPI struct {
	IPremiumStatuses premium.PremiumStatuses
}

func (api *UndoSyncAPI) UndoSync(context context.Context, request *nitro.UndoSyncRequest) (*nitro.UndoSyncResponse, error) {
	twitchUserId := request.TwitchUserID

	logger := log.WithFields(log.Fields{
		"userID": twitchUserId,
	})

	err := api.IPremiumStatuses.UndoSync(context, twitchUserId)

	if err != nil {
		logger.Error("[UndoSyncAPI] : ", err)
		return nil, errors.Wrap(err, "UndoSync API failed")
	}

	return &nitro.UndoSyncResponse{}, nil
}
