package api

import (
	"context"

	"code.justin.tv/samus/nitro/rpc"
	log "github.com/sirupsen/logrus"

	"time"

	"code.justin.tv/samus/nitro/internal/app/grandfathering"
	"code.justin.tv/samus/nitro/internal/clients/user_status"
	"github.com/pkg/errors"
)

type UpdateGrandfatheredUserAPI struct {
	IGrandfathering grandfathering.IGrandfathering
}

// UpdateGrandfatheredUser API
func (api *UpdateGrandfatheredUserAPI) UpdateGrandfatheredUser(context context.Context, request *nitro.UpdateGrandfatheredUserRequest) (*nitro.UpdateGrandfatheredUserResponse, error) {
	logger := log.WithFields(log.Fields{
		"userID": request.TwitchUserID,
	})

	endOfTwitchPrimeDate, err := time.Parse(time.RFC3339Nano, request.EndOfOldTwitchPrimeDate)
	if err != nil {
		return nil, errors.Wrap(err, "UpdateGrandfatheredUser API failed")
	}

	user := user_status.GrandfatheredUser{
		TwitchUserID:            request.TwitchUserID,
		HasOldTwitchPrime:       request.HasOldTwitchPrime,
		HasNewTwitchPrime:       request.HasNewTwitchPrime,
		EndOfOldTwitchPrimeDate: endOfTwitchPrimeDate.UTC(),
	}
	err = api.IGrandfathering.UpdateGrandfatheredUser(&user)

	if err != nil {
		logger.Error("[UpdateGrandfatheredUserAPI] : ", err)
		return nil, errors.Wrap(err, "UpdateGrandfatheredUser API failed")
	}

	return &nitro.UpdateGrandfatheredUserResponse{}, nil
}
