package grandfathering

import (
	"code.justin.tv/samus/nitro/internal/clients"
	"code.justin.tv/samus/nitro/internal/clients/user_status"
)

type IGrandfathering interface {
	// CRUD operations
	GetGrandfatheredUser(twitchUserID string) (*user_status.GrandfatheredUser, error)
	CreateGrandfatheredUser(twitchUserID string) (*user_status.GrandfatheredUser, error)
	UpdateGrandfatheredUser(user *user_status.GrandfatheredUser) error
	DeleteGrandfatheredUser(twitchUserID string) error

	// Grandfathering Flag
	IsGrandfatheringUsers() (*user_status.Flag, error)
}

type Grandfathering struct {
	Clients clients.Clients
}

func NewGrandfathering(c clients.Clients) IGrandfathering {
	return &Grandfathering{
		Clients: c,
	}
}

func (g *Grandfathering) GetGrandfatheredUser(twitchUserID string) (*user_status.GrandfatheredUser, error) {
	return g.Clients.UserStatusClient.GetGrandfatheredUser(twitchUserID)
}

func (g *Grandfathering) CreateGrandfatheredUser(twitchUserID string) (*user_status.GrandfatheredUser, error) {
	user := user_status.GrandfatheredUser{
		TwitchUserID:      twitchUserID,
		HasOldTwitchPrime: true,
		HasNewTwitchPrime: true,
	}

	return &user, g.Clients.UserStatusClient.CreateGrandfatheredUser(&user)
}

func (g *Grandfathering) UpdateGrandfatheredUser(user *user_status.GrandfatheredUser) error {
	return g.Clients.UserStatusClient.UpdateGrandfatheredUser(user)
}

func (g *Grandfathering) DeleteGrandfatheredUser(twitchUserID string) error {
	return g.Clients.UserStatusClient.DeleteGrandfatheredUser(twitchUserID)
}

func (g *Grandfathering) IsGrandfatheringUsers() (*user_status.Flag, error) {
	return g.Clients.UserStatusClient.GetGrandfatheringFlag()
}
