package grandfathering

import (
	"testing"

	"code.justin.tv/samus/nitro/internal/clients"
	"code.justin.tv/samus/nitro/internal/clients/user_status"
	"github.com/pkg/errors"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestGrandfathering(t *testing.T) {
	Convey("Test Grandfathering APIs", t, func() {
		mockUserStatusClient := new(user_status.MockIUserStatusClient)

		mockClients := clients.Clients{
			UserStatusClient: mockUserStatusClient,
		}

		grandfathering := Grandfathering{
			Clients: mockClients,
		}

		Convey("IsGrandfatheringUsers", func() {

			Convey("Failure", func() {
				mockUserStatusClient.On("GetGrandfatheringFlag", mock.Anything).Return(nil, errors.New("test"))

				_, err := grandfathering.IsGrandfatheringUsers()
				So(err, ShouldBeError)
			})

		})
	})
}
